/*
 * Decompiled with CFR 0.152.
 */
package xaeroplus.mixin.client;

import java.io.File;
import java.io.IOException;
import net.minecraft.client.KeyMapping;
import net.minecraft.resources.ResourceKey;
import net.minecraft.world.level.Level;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;
import org.spongepowered.asm.mixin.injection.callback.LocalCapture;
import xaero.common.IXaeroMinimap;
import xaero.common.XaeroMinimapSession;
import xaero.common.minimap.waypoints.Waypoint;
import xaero.common.minimap.waypoints.WaypointSet;
import xaero.common.minimap.waypoints.WaypointWorld;
import xaero.common.settings.ModOptions;
import xaero.common.settings.ModSettings;
import xaeroplus.XaeroPlus;
import xaeroplus.feature.extensions.IWaypointDimension;
import xaeroplus.settings.XaeroPlusModSettingsHooks;
import xaeroplus.settings.XaeroPlusSettingRegistry;
import xaeroplus.settings.XaeroPlusSettingsReflectionHax;

@Mixin(value={ModSettings.class}, remap=false)
public class MixinMinimapModSettings {
    @Shadow
    public int caveMaps;
    @Shadow
    private boolean lockNorth;
    @Shadow
    public boolean keepUnlockedWhenEnlarged;
    @Shadow
    protected IXaeroMinimap modMain;

    @Inject(method={"<init>"}, at={@At(value="RETURN")})
    private void init(CallbackInfo ci) {
        this.caveMaps = 0;
    }

    @Inject(method={"getLockNorth"}, at={@At(value="HEAD")}, cancellable=true, locals=LocalCapture.CAPTURE_FAILHARD)
    public void getLockNorth(int mapSize, int shape, CallbackInfoReturnable<Boolean> cir) {
        if (!XaeroPlusSettingRegistry.transparentMinimapBackground.getValue()) {
            return;
        }
        XaeroMinimapSession minimapSession = XaeroMinimapSession.getCurrentSession();
        if (minimapSession == null) {
            cir.setReturnValue((Object)this.lockNorth);
        } else {
            cir.setReturnValue((Object)(this.lockNorth || !this.keepUnlockedWhenEnlarged && minimapSession.getMinimapProcessor().isEnlargedMap() ? 1 : 0));
        }
    }

    @Inject(method={"checkWaypointsLine"}, at={@At(value="INVOKE", target="Ljava/util/ArrayList;add(Ljava/lang/Object;)Z")}, locals=LocalCapture.CAPTURE_FAILHARD)
    public void createWaypointInject(String[] args, WaypointWorld wpw, CallbackInfoReturnable<Boolean> cir, String setName, WaypointSet set, boolean yIncluded, int yCoord, Waypoint waypoint) {
        try {
            ((IWaypointDimension)waypoint).setDimension((ResourceKey<Level>)wpw.getDimId());
        }
        catch (Throwable e) {
            XaeroPlus.LOGGER.error("Failed setting waypoint dimension: {}", (Object)waypoint, (Object)e);
        }
    }

    @Inject(method={"saveSettings"}, at={@At(value="RETURN")})
    public void saveSettings(CallbackInfo ci) throws IOException {
        XaeroPlusModSettingsHooks.saveSettings(this.modMain.getConfigFile(), XaeroPlusSettingsReflectionHax.ALL_MINIMAP_SETTINGS.get());
    }

    @Inject(method={"loadSettingsFile"}, at={@At(value="RETURN")})
    public void loadSettings(File file, CallbackInfo ci) throws IOException {
        XaeroPlusModSettingsHooks.loadSettings(file, XaeroPlusSettingsReflectionHax.ALL_MINIMAP_SETTINGS.get());
    }

    @Inject(method={"getClientBooleanValue"}, at={@At(value="HEAD")}, cancellable=true)
    public void getClientBooleanValue(ModOptions o, CallbackInfoReturnable<Boolean> cir) {
        XaeroPlusModSettingsHooks.getClientBooleanValue(o.getEnumString(), XaeroPlusSettingsReflectionHax.ALL_MINIMAP_SETTINGS.get(), cir);
    }

    @Inject(method={"setOptionValue"}, at={@At(value="HEAD")})
    public void setOptionValue(ModOptions o, Object value, CallbackInfo ci) {
        XaeroPlusModSettingsHooks.setOptionValue(o.getEnumString(), value, XaeroPlusSettingsReflectionHax.ALL_MINIMAP_SETTINGS.get());
    }

    @Inject(method={"getOptionValue"}, at={@At(value="HEAD")}, cancellable=true)
    public void getOptionValue(ModOptions o, CallbackInfoReturnable<Object> cir) {
        XaeroPlusModSettingsHooks.getOptionValue(o.getEnumString(), cir, XaeroPlusSettingsReflectionHax.ALL_MINIMAP_SETTINGS.get());
    }

    @Inject(method={"setOptionDoubleValue"}, at={@At(value="HEAD")})
    public void setOptionFloatValue(ModOptions o, double f, CallbackInfo ci) {
        XaeroPlusModSettingsHooks.setOptionDoubleValue(o.getEnumString(), f, XaeroPlusSettingsReflectionHax.ALL_MINIMAP_SETTINGS.get());
    }

    @Inject(method={"getOptionDoubleValue"}, at={@At(value="HEAD")}, cancellable=true)
    public void getOptionFloatValue(ModOptions o, CallbackInfoReturnable<Double> cir) {
        XaeroPlusModSettingsHooks.getOptionDoubleValue(o.getEnumString(), cir, XaeroPlusSettingsReflectionHax.ALL_MINIMAP_SETTINGS.get());
    }

    @Inject(method={"getOptionValueName"}, at={@At(value="HEAD")}, cancellable=true)
    public void getOptionValueName(ModOptions o, CallbackInfoReturnable<String> cir) {
        XaeroPlusModSettingsHooks.getOptionValueName(o.getEnumString(), cir, XaeroPlusSettingsReflectionHax.ALL_MINIMAP_SETTINGS.get());
    }

    @Inject(method={"isKeyRepeat"}, at={@At(value="RETURN")}, cancellable=true)
    public void isKeyRepeat(KeyMapping kb, CallbackInfoReturnable<Boolean> cir) {
        cir.setReturnValue((Object)((Boolean)cir.getReturnValue() != false && XaeroPlusSettingsReflectionHax.keybindingMapSupplier.get().get(kb) == null ? 1 : 0));
    }

    @Inject(method={"getSliderOptionText"}, at={@At(value="HEAD")}, cancellable=true)
    public void getSliderOptionText(ModOptions o, CallbackInfoReturnable<String> cir) {
        XaeroPlusModSettingsHooks.getSliderOptionText(o.getEnumString(), cir, XaeroPlusSettingsReflectionHax.ALL_MINIMAP_SETTINGS.get());
    }
}

