/*
 * Decompiled with CFR 0.152.
 */
package xaeroplus.mixin.client;

import com.github.benmanes.caffeine.cache.Cache;
import com.github.benmanes.caffeine.cache.Caffeine;
import com.llamalad7.mixinextras.injector.ModifyExpressionValue;
import com.llamalad7.mixinextras.injector.wrapoperation.Operation;
import com.llamalad7.mixinextras.injector.wrapoperation.WrapOperation;
import com.llamalad7.mixinextras.sugar.Local;
import com.llamalad7.mixinextras.sugar.Share;
import com.llamalad7.mixinextras.sugar.ref.LocalBooleanRef;
import com.llamalad7.mixinextras.sugar.ref.LocalIntRef;
import com.llamalad7.mixinextras.sugar.ref.LocalLongRef;
import com.llamalad7.mixinextras.sugar.ref.LocalRef;
import java.util.Objects;
import java.util.concurrent.TimeUnit;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Registry;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.chunk.LevelChunk;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;
import xaero.map.MapProcessor;
import xaero.map.MapWriter;
import xaero.map.biome.BiomeColorCalculator;
import xaero.map.biome.BlockTintProvider;
import xaero.map.region.MapBlock;
import xaero.map.region.OverlayBuilder;
import xaero.map.region.OverlayManager;
import xaeroplus.settings.XaeroPlusSettingRegistry;
import xaeroplus.util.ChunkUtils;

@Mixin(value={MapWriter.class}, remap=false)
public abstract class MixinMapWriter {
    private final Cache<Long, Long> tileUpdateCache = Caffeine.newBuilder().maximumSize(10000L).expireAfterWrite(5L, TimeUnit.SECONDS).build();
    @Shadow
    private MapProcessor mapProcessor;
    @Shadow
    @Final
    private BlockPos.MutableBlockPos mutableLocalPos;
    @Shadow
    public long writeFreeSinceLastWrite;

    @Inject(method={"loadPixel"}, at={@At(value="HEAD")}, remap=false)
    public void setObsidianColumnLocalVar(Level world, Registry<Block> blockRegistry, MapBlock pixel, MapBlock currentPixel, LevelChunk bchunk, int insideX, int insideZ, int highY, int lowY, boolean cave, boolean fullCave, int mappedHeight, boolean canReuseBiomeColours, boolean ignoreHeightmaps, Registry<Biome> biomeRegistry, boolean flowers, int worldBottomY, BlockPos.MutableBlockPos mutableBlockPos3, CallbackInfo ci, @Share(value="columnRoofObsidian") LocalBooleanRef columnRoofObsidianRef) {
        if (!XaeroPlusSettingRegistry.transparentObsidianRoofSetting.getValue()) {
            return;
        }
        columnRoofObsidianRef.set(false);
    }

    @Inject(method={"loadPixel"}, at={@At(value="INVOKE", target="Lnet/minecraft/world/level/block/state/BlockState;getFluidState()Lnet/minecraft/world/level/material/FluidState;", ordinal=0)}, remap=true)
    public void obsidianRoofHeadInject(Level world, Registry<Block> blockRegistry, MapBlock pixel, MapBlock currentPixel, LevelChunk bchunk, int insideX, int insideZ, int highY, int lowY, boolean cave, boolean fullCave, int mappedHeight, boolean canReuseBiomeColours, boolean ignoreHeightmaps, Registry<Biome> biomeRegistry, boolean flowers, int worldBottomY, BlockPos.MutableBlockPos mutableBlockPos3, CallbackInfo ci, @Local(name={"state"}) LocalRef<BlockState> stateRef, @Local(name={"h"}) LocalIntRef hRef, @Local(name={"transparentSkipY"}) LocalIntRef transparentSkipYRef, @Share(value="columnRoofObsidian") LocalBooleanRef columnRoofObsidianRef) {
        boolean blockHeightAboveYLimit;
        if (!XaeroPlusSettingRegistry.transparentObsidianRoofSetting.getValue()) {
            return;
        }
        Block b = ((BlockState)stateRef.get()).m_60734_();
        boolean bl = blockHeightAboveYLimit = (float)hRef.get() >= XaeroPlusSettingRegistry.transparentObsidianRoofYSetting.getValue();
        if (blockHeightAboveYLimit) {
            boolean shouldMakeTransparent;
            boolean bl2 = shouldMakeTransparent = b == Blocks.f_50080_ || b == Blocks.f_50723_;
            if (b == Blocks.f_50125_) {
                this.mutableLocalPos.m_142448_(hRef.get() - 1);
                BlockState belowState = bchunk.m_8055_((BlockPos)this.mutableLocalPos);
                this.mutableLocalPos.m_142448_(hRef.get());
                boolean bl3 = shouldMakeTransparent = belowState.m_60734_() == Blocks.f_50080_ || belowState.m_60734_() == Blocks.f_50723_;
            }
            if (shouldMakeTransparent) {
                if (XaeroPlusSettingRegistry.transparentObsidianRoofDarkeningSetting.getValue() == 0.0f) {
                    stateRef.set((Object)Blocks.f_50016_.m_49966_());
                    transparentSkipYRef.set(transparentSkipYRef.get() - 1);
                }
                if (!columnRoofObsidianRef.get()) {
                    columnRoofObsidianRef.set(true);
                }
            }
        }
    }

    @WrapOperation(method={"loadPixel"}, at={@At(value="INVOKE", target="Lxaero/map/region/OverlayBuilder;isEmpty()Z")}, remap=false)
    public boolean checkObsidianRoofColumn(OverlayBuilder instance, Operation<Boolean> original, @Share(value="columnRoofObsidian") LocalBooleanRef columnRoofObsidianRef) {
        if (!XaeroPlusSettingRegistry.transparentObsidianRoofSetting.getValue()) {
            return (Boolean)original.call(new Object[]{instance});
        }
        return (Boolean)original.call(new Object[]{instance}) != false || columnRoofObsidianRef.get();
    }

    @ModifyExpressionValue(method={"loadPixelHelp"}, at={@At(value="INVOKE", target="Lxaero/map/MapWriter;shouldOverlayCached(Lnet/minecraft/world/level/block/state/StateHolder;)Z", ordinal=0)}, remap=false)
    public boolean obsidianRoofOverlayMod(boolean original, @Local(argsOnly=true) LevelChunk bChunk, @Local(name={"b"}) Block b, @Local(name={"h"}) int h) {
        if (XaeroPlusSettingRegistry.transparentObsidianRoofSetting.getValue() && (float)h > XaeroPlusSettingRegistry.transparentObsidianRoofYSetting.getValue()) {
            if (b == Blocks.f_50080_ || b == Blocks.f_50723_) {
                return true;
            }
            if (b == Blocks.f_50125_) {
                this.mutableLocalPos.m_142448_(h - 1);
                BlockState belowState = bChunk.m_8055_((BlockPos)this.mutableLocalPos);
                this.mutableLocalPos.m_142448_(h);
                return belowState.m_60734_() == Blocks.f_50080_ || belowState.m_60734_() == Blocks.f_50723_;
            }
        }
        return original;
    }

    @WrapOperation(method={"loadPixelHelp"}, at={@At(value="INVOKE", target="Lnet/minecraft/world/level/block/state/BlockState;getLightBlock(Lnet/minecraft/world/level/BlockGetter;Lnet/minecraft/core/BlockPos;)I", ordinal=1)}, remap=true)
    public int getOpacityForObsidianRoof(BlockState instance, BlockGetter world, BlockPos pos, Operation<Integer> original, @Local(name={"h"}) int h) {
        if (XaeroPlusSettingRegistry.transparentObsidianRoofSetting.getValue() && (float)h > XaeroPlusSettingRegistry.transparentObsidianRoofYSetting.getValue()) {
            boolean shouldMakeTransparent;
            boolean bl = shouldMakeTransparent = instance.m_60734_() == Blocks.f_50080_ || instance.m_60734_() == Blocks.f_50723_;
            if (instance.m_60734_() == Blocks.f_50125_) {
                this.mutableLocalPos.m_142448_(h - 1);
                BlockState belowState = world.m_8055_((BlockPos)this.mutableLocalPos);
                this.mutableLocalPos.m_142448_(h);
                if (belowState.m_60734_() == Blocks.f_50080_ || belowState.m_60734_() == Blocks.f_50723_) {
                    shouldMakeTransparent = true;
                }
            }
            if (shouldMakeTransparent) {
                return 5;
            }
        }
        return (Integer)original.call(new Object[]{instance, world, pos});
    }

    @Inject(method={"onRender"}, at={@At(value="FIELD", target="Lxaero/map/MapWriter;lastWrite:J", opcode=180, ordinal=2)})
    public void fastMapMaxTilesPerCycleSetting(BiomeColorCalculator biomeColorCalculator, OverlayManager overlayManager, CallbackInfo ci, @Local(name={"tilesToUpdate"}) LocalLongRef tilesToUpdateRef, @Local(name={"sizeTiles"}) int sizeTiles) {
        if (XaeroPlusSettingRegistry.fastMapSetting.getValue()) {
            this.writeFreeSinceLastWrite = Math.max(1L, this.writeFreeSinceLastWrite);
            if (this.mapProcessor.getCurrentCaveLayer() == Integer.MAX_VALUE) {
                tilesToUpdateRef.set((long)Math.min((float)sizeTiles, XaeroPlusSettingRegistry.fastMapMaxTilesPerCycle.getValue()));
            }
        }
    }

    @ModifyExpressionValue(method={"onRender"}, at={@At(value="INVOKE", target="Ljava/lang/System;nanoTime()J", ordinal=2)})
    public long removeWriteTimeLimiterPerFrame(long original) {
        if (XaeroPlusSettingRegistry.fastMapSetting.getValue() && this.mapProcessor.getCurrentCaveLayer() == Integer.MAX_VALUE) {
            return 0L;
        }
        return original;
    }

    @Inject(method={"writeChunk"}, at={@At(value="HEAD")}, cancellable=true, remap=false)
    public void writeChunk(Level world, Registry<Block> blockRegistry, int distance, boolean onlyLoad, Registry<Biome> biomeRegistry, OverlayManager overlayManager, boolean loadChunks, boolean updateChunks, boolean ignoreHeightmaps, boolean flowers, boolean detailedDebug, BlockPos.MutableBlockPos mutableBlockPos3, BlockTintProvider blockTintProvider, int caveDepth, int caveStart, int layerToWrite, int tileChunkX, int tileChunkZ, int tileChunkLocalX, int tileChunkLocalZ, int chunkX, int chunkZ, CallbackInfoReturnable<Boolean> cir) {
        if (!XaeroPlusSettingRegistry.fastMapSetting.getValue()) {
            return;
        }
        if (this.mapProcessor.getCurrentCaveLayer() != Integer.MAX_VALUE) {
            return;
        }
        Long cacheable = ChunkUtils.chunkPosToLong(chunkX, chunkZ);
        Long cacheValue = (Long)this.tileUpdateCache.getIfPresent((Object)cacheable);
        if (Objects.nonNull(cacheValue)) {
            if (cacheValue < System.currentTimeMillis() - (long)XaeroPlusSettingRegistry.fastMapWriterDelaySetting.getValue()) {
                this.tileUpdateCache.put((Object)cacheable, (Object)System.currentTimeMillis());
            } else {
                cir.setReturnValue((Object)false);
                cir.cancel();
            }
        } else {
            this.tileUpdateCache.put((Object)cacheable, (Object)System.currentTimeMillis());
        }
    }

    @Inject(method={"loadPixel"}, at={@At(value="HEAD")}, remap=false)
    public void netherCaveFixInject(Level world, Registry<Block> blockRegistry, MapBlock pixel, MapBlock currentPixel, LevelChunk bchunk, int insideX, int insideZ, int highY, int lowY, boolean cave, boolean fullCave, int mappedHeight, boolean canReuseBiomeColours, boolean ignoreHeightmaps, Registry<Biome> biomeRegistry, boolean flowers, int worldBottomY, BlockPos.MutableBlockPos mutableBlockPos3, CallbackInfo ci, @Local(index=10, argsOnly=true) LocalBooleanRef caveRef, @Local(index=11, argsOnly=true) LocalBooleanRef fullCaveRef) {
        if (XaeroPlusSettingRegistry.netherCaveFix.getValue()) {
            boolean nether = world.m_46472_() == Level.f_46429_;
            boolean shouldForceFullInNether = !cave && nether;
            caveRef.set(shouldForceFullInNether || cave);
            fullCaveRef.set(shouldForceFullInNether || fullCave);
        }
    }
}

