/*
 * Decompiled with CFR 0.152.
 */
package xaeroplus.mixin.client;

import baritone.api.BaritoneAPI;
import baritone.api.pathing.goals.Goal;
import baritone.api.pathing.goals.GoalXZ;
import com.llamalad7.mixinextras.injector.ModifyExpressionValue;
import com.llamalad7.mixinextras.injector.WrapWithCondition;
import com.llamalad7.mixinextras.injector.wrapoperation.Operation;
import com.llamalad7.mixinextras.injector.wrapoperation.WrapOperation;
import com.llamalad7.mixinextras.sugar.Local;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.EditBox;
import net.minecraft.client.gui.components.Renderable;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.narration.NarratableEntry;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.resources.language.I18n;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.Level;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Constant;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.ModifyConstant;
import org.spongepowered.asm.mixin.injection.Redirect;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;
import xaero.common.XaeroMinimapSession;
import xaero.common.graphics.CustomRenderTypes;
import xaero.common.graphics.shader.MinimapShaders;
import xaero.map.MapProcessor;
import xaero.map.WorldMap;
import xaero.map.animation.SlowingAnimation;
import xaero.map.element.HoveredMapElementHolder;
import xaero.map.element.MapElementRenderHandler;
import xaero.map.graphics.renderer.multitexture.MultiTextureRenderTypeRendererProvider;
import xaero.map.gui.CursorBox;
import xaero.map.gui.GuiMap;
import xaero.map.gui.GuiTexturedButton;
import xaero.map.gui.IRightClickableElement;
import xaero.map.gui.ScreenBase;
import xaero.map.gui.dropdown.rightclick.RightClickOption;
import xaero.map.misc.OptimizedMath;
import xaero.map.mods.SupportMods;
import xaero.map.world.MapDimension;
import xaeroplus.Globals;
import xaeroplus.XaeroPlus;
import xaeroplus.mixin.client.AccessorRightClickOption;
import xaeroplus.mixin.client.mc.AccessorGameOptions;
import xaeroplus.settings.XaeroPlusSettingRegistry;
import xaeroplus.util.BaritoneHelper;
import xaeroplus.util.ChunkUtils;

@Mixin(value={GuiMap.class}, remap=false)
public abstract class MixinGuiMap
extends ScreenBase
implements IRightClickableElement {
    Button coordinateGotoButton;
    EditBox xTextEntryField;
    EditBox zTextEntryField;
    Button followButton;
    Button switchToNetherButton;
    Button switchToOverworldButton;
    Button switchToEndButton;
    @Shadow
    private double cameraX = 0.0;
    @Shadow
    private double cameraZ = 0.0;
    @Shadow
    private int[] cameraDestination = null;
    @Shadow
    private SlowingAnimation cameraDestinationAnimX = null;
    @Shadow
    private SlowingAnimation cameraDestinationAnimZ = null;
    @Shadow
    private double scale;
    @Shadow
    private double prevPlayerDimDiv;
    @Shadow
    private MapProcessor mapProcessor;
    @Shadow
    private Button exportButton;
    @Shadow
    private Button claimsButton;
    @Shadow
    private Button zoomInButton;
    @Shadow
    private Button zoomOutButton;
    @Shadow
    private Button keybindingsButton;
    @Shadow
    private Button dimensionToggleButton;
    @Shadow
    private int rightClickX;
    @Shadow
    private int rightClickZ;

    protected MixinGuiMap(Screen parent, Screen escape, Component titleIn) {
        super(parent, escape, titleIn);
    }

    @Shadow
    public abstract <T extends GuiEventListener & Renderable> T addButton(T var1);

    @Shadow
    public abstract <T extends GuiEventListener & NarratableEntry> T m_7787_(T var1);

    @ModifyConstant(method={"changeZoom"}, constant={@Constant(doubleValue=0.0625)})
    public double customMinZoom(double original) {
        return XaeroPlusSettingRegistry.worldMapMinZoomSetting.getValue() / 10.0f;
    }

    @Inject(method={"init"}, at={@At(value="RETURN")}, remap=true)
    public void customInitGui(CallbackInfo ci) {
        this.followButton = new GuiTexturedButton(0, this.dimensionToggleButton.m_252907_() - 20, 20, 20, Globals.FOLLOW ? 133 : 149, 16, 16, 16, WorldMap.guiTextures, this::onFollowButton, () -> new CursorBox((Component)Component.m_237115_((String)"gui.world_map.toggle_follow_mode").m_130946_(" " + I18n.m_118938_((String)(Globals.FOLLOW ? "gui.xaeroplus.off" : "gui.xaeroplus.on"), (Object[])new Object[0]))));
        this.addButton(this.followButton);
        this.coordinateGotoButton = new GuiTexturedButton(0, this.followButton.m_252907_() - 20, 20, 20, 229, 16, 16, 16, WorldMap.guiTextures, this::onGotoCoordinatesButton, () -> new CursorBox((Component)Component.m_237115_((String)"gui.world_map.go_to_coordinates")));
        this.addButton(this.coordinateGotoButton);
        this.xTextEntryField = new EditBox(Minecraft.m_91087_().f_91062_, 20, this.coordinateGotoButton.m_252907_() - 10, 50, 20, Component.m_130674_((String)"X:"));
        this.xTextEntryField.m_94194_(false);
        this.xTextEntryField.m_94196_(0);
        this.xTextEntryField.m_257771_((Component)Component.m_237113_((String)"X:").m_130940_(ChatFormatting.DARK_GRAY));
        this.zTextEntryField = new EditBox(Minecraft.m_91087_().f_91062_, 20, this.xTextEntryField.m_252907_() + 20, 50, 20, Component.m_130674_((String)"Z:"));
        this.zTextEntryField.m_94194_(false);
        this.zTextEntryField.m_94196_(0);
        this.zTextEntryField.m_257771_((Component)Component.m_237113_((String)"Z:").m_130940_(ChatFormatting.DARK_GRAY));
        this.m_7787_(this.xTextEntryField);
        this.m_7787_(this.zTextEntryField);
        if (!SupportMods.pac()) {
            this.m_169411_((GuiEventListener)this.claimsButton);
            this.exportButton.m_253211_(this.claimsButton.m_252907_());
            this.keybindingsButton.m_253211_(this.claimsButton.m_252907_() - 20);
            this.zoomOutButton.m_253211_(this.keybindingsButton.m_252907_() - 20);
            this.zoomInButton.m_253211_(this.zoomOutButton.m_252907_() - 20);
        }
        this.switchToEndButton = new GuiTexturedButton(this.f_96543_ - 20, this.zoomInButton.m_252907_() - 20, 20, 20, 31, 0, 16, 16, Globals.xpGuiTextures, button -> this.onSwitchDimensionButton((ResourceKey<Level>)Level.f_46430_), () -> new CursorBox((Component)Component.m_237115_((String)"setting.keybinds.switch_to_end")));
        this.switchToOverworldButton = new GuiTexturedButton(this.f_96543_ - 20, this.switchToEndButton.m_252907_() - 20, 20, 20, 16, 0, 16, 16, Globals.xpGuiTextures, button -> this.onSwitchDimensionButton((ResourceKey<Level>)Level.f_46428_), () -> new CursorBox((Component)Component.m_237115_((String)"setting.keybinds.switch_to_overworld")));
        this.switchToNetherButton = new GuiTexturedButton(this.f_96543_ - 20, this.switchToOverworldButton.m_252907_() - 20, 20, 20, 0, 0, 16, 16, Globals.xpGuiTextures, button -> this.onSwitchDimensionButton((ResourceKey<Level>)Level.f_46429_), () -> new CursorBox((Component)Component.m_237115_((String)"setting.keybinds.switch_to_nether")));
        this.addButton(this.switchToEndButton);
        this.addButton(this.switchToOverworldButton);
        this.addButton(this.switchToNetherButton);
    }

    protected void onExit(Screen screen) {
        if (!XaeroPlusSettingRegistry.persistMapDimensionSwitchSetting.getValue()) {
            try {
                ResourceKey<Level> actualDimension = ChunkUtils.getActualDimension();
                if (Globals.getCurrentDimensionId() != actualDimension) {
                    Globals.switchToDimension(actualDimension);
                    if (!XaeroPlusSettingRegistry.radarWhileDimensionSwitchedSetting.getValue()) {
                        WorldMap.settings.minimapRadar = true;
                    }
                }
            }
            catch (Exception e) {
                XaeroPlus.LOGGER.error("Failed to switch back to original dimension", (Throwable)e);
            }
        }
        super.onExit(screen);
    }

    @Inject(method={"render"}, at={@At(value="INVOKE", target="Lxaero/map/gui/GuiMap;init(Lnet/minecraft/client/Minecraft;II)V", ordinal=0, shift=At.Shift.AFTER)}, remap=true)
    public void toggleRadarWhileDimensionSwitched(GuiGraphics guiGraphics, int scaledMouseX, int scaledMouseY, float partialTicks, CallbackInfo ci, @Local(name={"currentFutureDim"}) MapDimension currentFutureDim) {
        if (!XaeroPlusSettingRegistry.radarWhileDimensionSwitchedSetting.getValue()) {
            WorldMap.settings.minimapRadar = currentFutureDim.getDimId() == ChunkUtils.getActualDimension();
        }
    }

    @Redirect(method={"render"}, at=@At(value="FIELD", target="Lxaero/map/gui/GuiMap;cameraX:D", opcode=181, ordinal=1), remap=true)
    public void fixDimensionSwitchCameraCoordsX(GuiMap owner, double value, @Local(name={"playerDimDiv"}) double playerDimDiv) {
        this.cameraX *= this.prevPlayerDimDiv / playerDimDiv;
    }

    @Redirect(method={"render"}, at=@At(value="FIELD", target="Lxaero/map/gui/GuiMap;cameraZ:D", opcode=181, ordinal=1), remap=true)
    public void fixDimensionSwitchCameraCoordsZ(GuiMap owner, double value, @Local(name={"playerDimDiv"}) double playerDimDiv) {
        this.cameraZ *= this.prevPlayerDimDiv / playerDimDiv;
    }

    @Inject(method={"render"}, at={@At(value="FIELD", target="Lxaero/map/gui/GuiMap;lastStartTime:J", opcode=181, ordinal=0, shift=At.Shift.AFTER)}, remap=true)
    public void injectFollowMode(GuiGraphics guiGraphics, int scaledMouseX, int scaledMouseY, float partialTicks, CallbackInfo ci) {
        if (Globals.FOLLOW && Objects.isNull(this.cameraDestination) && Objects.isNull(this.cameraDestinationAnimX) && Objects.isNull(this.cameraDestinationAnimZ)) {
            this.cameraDestination = new int[]{(int)ChunkUtils.getPlayerX(), (int)ChunkUtils.getPlayerZ()};
        }
    }

    @ModifyExpressionValue(method={"render"}, at={@At(value="FIELD", target="Lxaero/map/settings/ModSettings;debug:Z", opcode=180)}, remap=true)
    public boolean hideDebugRenderingOnF1(boolean original) {
        return original && !Minecraft.m_91087_().f_91066_.f_92062_;
    }

    @Inject(method={"render"}, at={@At(value="INVOKE", target="Lxaero/map/region/LeveledRegion;loadingAnimation()Z", shift=At.Shift.BEFORE)}, remap=true)
    public void drawWorldMapFeatures(GuiGraphics guiGraphics, int scaledMouseX, int scaledMouseY, float partialTicks, CallbackInfo ci, @Local(name={"leafRegionMinX"}) int leafRegionMinX, @Local(name={"leafRegionMinZ"}) int leafRegionMinZ, @Local(name={"leveledSideInRegions"}) int leveledSideInRegions, @Local(name={"flooredCameraX"}) int flooredCameraX, @Local(name={"flooredCameraZ"}) int flooredCameraZ, @Local(name={"matrixStack"}) PoseStack matrixStack, @Local(name={"overlayBuffer"}) VertexConsumer overlayBuffer) {
        if (!Minecraft.m_91087_().f_91066_.f_92062_) {
            Globals.drawManager.drawWorldMapFeatures(leafRegionMinX, leafRegionMinZ, leveledSideInRegions, flooredCameraX, flooredCameraZ, matrixStack, overlayBuffer);
        }
    }

    @WrapWithCondition(method={"render"}, at={@At(value="INVOKE", target="Lxaero/map/graphics/MapRenderHelper;renderDynamicHighlight(Lcom/mojang/blaze3d/vertex/PoseStack;Lcom/mojang/blaze3d/vertex/VertexConsumer;IIIIIIFFFFFFFF)V")}, remap=true)
    public boolean hideHighlightsOnF1(PoseStack matrixStack, VertexConsumer overlayBuffer, int flooredCameraX, int flooredCameraZ, int leftX, int rightX, int topZ, int bottomZ, float sideR, float sideG, float sideB, float sideA, float centerR, float centerG, float centerB, float centerA) {
        return !Minecraft.m_91087_().f_91066_.f_92062_;
    }

    @WrapOperation(method={"render"}, at={@At(value="INVOKE", target="Lxaero/map/element/MapElementRenderHandler;render(Lxaero/map/gui/GuiMap;Lnet/minecraft/client/gui/GuiGraphics;Lnet/minecraft/client/renderer/MultiBufferSource$BufferSource;Lxaero/map/graphics/renderer/multitexture/MultiTextureRenderTypeRendererProvider;DDIIDDDDDFZLxaero/map/element/HoveredMapElementHolder;Lnet/minecraft/client/Minecraft;F)Lxaero/map/element/HoveredMapElementHolder;")}, remap=true)
    public HoveredMapElementHolder<?, ?> hideMapElementsOnF1(MapElementRenderHandler handler, GuiMap mapScreen, GuiGraphics guiGraphics, MultiBufferSource.BufferSource renderTypeBuffers, MultiTextureRenderTypeRendererProvider rendererProvider, double cameraX, double cameraZ, int width, int height, double screenSizeBasedScale, double scale, double playerDimDiv, double mouseX, double mouseZ, float brightness, boolean cave, HoveredMapElementHolder<?, ?> oldHovered, Minecraft mc, float partialTicks, Operation<HoveredMapElementHolder<?, ?>> original) {
        if (!Minecraft.m_91087_().f_91066_.f_92062_) {
            return (HoveredMapElementHolder)original.call(new Object[]{handler, mapScreen, guiGraphics, renderTypeBuffers, rendererProvider, cameraX, cameraZ, width, height, screenSizeBasedScale, scale, playerDimDiv, mouseX, mouseZ, Float.valueOf(brightness), cave, oldHovered, mc, Float.valueOf(partialTicks)});
        }
        return null;
    }

    @ModifyExpressionValue(method={"render"}, at={@At(value="FIELD", target="Lxaero/map/settings/ModSettings;footsteps:Z", opcode=180)}, remap=true)
    public boolean hideFootstepsOnF1(boolean original) {
        return original && !Minecraft.m_91087_().f_91066_.f_92062_;
    }

    @ModifyExpressionValue(method={"render"}, at={@At(value="FIELD", target="Lxaero/map/settings/ModSettings;renderArrow:Z", opcode=180)}, remap=true)
    public boolean hideArrowOnF1(boolean original) {
        return original && !Minecraft.m_91087_().f_91066_.f_92062_;
    }

    @Inject(method={"render"}, at={@At(value="FIELD", target="Lxaero/map/settings/ModSettings;renderArrow:Z", opcode=180, shift=At.Shift.BEFORE)}, remap=true)
    public void showRenderDistanceWorldMap(GuiGraphics guiGraphics, int scaledMouseX, int scaledMouseY, float partialTicks, CallbackInfo ci, @Local(name={"flooredCameraX"}) int flooredCameraX, @Local(name={"flooredCameraZ"}) int flooredCameraZ, @Local(name={"renderTypeBuffers"}) MultiBufferSource.BufferSource renderTypeBuffers, @Local(name={"matrixStack"}) PoseStack matrixStack) {
        Minecraft mc = Minecraft.m_91087_();
        if (XaeroPlusSettingRegistry.showRenderDistanceWorldMapSetting.getValue() && !mc.f_91066_.f_92062_ && mc.f_91073_.m_46472_() == Globals.getCurrentDimensionId()) {
            int viewDistance = ((AccessorGameOptions)mc.f_91066_).getServerRenderDistance();
            int width = viewDistance * 2 + 1;
            double playerX = ChunkUtils.getPlayerX();
            double playerZ = ChunkUtils.getPlayerZ();
            int xFloored = OptimizedMath.myFloor((double)playerX);
            int zFloored = OptimizedMath.myFloor((double)playerZ);
            int chunkLeftX = (xFloored >> 4) - width / 2 << 4;
            int chunkRightX = (xFloored >> 4) + 1 + width / 2 << 4;
            int chunkTopZ = (zFloored >> 4) - width / 2 << 4;
            int chunkBottomZ = (zFloored >> 4) + 1 + width / 2 << 4;
            int x0 = chunkLeftX - flooredCameraX;
            int x1 = chunkRightX - flooredCameraX;
            int z0 = chunkTopZ - flooredCameraZ;
            int z1 = chunkBottomZ - flooredCameraZ;
            VertexConsumer lineBufferBuilder = renderTypeBuffers.m_6299_(CustomRenderTypes.MAP_LINES);
            PoseStack.Pose matrices = matrixStack.m_85850_();
            MinimapShaders.FRAMEBUFFER_LINES.setFrameSize((float)mc.m_91268_().m_85441_(), (float)mc.m_91268_().m_85442_());
            float settingWidth = XaeroMinimapSession.getCurrentSession().getModMain().getSettings().chunkGridLineWidth;
            float lineScale = (float)Math.max(1.0, Math.min((double)settingWidth * this.scale, (double)settingWidth));
            RenderSystem.lineWidth((float)lineScale);
            this.addColoredLineToExistingBuffer(matrices, lineBufferBuilder, x0, z0, x1, z0, 1.0f, 1.0f, 0.0f, 0.8f);
            this.addColoredLineToExistingBuffer(matrices, lineBufferBuilder, x1, z0, x1, z1, 1.0f, 1.0f, 0.0f, 0.8f);
            this.addColoredLineToExistingBuffer(matrices, lineBufferBuilder, x1, z1, x0, z1, 1.0f, 1.0f, 0.0f, 0.8f);
            this.addColoredLineToExistingBuffer(matrices, lineBufferBuilder, x0, z0, x0, z1, 1.0f, 1.0f, 0.0f, 0.8f);
        }
    }

    @WrapWithCondition(method={"render"}, at={@At(value="INVOKE", target="Lxaero/map/graphics/MapRenderHelper;drawCenteredStringWithBackground(Lnet/minecraft/client/gui/GuiGraphics;Lnet/minecraft/client/gui/Font;Ljava/lang/String;IIIFFFFLcom/mojang/blaze3d/vertex/VertexConsumer;)V")}, remap=true)
    public boolean hideRenderedStringsOnF1(GuiGraphics guiGraphics, Font font, String string, int x, int y, int color, float bgRed, float bgGreen, float bgBlue, float bgAlpha, VertexConsumer backgroundVertexBuffer) {
        return !Minecraft.m_91087_().f_91066_.f_92062_;
    }

    @WrapWithCondition(method={"render"}, at={@At(value="INVOKE", target="Lnet/minecraft/client/gui/GuiGraphics;blit(Lnet/minecraft/resources/ResourceLocation;IIIIII)V")}, remap=true)
    public boolean hideCompassOnF1(GuiGraphics instance, ResourceLocation texture, int x, int y, int u, int v, int width, int height) {
        return !Minecraft.m_91087_().f_91066_.f_92062_;
    }

    @Inject(method={"render"}, at={@At(value="INVOKE", target="Lxaero/map/gui/ScreenBase;render(Lnet/minecraft/client/gui/GuiGraphics;IIF)V")}, remap=true)
    public void hideButtonsOnF1(GuiGraphics guiGraphics, int scaledMouseX, int scaledMouseY, float partialTicks, CallbackInfo ci) {
        if (Minecraft.m_91087_().f_91066_.f_92062_) {
            List<Button> buttonList = this.getButtonList();
            if (!buttonList.isEmpty()) {
                Globals.guiMapButtonTempList.clear();
                Globals.guiMapButtonTempList.addAll(buttonList);
                this.xTextEntryField.m_94194_(false);
                this.zTextEntryField.m_94194_(false);
                this.clearButtons();
            }
        } else if (!Globals.guiMapButtonTempList.isEmpty()) {
            this.clearButtons();
            Globals.guiMapButtonTempList.forEach(this::addButton);
            Globals.guiMapButtonTempList.clear();
        }
    }

    @Inject(method={"render"}, at={@At(value="INVOKE", target="Lxaero/map/graphics/MapRenderHelper;restoreDefaultShaderBlendState()V", shift=At.Shift.BEFORE)}, remap=true)
    public void renderCoordinatesGotoTextEntryFields(GuiGraphics guiGraphics, int scaledMouseX, int scaledMouseY, float partialTicks, CallbackInfo ci) {
        Minecraft mc = Minecraft.m_91087_();
        if (mc.f_91080_ != null && mc.f_91080_.getClass().equals(GuiMap.class) && this.xTextEntryField.m_94213_() && this.zTextEntryField.m_94213_()) {
            this.xTextEntryField.m_88315_(guiGraphics, scaledMouseX, scaledMouseY, partialTicks);
            this.zTextEntryField.m_88315_(guiGraphics, scaledMouseX, scaledMouseY, partialTicks);
        }
    }

    @WrapWithCondition(method={"render"}, at={@At(value="INVOKE", target="Lxaero/map/graphics/MapRenderHelper;drawCenteredStringWithBackground(Lnet/minecraft/client/gui/GuiGraphics;Lnet/minecraft/client/gui/Font;Lnet/minecraft/network/chat/Component;IIIFFFFLcom/mojang/blaze3d/vertex/VertexConsumer;)V")}, remap=true)
    public boolean hideMoreRenderedStringsOnF1(GuiGraphics guiGraphics, Font font, Component text, int x, int y, int color, float bgRed, float bgGreen, float bgBlue, float bgAlpha, VertexConsumer backgroundVertexBuffer) {
        return !Minecraft.m_91087_().f_91066_.f_92062_;
    }

    @Inject(method={"onDimensionToggleButton"}, at={@At(value="RETURN")})
    public void onDimensionToggleAfter(Button b, CallbackInfo ci) {
        if (!XaeroPlusSettingRegistry.radarWhileDimensionSwitchedSetting.getValue()) {
            WorldMap.settings.minimapRadar = this.mapProcessor.getMapWorld().getFutureDimensionId() == ChunkUtils.getActualDimension();
        }
    }

    @Inject(method={"tick"}, at={@At(value="RETURN")}, remap=true)
    public void onTick(CallbackInfo ci) {
        this.xTextEntryField.m_94120_();
        this.zTextEntryField.m_94120_();
    }

    @Inject(method={"keyPressed"}, at={@At(value="HEAD")}, cancellable=true, remap=true)
    public void onInputPress(int code, int scanCode, int modifiers, CallbackInfoReturnable<Boolean> cir) {
        if (code == 290) {
            Minecraft.m_91087_().f_91066_.f_92062_ = !Minecraft.m_91087_().f_91066_.f_92062_;
            cir.setReturnValue((Object)true);
            return;
        }
        if (this.xTextEntryField.m_94213_() && this.zTextEntryField.m_94213_() && (this.xTextEntryField.m_93696_() || this.zTextEntryField.m_93696_()) && code == 257) {
            this.onGotoCoordinatesButton(null);
            cir.setReturnValue((Object)true);
        }
    }

    @Inject(method={"getRightClickOptions"}, at={@At(value="RETURN")}, remap=false)
    public void getRightClickOptionsInject(CallbackInfoReturnable<ArrayList<RightClickOption>> cir) {
        if (BaritoneHelper.isBaritonePresent()) {
            ResourceKey<Level> customDim = Globals.getCurrentDimensionId();
            ResourceKey<Level> actualDim = ChunkUtils.getActualDimension();
            double customDimDiv = 1.0;
            if (customDim != actualDim) {
                if (customDim == Level.f_46429_ && actualDim == Level.f_46428_) {
                    customDimDiv = 8.0;
                } else if (customDim == Level.f_46428_ && actualDim == Level.f_46429_) {
                    customDimDiv = 0.125;
                }
            }
            final int goalX = (int)((double)this.rightClickX * customDimDiv);
            final int goalZ = (int)((double)this.rightClickZ * customDimDiv);
            ArrayList options = (ArrayList)cir.getReturnValue();
            options.addAll(3, Arrays.asList(new RightClickOption(I18n.m_118938_((String)"gui.world_map.baritone_goal_here", (Object[])new Object[0]), options.size(), this){

                public void onAction(Screen screen) {
                    BaritoneAPI.getProvider().getPrimaryBaritone().getCustomGoalProcess().setGoal((Goal)new GoalXZ(goalX, goalZ));
                }
            }, new RightClickOption(I18n.m_118938_((String)"gui.world_map.baritone_path_here", (Object[])new Object[0]), options.size(), this){

                public void onAction(Screen screen) {
                    BaritoneAPI.getProvider().getPrimaryBaritone().getCustomGoalProcess().setGoalAndPath((Goal)new GoalXZ(goalX, goalZ));
                }
            }));
            if (BaritoneHelper.isBaritoneElytraPresent()) {
                options.addAll(5, Arrays.asList(new RightClickOption(I18n.m_118938_((String)"gui.world_map.baritone_elytra_here", (Object[])new Object[0]), options.size(), this){

                    public void onAction(Screen screen) {
                        BaritoneAPI.getProvider().getPrimaryBaritone().getElytraProcess().pathTo((Goal)new GoalXZ(goalX, goalZ));
                    }
                }));
            }
        }
        if (XaeroPlusSettingRegistry.disableWaypointSharing.getValue()) {
            ((ArrayList)cir.getReturnValue()).removeIf(option -> ((AccessorRightClickOption)option).getName().equals("gui.xaero_right_click_map_share_location"));
        }
    }

    @Unique
    public void addColoredLineToExistingBuffer(PoseStack.Pose matrices, VertexConsumer vertexBuffer, float x1, float y1, float x2, float y2, float r, float g, float b, float a) {
        vertexBuffer.m_252986_(matrices.m_252922_(), x1, y1, 0.0f).m_85950_(r, g, b, a).m_252939_(matrices.m_252943_(), x2 - x1, y2 - y1, 0.0f).m_5752_();
        vertexBuffer.m_252986_(matrices.m_252922_(), x2, y2, 0.0f).m_85950_(r, g, b, a).m_252939_(matrices.m_252943_(), x2 - x1, y2 - y1, 0.0f).m_5752_();
    }

    public void onFollowButton(Button b) {
        Globals.FOLLOW = !Globals.FOLLOW;
        this.m_6575_(Minecraft.m_91087_(), this.f_96543_, this.f_96544_);
    }

    public void onGotoCoordinatesButton(Button b) {
        if (this.xTextEntryField.m_94213_() && this.zTextEntryField.m_94213_()) {
            try {
                int x = Integer.parseInt(this.xTextEntryField.m_94155_());
                int z = Integer.parseInt(this.zTextEntryField.m_94155_());
                this.cameraX = x;
                this.cameraZ = z;
                Globals.FOLLOW = false;
                this.m_6575_(Minecraft.m_91087_(), this.f_96543_, this.f_96544_);
            }
            catch (NumberFormatException e) {
                this.xTextEntryField.m_94144_("");
                this.zTextEntryField.m_94144_("");
                WorldMap.LOGGER.warn("Go to coordinates failed", (Throwable)e);
            }
        } else {
            this.xTextEntryField.m_94194_(true);
            this.zTextEntryField.m_94194_(true);
            this.m_7522_((GuiEventListener)this.xTextEntryField);
            this.xTextEntryField.m_94186_(true);
            this.xTextEntryField.m_93692_(true);
        }
    }

    private void onSwitchDimensionButton(ResourceKey<Level> newDimId) {
        Globals.switchToDimension(newDimId);
    }

    @Unique
    public List<Button> getButtonList() {
        return this.m_6702_().stream().filter(child -> child instanceof Button).map(child -> (Button)child).collect(Collectors.toList());
    }

    @Unique
    public void clearButtons() {
        this.getButtonList().forEach(x$0 -> this.m_169411_((GuiEventListener)x$0));
    }
}

