/*
 * Decompiled with CFR 0.152.
 */
package xaeroplus.feature.render.highlights;

import com.google.common.util.concurrent.Futures;
import com.google.common.util.concurrent.ListenableFuture;
import it.unimi.dsi.fastutil.longs.Long2LongMap;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.Executor;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import net.minecraft.resources.ResourceKey;
import net.minecraft.world.level.Level;
import xaero.map.core.XaeroWorldMapCore;
import xaero.map.gui.GuiMap;
import xaeroplus.Globals;
import xaeroplus.XaeroPlus;
import xaeroplus.feature.render.highlights.ChunkHighlightCache;
import xaeroplus.feature.render.highlights.ChunkHighlightCacheDimensionHandler;
import xaeroplus.feature.render.highlights.ChunkHighlightDatabase;
import xaeroplus.util.ChunkUtils;
import xaeroplus.util.GuiMapHelper;

public class ChunkHighlightSavingCache
implements ChunkHighlightCache {
    private ChunkHighlightCacheDimensionHandler netherCache = null;
    private ChunkHighlightCacheDimensionHandler overworldCache = null;
    private ChunkHighlightCacheDimensionHandler endCache = null;
    private ChunkHighlightDatabase database = null;
    private static final int defaultRegionWindowSize = 2;
    private String currentWorldId;
    private boolean worldCacheInitialized = false;
    private final String databaseName;
    int tickCounter = 0;

    public ChunkHighlightSavingCache(String databaseName) {
        this.databaseName = databaseName;
    }

    @Override
    public boolean addHighlight(int x, int z) {
        try {
            ChunkHighlightCacheDimensionHandler cacheForCurrentDimension = this.getCacheForCurrentDimension();
            if (cacheForCurrentDimension == null) {
                throw new RuntimeException("Didn't find cache for current dimension");
            }
            cacheForCurrentDimension.addHighlight(x, z);
            return true;
        }
        catch (Exception e) {
            XaeroPlus.LOGGER.debug("Error adding highlight to saving cache: {}", (Object)this.databaseName, (Object)e);
            return false;
        }
    }

    public void addHighlight(int x, int z, long foundTime, ResourceKey<Level> dimension) {
        ChunkHighlightCacheDimensionHandler cacheForDimension = this.getCacheForDimension(dimension);
        if (cacheForDimension == null) {
            return;
        }
        cacheForDimension.addHighlight(x, z, foundTime);
    }

    @Override
    public boolean removeHighlight(int x, int z) {
        try {
            ChunkHighlightCacheDimensionHandler cacheForCurrentDimension = this.getCacheForCurrentDimension();
            if (cacheForCurrentDimension == null) {
                throw new RuntimeException("Didn't find cache for current dimension");
            }
            cacheForCurrentDimension.removeHighlight(x, z);
            return true;
        }
        catch (Exception e) {
            XaeroPlus.LOGGER.debug("Error removing highlight from saving cache: {}, {}", new Object[]{x, z, e});
            return false;
        }
    }

    @Override
    public boolean isHighlighted(int chunkPosX, int chunkPosZ, ResourceKey<Level> dimensionId) {
        ChunkHighlightCacheDimensionHandler cacheForDimension = this.getCacheForDimension(dimensionId);
        if (cacheForDimension == null) {
            return false;
        }
        return cacheForDimension.isHighlighted(chunkPosX, chunkPosZ, dimensionId);
    }

    public boolean isHighlighted(int chunkPosX, int chunkPosZ) {
        ChunkHighlightCacheDimensionHandler cacheForDimension = this.getCacheForDimension(ChunkUtils.getActualDimension());
        if (cacheForDimension == null) {
            return false;
        }
        return cacheForDimension.isHighlighted(chunkPosX, chunkPosZ, ChunkUtils.getActualDimension());
    }

    @Override
    public void handleWorldChange() {
        Futures.whenAllComplete(this.saveAllChunks()).call(() -> {
            this.reset();
            this.initializeWorld();
            this.loadChunksInActualDimension();
            return null;
        }, (Executor)Globals.cacheRefreshExecutorService.get());
    }

    public void reset() {
        this.worldCacheInitialized = false;
        this.currentWorldId = null;
        if (this.netherCache != null) {
            this.netherCache.close();
        }
        this.netherCache = null;
        if (this.overworldCache != null) {
            this.overworldCache.close();
        }
        this.overworldCache = null;
        if (this.endCache != null) {
            this.endCache.close();
        }
        this.endCache = null;
        if (this.database != null) {
            this.database.close();
        }
        this.database = null;
    }

    private List<ListenableFuture<?>> saveAllChunks() {
        return this.getAllCaches().stream().map(ChunkHighlightCacheDimensionHandler::writeAllHighlightsToDatabase).collect(Collectors.toList());
    }

    public ChunkHighlightCacheDimensionHandler getCacheForCurrentDimension() {
        ResourceKey<Level> mcDimension = ChunkUtils.getActualDimension();
        if (mcDimension.equals((Object)Level.f_46429_)) {
            return this.netherCache;
        }
        if (mcDimension.equals((Object)Level.f_46428_)) {
            return this.overworldCache;
        }
        if (mcDimension.equals((Object)Level.f_46430_)) {
            return this.endCache;
        }
        return null;
    }

    public ChunkHighlightCacheDimensionHandler getCacheForDimension(ResourceKey<Level> dimension) {
        if (dimension.equals((Object)Level.f_46429_)) {
            return this.netherCache;
        }
        if (dimension.equals((Object)Level.f_46428_)) {
            return this.overworldCache;
        }
        if (dimension.equals((Object)Level.f_46430_)) {
            return this.endCache;
        }
        return null;
    }

    private List<ChunkHighlightCacheDimensionHandler> getAllCaches() {
        return Stream.of(this.netherCache, this.overworldCache, this.endCache).filter(Objects::nonNull).collect(Collectors.toList());
    }

    public List<ChunkHighlightCacheDimensionHandler> getCachesExceptDimension(ResourceKey<Level> dimension) {
        if (dimension.equals((Object)Level.f_46429_)) {
            return Stream.of(this.overworldCache, this.endCache).filter(Objects::nonNull).collect(Collectors.toList());
        }
        if (dimension.equals((Object)Level.f_46428_)) {
            return Stream.of(this.netherCache, this.endCache).filter(Objects::nonNull).collect(Collectors.toList());
        }
        if (dimension.equals((Object)Level.f_46430_)) {
            return Stream.of(this.netherCache, this.overworldCache).filter(Objects::nonNull).collect(Collectors.toList());
        }
        return Collections.emptyList();
    }

    private void initializeWorld() {
        try {
            String worldId = XaeroWorldMapCore.currentSession.getMapProcessor().getCurrentWorldId();
            if (worldId == null) {
                return;
            }
            ResourceKey<Level> dimension = ChunkUtils.getActualDimension();
            if (dimension != Level.f_46428_ && dimension != Level.f_46429_ && dimension != Level.f_46430_) {
                XaeroPlus.LOGGER.error("Unexpected dimension ID: " + dimension + ". Disable Save/Load to Disk to restore functionality.");
                return;
            }
            this.currentWorldId = worldId;
            this.database = new ChunkHighlightDatabase(worldId, this.databaseName);
            this.netherCache = new ChunkHighlightCacheDimensionHandler(-1, this.database);
            this.overworldCache = new ChunkHighlightCacheDimensionHandler(0, this.database);
            this.endCache = new ChunkHighlightCacheDimensionHandler(1, this.database);
            this.worldCacheInitialized = true;
            this.loadChunksInActualDimension();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private void loadChunksInActualDimension() {
        ChunkHighlightCacheDimensionHandler cacheForCurrentDimension = this.getCacheForCurrentDimension();
        if (cacheForCurrentDimension == null) {
            return;
        }
        cacheForCurrentDimension.setWindow(ChunkUtils.actualPlayerRegionX(), ChunkUtils.actualPlayerRegionZ(), 2);
    }

    @Override
    public void onEnable() {
        if (!this.worldCacheInitialized) {
            this.initializeWorld();
        }
    }

    @Override
    public void onDisable() {
        Futures.whenAllComplete(this.saveAllChunks()).call(() -> {
            this.reset();
            return null;
        }, (Executor)Globals.cacheRefreshExecutorService.get());
    }

    @Override
    public Long2LongMap getHighlightsState() {
        return null;
    }

    @Override
    public void loadPreviousState(Long2LongMap state) {
    }

    @Override
    public void handleTick() {
        if (!this.worldCacheInitialized) {
            return;
        }
        if (this.tickCounter > 2400) {
            this.tickCounter = 0;
        }
        if (this.tickCounter++ % 30 != 0) {
            return;
        }
        if (this.tickCounter % 1200 == 0) {
            this.getAllCaches().forEach(ChunkHighlightCacheDimensionHandler::writeAllHighlightsToDatabase);
            return;
        }
        Optional<GuiMap> guiMapOptional = GuiMapHelper.getGuiMap();
        if (guiMapOptional.isPresent()) {
            GuiMap guiMap = guiMapOptional.get();
            ResourceKey<Level> mapDimension = Globals.getCurrentDimensionId();
            int mapCenterX = GuiMapHelper.getGuiMapCenterRegionX(guiMap);
            int mapCenterZ = GuiMapHelper.getGuiMapCenterRegionZ(guiMap);
            int mapSize = GuiMapHelper.getGuiMapRegionSize(guiMap);
            ChunkHighlightCacheDimensionHandler cacheForDimension = this.getCacheForDimension(mapDimension);
            if (cacheForDimension != null) {
                cacheForDimension.setWindow(mapCenterX, mapCenterZ, mapSize);
            }
            this.getCachesExceptDimension(mapDimension).forEach(cache -> cache.setWindow(0, 0, 0));
        } else {
            ChunkHighlightCacheDimensionHandler cacheForDimension = this.getCacheForDimension(Globals.getCurrentDimensionId());
            if (cacheForDimension != null) {
                cacheForDimension.setWindow(ChunkUtils.getPlayerRegionX(), ChunkUtils.getPlayerRegionZ(), 2);
            }
            this.getCachesExceptDimension(Globals.getCurrentDimensionId()).forEach(cache -> cache.setWindow(0, 0, 0));
        }
    }
}

