/*
 * Decompiled with CFR 0.152.
 */
package xaeroplus.feature.render.highlights;

import com.google.common.collect.Lists;
import java.io.Closeable;
import java.nio.file.Path;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.ResultSet;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import xaero.map.WorldMap;
import xaeroplus.XaeroPlus;
import xaeroplus.feature.render.highlights.ChunkHighlightData;
import xaeroplus.util.ChunkUtils;

public class ChunkHighlightDatabase
implements Closeable {
    public static int MAX_HIGHLIGHTS_LIST = 25000;
    private final Connection connection;
    protected final String databaseName;

    public ChunkHighlightDatabase(String worldId, String databaseName) {
        this.databaseName = databaseName;
        try {
            Path dbPath = WorldMap.saveFolder.toPath().resolve(worldId).resolve(databaseName + ".db");
            this.connection = DriverManager.getConnection("jdbc:rfresh_sqlite:" + dbPath);
            this.createHighlightsTables();
        }
        catch (Exception e) {
            XaeroPlus.LOGGER.error("Error while creating chunk highlight database: {}", (Object)databaseName, (Object)e);
            throw new RuntimeException(e);
        }
    }

    private void createHighlightsTables() {
        try {
            this.connection.createStatement().execute("CREATE TABLE IF NOT EXISTS \"0\" (x INTEGER, z INTEGER, foundTime INTEGER)");
            this.connection.createStatement().execute("CREATE TABLE IF NOT EXISTS \"-1\" (x INTEGER, z INTEGER, foundTime INTEGER)");
            this.connection.createStatement().execute("CREATE TABLE IF NOT EXISTS \"1\" (x INTEGER, z INTEGER, foundTime INTEGER)");
            this.connection.createStatement().execute("CREATE UNIQUE INDEX IF NOT EXISTS unique_xzO ON \"0\" (x, z)");
            this.connection.createStatement().execute("CREATE UNIQUE INDEX IF NOT EXISTS unique_xzN ON \"-1\" (x, z)");
            this.connection.createStatement().execute("CREATE UNIQUE INDEX IF NOT EXISTS unique_xzE ON \"1\" (x, z)");
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public void insertHighlightList(List<ChunkHighlightData> chunks, int dimension) {
        if (chunks.isEmpty()) {
            return;
        }
        if (chunks.size() > MAX_HIGHLIGHTS_LIST) {
            Lists.partition(chunks, (int)MAX_HIGHLIGHTS_LIST).forEach(l -> this.insertHighlightsListInternal((List<ChunkHighlightData>)l, dimension));
        } else {
            this.insertHighlightsListInternal(chunks, dimension);
        }
    }

    private void insertHighlightsListInternal(List<ChunkHighlightData> chunks, int dimension) {
        try {
            String statement = "INSERT OR IGNORE INTO \"" + dimension + "\" VALUES ";
            statement = statement + chunks.stream().map(chunk -> "(" + chunk.x() + ", " + chunk.z() + ", " + chunk.foundTime() + ")").collect(Collectors.joining(", "));
            this.connection.createStatement().execute(statement);
        }
        catch (Exception e) {
            XaeroPlus.LOGGER.error("Error inserting chunks into database", (Throwable)e);
        }
    }

    public List<ChunkHighlightData> getHighlightsInWindow(int dimension, int regionXMin, int regionXMax, int regionZMin, int regionZMax) {
        try {
            ResultSet resultSet = this.connection.createStatement().executeQuery("SELECT * FROM \"" + dimension + "\" WHERE x >= " + ChunkUtils.regionCoordToChunkCoord(regionXMin) + " AND x <= " + ChunkUtils.regionCoordToChunkCoord(regionXMax) + " AND z >= " + ChunkUtils.regionCoordToChunkCoord(regionZMin) + " AND z <= " + ChunkUtils.regionCoordToChunkCoord(regionZMax));
            ArrayList<ChunkHighlightData> chunks = new ArrayList<ChunkHighlightData>();
            while (resultSet.next()) {
                chunks.add(new ChunkHighlightData(resultSet.getInt("x"), resultSet.getInt("z"), resultSet.getInt("foundTime")));
            }
            return chunks;
        }
        catch (Exception e) {
            XaeroPlus.LOGGER.error("Error getting chunks from database", (Throwable)e);
            return Collections.emptyList();
        }
    }

    public void removeHighlight(int x, int z, int dimension) {
        try {
            this.connection.createStatement().execute("DELETE FROM \"" + dimension + "\" WHERE x = " + x + " AND z = " + z);
        }
        catch (Exception e) {
            XaeroPlus.LOGGER.error("Error while removing highlight from database", (Throwable)e);
        }
    }

    @Override
    public void close() {
        try {
            this.connection.close();
        }
        catch (Exception e) {
            XaeroPlus.LOGGER.warn("Failed closing database connection", (Throwable)e);
        }
    }
}

