/*
 * Decompiled with CFR 0.152.
 */
package xaeroplus.feature.render;

import xaeroplus.settings.TranslatableSettingEnum;

public class ColorHelper {
    public static int getColor(int r, int g, int b, int a) {
        return (a & 0xFF) << 24 | (r & 0xFF) << 16 | (g & 0xFF) << 8 | b & 0xFF;
    }

    public static int getColorWithAlpha(int colorInt, int a) {
        return (a & 0xFF) << 24 | colorInt & 0xFFFFFF;
    }

    public static float[] getColorRGBA(int colorInt) {
        return new float[]{(float)(colorInt >> 16 & 0xFF) / 255.0f, (float)(colorInt >> 8 & 0xFF) / 255.0f, (float)(colorInt & 0xFF) / 255.0f, (float)(colorInt >> 24 & 0xFF) / 255.0f};
    }

    public static int getColorAlpha(int colorInt) {
        return colorInt >> 24 & 0xFF;
    }

    public static enum WaystoneColor implements TranslatableSettingEnum
    {
        BLACK(0, "gui.xaero_black"),
        DARK_BLUE(1, "gui.xaero_dark_blue"),
        DARK_GREEN(2, "gui.xaero_dark_green"),
        DARK_AQUA(3, "gui.xaero_dark_aqua"),
        DARK_RED(4, "gui.xaero_dark_red"),
        DARK_PURPLE(5, "gui.xaero_dark_purple"),
        GOLD(6, "gui.xaero_gold"),
        GRAY(7, "gui.xaero_gray"),
        DARK_GRAY(8, "gui.xaero_dark_gray"),
        BLUE(9, "gui.xaero_blue"),
        GREEN(10, "gui.xaero_green"),
        AQUA(11, "gui.xaero_aqua"),
        RED(12, "gui.xaero_red"),
        LIGHT_PURPLE(13, "gui.xaero_purple"),
        YELLOW(14, "gui.xaero_yellow"),
        WHITE(15, "gui.xaero_white"),
        RANDOM(16, "gui.xaeroplus.random");

        private final int colorIndex;
        private final String translationKey;

        private WaystoneColor(int colorIndex, String translationKey) {
            this.colorIndex = colorIndex;
            this.translationKey = translationKey;
        }

        public int getColorIndex() {
            return this.colorIndex;
        }

        @Override
        public String getTranslationKey() {
            return this.translationKey;
        }
    }

    public static enum HighlightColor implements TranslatableSettingEnum
    {
        RED(ColorHelper.getColor(255, 0, 0, 100), "gui.xaero_red"),
        GREEN(ColorHelper.getColor(0, 255, 0, 100), "gui.xaero_green"),
        BLUE(ColorHelper.getColor(0, 0, 255, 100), "gui.xaero_blue"),
        YELLOW(ColorHelper.getColor(255, 255, 0, 100), "gui.xaero_yellow"),
        CYAN(ColorHelper.getColor(0, 255, 255, 100), "gui.xaero_aqua"),
        MAGENTA(ColorHelper.getColor(255, 0, 255, 100), "gui.xaero_purple"),
        WHITE(ColorHelper.getColor(255, 255, 255, 100), "gui.xaero_white"),
        BLACK(ColorHelper.getColor(0, 0, 0, 100), "gui.xaero_black");

        private final int color;
        private final String translationKey;

        private HighlightColor(int color, String translationKey) {
            this.color = color;
            this.translationKey = translationKey;
        }

        public int getColor() {
            return this.color;
        }

        @Override
        public String getTranslationKey() {
            return this.translationKey;
        }
    }
}

