/*
 * Decompiled with CFR 0.152.
 */
package uk.co.hexeption.rsinfinitybooster.mixins;

import com.refinedmods.refinedstorage.api.network.INetwork;
import com.refinedmods.refinedstorage.api.network.item.INetworkItem;
import com.refinedmods.refinedstorage.api.network.item.INetworkItemManager;
import com.refinedmods.refinedstorage.api.network.item.INetworkItemProvider;
import com.refinedmods.refinedstorage.api.network.node.INetworkNode;
import com.refinedmods.refinedstorage.apiimpl.network.item.NetworkItemManager;
import com.refinedmods.refinedstorage.apiimpl.network.node.WirelessTransmitterNetworkNode;
import com.refinedmods.refinedstorage.inventory.player.PlayerSlot;
import java.util.Map;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import uk.co.hexeption.rsinfinitybooster.utils.CardUtil;

@Mixin(value={NetworkItemManager.class}, remap=false)
public abstract class MixinNetworkItemManager
implements INetworkItemManager {
    @Shadow
    @Final
    private INetwork network;
    @Shadow
    @Final
    private Map<Player, INetworkItem> items;

    @Inject(method={"open"}, at={@At(value="HEAD")}, cancellable=true)
    private void onOpen(Player player, ItemStack itemStack, PlayerSlot playerSlot, CallbackInfo ci) {
        this.network.getNodeGraph().all().forEach(iNetworkNode -> {
            INetworkNode node = iNetworkNode.getNode();
            if (node instanceof WirelessTransmitterNetworkNode) {
                WirelessTransmitterNetworkNode transmitter = (WirelessTransmitterNetworkNode)node;
                if (!transmitter.isActive()) {
                    return;
                }
                if (CardUtil.isDimensionCard(transmitter.getUpgrades())) {
                    INetworkItem item = ((INetworkItemProvider)itemStack.m_41720_()).provide((INetworkItemManager)this, player, itemStack, playerSlot);
                    if (item.onOpen(this.network)) {
                        this.items.put(player, item);
                    }
                    ci.cancel();
                }
            }
        });
    }
}

