/*
 * Decompiled with CFR 0.152.
 */
package fr.alasdiablo.jerintegration.compat;

import fr.alasdiablo.jerintegration.JERIntegration;
import fr.alasdiablo.jerintegration.compat.create.CreateWorldGen;
import fr.alasdiablo.jerintegration.compat.immersiveengineering.ImmersiveEngineeringWorldGen;
import fr.alasdiablo.jerintegration.compat.mekanism.MekanismWorldGen;
import fr.alasdiablo.jerintegration.compat.miningmaster.MiningMasterWorldGen;
import fr.alasdiablo.jerintegration.compat.randomite.RandomiteWorldGen;
import fr.alasdiablo.jerintegration.compat.tconstruct.TConstructWorldGen;
import fr.alasdiablo.jerintegration.compat.thermal.ThermalWorldGen;
import java.io.PrintWriter;
import java.io.StringWriter;
import jeresources.api.IJERAPI;
import jeresources.compatibility.api.JERAPI;
import org.jetbrains.annotations.NotNull;

public class CompatibilityHandler {
    public static void init() {
        IJERAPI api = JERAPI.getInstance();
        if (JERIntegration.Compat.CREATE && ((Boolean)JERIntegration.DisableConfig.CONFIG.CREATE.get()).booleanValue()) {
            try {
                JERIntegration.LOGGER.info("Applying Create patch");
                new CreateWorldGen().register(api);
            }
            catch (Exception e) {
                JERIntegration.LOGGER.info("Failing to apply patch for Create");
                CompatibilityHandler.loggerError(e);
            }
        }
        if (JERIntegration.Compat.IMMERSIVE_ENGINEERING && ((Boolean)JERIntegration.DisableConfig.CONFIG.IMMERSIVE_ENGINEERING.get()).booleanValue()) {
            try {
                JERIntegration.LOGGER.info("Applying Immersive Engineering patch");
                new ImmersiveEngineeringWorldGen().register(api);
            }
            catch (Exception e) {
                JERIntegration.LOGGER.info("Failing to apply patch for Immersive Engineering");
                CompatibilityHandler.loggerError(e);
            }
        }
        if (JERIntegration.Compat.TINKERS_CONSTRUCT && ((Boolean)JERIntegration.DisableConfig.CONFIG.TINKERS_CONSTRUCT.get()).booleanValue()) {
            try {
                JERIntegration.LOGGER.info("Applying Tinkers' Construct patch");
                new TConstructWorldGen().register(api);
            }
            catch (Exception e) {
                JERIntegration.LOGGER.info("Failing to apply patch for Tinkers' Construct");
                CompatibilityHandler.loggerError(e);
            }
        }
        if (JERIntegration.Compat.MEKANISM && ((Boolean)JERIntegration.DisableConfig.CONFIG.MEKANISM.get()).booleanValue()) {
            try {
                JERIntegration.LOGGER.info("Applying Mekanism patch");
                new MekanismWorldGen().register(api);
            }
            catch (Exception e) {
                JERIntegration.LOGGER.info("Failing to apply patch for Mekanism");
                CompatibilityHandler.loggerError(e);
            }
        }
        if (JERIntegration.Compat.RANDOMITE && ((Boolean)JERIntegration.DisableConfig.CONFIG.RANDOMITE.get()).booleanValue()) {
            try {
                JERIntegration.LOGGER.info("Applying Randomite patch");
                new RandomiteWorldGen().register(api);
            }
            catch (Exception e) {
                JERIntegration.LOGGER.info("Failing to apply patch for Randomite");
                CompatibilityHandler.loggerError(e);
            }
        }
        if (JERIntegration.Compat.MINING_MASTER && ((Boolean)JERIntegration.DisableConfig.CONFIG.MINING_MASTER.get()).booleanValue()) {
            try {
                JERIntegration.LOGGER.info("Applying Mining Master patch");
                new MiningMasterWorldGen().register(api);
            }
            catch (Exception e) {
                JERIntegration.LOGGER.info("Failing to apply patch for Mining Master");
                CompatibilityHandler.loggerError(e);
            }
        }
        if (JERIntegration.Compat.THERMAL && ((Boolean)JERIntegration.DisableConfig.CONFIG.THERMAL.get()).booleanValue()) {
            try {
                JERIntegration.LOGGER.info("Applying Thermal patch");
                new ThermalWorldGen().register(api);
            }
            catch (Exception e) {
                JERIntegration.LOGGER.info("Failing to apply patch for Thermal");
                CompatibilityHandler.loggerError(e);
            }
        }
    }

    private static void loggerError(@NotNull Exception e) {
        StringWriter message = new StringWriter();
        PrintWriter writer = new PrintWriter(message);
        e.printStackTrace(writer);
        JERIntegration.LOGGER.debug((Object)message);
    }
}

