/*
 * Decompiled with CFR 0.152.
 */
package net.mehvahdjukaar.jeed.plugin.rei.display;

import java.util.ArrayList;
import java.util.List;
import me.shedaniel.rei.api.common.category.CategoryIdentifier;
import me.shedaniel.rei.api.common.display.Display;
import me.shedaniel.rei.api.common.entry.EntryIngredient;
import me.shedaniel.rei.api.common.entry.EntryStack;
import me.shedaniel.rei.api.common.util.EntryIngredients;
import net.mehvahdjukaar.jeed.common.EffectInfo;
import net.mehvahdjukaar.jeed.plugin.rei.REIPlugin;
import net.minecraft.network.chat.Component;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.item.ItemStack;

public class EffectInfoDisplay
extends EffectInfo
implements Display {
    private final List<EntryIngredient> inputEntries;
    private final List<EntryIngredient> outputEntries;
    private final List<Component> componentList;

    protected EffectInfoDisplay(MobEffectInstance effectInstance, List<ItemStack> inputs, Component description) {
        super(effectInstance, inputs, List.of(description));
        ArrayList<EntryIngredient> list = new ArrayList<EntryIngredient>(this.inputItems.stream().map(EntryIngredients::of).toList());
        this.outputEntries = List.of(EntryIngredient.of((EntryStack)EntryStack.of(REIPlugin.EFFECT_ENTRY_TYPE, (Object)effectInstance).normalize()));
        list.addAll(this.outputEntries);
        this.inputEntries = list.stream().toList();
        this.componentList = List.of(description);
    }

    public List<Component> getComponents() {
        return this.componentList;
    }

    public List<EntryIngredient> getInputEntries() {
        return this.inputEntries;
    }

    public List<EntryIngredient> getOutputEntries() {
        return this.outputEntries;
    }

    public CategoryIdentifier<?> getCategoryIdentifier() {
        return REIPlugin.EFFECTS_INFO_CATEGORY;
    }

    public static EffectInfoDisplay create(MobEffect effect) {
        Component text = EffectInfoDisplay.getDescription(effect);
        return new EffectInfoDisplay(new MobEffectInstance(effect), EffectInfoDisplay.computeEffectProviders(effect), text);
    }
}

