/*
 * Decompiled with CFR 0.152.
 */
package net.mehvahdjukaar.jeed.compat;

import net.mehvahdjukaar.jeed.Jeed;
import net.mehvahdjukaar.jeed.api.IEffectScreenExtension;
import net.mehvahdjukaar.jeed.api.JeedAPI;
import net.minecraft.client.gui.screens.inventory.BeaconScreen;
import net.minecraft.client.gui.screens.inventory.EffectRenderingInventoryScreen;
import net.minecraft.world.effect.MobEffectInstance;
import org.jetbrains.annotations.Nullable;

public class NativeCompat {
    private static MobEffectInstance inventoryHoveredEffect;
    private static boolean small;
    private static final IEffectScreenExtension<BeaconScreen> BEACON_EXTENSION;
    public static final IEffectScreenExtension<EffectRenderingInventoryScreen> INVENTORY_EXTENSION;

    public static void init() {
        JeedAPI.registerScreenExtension(EffectRenderingInventoryScreen.class, INVENTORY_EXTENSION);
        JeedAPI.registerScreenExtension(BeaconScreen.class, BEACON_EXTENSION);
    }

    public static void setInventoryEffect(@Nullable MobEffectInstance hoveredEffect, boolean isSmall) {
        inventoryHoveredEffect = hoveredEffect;
        small = isSmall;
    }

    static {
        small = false;
        BEACON_EXTENSION = (screen, mouseX, mouseY, reason) -> {
            if (reason != IEffectScreenExtension.CallReason.MOUSE_CLICKED) {
                for (BeaconScreen.BeaconButton b : screen.f_169612_) {
                    BeaconScreen.BeaconPowerButton pb;
                    if (!(b instanceof BeaconScreen.BeaconPowerButton) || !(pb = (BeaconScreen.BeaconPowerButton)b).m_274382_()) continue;
                    int tier = b.getClass() != BeaconScreen.BeaconPowerButton.class ? 1 : 0;
                    return new MobEffectInstance(pb.f_98000_, 0, tier);
                }
            }
            return null;
        };
        INVENTORY_EXTENSION = new IEffectScreenExtension<EffectRenderingInventoryScreen>(){

            @Override
            @Nullable
            public MobEffectInstance getEffectAtPosition(EffectRenderingInventoryScreen screen, double mouseX, double mouseY, IEffectScreenExtension.CallReason reason) {
                if (!reason.isForRender() || screen.f_97734_ == null && screen.m_6262_().m_142621_().m_41619_()) {
                    if (small && reason == IEffectScreenExtension.CallReason.TOOLTIP && !Jeed.suppressVanillaTooltips()) {
                        return null;
                    }
                    return inventoryHoveredEffect;
                }
                return null;
            }

            @Override
            public boolean showDurationOnTooltip() {
                return small;
            }
        };
    }
}

