/*
 * Decompiled with CFR 0.152.
 */
package net.mehvahdjukaar.jeed.common;

import java.util.IdentityHashMap;
import java.util.List;
import java.util.Map;
import net.mehvahdjukaar.jeed.api.IEffectScreenExtension;
import net.mehvahdjukaar.jeed.common.EffectRenderer;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.network.chat.Component;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.item.TooltipFlag;

public class ScreenExtensionsHandler {
    public static final Map<Class<? extends Screen>, IEffectScreenExtension<? extends Screen>> EXTENSIONS = new IdentityHashMap<Class<? extends Screen>, IEffectScreenExtension<? extends Screen>>();

    public static <T extends Screen, E extends IEffectScreenExtension<T>> E getExtension(T screen) {
        Class<?> c = screen.getClass();
        IEffectScreenExtension<? extends Screen> direct = EXTENSIONS.get(c);
        if (direct != null) {
            return (E)direct;
        }
        for (Map.Entry<Class<? extends Screen>, IEffectScreenExtension<? extends Screen>> e : EXTENSIONS.entrySet()) {
            if (!e.getKey().isInstance(screen)) continue;
            return (E)e.getValue();
        }
        return null;
    }

    public static <T extends Screen> void registerScreenExtension(Class<T> screenClass, IEffectScreenExtension<T> extension) {
        EXTENSIONS.put(screenClass, extension);
    }

    public static <T extends Screen> void unRegisterExtension(Class<T> screenClass) {
        EXTENSIONS.remove(screenClass);
    }

    public static void renderEffectTooltip(MobEffectInstance effect, Screen screen, GuiGraphics graphics, int x, int y, boolean showDuration) {
        Minecraft mc = Minecraft.m_91087_();
        TooltipFlag.Default flag = mc.f_91066_.f_92125_ ? TooltipFlag.Default.f_256730_ : TooltipFlag.Default.f_256752_;
        List<Component> tooltip = EffectRenderer.getTooltipsWithDescription(effect, (TooltipFlag)flag, true, showDuration);
        if (!tooltip.isEmpty()) {
            graphics.m_280666_(mc.f_91062_, tooltip, x, y);
        }
    }
}

