/*
 * Decompiled with CFR 0.152.
 */
package com.christofmeg.justenoughbreeding.jei;

import com.christofmeg.justenoughbreeding.recipe.BreedingRecipe;
import com.christofmeg.justenoughbreeding.utils.Utils;
import mezz.jei.api.constants.VanillaTypes;
import mezz.jei.api.gui.builder.IRecipeLayoutBuilder;
import mezz.jei.api.gui.drawable.IDrawable;
import mezz.jei.api.gui.ingredient.IRecipeSlotsView;
import mezz.jei.api.helpers.IGuiHelper;
import mezz.jei.api.ingredients.IIngredientType;
import mezz.jei.api.recipe.IFocusGroup;
import mezz.jei.api.recipe.RecipeIngredientRole;
import mezz.jei.api.recipe.RecipeType;
import mezz.jei.api.recipe.category.IRecipeCategory;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.DyeColor;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import org.jetbrains.annotations.NotNull;

public class BreedingCategory
implements IRecipeCategory<BreedingRecipe> {
    public static final RecipeType<BreedingRecipe> TYPE = new RecipeType(new ResourceLocation("justenoughbreeding", "breeding"), BreedingRecipe.class);
    final ResourceLocation slotVanilla = new ResourceLocation("jei", "textures/jei/atlas/gui/slot.png");
    final ResourceLocation guiVanilla = new ResourceLocation("jei", "textures/jei/gui/gui_vanilla.png");
    private final IDrawable background;
    private final IDrawable icon;
    private final IDrawable slot;
    private final IDrawable outputSlot;
    private final IDrawable mobRenderSlotTop;
    private final IDrawable mobRenderSlotBottom;
    private final IDrawable mobRenderSlotLeft;
    private final IDrawable mobRenderSlotRight;
    private final IDrawable mobRenderSlotTopCorner;
    private final IDrawable mobRenderSlotTopCenter;
    final int inputSlotItemX = 69;
    final int inputSlotFrameX = 68;
    final int inputSlot1ItemY = 52;
    final int inputSlot1FrameY = 51;
    final int inputSlot2FrameY = 32;
    final int outputSlotFrameX = 94;
    final int outputSlotFrameY = 38;

    public BreedingCategory(IGuiHelper helper, ItemLike itemStack) {
        this.background = helper.createBlankDrawable(151, 91);
        this.icon = helper.createDrawableIngredient((IIngredientType)VanillaTypes.ITEM_STACK, (Object)new ItemStack(itemStack));
        this.slot = helper.drawableBuilder(this.slotVanilla, 0, 0, 18, 18).setTextureSize(18, 18).build();
        this.outputSlot = helper.drawableBuilder(this.guiVanilla, 25, 224, 57, 26).setTextureSize(256, 256).build();
        this.mobRenderSlotTop = helper.drawableBuilder(this.guiVanilla, 56, 128, 25, 1).setTextureSize(256, 256).build();
        this.mobRenderSlotBottom = helper.drawableBuilder(this.guiVanilla, 57, 153, 25, 1).setTextureSize(256, 256).build();
        this.mobRenderSlotLeft = helper.drawableBuilder(this.guiVanilla, 56, 129, 1, 24).setTextureSize(256, 256).build();
        this.mobRenderSlotRight = helper.drawableBuilder(this.guiVanilla, 81, 129, 1, 24).setTextureSize(256, 256).build();
        this.mobRenderSlotTopCorner = helper.drawableBuilder(this.guiVanilla, 81, 128, 1, 1).setTextureSize(256, 256).build();
        this.mobRenderSlotTopCenter = helper.drawableBuilder(this.guiVanilla, 57, 129, 24, 24).setTextureSize(256, 256).build();
    }

    @NotNull
    public RecipeType<BreedingRecipe> getRecipeType() {
        return TYPE;
    }

    @NotNull
    public Component getTitle() {
        return Component.m_237115_((String)"translation.justenoughbreeding.breeding");
    }

    @NotNull
    public IDrawable getBackground() {
        return this.background;
    }

    @NotNull
    public IDrawable getIcon() {
        return this.icon;
    }

    public void setRecipe(IRecipeLayoutBuilder builder, BreedingRecipe recipe, @NotNull IFocusGroup focuses) {
        builder.addSlot(RecipeIngredientRole.INPUT, 134, 1).addItemStack(recipe.spawnEgg);
        builder.addInvisibleIngredients(RecipeIngredientRole.OUTPUT).addItemStack(recipe.spawnEgg);
        builder.addSlot(RecipeIngredientRole.INPUT, 69, 52).addIngredients(recipe.breedingCatalyst);
        int outputSlotItemX = 130;
        int outputSlotItemY = 43;
        int inputSlot2ItemY = 33;
        if (recipe.resultItemStack != null && !recipe.resultItemStack.m_43947_()) {
            builder.addSlot(RecipeIngredientRole.OUTPUT, 130, 43).addIngredients(recipe.resultItemStack);
        }
        if (recipe.extraInputStack != null && !recipe.extraInputStack.m_43947_()) {
            builder.addSlot(RecipeIngredientRole.INPUT, 69, 33).addIngredients(recipe.extraInputStack);
        }
    }

    public void draw(@NotNull BreedingRecipe recipe, @NotNull IRecipeSlotsView recipeSlotsView, @NotNull GuiGraphics stack, double mouseX, double mouseY) {
        this.slot.draw(stack, 133, 0);
        this.slot.draw(stack, 68, 51);
        this.slot.draw(stack, 68, 32);
        this.outputSlot.draw(stack, 94, 38);
        this.mobRenderSlotTop.draw(stack, 0, 10);
        this.mobRenderSlotTop.draw(stack, 25, 10);
        this.mobRenderSlotTop.draw(stack, 35, 10);
        this.mobRenderSlotTopCorner.draw(stack, 60, 10);
        this.mobRenderSlotTopCorner.draw(stack, 0, 90);
        this.mobRenderSlotBottom.draw(stack, 1, 90);
        this.mobRenderSlotBottom.draw(stack, 26, 90);
        this.mobRenderSlotBottom.draw(stack, 36, 90);
        this.mobRenderSlotLeft.draw(stack, 0, 11);
        this.mobRenderSlotLeft.draw(stack, 0, 35);
        this.mobRenderSlotLeft.draw(stack, 0, 59);
        this.mobRenderSlotLeft.draw(stack, 0, 66);
        this.mobRenderSlotRight.draw(stack, 60, 11);
        this.mobRenderSlotRight.draw(stack, 60, 35);
        this.mobRenderSlotRight.draw(stack, 60, 59);
        this.mobRenderSlotRight.draw(stack, 60, 66);
        this.mobRenderSlotTopCenter.draw(stack, 1, 11);
        this.mobRenderSlotTopCenter.draw(stack, 25, 11);
        this.mobRenderSlotTopCenter.draw(stack, 36, 11);
        this.mobRenderSlotTopCenter.draw(stack, 1, 35);
        this.mobRenderSlotTopCenter.draw(stack, 25, 35);
        this.mobRenderSlotTopCenter.draw(stack, 36, 35);
        this.mobRenderSlotTopCenter.draw(stack, 1, 59);
        this.mobRenderSlotTopCenter.draw(stack, 25, 59);
        this.mobRenderSlotTopCenter.draw(stack, 36, 59);
        this.mobRenderSlotTopCenter.draw(stack, 1, 66);
        this.mobRenderSlotTopCenter.draw(stack, 25, 66);
        this.mobRenderSlotTopCenter.draw(stack, 36, 66);
        EntityType<?> entityType = recipe.entityType;
        if (entityType != null) {
            LivingEntity currentLivingEntity;
            Minecraft instance = Minecraft.m_91087_();
            Font font = instance.f_91062_;
            MutableComponent entityName = Component.m_237115_((String)entityType.m_20675_());
            Object entityNameString = entityName.getString();
            if (recipe.needsToBeTamed != null) {
                MutableComponent tamed = Component.m_237115_((String)"translation.justenoughbreeding.tamed");
                entityNameString = (String)entityNameString + " (" + tamed.getString() + ")";
            } else if (recipe.animalTrusting != null) {
                MutableComponent trusting = Component.m_237115_((String)"translation.justenoughbreeding.trusting");
                entityNameString = (String)entityNameString + " (" + trusting.getString() + ")";
            } else if (recipe.spawnEgg.m_41778_().startsWith("item.tfc")) {
                MutableComponent familiarity = Component.m_237115_((String)"tfc.jade.familiarity");
                String tfc = familiarity.getString().replaceAll(":[^:]*$", "");
                entityNameString = (String)entityNameString + " (" + tfc + " > 30)";
            }
            int stringWidth = font.m_92895_((String)entityNameString);
            int availableWidth = 154;
            if (stringWidth > availableWidth) {
                float pixelWidthPerCharacter = (float)stringWidth / (float)((String)entityNameString).length();
                int maxCharacters = (int)((float)availableWidth / pixelWidthPerCharacter);
                entityNameString = ((String)entityNameString).substring(0, maxCharacters);
            }
            if (!((String)entityNameString).isEmpty()) {
                Component abbreviatedEntityName = Component.m_130674_((String)entityNameString);
                stack.m_280614_(font, abbreviatedEntityName, 0, 0, DyeColor.BLACK.m_41071_(), false);
            }
            if ((currentLivingEntity = recipe.doRendering()) != null) {
                Utils.renderEntity(stack.m_280168_(), mouseX, currentLivingEntity);
            }
        }
    }
}

