/*
 * Decompiled with CFR 0.152.
 */
package com.christofmeg.justenoughbreeding.emi;

import com.christofmeg.justenoughbreeding.CommonConstants;
import com.christofmeg.justenoughbreeding.JustEnoughBreeding;
import com.christofmeg.justenoughbreeding.emi.BreedingCategoryEMI;
import com.christofmeg.justenoughbreeding.recipe.BreedingRecipe;
import com.christofmeg.justenoughbreeding.utils.Utils;
import dev.emi.emi.api.EmiRegistry;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.SpawnEggItem;
import net.minecraft.world.item.crafting.Ingredient;

public class EMIUtils {
    public static void registerMobBreedingRecipes(EmiRegistry registration) {
        ArrayList<String> sortedMobNames = new ArrayList<String>(CommonConstants.breedingIngredients.keySet());
        Collections.sort(sortedMobNames);
        for (String mobName : sortedMobNames) {
            int mobMaxResultCount;
            BreedingRecipe breedingRecipe;
            String mobExtraIngredients;
            Ingredient combinedExtraIngredient;
            Boolean animalTrusting;
            Boolean needsToBeTamed;
            EntityType<?> entityType;
            String mobResultItem;
            if (mobName == null || CommonConstants.breedingIngredients == null) continue;
            String mobIngredients = CommonConstants.breedingIngredients.get(mobName);
            String string = mobResultItem = CommonConstants.breedingEggResult.get(mobName) != null ? CommonConstants.breedingEggResult.get(mobName) : "";
            if (CommonConstants.sharedGetSpawnEggFromEntity != null && CommonConstants.sharedGetSpawnEggFromEntity.get(mobName) != null) {
                int mobMaxResultCount2;
                String mobSpawnEgg = CommonConstants.sharedGetSpawnEggFromEntity.get(mobName);
                int mobMinResultCount = CommonConstants.breedingEggResultMinAmount.get(mobName) != null ? CommonConstants.breedingEggResultMinAmount.get(mobName) : 1;
                int n = mobMaxResultCount2 = CommonConstants.breedingEggResultMaxAmount.get(mobName) != null ? CommonConstants.breedingEggResultMaxAmount.get(mobName) : 1;
                if (mobIngredients != null && mobSpawnEgg != null) {
                    Ingredient combinedIngredient = Utils.createCombinedIngredient(mobIngredients);
                    List<Ingredient> combinedResultIngredient = Utils.createCombinedResultIngredients(mobResultItem, mobMinResultCount, mobMaxResultCount2);
                    Item spawnEggItem = JustEnoughBreeding.getItemFromLoaderRegistries(new ResourceLocation(mobSpawnEgg.trim()));
                    if (spawnEggItem instanceof SpawnEggItem) {
                        SpawnEggItem spawnEgg = (SpawnEggItem)spawnEggItem;
                        entityType = spawnEgg.m_43228_(null);
                        needsToBeTamed = CommonConstants.breedingNeedsToBeTamed.get(mobName);
                        animalTrusting = CommonConstants.breedingNeedsToBeTrusting.get(mobName);
                        combinedExtraIngredient = null;
                        if (CommonConstants.breedingExtraIngredients != null && CommonConstants.breedingExtraIngredients.get(mobName) != null && (mobExtraIngredients = CommonConstants.breedingExtraIngredients.get(mobName)) != null) {
                            combinedExtraIngredient = Utils.createCombinedIngredient(mobExtraIngredients);
                        }
                        breedingRecipe = Utils.createBreedingRecipe(entityType, combinedIngredient, spawnEggItem, needsToBeTamed, combinedResultIngredient, animalTrusting, combinedExtraIngredient);
                        registration.addRecipe(BreedingCategoryEMI.builder().id(new ResourceLocation("justenoughbreeding", "breeding/" + breedingRecipe.entityType.m_20675_() + "/" + breedingRecipe.spawnEgg.m_41778_())).breedingRecipe(breedingRecipe).build());
                    }
                }
            }
            if (CommonConstants.breedingGetSpawnEggFromItem == null || CommonConstants.breedingGetMobFromString == null || CommonConstants.breedingGetSpawnEggFromItem.get(mobName) == null || CommonConstants.breedingGetMobFromString.get(mobName) == null) continue;
            String mobSpawnEggItem = CommonConstants.breedingGetSpawnEggFromItem.get(mobName);
            String mobEntityName = CommonConstants.breedingGetMobFromString.get(mobName);
            int mobMinResultCount = CommonConstants.breedingEggResultMinAmount.get(mobName) != null ? CommonConstants.breedingEggResultMinAmount.get(mobName) : 1;
            int n = mobMaxResultCount = CommonConstants.breedingEggResultMaxAmount.get(mobName) != null ? CommonConstants.breedingEggResultMaxAmount.get(mobName) : 1;
            if (mobIngredients == null || mobSpawnEggItem == null || mobEntityName == null) continue;
            Ingredient combinedIngredient = Utils.createCombinedIngredient(mobIngredients);
            List<Ingredient> combinedResultIngredient = Utils.createCombinedResultIngredients(mobResultItem, mobMinResultCount, mobMaxResultCount);
            Item spawnEggItem = JustEnoughBreeding.getItemFromLoaderRegistries(new ResourceLocation(mobSpawnEggItem.trim()));
            entityType = JustEnoughBreeding.getEntityFromLoaderRegistries(new ResourceLocation(mobEntityName.trim()));
            needsToBeTamed = CommonConstants.breedingNeedsToBeTamed.get(mobName);
            animalTrusting = CommonConstants.breedingNeedsToBeTrusting.get(mobName);
            combinedExtraIngredient = null;
            if (CommonConstants.breedingExtraIngredients != null && CommonConstants.breedingExtraIngredients.get(mobName) != null && (mobExtraIngredients = CommonConstants.breedingExtraIngredients.get(mobName)) != null) {
                combinedExtraIngredient = Utils.createCombinedIngredient(mobExtraIngredients);
            }
            breedingRecipe = Utils.createBreedingRecipe(entityType, combinedIngredient, spawnEggItem, needsToBeTamed, combinedResultIngredient, animalTrusting, combinedExtraIngredient);
            registration.addRecipe(BreedingCategoryEMI.builder().id(new ResourceLocation("justenoughbreeding", "breeding/" + breedingRecipe.entityType.m_20675_() + "/" + breedingRecipe.spawnEgg.m_41778_())).breedingRecipe(breedingRecipe).build());
        }
    }
}

