/*
 * Decompiled with CFR 0.152.
 */
package net.creeperhost.ftbbackups.repack.org.quartz;

import java.util.Date;
import net.creeperhost.ftbbackups.repack.org.quartz.JobDataMap;
import net.creeperhost.ftbbackups.repack.org.quartz.JobDetail;
import net.creeperhost.ftbbackups.repack.org.quartz.JobKey;
import net.creeperhost.ftbbackups.repack.org.quartz.ScheduleBuilder;
import net.creeperhost.ftbbackups.repack.org.quartz.SimpleScheduleBuilder;
import net.creeperhost.ftbbackups.repack.org.quartz.Trigger;
import net.creeperhost.ftbbackups.repack.org.quartz.TriggerKey;
import net.creeperhost.ftbbackups.repack.org.quartz.spi.MutableTrigger;
import net.creeperhost.ftbbackups.repack.org.quartz.utils.Key;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TriggerBuilder<T extends Trigger> {
    private TriggerKey key;
    private String description;
    private Date startTime = new Date();
    private Date endTime;
    private int priority = 5;
    private String calendarName;
    private JobKey jobKey;
    private JobDataMap jobDataMap = new JobDataMap();
    private ScheduleBuilder scheduleBuilder = null;

    private TriggerBuilder() {
    }

    public static TriggerBuilder<Trigger> newTrigger() {
        return new TriggerBuilder<Trigger>();
    }

    public T build() {
        if (this.scheduleBuilder == null) {
            this.scheduleBuilder = SimpleScheduleBuilder.simpleSchedule();
        }
        MutableTrigger trig = this.scheduleBuilder.build();
        trig.setCalendarName(this.calendarName);
        trig.setDescription(this.description);
        trig.setEndTime(this.endTime);
        if (this.key == null) {
            this.key = new TriggerKey(Key.createUniqueName(null), null);
        }
        trig.setKey(this.key);
        if (this.jobKey != null) {
            trig.setJobKey(this.jobKey);
        }
        trig.setPriority(this.priority);
        trig.setStartTime(this.startTime);
        if (!this.jobDataMap.isEmpty()) {
            trig.setJobDataMap(this.jobDataMap);
        }
        return (T)trig;
    }

    public TriggerBuilder<T> withIdentity(String name) {
        this.key = new TriggerKey(name, null);
        return this;
    }

    public TriggerBuilder<T> withIdentity(String name, String group) {
        this.key = new TriggerKey(name, group);
        return this;
    }

    public TriggerBuilder<T> withIdentity(TriggerKey key) {
        this.key = key;
        return this;
    }

    public TriggerBuilder<T> withDescription(String description) {
        this.description = description;
        return this;
    }

    public TriggerBuilder<T> withPriority(int priority) {
        this.priority = priority;
        return this;
    }

    public TriggerBuilder<T> modifiedByCalendar(String calendarName) {
        this.calendarName = calendarName;
        return this;
    }

    public TriggerBuilder<T> startAt(Date startTime) {
        this.startTime = startTime;
        return this;
    }

    public TriggerBuilder<T> startNow() {
        this.startTime = new Date();
        return this;
    }

    public TriggerBuilder<T> endAt(Date endTime) {
        this.endTime = endTime;
        return this;
    }

    public <SBT extends T> TriggerBuilder<SBT> withSchedule(ScheduleBuilder<SBT> scheduleBuilder) {
        this.scheduleBuilder = scheduleBuilder;
        return this;
    }

    public TriggerBuilder<T> forJob(JobKey jobKey) {
        this.jobKey = jobKey;
        return this;
    }

    public TriggerBuilder<T> forJob(String jobName) {
        this.jobKey = new JobKey(jobName, null);
        return this;
    }

    public TriggerBuilder<T> forJob(String jobName, String jobGroup) {
        this.jobKey = new JobKey(jobName, jobGroup);
        return this;
    }

    public TriggerBuilder<T> forJob(JobDetail jobDetail) {
        JobKey k = jobDetail.getKey();
        if (k.getName() == null) {
            throw new IllegalArgumentException("The given job has not yet had a name assigned to it.");
        }
        this.jobKey = k;
        return this;
    }

    public TriggerBuilder<T> usingJobData(String key, String value) {
        this.jobDataMap.put(key, value);
        return this;
    }

    public TriggerBuilder<T> usingJobData(String key, Integer value) {
        this.jobDataMap.put((Object)key, value);
        return this;
    }

    public TriggerBuilder<T> usingJobData(String key, Long value) {
        this.jobDataMap.put((Object)key, value);
        return this;
    }

    public TriggerBuilder<T> usingJobData(String key, Float value) {
        this.jobDataMap.put((Object)key, value);
        return this;
    }

    public TriggerBuilder<T> usingJobData(String key, Double value) {
        this.jobDataMap.put((Object)key, value);
        return this;
    }

    public TriggerBuilder<T> usingJobData(String key, Boolean value) {
        this.jobDataMap.put((Object)key, value);
        return this;
    }

    public TriggerBuilder<T> usingJobData(JobDataMap newJobDataMap) {
        for (Object key : this.jobDataMap.keySet()) {
            newJobDataMap.put(key, this.jobDataMap.get(key));
        }
        this.jobDataMap = newJobDataMap;
        return this;
    }
}

