/*
 * Decompiled with CFR 0.152.
 */
package net.creeperhost.polylib.data.serializable;

import java.util.Objects;
import net.minecraft.nbt.Tag;
import net.minecraft.network.FriendlyByteBuf;

public abstract class AbstractDataStore<T> {
    protected T value;

    public AbstractDataStore(T defaultValue) {
        this.value = defaultValue;
    }

    public T getValue() {
        return this.value;
    }

    public void setValue(T value) {
        this.value = value;
        this.markDirty();
    }

    public void markDirty() {
    }

    public abstract void toBytes(FriendlyByteBuf var1);

    public abstract void fromBytes(FriendlyByteBuf var1);

    public abstract Tag toTag();

    public abstract void fromTag(Tag var1);

    public boolean isSameValue(T newValue) {
        return Objects.equals(this.value, newValue);
    }
}

