/*
 * Decompiled with CFR 0.152.
 */
package net.creeperhost.polylib.client.modulargui;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Consumer;
import net.creeperhost.polylib.client.modulargui.elements.GuiElement;
import net.creeperhost.polylib.client.modulargui.lib.ContentElement;
import net.creeperhost.polylib.client.modulargui.lib.CursorHelper;
import net.creeperhost.polylib.client.modulargui.lib.DynamicTextures;
import net.creeperhost.polylib.client.modulargui.lib.GuiProvider;
import net.creeperhost.polylib.client.modulargui.lib.GuiRender;
import net.creeperhost.polylib.client.modulargui.lib.geometry.Constraint;
import net.creeperhost.polylib.client.modulargui.lib.geometry.GeoParam;
import net.creeperhost.polylib.client.modulargui.lib.geometry.GuiParent;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.inventory.Slot;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.logging.log4j.util.TriConsumer;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ModularGui
implements GuiParent<ModularGui> {
    private static final Logger LOGGER = LogManager.getLogger();
    private final GuiProvider provider;
    private final GuiElement<?> root;
    private boolean guiBuilt = false;
    private boolean pauseScreen = false;
    private boolean closeOnEscape = true;
    private boolean renderBackground = true;
    private boolean vanillaSlotRendering = false;
    private Font font;
    private Minecraft mc;
    private int screenWidth;
    private int screenHeight;
    private Screen screen;
    private Screen parentScreen;
    private Component guiTitle = Component.m_237119_();
    private GuiElement<?> focused;
    private ResourceLocation newCursor = null;
    private final Map<Slot, GuiElement<?>> slotHandlers = new HashMap();
    private final List<Runnable> tickListeners = new ArrayList<Runnable>();
    private final List<Runnable> resizeListeners = new ArrayList<Runnable>();
    private final List<Runnable> closeListeners = new ArrayList<Runnable>();
    private final List<TriConsumer<Double, Double, Integer>> preClickListeners = new ArrayList<TriConsumer<Double, Double, Integer>>();
    private final List<TriConsumer<Double, Double, Integer>> postClickListeners = new ArrayList<TriConsumer<Double, Double, Integer>>();
    private final List<TriConsumer<Integer, Integer, Integer>> preKeyPressListeners = new ArrayList<TriConsumer<Integer, Integer, Integer>>();
    private final List<TriConsumer<Integer, Integer, Integer>> postKeyPressListeners = new ArrayList<TriConsumer<Integer, Integer, Integer>>();

    public ModularGui(GuiProvider provider) {
        this.provider = provider;
        if (provider instanceof DynamicTextures) {
            DynamicTextures textures = (DynamicTextures)((Object)provider);
            textures.makeTextures(DynamicTextures.DynamicTexture::guiTexturePath);
        }
        Minecraft mc = Minecraft.m_91087_();
        this.updateScreenData(mc, mc.f_91062_, mc.m_91268_().m_85445_(), mc.m_91268_().m_85446_());
        try {
            this.root = provider.createRootElement(this);
        }
        catch (Throwable ex) {
            LOGGER.error("An error occurred while constructing a modular gui", ex);
            throw ex;
        }
    }

    public ModularGui(GuiProvider provider, Screen parentScreen) {
        this(provider);
        this.parentScreen = parentScreen;
    }

    public void setScreen(Screen screen) {
        this.screen = screen;
    }

    public GuiProvider getProvider() {
        return this.provider;
    }

    public void setGuiTitle(@NotNull Component guiTitle) {
        this.guiTitle = guiTitle;
    }

    @NotNull
    public Component getGuiTitle() {
        return this.guiTitle;
    }

    public void setPauseScreen(boolean pauseScreen) {
        this.pauseScreen = pauseScreen;
    }

    public boolean isPauseScreen() {
        return this.pauseScreen;
    }

    public void setCloseOnEscape(boolean closeOnEscape) {
        this.closeOnEscape = closeOnEscape;
    }

    public boolean closeOnEscape() {
        return this.closeOnEscape;
    }

    public void renderScreenBackground(boolean renderBackground) {
        this.renderBackground = renderBackground;
    }

    public boolean renderBackground() {
        return this.renderBackground;
    }

    public GuiElement<?> getRoot() {
        return this.root instanceof ContentElement ? ((ContentElement)((Object)this.root)).getContentElement() : this.root;
    }

    public GuiElement<?> getDirectRoot() {
        return this.root;
    }

    public ModularGui initStandardGui(int guiWidth, int guiHeight) {
        this.root.constrain(GeoParam.WIDTH, Constraint.literal(guiWidth));
        this.root.constrain(GeoParam.HEIGHT, Constraint.literal(guiHeight));
        this.root.constrain(GeoParam.LEFT, Constraint.midPoint(this.get(GeoParam.LEFT), this.get(GeoParam.RIGHT), (double)guiWidth / -2.0));
        this.root.constrain(GeoParam.TOP, Constraint.midPoint(this.get(GeoParam.TOP), this.get(GeoParam.BOTTOM), (double)guiHeight / -2.0));
        return this;
    }

    public ModularGui initFullscreenGui() {
        this.root.constrain(GeoParam.WIDTH, Constraint.match(this.get(GeoParam.WIDTH)));
        this.root.constrain(GeoParam.HEIGHT, Constraint.match(this.get(GeoParam.HEIGHT)));
        this.root.constrain(GeoParam.TOP, Constraint.match(this.get(GeoParam.TOP)));
        this.root.constrain(GeoParam.LEFT, Constraint.match(this.get(GeoParam.LEFT)));
        return this;
    }

    public void setVanillaSlotRendering(boolean vanillaSlotRendering) {
        this.vanillaSlotRendering = vanillaSlotRendering;
    }

    public boolean vanillaSlotRendering() {
        return this.vanillaSlotRendering;
    }

    public GuiRender createRender(MultiBufferSource.BufferSource buffers) {
        return new GuiRender(this.mc, buffers);
    }

    public void render(GuiRender render, float partialTicks) {
        this.root.clearGeometryCache();
        double mouseX = this.computeMouseX();
        double mouseY = this.computeMouseY();
        this.root.render(render, mouseX, mouseY, partialTicks);
        double depth = this.root.getCombinedElementDepth();
        if (depth <= 300.0) {
            render.pose().m_85837_(0.0, 0.0, 400.0 - depth);
        } else {
            render.pose().m_252880_(0.0f, 0.0f, 100.0f);
        }
    }

    public boolean renderOverlay(GuiRender render, float partialTicks) {
        double mouseX = this.computeMouseX();
        double mouseY = this.computeMouseY();
        return this.root.renderOverlay(render, mouseX, mouseY, partialTicks, false);
    }

    public void tick() {
        this.newCursor = null;
        double mouseX = this.computeMouseX();
        double mouseY = this.computeMouseY();
        this.root.updateMouseOver(mouseX, mouseY, false);
        this.tickListeners.forEach(Runnable::run);
        this.root.tick(mouseX, mouseY);
        CursorHelper.setCursor(this.newCursor);
    }

    public void mouseMoved(double mouseX, double mouseY) {
        this.root.mouseMoved(mouseX, mouseY);
    }

    public boolean mouseClicked(double mouseX, double mouseY, int button) {
        this.preClickListeners.forEach(e -> e.accept((Object)mouseX, (Object)mouseY, (Object)button));
        boolean consumed = this.root.mouseClicked(mouseX, mouseY, button, false);
        if (!consumed) {
            this.postClickListeners.forEach(e -> e.accept((Object)mouseX, (Object)mouseY, (Object)button));
        }
        return consumed;
    }

    public boolean mouseReleased(double mouseX, double mouseY, int button) {
        return this.root.mouseReleased(mouseX, mouseY, button, false);
    }

    public boolean keyPressed(int key, int scancode, int modifiers) {
        this.preKeyPressListeners.forEach(e -> e.accept((Object)key, (Object)scancode, (Object)modifiers));
        boolean consumed = this.root.keyPressed(key, scancode, modifiers, false);
        if (!consumed) {
            this.postKeyPressListeners.forEach(e -> e.accept((Object)key, (Object)scancode, (Object)modifiers));
        }
        return consumed;
    }

    public boolean keyReleased(int key, int scancode, int modifiers) {
        return this.root.keyReleased(key, scancode, modifiers, false);
    }

    public boolean charTyped(char character, int modifiers) {
        return this.root.charTyped(character, modifiers, false);
    }

    public boolean mouseScrolled(double mouseX, double mouseY, double scroll) {
        return this.root.mouseScrolled(mouseX, mouseY, scroll, false);
    }

    public void onGuiClose() {
        CursorHelper.resetCursor();
        this.closeListeners.forEach(Runnable::run);
    }

    protected void updateScreenData(Minecraft mc, Font font, int screenWidth, int screenHeight) {
        this.mc = mc;
        this.font = font;
        this.screenWidth = screenWidth;
        this.screenHeight = screenHeight;
    }

    @Override
    public void onScreenInit(Minecraft mc, Font font, int screenWidth, int screenHeight) {
        this.updateScreenData(mc, font, screenWidth, screenHeight);
        try {
            this.root.onScreenInit(mc, font, screenWidth, screenHeight);
            if (!this.guiBuilt) {
                this.guiBuilt = true;
                this.provider.buildGui(this);
            } else {
                this.resizeListeners.forEach(Runnable::run);
            }
        }
        catch (Throwable ex) {
            LOGGER.error("An error occurred while building a modular gui", ex);
            throw ex;
        }
    }

    @Override
    public Minecraft mc() {
        return this.mc;
    }

    @Override
    public Font font() {
        return this.font;
    }

    @Override
    public int scaledScreenWidth() {
        return this.screenWidth;
    }

    @Override
    public int scaledScreenHeight() {
        return this.screenHeight;
    }

    @Override
    public ModularGui getModularGui() {
        return this;
    }

    public Screen getScreen() {
        return this.screen;
    }

    @Nullable
    public Screen getParentScreen() {
        return this.parentScreen;
    }

    @Override
    public List<GuiElement<?>> getChildren() {
        throw new UnsupportedOperationException("Child elements must be managed via the root gui element not the modular gui itself.");
    }

    @Override
    public void addChild(GuiElement<?> child) {
        if (this.root == null) {
            child.initElement(this);
            return;
        }
        throw new UnsupportedOperationException("Child elements must be managed via the root gui element not the modular gui itself.");
    }

    @Override
    public ModularGui addChild(Consumer<ModularGui> createChild) {
        throw new UnsupportedOperationException("Child elements must be managed via the root gui element not the modular gui itself.");
    }

    @Override
    public void adoptChild(GuiElement<?> child) {
        throw new UnsupportedOperationException("Child elements must be managed via the root gui element not the modular gui itself.");
    }

    @Override
    public void removeChild(GuiElement<?> child) {
        throw new UnsupportedOperationException("Child elements must be managed via the root gui element not the modular gui itself.");
    }

    @Override
    public double xMin() {
        return 0.0;
    }

    @Override
    public double xMax() {
        return this.screenWidth;
    }

    @Override
    public double xSize() {
        return this.screenWidth;
    }

    @Override
    public double yMin() {
        return 0.0;
    }

    @Override
    public double yMax() {
        return this.screenHeight;
    }

    @Override
    public double ySize() {
        return this.screenHeight;
    }

    public double computeMouseX() {
        return this.mc.f_91067_.m_91589_() * (double)this.mc.m_91268_().m_85445_() / (double)this.mc.m_91268_().m_85443_();
    }

    public double computeMouseY() {
        return this.mc.f_91067_.m_91594_() * (double)this.mc.m_91268_().m_85446_() / (double)this.mc.m_91268_().m_85444_();
    }

    public void setSlotHandler(Slot slot, GuiElement<?> handler) {
        if (this.slotHandlers.containsKey(slot)) {
            throw new IllegalStateException("A gui slot can only have a single handler!");
        }
        this.slotHandlers.put(slot, handler);
    }

    public GuiElement<?> getSlotHandler(Slot slot) {
        return this.slotHandlers.get(slot);
    }

    public void setCursor(ResourceLocation cursor) {
        this.newCursor = cursor;
    }

    public void onTick(Runnable onTick) {
        this.tickListeners.add(onTick);
    }

    public void onResize(Runnable onResize) {
        this.resizeListeners.add(onResize);
    }

    public void onClose(Runnable onClose) {
        this.closeListeners.add(onClose);
    }

    public void onMouseClickPre(TriConsumer<Double, Double, Integer> onClick) {
        this.preClickListeners.add(onClick);
    }

    public void onMouseClickPost(TriConsumer<Double, Double, Integer> onClick) {
        this.postClickListeners.add(onClick);
    }

    public void onKeyPressPre(TriConsumer<Integer, Integer, Integer> preKeyPress) {
        this.preKeyPressListeners.add(preKeyPress);
    }

    public void onKeyPressPost(TriConsumer<Integer, Integer, Integer> postKeyPress) {
        this.postKeyPressListeners.add(postKeyPress);
    }
}

