/*
 * Decompiled with CFR 0.152.
 */
package ms55.roughtweaksrevamped.common.item;

import java.util.List;
import net.minecraft.ChatFormatting;
import net.minecraft.network.chat.Component;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.UseAnim;
import net.minecraft.world.level.Level;
import net.minecraftforge.common.ForgeConfigSpec;
import org.jetbrains.annotations.Nullable;

public class HealItem
extends Item {
    private final ForgeConfigSpec.IntValue HEAL_RATE;
    private final ForgeConfigSpec.IntValue MAX_DAMAGE;
    private final ForgeConfigSpec.DoubleValue HEAL_AMOUNT;
    private final MobEffect EFFECT;
    private final ItemStack RETURN_STACK;

    public HealItem(ForgeConfigSpec.IntValue useCount, ForgeConfigSpec.IntValue healRate, ForgeConfigSpec.DoubleValue healAmount, MobEffect effect, ItemStack returnStack) {
        super(new Item.Properties().m_41487_(1).m_41503_(10));
        this.HEAL_RATE = healRate;
        this.HEAL_AMOUNT = healAmount;
        this.MAX_DAMAGE = useCount;
        this.EFFECT = effect;
        this.RETURN_STACK = returnStack;
    }

    public InteractionResultHolder<ItemStack> m_7203_(Level level, Player player, InteractionHand hand) {
        ItemStack stack = player.m_21120_(hand);
        if (player.m_7500_()) {
            return InteractionResultHolder.m_19098_((Object)stack);
        }
        player.m_6672_(hand);
        return InteractionResultHolder.m_19090_((Object)stack);
    }

    public int getMaxDamage(ItemStack stack) {
        return (Integer)this.MAX_DAMAGE.get();
    }

    public int m_8105_(ItemStack stack) {
        return 72000;
    }

    public UseAnim m_6164_(ItemStack stack) {
        return UseAnim.BOW;
    }

    public boolean m_5812_(ItemStack stack) {
        return this.EFFECT != null;
    }

    public void m_5929_(Level world, LivingEntity player, ItemStack stack, int count) {
        if (count % (Integer)this.HEAL_RATE.get() == 1) {
            stack.m_41622_(1, player, x -> {
                x.m_21008_(player.m_7655_(), this.RETURN_STACK);
                x.m_5496_(SoundEvents.f_12642_, 1.0f, 0.5f);
                x.m_21190_(player.m_7655_());
            });
            player.m_5634_(((Double)this.HEAL_AMOUNT.get()).floatValue());
            player.m_5496_(SoundEvents.f_12642_, 1.0f, 1.5f);
            if (this.EFFECT != null) {
                player.m_7292_(new MobEffectInstance(this.EFFECT, 1200));
            }
        }
    }

    public void m_7373_(ItemStack stack, @Nullable Level level, List<Component> tooltip, TooltipFlag flag) {
        float hearts = ((Double)this.HEAL_AMOUNT.get()).floatValue() / 2.0f;
        if ((double)hearts % 1.0 == 0.0) {
            tooltip.add((Component)Component.m_237113_((String)("Heal Amount: " + (int)hearts + " Hearts")).m_130940_(ChatFormatting.BLUE));
        } else {
            tooltip.add((Component)Component.m_237113_((String)("Heal Amount: " + hearts + " Hearts")).m_130940_(ChatFormatting.BLUE));
        }
    }
}

