/*
 * Decompiled with CFR 0.152.
 */
package ms55.roughtweaksrevamped.client;

import net.minecraftforge.common.ForgeConfigSpec;
import net.minecraftforge.fml.common.Mod;

@Mod.EventBusSubscriber(modid="roughtweaks", bus=Mod.EventBusSubscriber.Bus.MOD)
public class RoughConfig {
    public static final ForgeConfigSpec COMMON_SPEC;
    public static final General GENERAL;
    public static final HealCount HEAL_COUNT;
    public static final HealAmount HEAL_AMOUNT;
    public static final HealTime HEAL_TIME;

    static {
        ForgeConfigSpec.Builder builder = new ForgeConfigSpec.Builder();
        GENERAL = new General(builder);
        HEAL_COUNT = new HealCount(builder);
        HEAL_AMOUNT = new HealAmount(builder);
        HEAL_TIME = new HealTime(builder);
        COMMON_SPEC = builder.build();
    }

    public static class General {
        public final ForgeConfigSpec.IntValue DROP_CHANCE;
        public final ForgeConfigSpec.DoubleValue SLEEP_HEAL_AMOUNT;
        public final ForgeConfigSpec.BooleanValue HEALTH_REGEN;

        public General(ForgeConfigSpec.Builder builder) {
            builder.comment("Here you can tweak some additional stuff this mod does").push("General");
            this.DROP_CHANCE = builder.comment("Chance 1 in X that a hostile entity drops either salve, a plaster or a bandage\\nSet this to 0 if you want to disable entity drops").defineInRange("dropChance", 30, 0, Short.MAX_VALUE);
            this.SLEEP_HEAL_AMOUNT = builder.comment("Amount of half hearts sleeping heals. Set to 0 to disable this feature").defineInRange("sleepHealAmount", 4.0, 0.0, 32767.0);
            this.HEALTH_REGEN = builder.comment("Set to true if you want to regenerate health without the use of healing items").define("healthRegen", false);
            builder.pop();
        }
    }

    public static class HealCount {
        public final ForgeConfigSpec.IntValue SALVE_HEAL_COUNT;
        public final ForgeConfigSpec.IntValue PLASTER_HEAL_COUNT;
        public final ForgeConfigSpec.IntValue BANDAGE_HEAL_COUNT;
        public final ForgeConfigSpec.IntValue MEDKIT_HEAL_COUNT;
        public final ForgeConfigSpec.IntValue MEDKIT_ENCHANTED_HEAL_COUNT;

        public HealCount(ForgeConfigSpec.Builder builder) {
            builder.comment("Defines how often you're able to rightclick the item to heal yourself. Set the use count to 0 to disable the item.").push("HealCount");
            this.SALVE_HEAL_COUNT = builder.comment("Use count for the salve item").defineInRange("salveHealCount", 4, 0, Integer.MAX_VALUE);
            this.PLASTER_HEAL_COUNT = builder.comment("Use count for the plaster item").defineInRange("plasterHealCount", 4, 0, Integer.MAX_VALUE);
            this.BANDAGE_HEAL_COUNT = builder.comment("Use count for the bandage item").defineInRange("bandageHealCount", 6, 0, Integer.MAX_VALUE);
            this.MEDKIT_HEAL_COUNT = builder.comment("Use count for the medkit item").defineInRange("medkitHealCount", 16, 0, Integer.MAX_VALUE);
            this.MEDKIT_ENCHANTED_HEAL_COUNT = builder.comment("Use count for the enchanted medkit item").defineInRange("medkitEnchantedHealCount", 16, 0, Integer.MAX_VALUE);
            builder.pop();
        }
    }

    public static class HealAmount {
        public final ForgeConfigSpec.DoubleValue SALVE_HEAL_AMOUNT;
        public final ForgeConfigSpec.DoubleValue PLASTER_HEAL_AMOUNT;
        public final ForgeConfigSpec.DoubleValue BANDAGE_HEAL_AMOUNT;
        public final ForgeConfigSpec.DoubleValue MEDKIT_HEAL_AMOUNT;
        public final ForgeConfigSpec.DoubleValue MEDKIT_ENCHANTED_HEAL_AMOUNT;

        public HealAmount(ForgeConfigSpec.Builder builder) {
            builder.comment("Defines how much health the item restores on rightclick.").push("HealAmount");
            this.SALVE_HEAL_AMOUNT = builder.comment("Salve heal amount").defineInRange("salveHealAmount", 1.0, 1.0, Double.MAX_VALUE);
            this.PLASTER_HEAL_AMOUNT = builder.comment("Salve heal amount").defineInRange("plasterHealAmount", 1.0, 1.0, Double.MAX_VALUE);
            this.BANDAGE_HEAL_AMOUNT = builder.comment("Salve heal amount").defineInRange("bandageHealAmount", 1.0, 1.0, Double.MAX_VALUE);
            this.MEDKIT_HEAL_AMOUNT = builder.comment("Salve heal amount").defineInRange("medkitHealAmount", 2.0, 1.0, Double.MAX_VALUE);
            this.MEDKIT_ENCHANTED_HEAL_AMOUNT = builder.comment("Salve heal amount").defineInRange("medkitEnchantedHealAmount", 3.0, 1.0, Double.MAX_VALUE);
            builder.pop();
        }
    }

    public static class HealTime {
        public final ForgeConfigSpec.IntValue SALVE_USE_TIME;
        public final ForgeConfigSpec.IntValue PLASTER_USE_TIME;
        public final ForgeConfigSpec.IntValue BANDAGE_USE_TIME;
        public final ForgeConfigSpec.IntValue MEDKIT_USE_TIME;
        public final ForgeConfigSpec.IntValue MEDKIT_ENCHANTED_USE_TIME;

        public HealTime(ForgeConfigSpec.Builder builder) {
            builder.comment("Defines how long it takes for a healing item to get used.").push("HealTime");
            this.SALVE_USE_TIME = builder.comment("Use time for the salve item").defineInRange("salveUseTime", 5, 0, 72000);
            this.PLASTER_USE_TIME = builder.comment("Use count for the plaster item").defineInRange("plasterUseTime", 10, 0, 72000);
            this.BANDAGE_USE_TIME = builder.comment("Use count for the bandage item").defineInRange("bandageUseTime", 20, 0, 72000);
            this.MEDKIT_USE_TIME = builder.comment("Use count for the medkit item").defineInRange("medkitUseTime", 40, 0, 72000);
            this.MEDKIT_ENCHANTED_USE_TIME = builder.comment("Use count for the enchanted medkit item").defineInRange("medkitEnchantedUseTime", 40, 0, 72000);
            builder.pop();
        }
    }
}

