/*
 * Decompiled with CFR 0.152.
 */
package se.mickelus.tetra.module.schematic.requirement;

import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonDeserializer;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import java.lang.reflect.Type;
import java.util.function.Predicate;
import se.mickelus.mutil.util.JsonOptional;

public class IntegerPredicate
implements Predicate<Integer> {
    Integer min;
    Integer max;

    public IntegerPredicate(Integer min, Integer max) {
        this.min = min;
        this.max = max;
    }

    @Override
    public boolean test(Integer value) {
        if (this.min != null && this.min > value) {
            return false;
        }
        return this.max == null || this.max >= value;
    }

    public static class Deserializer
    implements JsonDeserializer<IntegerPredicate> {
        public IntegerPredicate deserialize(JsonElement json, Type typeOfT, JsonDeserializationContext context) throws JsonParseException {
            return Deserializer.deserialize(json);
        }

        public static IntegerPredicate deserialize(JsonElement json) throws JsonParseException {
            if (json.isJsonObject()) {
                JsonObject jsonObject = json.getAsJsonObject();
                return new IntegerPredicate(JsonOptional.field((JsonObject)jsonObject, (String)"min").map(JsonElement::getAsInt).orElse(null), JsonOptional.field((JsonObject)jsonObject, (String)"max").map(JsonElement::getAsInt).orElse(null));
            }
            int value = json.getAsInt();
            return new IntegerPredicate(value, value);
        }
    }
}

