/*
 * Decompiled with CFR 0.152.
 */
package se.mickelus.tetra.module.data;

import java.util.Arrays;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.annotation.ParametersAreNonnullByDefault;
import net.minecraft.resources.ResourceLocation;
import se.mickelus.tetra.module.data.AspectData;
import se.mickelus.tetra.module.data.EffectData;
import se.mickelus.tetra.module.data.GlyphData;
import se.mickelus.tetra.module.data.MaterialData;
import se.mickelus.tetra.module.data.MaterialMultiplier;
import se.mickelus.tetra.module.data.ModuleModel;
import se.mickelus.tetra.module.data.ToolData;
import se.mickelus.tetra.module.data.UniqueVariantData;
import se.mickelus.tetra.module.data.VariantData;
import se.mickelus.tetra.properties.AttributeHelper;

@ParametersAreNonnullByDefault
public class MaterialVariantData
extends VariantData {
    public ResourceLocation[] materials = new ResourceLocation[0];
    public MaterialMultiplier extract = new MaterialMultiplier();

    public VariantData combine(MaterialData material) {
        UniqueVariantData result = new UniqueVariantData();
        result.key = this.key + material.key;
        if (material.category != null) {
            result.category = material.category;
        }
        result.attributes = AttributeHelper.collapseRound(AttributeHelper.merge(Arrays.asList(this.attributes, material.attributes, AttributeHelper.multiplyModifiers(this.extract.primaryAttributes, material.primary.floatValue()), AttributeHelper.multiplyModifiers(this.extract.secondaryAttributes, material.secondary.floatValue()), AttributeHelper.multiplyModifiers(this.extract.tertiaryAttributes, material.tertiary.floatValue()))));
        result.durability = Math.round((float)this.durability + Optional.ofNullable(this.extract.durability).map(extracted -> Float.valueOf(extracted.floatValue() * material.durability)).orElse(Float.valueOf(0.0f)).floatValue());
        result.durabilityMultiplier = this.durabilityMultiplier + Optional.ofNullable(this.extract.durabilityMultiplier).map(extracted -> Float.valueOf(extracted.floatValue() * material.durability)).orElse(Float.valueOf(0.0f)).floatValue();
        result.integrity = this.integrity + Optional.ofNullable(this.extract.integrity).map(extracted -> Float.valueOf(extracted.floatValue() * (extracted.floatValue() > 0.0f ? material.integrityGain : material.integrityCost))).map(Math::round).orElse(0);
        result.magicCapacity = Math.round((float)this.magicCapacity + Optional.ofNullable(this.extract.magicCapacity).map(extracted -> Float.valueOf(extracted.floatValue() * (float)material.magicCapacity)).orElse(Float.valueOf(0.0f)).floatValue());
        result.effects = EffectData.merge(Arrays.asList(this.effects, material.effects, EffectData.multiply(this.extract.primaryEffects, material.primary.floatValue(), material.primary.floatValue()), EffectData.multiply(this.extract.secondaryEffects, material.secondary.floatValue(), material.secondary.floatValue()), EffectData.multiply(this.extract.tertiaryEffects, material.tertiary.floatValue(), material.tertiary.floatValue())));
        result.tools = ToolData.merge(Arrays.asList(this.tools, ToolData.multiply(this.extract.tools, material.toolLevel, material.toolEfficiency)));
        result.aspects = AspectData.merge(this.aspects, material.aspects);
        result.glyph = Optional.ofNullable(this.extract.glyph).map(glyph -> new GlyphData(glyph.textureLocation, glyph.textureX, glyph.textureY, material.tints.glyph)).orElse(this.glyph);
        List<String> availableTextures = Arrays.asList(this.extract.availableTextures);
        result.models = (ModuleModel[])Stream.concat(Arrays.stream(this.models), Arrays.stream(this.extract.models).map(model -> MaterialData.kneadModel(model, material, availableTextures))).toArray(ModuleModel[]::new);
        result.tags = this.tags == null ? material.tags : (material.tags == null ? this.tags : Stream.concat(this.tags.stream(), material.tags.stream()).collect(Collectors.toSet()));
        return result;
    }
}

