/*
 * Decompiled with CFR 0.152.
 */
package se.mickelus.tetra.items.modular.impl.toolbelt.gui.overlay;

import com.mojang.blaze3d.platform.Window;
import javax.annotation.ParametersAreNonnullByDefault;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.network.chat.Component;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraftforge.client.event.InputEvent;
import net.minecraftforge.client.gui.overlay.ForgeGui;
import net.minecraftforge.client.gui.overlay.IGuiOverlay;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import se.mickelus.mutil.gui.GuiAttachment;
import se.mickelus.mutil.gui.GuiRoot;
import se.mickelus.mutil.network.AbstractPacket;
import se.mickelus.tetra.TetraMod;
import se.mickelus.tetra.client.keymap.TetraKeyMappings;
import se.mickelus.tetra.items.modular.impl.holo.ModularHolosphereItem;
import se.mickelus.tetra.items.modular.impl.toolbelt.EquipToolbeltItemPacket;
import se.mickelus.tetra.items.modular.impl.toolbelt.OpenToolbeltItemPacket;
import se.mickelus.tetra.items.modular.impl.toolbelt.StoreToolbeltItemPacket;
import se.mickelus.tetra.items.modular.impl.toolbelt.ToolbeltHelper;
import se.mickelus.tetra.items.modular.impl.toolbelt.gui.overlay.HolosphereGroupGui;
import se.mickelus.tetra.items.modular.impl.toolbelt.gui.overlay.PotionGroupGui;
import se.mickelus.tetra.items.modular.impl.toolbelt.gui.overlay.QuickslotGroupGui;
import se.mickelus.tetra.items.modular.impl.toolbelt.gui.overlay.QuiverGroupGui;
import se.mickelus.tetra.items.modular.impl.toolbelt.inventory.PotionsInventory;
import se.mickelus.tetra.items.modular.impl.toolbelt.inventory.QuickslotInventory;
import se.mickelus.tetra.items.modular.impl.toolbelt.inventory.QuiverInventory;
import se.mickelus.tetra.items.modular.impl.toolbelt.inventory.ToolbeltSlotType;

@ParametersAreNonnullByDefault
public class ToolbeltOverlay
extends GuiRoot
implements IGuiOverlay {
    private final QuickslotGroupGui quickslotGroup = new QuickslotGroupGui(52, 0);
    private final PotionGroupGui potionGroup;
    private final QuiverGroupGui quiverGroup;
    private final HolosphereGroupGui holosphereGroup;
    private long openTime = -1L;
    private boolean isActive = false;

    public ToolbeltOverlay(Minecraft mc) {
        super(mc);
        this.quickslotGroup.setAttachmentAnchor(GuiAttachment.middleCenter);
        this.addChild(this.quickslotGroup);
        this.potionGroup = new PotionGroupGui(0, 40);
        this.potionGroup.setAttachmentPoint(GuiAttachment.topCenter);
        this.potionGroup.setAttachmentAnchor(GuiAttachment.middleCenter);
        this.addChild(this.potionGroup);
        this.quiverGroup = new QuiverGroupGui(-40, -40);
        this.quiverGroup.setAttachmentPoint(GuiAttachment.bottomRight);
        this.quiverGroup.setAttachmentAnchor(GuiAttachment.middleCenter);
        this.addChild(this.quiverGroup);
        this.holosphereGroup = new HolosphereGroupGui(0, -40);
        this.holosphereGroup.setAttachmentAnchor(GuiAttachment.middleCenter);
        this.addChild(this.holosphereGroup);
    }

    public void setInventories(ItemStack itemStack) {
    }

    public void toggleActive(boolean active) {
        this.isActive = active;
        this.quickslotGroup.setVisible(active);
        this.potionGroup.setVisible(active);
        this.quiverGroup.setVisible(active);
        this.holosphereGroup.setVisible(active);
    }

    @SubscribeEvent
    public void onKeyInput(InputEvent.Key event) {
        if (TetraKeyMappings.restockBinding.m_90857_()) {
            this.storeToolbeltItem();
        } else if (TetraKeyMappings.openBinding.m_90859_()) {
            this.openToolbelt();
        } else if (TetraKeyMappings.accessBinding.m_90857_() && this.mc.m_91302_() && !this.isActive) {
            this.showView();
        }
    }

    public void render(ForgeGui gui, GuiGraphics graphics, float partialTick, int screenWidth, int screenHeight) {
        if (!TetraKeyMappings.accessBinding.m_90857_() && this.isActive) {
            this.hideView();
        }
        this.draw(graphics);
    }

    public void draw(GuiGraphics graphics) {
        super.draw(graphics);
        if (this.isVisible()) {
            Window window = this.mc.m_91268_();
            int mouseX = (int)(this.mc.f_91067_.m_91589_() * (double)this.width / (double)window.m_85443_());
            int mouseY = (int)(this.mc.f_91067_.m_91594_() * (double)this.height / (double)window.m_85444_());
            this.updateFocusState(0, 0, mouseX, mouseY);
        }
    }

    private void showView() {
        boolean canOpen = this.updateGuiData();
        if (canOpen) {
            this.toggleActive(true);
            this.mc.f_91067_.m_91602_();
            this.openTime = System.currentTimeMillis();
        }
    }

    private void hideView() {
        this.toggleActive(false);
        this.mc.f_91067_.m_91601_();
        int focusIndex = this.getFocusIndex();
        if (focusIndex != -1) {
            this.equipToolbeltItem(this.getFocusType(), focusIndex, this.getFocusHand());
        } else if (System.currentTimeMillis() - this.openTime < 500L) {
            this.quickEquip();
        }
        this.holosphereGroup.performActions();
    }

    private boolean openToolbelt() {
        ItemStack itemStack = ToolbeltHelper.findToolbelt((Player)this.mc.f_91074_);
        if (!itemStack.m_41619_()) {
            TetraMod.packetHandler.sendToServer((AbstractPacket)new OpenToolbeltItemPacket());
        }
        return !itemStack.m_41619_();
    }

    private boolean updateGuiData() {
        boolean canShow = false;
        ItemStack toolbeltStack = ToolbeltHelper.findToolbelt((Player)this.mc.f_91074_);
        if (!toolbeltStack.m_41619_()) {
            this.quickslotGroup.setInventory(new QuickslotInventory(toolbeltStack));
            this.potionGroup.setInventory(new PotionsInventory(toolbeltStack));
            this.quiverGroup.setInventory(new QuiverInventory(toolbeltStack));
            canShow = true;
        } else {
            this.quickslotGroup.clear();
            this.potionGroup.clear();
            this.quiverGroup.clear();
        }
        ItemStack holosphereStack = ModularHolosphereItem.findHolosphere((Player)this.mc.f_91074_);
        if (!holosphereStack.m_41619_()) {
            this.holosphereGroup.update(holosphereStack);
            canShow = true;
        } else {
            this.holosphereGroup.clear();
        }
        return canShow;
    }

    private void equipToolbeltItem(ToolbeltSlotType slotType, int toolbeltItemIndex, InteractionHand hand) {
        if (toolbeltItemIndex > -1) {
            EquipToolbeltItemPacket packet = new EquipToolbeltItemPacket(slotType, toolbeltItemIndex, hand);
            TetraMod.packetHandler.sendToServer((AbstractPacket)packet);
            ToolbeltHelper.equipItemFromToolbelt((Player)this.mc.f_91074_, slotType, toolbeltItemIndex, hand);
        }
    }

    private void storeToolbeltItem() {
        boolean storeItemSuccess = ToolbeltHelper.storeItemInToolbelt((Player)this.mc.f_91074_);
        StoreToolbeltItemPacket packet = new StoreToolbeltItemPacket();
        TetraMod.packetHandler.sendToServer((AbstractPacket)packet);
        if (!storeItemSuccess) {
            this.mc.f_91074_.m_5661_((Component)Component.m_237115_((String)"tetra.toolbelt.full"), true);
        }
    }

    private void quickEquip() {
        BlockHitResult raytrace;
        BlockState blockState;
        int index;
        if (this.mc.f_91077_.m_6662_() == HitResult.Type.BLOCK && (index = ToolbeltHelper.getQuickAccessSlotIndex((Player)this.mc.f_91074_, this.mc.f_91077_, blockState = this.mc.f_91073_.m_8055_((raytrace = (BlockHitResult)this.mc.f_91077_).m_82425_()))) > -1) {
            this.equipToolbeltItem(ToolbeltSlotType.quickslot, index, InteractionHand.MAIN_HAND);
        }
    }

    public ToolbeltSlotType getFocusType() {
        if (this.quickslotGroup.getFocus() != -1) {
            return ToolbeltSlotType.quickslot;
        }
        if (this.potionGroup.getFocus() != -1) {
            return ToolbeltSlotType.potion;
        }
        if (this.quiverGroup.getFocus() != -1) {
            return ToolbeltSlotType.quiver;
        }
        return ToolbeltSlotType.quickslot;
    }

    public int getFocusIndex() {
        int quickslotFocus = this.quickslotGroup.getFocus();
        if (quickslotFocus != -1) {
            return quickslotFocus;
        }
        int potionFocus = this.potionGroup.getFocus();
        if (potionFocus != -1) {
            return potionFocus;
        }
        int quiverFocus = this.quiverGroup.getFocus();
        if (quiverFocus != -1) {
            return quiverFocus;
        }
        return -1;
    }

    public InteractionHand getFocusHand() {
        InteractionHand quickslotHand = this.quickslotGroup.getHand();
        if (quickslotHand != null) {
            return quickslotHand;
        }
        InteractionHand potionHand = this.potionGroup.getHand();
        if (potionHand != null) {
            return potionHand;
        }
        InteractionHand quiverHand = this.quiverGroup.getHand();
        if (quiverHand != null) {
            return quiverHand;
        }
        return InteractionHand.OFF_HAND;
    }
}

