/*
 * Decompiled with CFR 0.152.
 */
package se.mickelus.tetra.interactions;

import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.core.BlockPos;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.EntityHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraftforge.client.event.InputEvent;
import net.minecraftforge.client.gui.overlay.ForgeGui;
import net.minecraftforge.client.gui.overlay.IGuiOverlay;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import se.mickelus.mutil.gui.GuiAttachment;
import se.mickelus.mutil.gui.GuiRoot;
import se.mickelus.tetra.client.keymap.TetraKeyMappings;
import se.mickelus.tetra.interactions.SecondaryInteraction;
import se.mickelus.tetra.interactions.SecondaryInteractionGui;
import se.mickelus.tetra.interactions.SecondaryInteractionHandler;

public class SecondaryInteractionOverlay
extends GuiRoot
implements IGuiOverlay {
    SecondaryInteraction currentInteraction;
    SecondaryInteractionGui currentDisplay;
    boolean wasKeyDown = false;

    public SecondaryInteractionOverlay(Minecraft minecraft) {
        super(minecraft);
    }

    @SubscribeEvent
    public void onKeyInput(InputEvent.Key event) {
        if (!TetraKeyMappings.secondaryUseBinding.m_90857_() && this.wasKeyDown) {
            BlockPos blockPos = this.mc.f_91077_.m_6662_() == HitResult.Type.BLOCK ? ((BlockHitResult)this.mc.f_91077_).m_82425_() : null;
            Entity entity = this.mc.f_91077_.m_6662_() == HitResult.Type.ENTITY ? ((EntityHitResult)this.mc.f_91077_).m_82443_() : null;
            this.updateCurrentInteraction(blockPos, entity);
            if (this.currentInteraction != null) {
                SecondaryInteractionHandler.dispatchInteraction(this.currentInteraction, (Player)this.mc.f_91074_, blockPos, entity);
            }
        }
        this.wasKeyDown = TetraKeyMappings.secondaryUseBinding.m_90857_();
    }

    public void render(ForgeGui gui, GuiGraphics guiGraphics, float partialTick, int screenWidth, int screenHeight) {
        this.draw(guiGraphics);
    }

    @SubscribeEvent
    public void onClientTick(TickEvent.ClientTickEvent event) {
        if (TickEvent.Phase.END == event.phase && this.mc.f_91073_ != null && this.mc.f_91073_.m_46467_() % 10L == 0L) {
            this.updateCurrentInteraction(this.mc.f_91077_.m_6662_() == HitResult.Type.BLOCK ? ((BlockHitResult)this.mc.f_91077_).m_82425_() : null, this.mc.f_91077_.m_6662_() == HitResult.Type.ENTITY ? ((EntityHitResult)this.mc.f_91077_).m_82443_() : null);
        }
    }

    private void updateCurrentInteraction(BlockPos pos, Entity target) {
        boolean changed;
        SecondaryInteraction newInteraction = SecondaryInteractionHandler.findRelevantAction((Player)this.mc.f_91074_, pos, target);
        boolean bl = changed = newInteraction != this.currentInteraction;
        if (this.currentInteraction != null && changed) {
            if (this.currentDisplay != null) {
                this.currentDisplay.hide();
            }
            this.currentInteraction = null;
        }
        if (newInteraction != null && changed) {
            this.currentInteraction = newInteraction;
            int offset = Math.min((int)((double)(-this.mc.m_91268_().m_85445_()) * 0.3), -120);
            this.currentDisplay = new SecondaryInteractionGui(offset, -1, this.currentInteraction);
            this.currentDisplay.setAttachmentPoint(GuiAttachment.middleLeft);
            this.currentDisplay.setAttachmentAnchor(GuiAttachment.middleRight);
            this.currentDisplay.show();
            this.addChild(this.currentDisplay);
        }
    }
}

