/*
 * Decompiled with CFR 0.152.
 */
package se.mickelus.tetra.client.particle;

import com.mojang.brigadier.StringReader;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.Locale;
import net.minecraft.MethodsReturnNonnullByDefault;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleType;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraftforge.registries.ForgeRegistries;
import se.mickelus.tetra.client.particle.SweepingStrikeParticleType;

@MethodsReturnNonnullByDefault
public record SweepingStrikeParticleOption(int duration, boolean reverse, float pitch, float yaw) implements ParticleOptions
{
    public static final Codec<SweepingStrikeParticleOption> CODEC = RecordCodecBuilder.create(builder -> builder.group((App)Codec.INT.fieldOf("duration").forGetter(option -> option.duration), (App)Codec.BOOL.fieldOf("reverse").forGetter(option -> option.reverse), (App)Codec.FLOAT.fieldOf("pitch").forGetter(option -> Float.valueOf(option.pitch)), (App)Codec.FLOAT.fieldOf("yaw").forGetter(option -> Float.valueOf(option.yaw))).apply((Applicative)builder, SweepingStrikeParticleOption::new));
    public static final ParticleOptions.Deserializer<SweepingStrikeParticleOption> DESERIALIZER = new ParticleOptions.Deserializer<SweepingStrikeParticleOption>(){

        public SweepingStrikeParticleOption fromCommand(ParticleType<SweepingStrikeParticleOption> type, StringReader reader) throws CommandSyntaxException {
            reader.expect(' ');
            int duration = reader.readInt();
            reader.expect(' ');
            boolean reverse = reader.readBoolean();
            reader.expect(' ');
            float pitch = reader.readFloat();
            reader.expect(' ');
            float yaw = reader.readFloat();
            return new SweepingStrikeParticleOption(duration, reverse, pitch, yaw);
        }

        public SweepingStrikeParticleOption fromNetwork(ParticleType<SweepingStrikeParticleOption> type, FriendlyByteBuf buffer) {
            return new SweepingStrikeParticleOption(buffer.m_130242_(), buffer.readBoolean(), buffer.readFloat(), buffer.readFloat());
        }
    };

    public void m_7711_(FriendlyByteBuf buffer) {
        buffer.m_130130_(this.duration);
        buffer.writeBoolean(this.reverse);
        buffer.writeFloat(this.pitch);
        buffer.writeFloat(this.yaw);
    }

    public String m_5942_() {
        return String.format(Locale.ROOT, "%s %d %b %.2f %.2f", ForgeRegistries.PARTICLE_TYPES.getKey(this.m_6012_()), this.duration, this.reverse, Float.valueOf(this.pitch), Float.valueOf(this.yaw));
    }

    public ParticleType<SweepingStrikeParticleOption> m_6012_() {
        return SweepingStrikeParticleType.instance;
    }
}

