/*
 * Decompiled with CFR 0.152.
 */
package it.hurts.sskirillss.octolib.particle;

import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.BufferBuilder;
import com.mojang.blaze3d.vertex.DefaultVertexFormat;
import com.mojang.blaze3d.vertex.Tesselator;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.blaze3d.vertex.VertexFormat;
import com.mojang.brigadier.StringReader;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import it.hurts.sskirillss.octolib.init.OctoParticles;
import java.awt.Color;
import java.util.Locale;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.client.Camera;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.particle.Particle;
import net.minecraft.client.particle.ParticleProvider;
import net.minecraft.client.particle.ParticleRenderType;
import net.minecraft.client.particle.SpriteSet;
import net.minecraft.client.particle.TextureSheetParticle;
import net.minecraft.client.renderer.GameRenderer;
import net.minecraft.client.renderer.texture.TextureAtlas;
import net.minecraft.client.renderer.texture.TextureManager;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleType;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.registries.ForgeRegistries;
import org.antlr.v4.runtime.misc.NotNull;
import org.apache.commons.lang3.tuple.Pair;
import org.joml.Quaternionf;
import org.joml.Quaternionfc;
import org.joml.Vector3f;

public class BasicColoredParticle
extends TextureSheetParticle {
    private final Constructor constructor;
    private static final ParticleRenderType RENDERER = new ParticleRenderType(){

        public void m_6505_(BufferBuilder buffer, @NotNull TextureManager manager) {
            RenderSystem.setShader(GameRenderer::m_172829_);
            RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            RenderSystem.setShaderTexture((int)0, (ResourceLocation)TextureAtlas.f_118260_);
            RenderSystem.enableBlend();
            RenderSystem.blendFunc((int)770, (int)1);
            RenderSystem.depthMask((boolean)false);
            buffer.m_166779_(VertexFormat.Mode.QUADS, DefaultVertexFormat.f_85813_);
        }

        public void m_6294_(Tesselator tesselator) {
            tesselator.m_85914_();
            RenderSystem.disableBlend();
            RenderSystem.enableDepthTest();
            RenderSystem.depthMask((boolean)true);
        }

        public String toString() {
            return "octolib:basic_colored";
        }
    };

    public BasicColoredParticle(ClientLevel world, double x, double y, double z, double velocityX, double velocityY, double velocityZ, Constructor constructor) {
        super(world, x, y, z, velocityX, velocityY, velocityZ);
        this.m_107253_((float)constructor.getColor().getRed() / 255.0f, (float)constructor.getColor().getGreen() / 255.0f, (float)constructor.getColor().getBlue() / 255.0f);
        this.m_107250_(constructor.getDiameter(), constructor.getDiameter());
        this.m_107271_((float)constructor.getColor().getAlpha() / 255.0f);
        this.m_107257_(constructor.getLifetime());
        this.constructor = constructor;
        this.f_107663_ = constructor.getDiameter();
        this.f_107219_ = constructor.isPhysical();
        this.f_107215_ = velocityX;
        this.f_107216_ = velocityY;
        this.f_107217_ = velocityZ;
    }

    public void m_5744_(VertexConsumer buffer, Camera camera, float partialTicks) {
        Vec3 vec3 = camera.m_90583_();
        float f = (float)(Mth.m_14139_((double)partialTicks, (double)this.f_107209_, (double)this.f_107212_) - vec3.m_7096_());
        float f1 = (float)(Mth.m_14139_((double)partialTicks, (double)this.f_107210_, (double)this.f_107213_) - vec3.m_7098_());
        float f2 = (float)(Mth.m_14139_((double)partialTicks, (double)this.f_107211_, (double)this.f_107214_) - vec3.m_7094_());
        Quaternionf quaternionf = new Quaternionf((Quaternionfc)camera.m_253121_());
        quaternionf.rotateZ(Mth.m_14179_((float)partialTicks, (float)this.f_107204_, (float)this.f_107231_));
        Vector3f[] avector3f = new Vector3f[]{new Vector3f(-1.0f, -1.0f, 0.0f), new Vector3f(-1.0f, 1.0f, 0.0f), new Vector3f(1.0f, 1.0f, 0.0f), new Vector3f(1.0f, -1.0f, 0.0f)};
        float f3 = this.m_5902_(partialTicks);
        for (int i = 0; i < 4; ++i) {
            Vector3f vector3f = avector3f[i];
            vector3f.rotate((Quaternionfc)quaternionf);
            vector3f.mul(f3);
            vector3f.add(f, f1, f2);
        }
        float f6 = this.m_5970_();
        float f7 = this.m_5952_();
        float f4 = this.m_5951_();
        float f5 = this.m_5950_();
        int j = this.m_6355_(partialTicks);
        buffer.m_5483_((double)avector3f[0].x(), (double)avector3f[0].y(), (double)avector3f[0].z()).m_7421_(f7, f5).m_85950_(this.f_107227_, this.f_107228_, this.f_107229_, this.f_107230_).m_85969_(j).m_5752_();
        buffer.m_5483_((double)avector3f[1].x(), (double)avector3f[1].y(), (double)avector3f[1].z()).m_7421_(f7, f4).m_85950_(this.f_107227_, this.f_107228_, this.f_107229_, this.f_107230_).m_85969_(j).m_5752_();
        buffer.m_5483_((double)avector3f[2].x(), (double)avector3f[2].y(), (double)avector3f[2].z()).m_7421_(f6, f4).m_85950_(this.f_107227_, this.f_107228_, this.f_107229_, this.f_107230_).m_85969_(j).m_5752_();
        buffer.m_5483_((double)avector3f[3].x(), (double)avector3f[3].y(), (double)avector3f[3].z()).m_7421_(f6, f5).m_85950_(this.f_107227_, this.f_107228_, this.f_107229_, this.f_107230_).m_85969_(j).m_5752_();
    }

    public void m_5989_() {
        this.f_107663_ *= this.constructor.getScaleModifier();
        this.f_107209_ = this.f_107212_;
        this.f_107210_ = this.f_107213_;
        this.f_107211_ = this.f_107214_;
        this.f_107204_ = this.f_107231_;
        this.f_107231_ += this.constructor.getRoll();
        this.m_6257_(this.f_107215_, this.f_107216_, this.f_107217_);
        if (this.f_107224_++ >= this.f_107225_) {
            this.m_107274_();
        }
    }

    protected int m_6355_(float partialTick) {
        return 0xF000F0;
    }

    @Nonnull
    public ParticleRenderType m_7556_() {
        return RENDERER;
    }

    public static class Constructor {
        private Color color;
        private float diameter;
        private float roll;
        private boolean blended;
        @Nullable
        private Pair<Integer, Integer> blendFunc;
        private boolean blurred;
        private boolean physical;
        private boolean depthTest;
        private int lifetime;
        private float scaleModifier;

        private static float $default$diameter() {
            return 1.0f;
        }

        private static float $default$roll() {
            return 0.0f;
        }

        private static boolean $default$blurred() {
            return false;
        }

        private static boolean $default$physical() {
            return true;
        }

        private static boolean $default$depthTest() {
            return true;
        }

        private static int $default$lifetime() {
            return 20;
        }

        private static float $default$scaleModifier() {
            return 1.0f;
        }

        Constructor(Color color, float diameter, float roll, boolean blended, @Nullable Pair<Integer, Integer> blendFunc, boolean blurred, boolean physical, boolean depthTest, int lifetime, float scaleModifier) {
            this.color = color;
            this.diameter = diameter;
            this.roll = roll;
            this.blended = blended;
            this.blendFunc = blendFunc;
            this.blurred = blurred;
            this.physical = physical;
            this.depthTest = depthTest;
            this.lifetime = lifetime;
            this.scaleModifier = scaleModifier;
        }

        public static ConstructorBuilder builder() {
            return new ConstructorBuilder();
        }

        public Color getColor() {
            return this.color;
        }

        public float getDiameter() {
            return this.diameter;
        }

        public float getRoll() {
            return this.roll;
        }

        public boolean isBlended() {
            return this.blended;
        }

        @Nullable
        public Pair<Integer, Integer> getBlendFunc() {
            return this.blendFunc;
        }

        public boolean isBlurred() {
            return this.blurred;
        }

        public boolean isPhysical() {
            return this.physical;
        }

        public boolean isDepthTest() {
            return this.depthTest;
        }

        public int getLifetime() {
            return this.lifetime;
        }

        public float getScaleModifier() {
            return this.scaleModifier;
        }

        public void setColor(Color color) {
            this.color = color;
        }

        public void setDiameter(float diameter) {
            this.diameter = diameter;
        }

        public void setRoll(float roll) {
            this.roll = roll;
        }

        public void setBlended(boolean blended) {
            this.blended = blended;
        }

        public void setBlendFunc(@Nullable Pair<Integer, Integer> blendFunc) {
            this.blendFunc = blendFunc;
        }

        public void setBlurred(boolean blurred) {
            this.blurred = blurred;
        }

        public void setPhysical(boolean physical) {
            this.physical = physical;
        }

        public void setDepthTest(boolean depthTest) {
            this.depthTest = depthTest;
        }

        public void setLifetime(int lifetime) {
            this.lifetime = lifetime;
        }

        public void setScaleModifier(float scaleModifier) {
            this.scaleModifier = scaleModifier;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof Constructor)) {
                return false;
            }
            Constructor other = (Constructor)o;
            if (!other.canEqual(this)) {
                return false;
            }
            if (Float.compare(this.getDiameter(), other.getDiameter()) != 0) {
                return false;
            }
            if (Float.compare(this.getRoll(), other.getRoll()) != 0) {
                return false;
            }
            if (this.isBlended() != other.isBlended()) {
                return false;
            }
            if (this.isBlurred() != other.isBlurred()) {
                return false;
            }
            if (this.isPhysical() != other.isPhysical()) {
                return false;
            }
            if (this.isDepthTest() != other.isDepthTest()) {
                return false;
            }
            if (this.getLifetime() != other.getLifetime()) {
                return false;
            }
            if (Float.compare(this.getScaleModifier(), other.getScaleModifier()) != 0) {
                return false;
            }
            Color this$color = this.getColor();
            Color other$color = other.getColor();
            if (this$color == null ? other$color != null : !((Object)this$color).equals(other$color)) {
                return false;
            }
            Pair<Integer, Integer> this$blendFunc = this.getBlendFunc();
            Pair<Integer, Integer> other$blendFunc = other.getBlendFunc();
            return !(this$blendFunc == null ? other$blendFunc != null : !this$blendFunc.equals(other$blendFunc));
        }

        protected boolean canEqual(Object other) {
            return other instanceof Constructor;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            result = result * 59 + Float.floatToIntBits(this.getDiameter());
            result = result * 59 + Float.floatToIntBits(this.getRoll());
            result = result * 59 + (this.isBlended() ? 79 : 97);
            result = result * 59 + (this.isBlurred() ? 79 : 97);
            result = result * 59 + (this.isPhysical() ? 79 : 97);
            result = result * 59 + (this.isDepthTest() ? 79 : 97);
            result = result * 59 + this.getLifetime();
            result = result * 59 + Float.floatToIntBits(this.getScaleModifier());
            Color $color = this.getColor();
            result = result * 59 + ($color == null ? 43 : ((Object)$color).hashCode());
            Pair<Integer, Integer> $blendFunc = this.getBlendFunc();
            result = result * 59 + ($blendFunc == null ? 43 : $blendFunc.hashCode());
            return result;
        }

        public String toString() {
            return "BasicColoredParticle.Constructor(color=" + this.getColor() + ", diameter=" + this.getDiameter() + ", roll=" + this.getRoll() + ", blended=" + this.isBlended() + ", blendFunc=" + this.getBlendFunc() + ", blurred=" + this.isBlurred() + ", physical=" + this.isPhysical() + ", depthTest=" + this.isDepthTest() + ", lifetime=" + this.getLifetime() + ", scaleModifier=" + this.getScaleModifier() + ")";
        }

        public static class ConstructorBuilder {
            private boolean diameter$set;
            private float diameter$value;
            private boolean roll$set;
            private float roll$value;
            private Pair<Integer, Integer> blendFunc;
            private boolean blurred$set;
            private boolean blurred$value;
            private boolean physical$set;
            private boolean physical$value;
            private boolean depthTest$set;
            private boolean depthTest$value;
            private boolean lifetime$set;
            private int lifetime$value;
            private boolean scaleModifier$set;
            private float scaleModifier$value;
            private Color color = new Color(-1, true);
            private boolean blended = false;

            public ConstructorBuilder color(int color) {
                this.color = new Color(color, true);
                return this;
            }

            public ConstructorBuilder color(float r, float g, float b, float a) {
                return this.color(new Color(r, g, b, a).getRGB());
            }

            public ConstructorBuilder color(float r, float g, float b) {
                return this.color(r, g, b, 1.0f);
            }

            public ConstructorBuilder color(int r, int g, int b, int a) {
                return this.color((float)r / 255.0f, (float)g / 255.0f, (float)b / 255.0f, (float)a / 255.0f);
            }

            public ConstructorBuilder color(int r, int g, int b) {
                return this.color(r, g, b, 255);
            }

            private ConstructorBuilder blendFunc(Pair<Integer, Integer> pair) {
                return this;
            }

            public ConstructorBuilder blended(boolean blended) {
                this.blended = blended;
                return this;
            }

            public ConstructorBuilder blended(int source, int dest) {
                this.blendFunc = Pair.of((Object)source, (Object)dest);
                this.blended = true;
                return this;
            }

            ConstructorBuilder() {
            }

            public ConstructorBuilder diameter(float diameter) {
                this.diameter$value = diameter;
                this.diameter$set = true;
                return this;
            }

            public ConstructorBuilder roll(float roll) {
                this.roll$value = roll;
                this.roll$set = true;
                return this;
            }

            public ConstructorBuilder blurred(boolean blurred) {
                this.blurred$value = blurred;
                this.blurred$set = true;
                return this;
            }

            public ConstructorBuilder physical(boolean physical) {
                this.physical$value = physical;
                this.physical$set = true;
                return this;
            }

            public ConstructorBuilder depthTest(boolean depthTest) {
                this.depthTest$value = depthTest;
                this.depthTest$set = true;
                return this;
            }

            public ConstructorBuilder lifetime(int lifetime) {
                this.lifetime$value = lifetime;
                this.lifetime$set = true;
                return this;
            }

            public ConstructorBuilder scaleModifier(float scaleModifier) {
                this.scaleModifier$value = scaleModifier;
                this.scaleModifier$set = true;
                return this;
            }

            public Constructor build() {
                float diameter$value = this.diameter$value;
                if (!this.diameter$set) {
                    diameter$value = Constructor.$default$diameter();
                }
                float roll$value = this.roll$value;
                if (!this.roll$set) {
                    roll$value = Constructor.$default$roll();
                }
                boolean blurred$value = this.blurred$value;
                if (!this.blurred$set) {
                    blurred$value = Constructor.$default$blurred();
                }
                boolean physical$value = this.physical$value;
                if (!this.physical$set) {
                    physical$value = Constructor.$default$physical();
                }
                boolean depthTest$value = this.depthTest$value;
                if (!this.depthTest$set) {
                    depthTest$value = Constructor.$default$depthTest();
                }
                int lifetime$value = this.lifetime$value;
                if (!this.lifetime$set) {
                    lifetime$value = Constructor.$default$lifetime();
                }
                float scaleModifier$value = this.scaleModifier$value;
                if (!this.scaleModifier$set) {
                    scaleModifier$value = Constructor.$default$scaleModifier();
                }
                return new Constructor(this.color, diameter$value, roll$value, this.blended, this.blendFunc, blurred$value, physical$value, depthTest$value, lifetime$value, scaleModifier$value);
            }

            public String toString() {
                return "BasicColoredParticle.Constructor.ConstructorBuilder(color=" + this.color + ", diameter$value=" + this.diameter$value + ", roll$value=" + this.roll$value + ", blended=" + this.blended + ", blendFunc=" + this.blendFunc + ", blurred$value=" + this.blurred$value + ", physical$value=" + this.physical$value + ", depthTest$value=" + this.depthTest$value + ", lifetime$value=" + this.lifetime$value + ", scaleModifier$value=" + this.scaleModifier$value + ")";
            }
        }
    }

    public static class Factory
    implements ParticleProvider<Options> {
        private final SpriteSet sprites;

        @Nullable
        public Particle createParticle(Options options, ClientLevel world, double xPos, double yPos, double zPos, double xVelocity, double yVelocity, double zVelocity) {
            BasicColoredParticle particle = new BasicColoredParticle(world, xPos, yPos, zPos, xVelocity, yVelocity, zVelocity, options.getData());
            particle.m_108335_(this.sprites);
            return particle;
        }

        public Factory(SpriteSet sprite) {
            this.sprites = sprite;
        }

        public static class Type
        extends ParticleType<Options> {
            public Type() {
                super(false, Options.DESERIALIZER);
            }

            public Codec<Options> m_7652_() {
                return Options.CODEC;
            }
        }
    }

    public static class Options
    implements ParticleOptions {
        private final Constructor data;
        public static final Codec<Options> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)Codec.INT.fieldOf("color").forGetter(options -> options.getData().getColor().getRGB()), (App)Codec.FLOAT.fieldOf("diameter").forGetter(options -> Float.valueOf(options.getData().getDiameter())), (App)Codec.INT.fieldOf("lifetime").forGetter(options -> options.getData().getLifetime()), (App)Codec.FLOAT.fieldOf("roll").forGetter(options -> Float.valueOf(options.getData().getRoll()))).apply((Applicative)instance, Options::new));
        public static final ParticleOptions.Deserializer<Options> DESERIALIZER = new ParticleOptions.Deserializer<Options>(){

            @Nonnull
            public Options fromCommand(@Nonnull ParticleType<Options> type, @Nonnull StringReader reader) throws CommandSyntaxException {
                reader.expect(' ');
                int color = reader.readInt();
                reader.expect(' ');
                float diameter = reader.readFloat();
                reader.expect(' ');
                int lifetime = reader.readInt();
                reader.expect(' ');
                float roll = reader.readFloat();
                return new Options(color, diameter, lifetime, roll);
            }

            public Options fromNetwork(@Nonnull ParticleType<Options> type, FriendlyByteBuf buf) {
                int color = buf.readInt();
                float diameter = buf.readFloat();
                int lifetime = buf.readInt();
                float roll = buf.readFloat();
                return new Options(color, diameter, lifetime, roll);
            }
        };

        private Options(int color, float diameter, int lifetime, float roll) {
            this.data = Constructor.builder().color(color).diameter(diameter).lifetime(lifetime).roll(roll).build();
        }

        public Options(Constructor data) {
            this.data = data;
        }

        @Nonnull
        public ParticleType<Options> m_6012_() {
            return (ParticleType)OctoParticles.BASIC_COLORED.get();
        }

        public void m_7711_(FriendlyByteBuf buf) {
            buf.writeInt(this.data.getColor().getRGB());
            buf.writeFloat(this.data.getDiameter());
            buf.writeInt(this.data.getLifetime());
            buf.writeFloat(this.data.getRoll());
        }

        @Nonnull
        public String m_5942_() {
            return String.format(Locale.ROOT, "%s %d %.2f %d %.2f", ForgeRegistries.PARTICLE_TYPES.getKey(this.m_6012_()), this.data.getColor().getRGB(), Float.valueOf(this.data.getDiameter()), this.data.getLifetime(), Float.valueOf(this.data.getRoll()));
        }

        public Constructor getData() {
            return this.data;
        }
    }
}

