/*
 * Decompiled with CFR 0.152.
 */
package it.hurts.sskirillss.relics.system.casts.slots;

import it.hurts.sskirillss.relics.system.casts.slots.base.SlotReference;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import top.theillusivec4.curios.api.CuriosApi;
import top.theillusivec4.curios.api.type.inventory.ICurioStacksHandler;
import top.theillusivec4.curios.api.type.inventory.IDynamicStackHandler;

public class CurioSlotReference
extends SlotReference {
    private int index;
    private String type;

    @Override
    public ItemStack gatherStack(Player player) {
        return CuriosApi.getCuriosInventory((LivingEntity)player).resolve().map(itemHandler -> {
            IDynamicStackHandler stackHandler = ((ICurioStacksHandler)itemHandler.getCurios().get(this.getType())).getStacks();
            int index = this.getIndex();
            return index > stackHandler.getSlots() - 1 ? null : stackHandler.getStackInSlot(index);
        }).orElse(ItemStack.f_41583_);
    }

    @Override
    public CompoundTag serializeNBT() {
        CompoundTag tag = super.serializeNBT();
        tag.m_128405_("index", this.index);
        tag.m_128359_("type", this.type);
        return tag;
    }

    @Override
    public SlotReference deserializeNBT(CompoundTag tag) {
        this.index = tag.m_128451_("index");
        this.type = tag.m_128461_("type");
        return this;
    }

    public int getIndex() {
        return this.index;
    }

    public String getType() {
        return this.type;
    }

    public void setIndex(int index) {
        this.index = index;
    }

    public void setType(String type) {
        this.type = type;
    }

    @Override
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof CurioSlotReference)) {
            return false;
        }
        CurioSlotReference other = (CurioSlotReference)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.getIndex() != other.getIndex()) {
            return false;
        }
        String this$type = this.getType();
        String other$type = other.getType();
        return !(this$type == null ? other$type != null : !this$type.equals(other$type));
    }

    @Override
    protected boolean canEqual(Object other) {
        return other instanceof CurioSlotReference;
    }

    @Override
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + this.getIndex();
        String $type = this.getType();
        result = result * 59 + ($type == null ? 43 : $type.hashCode());
        return result;
    }

    @Override
    public String toString() {
        return "CurioSlotReference(index=" + this.getIndex() + ", type=" + this.getType() + ")";
    }

    public CurioSlotReference() {
    }

    public CurioSlotReference(int index, String type) {
        this.index = index;
        this.type = type;
    }
}

