/*
 * Decompiled with CFR 0.152.
 */
package it.hurts.sskirillss.relics.network.packets.abilities;

import it.hurts.sskirillss.relics.items.relics.base.IRelicItem;
import it.hurts.sskirillss.relics.items.relics.base.data.cast.misc.CastStage;
import it.hurts.sskirillss.relics.items.relics.base.data.cast.misc.CastType;
import it.hurts.sskirillss.relics.system.casts.abilities.AbilityReference;
import java.util.function.Supplier;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.network.NetworkEvent;

public class SpellCastPacket {
    private final CastType type;
    private final CastStage stage;
    private final AbilityReference ability;

    public SpellCastPacket(FriendlyByteBuf buf) {
        this.type = (CastType)buf.m_130066_(CastType.class);
        this.stage = (CastStage)buf.m_130066_(CastStage.class);
        this.ability = new AbilityReference().deserializeNBT(buf.m_130260_());
    }

    public SpellCastPacket(CastType type, CastStage stage, AbilityReference ability) {
        this.type = type;
        this.stage = stage;
        this.ability = ability;
    }

    public void toBytes(FriendlyByteBuf buf) {
        buf.m_130068_((Enum)this.type);
        buf.m_130068_((Enum)this.stage);
        buf.m_130079_(this.ability.serializeNBT());
    }

    public boolean handle(Supplier<NetworkEvent.Context> ctx) {
        ctx.get().enqueueWork(() -> {
            ServerPlayer player = ((NetworkEvent.Context)ctx.get()).getSender();
            if (player == null) {
                return;
            }
            ItemStack stack = this.ability.getSlot().gatherStack((Player)player);
            Item patt1650$temp = stack.m_41720_();
            if (!(patt1650$temp instanceof IRelicItem)) {
                return;
            }
            IRelicItem relic = (IRelicItem)patt1650$temp;
            if (!relic.canPlayerUseActiveAbility((Player)player, stack, this.ability.getId())) {
                if (relic.isAbilityTicking(stack, this.ability.getId())) {
                    relic.setAbilityTicking(stack, this.ability.getId(), false);
                    relic.castActiveAbility(stack, (Player)player, this.ability.getId(), this.type, CastStage.END);
                }
                return;
            }
            block0 : switch (this.type) {
                case CYCLICAL: 
                case TOGGLEABLE: {
                    switch (this.stage) {
                        case START: {
                            relic.setAbilityTicking(stack, this.ability.getId(), true);
                            break block0;
                        }
                        case END: {
                            relic.setAbilityTicking(stack, this.ability.getId(), false);
                        }
                    }
                }
            }
            relic.castActiveAbility(stack, (Player)player, this.ability.getId(), this.type, this.stage);
        });
        return true;
    }
}

