/*
 * Decompiled with CFR 0.152.
 */
package it.hurts.sskirillss.relics.level;

import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import it.hurts.sskirillss.relics.init.CodecRegistry;
import it.hurts.sskirillss.relics.items.relics.base.IRelicItem;
import it.hurts.sskirillss.relics.items.relics.base.data.RelicStorage;
import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import java.util.Map;
import java.util.regex.PatternSyntaxException;
import javax.annotation.Nonnull;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.storage.loot.LootContext;
import net.minecraft.world.level.storage.loot.predicates.LootItemCondition;
import net.minecraftforge.common.loot.IGlobalLootModifier;
import net.minecraftforge.common.loot.LootModifier;
import org.jetbrains.annotations.NotNull;

public class RelicLootModifier
extends LootModifier {
    public static final Codec<RelicLootModifier> CODEC = RecordCodecBuilder.create(inst -> RelicLootModifier.codecStart((RecordCodecBuilder.Instance)inst).apply((Applicative)inst, RelicLootModifier::new));

    public RelicLootModifier(LootItemCondition[] conditionsIn) {
        super(conditionsIn);
    }

    @Nonnull
    @NotNull
    protected ObjectArrayList<ItemStack> doApply(ObjectArrayList<ItemStack> generatedLoot, LootContext context) {
        String lootId = context.getQueriedLootTableId().toString();
        block2: for (IRelicItem relic : RelicStorage.RELICS.keySet()) {
            for (Map.Entry<String, Float> entry : relic.getLootData().getCollection().getEntries().entrySet()) {
                boolean isValid;
                String pattern = entry.getKey();
                float chance = entry.getValue().floatValue();
                try {
                    isValid = lootId.matches(pattern);
                }
                catch (PatternSyntaxException exception) {
                    isValid = lootId.equals(pattern);
                }
                if (!isValid) continue;
                if (!(context.m_230907_().m_188501_() <= chance)) continue block2;
                generatedLoot.add((Object)relic.getItem().m_7968_());
                continue block2;
            }
        }
        return generatedLoot;
    }

    public Codec<? extends IGlobalLootModifier> codec() {
        return (Codec)CodecRegistry.RELIC_LOOT.get();
    }
}

