/*
 * Decompiled with CFR 0.152.
 */
package it.hurts.sskirillss.relics.items.relics.ring;

import it.hurts.sskirillss.relics.init.ItemRegistry;
import it.hurts.sskirillss.relics.items.relics.base.RelicItem;
import it.hurts.sskirillss.relics.items.relics.base.data.RelicData;
import it.hurts.sskirillss.relics.items.relics.base.data.leveling.AbilitiesData;
import it.hurts.sskirillss.relics.items.relics.base.data.leveling.AbilityData;
import it.hurts.sskirillss.relics.items.relics.base.data.leveling.LevelingData;
import it.hurts.sskirillss.relics.items.relics.base.data.leveling.StatData;
import it.hurts.sskirillss.relics.items.relics.base.data.leveling.misc.UpgradeOperation;
import it.hurts.sskirillss.relics.items.relics.base.data.loot.LootData;
import it.hurts.sskirillss.relics.items.relics.base.data.loot.misc.LootCollections;
import it.hurts.sskirillss.relics.items.relics.base.data.style.StyleData;
import it.hurts.sskirillss.relics.items.relics.base.data.style.misc.Backgrounds;
import it.hurts.sskirillss.relics.utils.EntityUtils;
import it.hurts.sskirillss.relics.utils.MathUtils;
import it.hurts.sskirillss.relics.utils.ParticleUtils;
import java.awt.Color;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ClipContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.event.entity.EntityTeleportEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import top.theillusivec4.curios.api.SlotContext;

public class ChorusInhibitorItem
extends RelicItem {
    @Override
    public RelicData constructDefaultRelicData() {
        return RelicData.builder().abilities(AbilitiesData.builder().ability(AbilityData.builder("blink").stat(StatData.builder("distance").initialValue(16.0, 32.0).upgradeModifier(UpgradeOperation.MULTIPLY_BASE, 0.2).formatValue(value -> (int)MathUtils.round(value, 0)).build()).stat(StatData.builder("cooldown").initialValue(5.0, 10.0).upgradeModifier(UpgradeOperation.ADD, -0.5).formatValue(value -> MathUtils.round(value, 1)).build()).build()).build()).leveling(new LevelingData(100, 10, 100)).style(StyleData.builder().background(Backgrounds.END).build()).loot(LootData.builder().entry(LootCollections.END).build()).build();
    }

    public void curioTick(SlotContext slotContext, ItemStack stack) {
        Player player;
        LivingEntity livingEntity = slotContext.entity();
        if (!(livingEntity instanceof Player) || (player = (Player)livingEntity).m_21120_(InteractionHand.MAIN_HAND).m_41720_() != Items.f_42730_ || player.m_36335_().m_41519_(Items.f_42730_) || !player.m_9236_().m_5776_()) {
            return;
        }
        BlockPos pos = this.getEyesPos(player, stack);
        if (pos == null) {
            return;
        }
        Vec3 start = player.m_20182_().m_82520_(0.0, (double)player.m_20206_() * 0.65, 0.0);
        Vec3 end = new Vec3((double)((float)pos.m_123341_() + 0.5f), (double)((float)pos.m_123342_() - 0.5f), (double)((float)pos.m_123343_() + 0.5f));
        ParticleUtils.createLine((ParticleOptions)ParticleUtils.constructSimpleSpark(new Color(20, 0, 80), 0.15f, 0, 0.5f), player.m_9236_(), start, end, (int)Math.round(start.m_82554_(end) * 5.0));
    }

    @Nullable
    public BlockPos getEyesPos(Player player, ItemStack stack) {
        double distance;
        Level world = player.m_20193_();
        Vec3 view = player.m_20252_(0.0f);
        Vec3 eyeVec = player.m_20299_(0.0f);
        BlockHitResult ray = world.m_45547_(new ClipContext(eyeVec, eyeVec.m_82520_(view.f_82479_ * (distance = this.getAbilityValue(stack, "blink", "distance")), view.f_82480_ * distance, view.f_82481_ * distance), ClipContext.Block.COLLIDER, ClipContext.Fluid.NONE, (Entity)player));
        BlockPos pos = ray.m_82425_();
        if (!world.m_8055_(pos).m_280555_()) {
            return null;
        }
        pos = pos.m_7494_();
        for (int i = 0; i < 10; ++i) {
            if (!world.m_8055_(pos).m_280555_() && !world.m_8055_(pos.m_7494_()).m_280555_()) {
                return pos;
            }
            pos = pos.m_7494_();
        }
        return null;
    }

    @Mod.EventBusSubscriber
    public static class Events {
        @SubscribeEvent
        public static void onChorusTeleport(EntityTeleportEvent.ChorusFruit event) {
            Entity entity = event.getEntity();
            if (!(entity instanceof Player)) {
                return;
            }
            Player player = (Player)entity;
            ItemStack stack = EntityUtils.findEquippedCurio((Entity)player, (Item)ItemRegistry.CHORUS_INHIBITOR.get());
            Item item = stack.m_41720_();
            if (!(item instanceof ChorusInhibitorItem)) {
                return;
            }
            ChorusInhibitorItem relic = (ChorusInhibitorItem)item;
            event.setCanceled(true);
            BlockPos pos = relic.getEyesPos(player, stack);
            if (pos == null) {
                return;
            }
            relic.spreadExperience((LivingEntity)player, stack, (int)Math.floor(player.m_20182_().m_82554_(new Vec3((double)pos.m_123341_(), (double)pos.m_123342_(), (double)pos.m_123343_())) / 10.0));
            player.m_6021_((double)pos.m_123341_() + 0.5, (double)pos.m_123342_(), (double)pos.m_123343_() + 0.5);
            player.m_9236_().m_5594_(null, pos, SoundEvents.f_11757_, SoundSource.PLAYERS, 1.0f, 1.0f);
            player.m_36335_().m_41524_(Items.f_42730_, Math.max((int)Math.round(relic.getAbilityValue(stack, "blink", "cooldown") * 20.0), 0));
        }
    }
}

