/*
 * Decompiled with CFR 0.152.
 */
package it.hurts.sskirillss.relics.commands;

import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.DoubleArgumentType;
import com.mojang.brigadier.arguments.IntegerArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import it.hurts.sskirillss.relics.commands.arguments.RelicAbilityArgument;
import it.hurts.sskirillss.relics.commands.arguments.RelicAbilityStatArgument;
import it.hurts.sskirillss.relics.config.ConfigHelper;
import it.hurts.sskirillss.relics.items.relics.base.IRelicItem;
import it.hurts.sskirillss.relics.items.relics.base.data.RelicData;
import it.hurts.sskirillss.relics.items.relics.base.data.leveling.AbilityData;
import it.hurts.sskirillss.relics.items.relics.base.data.leveling.StatData;
import java.util.Map;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.Commands;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.server.command.EnumArgument;

public class RelicsCommand {
    public static void register(CommandDispatcher<CommandSourceStack> dispatcher) {
        dispatcher.register((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.m_82127_((String)"relics").requires(sender -> sender.m_6761_(2))).then(Commands.m_82127_((String)"config").then(Commands.m_82127_((String)"reload").executes(context -> {
            ConfigHelper.readConfigs();
            return 1;
        })))).then(Commands.m_82127_((String)"maximize").executes(context -> {
            ServerPlayer player = ((CommandSourceStack)context.getSource()).m_81375_();
            ItemStack stack = player.m_21120_(InteractionHand.MAIN_HAND);
            Item patt2010$temp = stack.m_41720_();
            if (!(patt2010$temp instanceof IRelicItem)) {
                ((CommandSourceStack)context.getSource()).m_81352_((Component)Component.m_237115_((String)"command.relics.base.not_relic"));
                return 0;
            }
            IRelicItem relic = (IRelicItem)patt2010$temp;
            RelicData relicData = relic.getRelicData();
            relic.setLevel(stack, relicData.getLeveling().getMaxLevel());
            for (Map.Entry<String, AbilityData> abilityEntry : relicData.getAbilities().getAbilities().entrySet()) {
                String abilityId = abilityEntry.getKey();
                AbilityData abilityInfo = abilityEntry.getValue();
                relic.setAbilityPoints(stack, abilityId, abilityInfo.getMaxLevel());
                for (Map.Entry<String, StatData> statEntry : abilityInfo.getStats().entrySet()) {
                    String statId = statEntry.getKey();
                    relic.setAbilityValue(stack, abilityId, statId, relic.getStatByQuality(abilityId, statId, relic.getMaxQuality()));
                }
            }
            return 1;
        }))).then(Commands.m_82127_((String)"minimize").executes(context -> {
            ServerPlayer player = ((CommandSourceStack)context.getSource()).m_81375_();
            ItemStack stack = player.m_21120_(InteractionHand.MAIN_HAND);
            Item patt3671$temp = stack.m_41720_();
            if (!(patt3671$temp instanceof IRelicItem)) {
                ((CommandSourceStack)context.getSource()).m_81352_((Component)Component.m_237115_((String)"command.relics.base.not_relic"));
                return 0;
            }
            IRelicItem relic = (IRelicItem)patt3671$temp;
            RelicData relicData = relic.getRelicData();
            relic.setLevel(stack, relicData.getLeveling().getMaxLevel());
            for (Map.Entry<String, AbilityData> abilityEntry : relicData.getAbilities().getAbilities().entrySet()) {
                String abilityId = abilityEntry.getKey();
                relic.setAbilityPoints(stack, abilityId, 0);
                for (Map.Entry<String, StatData> statEntry : abilityEntry.getValue().getStats().entrySet()) {
                    String statId = statEntry.getKey();
                    relic.setAbilityValue(stack, abilityId, statId, relic.getStatByQuality(abilityId, statId, 0));
                }
            }
            return 1;
        }))).then(Commands.m_82127_((String)"level").then(Commands.m_82129_((String)"action", (ArgumentType)EnumArgument.enumArgument(CommandAction.class)).then(Commands.m_82129_((String)"level", (ArgumentType)IntegerArgumentType.integer()).executes(context -> {
            ServerPlayer player = ((CommandSourceStack)context.getSource()).m_81375_();
            ItemStack stack = player.m_21120_(InteractionHand.MAIN_HAND);
            Item patt5481$temp = stack.m_41720_();
            if (!(patt5481$temp instanceof IRelicItem)) {
                ((CommandSourceStack)context.getSource()).m_81352_((Component)Component.m_237115_((String)"command.relics.base.not_relic"));
                return 0;
            }
            IRelicItem relic = (IRelicItem)patt5481$temp;
            CommandAction action = (CommandAction)((Object)((Object)context.getArgument("action", CommandAction.class)));
            int level = IntegerArgumentType.getInteger((CommandContext)context, (String)"level");
            switch (action) {
                case SET: {
                    relic.setLevel(stack, level);
                    break;
                }
                case ADD: {
                    relic.addLevel(stack, level);
                    break;
                }
                case TAKE: {
                    relic.addLevel(stack, -level);
                }
            }
            return 1;
        }))))).then(Commands.m_82127_((String)"experience").then(Commands.m_82129_((String)"action", (ArgumentType)EnumArgument.enumArgument(CommandAction.class)).then(Commands.m_82129_((String)"experience", (ArgumentType)IntegerArgumentType.integer()).executes(context -> {
            ServerPlayer player = ((CommandSourceStack)context.getSource()).m_81375_();
            ItemStack stack = player.m_21120_(InteractionHand.MAIN_HAND);
            Item patt7122$temp = stack.m_41720_();
            if (!(patt7122$temp instanceof IRelicItem)) {
                ((CommandSourceStack)context.getSource()).m_81352_((Component)Component.m_237115_((String)"command.relics.base.not_relic"));
                return 0;
            }
            IRelicItem relic = (IRelicItem)patt7122$temp;
            CommandAction action = (CommandAction)((Object)((Object)context.getArgument("action", CommandAction.class)));
            int experience = IntegerArgumentType.getInteger((CommandContext)context, (String)"experience");
            switch (action) {
                case SET: {
                    relic.setExperience(stack, experience);
                    break;
                }
                case ADD: {
                    relic.addExperience(stack, experience);
                    break;
                }
                case TAKE: {
                    relic.addExperience(stack, -experience);
                }
            }
            return 1;
        }))))).then(Commands.m_82127_((String)"points").then(Commands.m_82129_((String)"action", (ArgumentType)EnumArgument.enumArgument(CommandAction.class)).then(Commands.m_82129_((String)"points", (ArgumentType)IntegerArgumentType.integer()).executes(context -> {
            ServerPlayer player = ((CommandSourceStack)context.getSource()).m_81375_();
            ItemStack stack = player.m_21120_(InteractionHand.MAIN_HAND);
            Item patt8795$temp = stack.m_41720_();
            if (!(patt8795$temp instanceof IRelicItem)) {
                ((CommandSourceStack)context.getSource()).m_81352_((Component)Component.m_237115_((String)"command.relics.base.not_relic"));
                return 0;
            }
            IRelicItem relic = (IRelicItem)patt8795$temp;
            CommandAction action = (CommandAction)((Object)((Object)context.getArgument("action", CommandAction.class)));
            int points = IntegerArgumentType.getInteger((CommandContext)context, (String)"points");
            switch (action) {
                case SET: {
                    relic.setPoints(stack, points);
                    break;
                }
                case ADD: {
                    relic.addPoints(stack, points);
                    break;
                }
                case TAKE: {
                    relic.addPoints(stack, -points);
                }
            }
            return 1;
        }))))).then(((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.m_82127_((String)"ability").then(Commands.m_82127_((String)"points").then(Commands.m_82129_((String)"action", (ArgumentType)EnumArgument.enumArgument(CommandAction.class)).then(Commands.m_82129_((String)"ability", (ArgumentType)RelicAbilityArgument.ability()).then(Commands.m_82129_((String)"points", (ArgumentType)IntegerArgumentType.integer()).executes(context -> {
            ServerPlayer player = ((CommandSourceStack)context.getSource()).m_81375_();
            ItemStack stack = player.m_21120_(InteractionHand.MAIN_HAND);
            Item patt10691$temp = stack.m_41720_();
            if (!(patt10691$temp instanceof IRelicItem)) {
                ((CommandSourceStack)context.getSource()).m_81352_((Component)Component.m_237115_((String)"command.relics.base.not_relic"));
                return 0;
            }
            IRelicItem relic = (IRelicItem)patt10691$temp;
            CommandAction action = (CommandAction)((Object)((Object)context.getArgument("action", CommandAction.class)));
            String ability = RelicAbilityArgument.getAbility(context, "ability");
            int points = IntegerArgumentType.getInteger((CommandContext)context, (String)"points");
            if (ability.equals("all")) {
                for (String entry : relic.getRelicData().getAbilities().getAbilities().keySet()) {
                    switch (action) {
                        case SET: {
                            relic.setAbilityPoints(stack, entry, points);
                            break;
                        }
                        case ADD: {
                            relic.addAbilityPoints(stack, entry, points);
                            break;
                        }
                        case TAKE: {
                            relic.addAbilityPoints(stack, entry, -points);
                        }
                    }
                }
            } else {
                switch (action) {
                    case SET: {
                        relic.setAbilityPoints(stack, ability, points);
                        break;
                    }
                    case ADD: {
                        relic.addAbilityPoints(stack, ability, points);
                        break;
                    }
                    case TAKE: {
                        relic.addAbilityPoints(stack, ability, -points);
                    }
                }
            }
            return 1;
        })))))).then(Commands.m_82127_((String)"value").then(Commands.m_82129_((String)"action", (ArgumentType)EnumArgument.enumArgument(CommandAction.class)).then(Commands.m_82129_((String)"ability", (ArgumentType)RelicAbilityArgument.ability()).then(Commands.m_82129_((String)"stat", (ArgumentType)RelicAbilityStatArgument.abilityStat()).then(Commands.m_82129_((String)"value", (ArgumentType)DoubleArgumentType.doubleArg()).executes(context -> {
            ServerPlayer player = ((CommandSourceStack)context.getSource()).m_81375_();
            ItemStack stack = player.m_21120_(InteractionHand.MAIN_HAND);
            Item patt14079$temp = stack.m_41720_();
            if (!(patt14079$temp instanceof IRelicItem)) {
                ((CommandSourceStack)context.getSource()).m_81352_((Component)Component.m_237115_((String)"command.relics.base.not_relic"));
                return 0;
            }
            IRelicItem relic = (IRelicItem)patt14079$temp;
            CommandAction action = (CommandAction)((Object)((Object)context.getArgument("action", CommandAction.class)));
            String ability = RelicAbilityArgument.getAbility(context, "ability");
            String stat = RelicAbilityStatArgument.getAbilityStat(context, "stat");
            double value = DoubleArgumentType.getDouble((CommandContext)context, (String)"value");
            if (ability.equals("all")) {
                for (String abilityEntry : relic.getRelicData().getAbilities().getAbilities().keySet()) {
                    if (stat.equals("all")) {
                        for (String statEntry : relic.getAbilityData(abilityEntry).getStats().keySet()) {
                            switch (action) {
                                case SET: {
                                    relic.setAbilityValue(stack, abilityEntry, statEntry, value);
                                    break;
                                }
                                case ADD: {
                                    relic.addAbilityValue(stack, abilityEntry, statEntry, value);
                                    break;
                                }
                                case TAKE: {
                                    relic.addAbilityValue(stack, abilityEntry, statEntry, -value);
                                }
                            }
                        }
                        continue;
                    }
                    switch (action) {
                        case SET: {
                            relic.setAbilityValue(stack, abilityEntry, stat, value);
                            break;
                        }
                        case ADD: {
                            relic.addAbilityValue(stack, abilityEntry, stat, value);
                            break;
                        }
                        case TAKE: {
                            relic.addAbilityValue(stack, abilityEntry, stat, -value);
                        }
                    }
                }
            } else if (stat.equals("all")) {
                for (String statEntry : relic.getAbilityData(ability).getStats().keySet()) {
                    switch (action) {
                        case SET: {
                            relic.setAbilityValue(stack, ability, statEntry, value);
                            break;
                        }
                        case ADD: {
                            relic.addAbilityValue(stack, ability, statEntry, value);
                            break;
                        }
                        case TAKE: {
                            relic.addAbilityValue(stack, ability, statEntry, -value);
                        }
                    }
                }
            } else {
                switch (action) {
                    case SET: {
                        relic.setAbilityValue(stack, ability, stat, value);
                        break;
                    }
                    case ADD: {
                        relic.addAbilityValue(stack, ability, stat, value);
                        break;
                    }
                    case TAKE: {
                        relic.addAbilityValue(stack, ability, stat, -value);
                    }
                }
            }
            return 1;
        }))))))).then(Commands.m_82127_((String)"quality").then(Commands.m_82129_((String)"action", (ArgumentType)EnumArgument.enumArgument(CommandAction.class)).then(Commands.m_82129_((String)"ability", (ArgumentType)RelicAbilityArgument.ability()).then(Commands.m_82129_((String)"stat", (ArgumentType)RelicAbilityStatArgument.abilityStat()).then(Commands.m_82129_((String)"quality", (ArgumentType)IntegerArgumentType.integer()).executes(context -> {
            ServerPlayer player = ((CommandSourceStack)context.getSource()).m_81375_();
            ItemStack stack = player.m_21120_(InteractionHand.MAIN_HAND);
            Item patt20217$temp = stack.m_41720_();
            if (!(patt20217$temp instanceof IRelicItem)) {
                ((CommandSourceStack)context.getSource()).m_81352_((Component)Component.m_237115_((String)"command.relics.base.not_relic"));
                return 0;
            }
            IRelicItem relic = (IRelicItem)patt20217$temp;
            CommandAction action = (CommandAction)((Object)((Object)context.getArgument("action", CommandAction.class)));
            String ability = RelicAbilityArgument.getAbility(context, "ability");
            String stat = RelicAbilityStatArgument.getAbilityStat(context, "stat");
            int quality = IntegerArgumentType.getInteger((CommandContext)context, (String)"quality");
            if (ability.equals("all")) {
                for (String abilityEntry : relic.getRelicData().getAbilities().getAbilities().keySet()) {
                    if (stat.equals("all")) {
                        for (String statEntry : relic.getAbilityData(abilityEntry).getStats().keySet()) {
                            double value = relic.getStatByQuality(abilityEntry, statEntry, quality);
                            switch (action) {
                                case SET: {
                                    relic.setAbilityValue(stack, abilityEntry, statEntry, value);
                                    break;
                                }
                                case ADD: {
                                    relic.addAbilityValue(stack, abilityEntry, statEntry, value);
                                    break;
                                }
                                case TAKE: {
                                    relic.addAbilityValue(stack, abilityEntry, statEntry, -value);
                                }
                            }
                        }
                        continue;
                    }
                    double value = relic.getStatByQuality(abilityEntry, stat, quality);
                    switch (action) {
                        case SET: {
                            relic.setAbilityValue(stack, abilityEntry, stat, value);
                            break;
                        }
                        case ADD: {
                            relic.addAbilityValue(stack, abilityEntry, stat, value);
                            break;
                        }
                        case TAKE: {
                            relic.addAbilityValue(stack, abilityEntry, stat, -value);
                        }
                    }
                }
            } else if (stat.equals("all")) {
                for (String statEntry : relic.getAbilityData(ability).getStats().keySet()) {
                    double value = relic.getStatByQuality(ability, statEntry, quality);
                    switch (action) {
                        case SET: {
                            relic.setAbilityValue(stack, ability, statEntry, value);
                            break;
                        }
                        case ADD: {
                            relic.addAbilityValue(stack, ability, statEntry, value);
                            break;
                        }
                        case TAKE: {
                            relic.addAbilityValue(stack, ability, statEntry, -value);
                        }
                    }
                }
            } else {
                double value = relic.getStatByQuality(ability, stat, quality);
                switch (action) {
                    case SET: {
                        relic.setAbilityValue(stack, ability, stat, value);
                        break;
                    }
                    case ADD: {
                        relic.addAbilityValue(stack, ability, stat, value);
                        break;
                    }
                    case TAKE: {
                        relic.addAbilityValue(stack, ability, stat, -value);
                    }
                }
            }
            return 1;
        }))))))).then(Commands.m_82127_((String)"randomize").then(Commands.m_82129_((String)"ability", (ArgumentType)RelicAbilityArgument.ability()).then(Commands.m_82129_((String)"stat", (ArgumentType)RelicAbilityStatArgument.abilityStat()).executes(context -> {
            ServerPlayer player = ((CommandSourceStack)context.getSource()).m_81375_();
            ItemStack stack = player.m_21120_(InteractionHand.MAIN_HAND);
            Item patt26646$temp = stack.m_41720_();
            if (!(patt26646$temp instanceof IRelicItem)) {
                ((CommandSourceStack)context.getSource()).m_81352_((Component)Component.m_237115_((String)"command.relics.base.not_relic"));
                return 0;
            }
            IRelicItem relic = (IRelicItem)patt26646$temp;
            String ability = RelicAbilityArgument.getAbility(context, "ability");
            String stat = RelicAbilityStatArgument.getAbilityStat(context, "stat");
            if (ability.equals("all")) {
                for (String abilityEntry : relic.getRelicData().getAbilities().getAbilities().keySet()) {
                    if (stat.equals("all")) {
                        for (String statEntry : relic.getAbilityData(abilityEntry).getStats().keySet()) {
                            relic.randomizeStat(stack, abilityEntry, statEntry);
                        }
                        continue;
                    }
                    relic.randomizeStat(stack, abilityEntry, stat);
                }
            } else if (stat.equals("all")) {
                for (String statEntry : relic.getAbilityData(ability).getStats().keySet()) {
                    relic.randomizeStat(stack, ability, statEntry);
                }
            } else {
                relic.randomizeStat(stack, ability, stat);
            }
            return 1;
        }))))));
    }

    public static enum CommandAction {
        SET,
        ADD,
        TAKE;

    }
}

