/*
 * Decompiled with CFR 0.152.
 */
package com.Polarice3.goety_cataclysm.common.magic.spells.necromancy;

import com.Polarice3.Goety.api.magic.SpellType;
import com.Polarice3.Goety.client.particles.ModParticleTypes;
import com.Polarice3.Goety.common.effects.GoetyEffects;
import com.Polarice3.Goety.common.enchantments.ModEnchantments;
import com.Polarice3.Goety.common.entities.ally.Summoned;
import com.Polarice3.Goety.common.magic.SpellStat;
import com.Polarice3.Goety.common.magic.SummonSpell;
import com.Polarice3.Goety.utils.BlockFinder;
import com.Polarice3.Goety.utils.ColorUtil;
import com.Polarice3.Goety.utils.EffectsUtil;
import com.Polarice3.Goety.utils.MobUtil;
import com.Polarice3.Goety.utils.ServerParticleUtil;
import com.Polarice3.Goety.utils.WandUtil;
import com.Polarice3.goety_cataclysm.common.entities.GCEntityType;
import com.Polarice3.goety_cataclysm.common.entities.ally.undead.draugr.RoyalDraugrServant;
import com.Polarice3.goety_cataclysm.common.items.GoetyItems;
import com.Polarice3.goety_cataclysm.config.GCSpellConfig;
import com.Polarice3.goety_cataclysm.init.GoetySounds;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Predicate;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.core.particles.SimpleParticleType;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.util.Mth;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.phys.Vec3;

public class RoyalDraugrSpell
extends SummonSpell {
    public int defaultSoulCost() {
        return (Integer)GCSpellConfig.RoyalDraugrCost.get();
    }

    public int defaultCastDuration() {
        return (Integer)GCSpellConfig.RoyalDraugrDuration.get();
    }

    public int SummonDownDuration() {
        return (Integer)GCSpellConfig.RoyalDraugrSummonDown.get();
    }

    public SoundEvent CastingSound() {
        return null;
    }

    public int defaultSpellCooldown() {
        return (Integer)GCSpellConfig.RoyalDraugrCoolDown.get();
    }

    public SpellType getSpellType() {
        return SpellType.NECROMANCY;
    }

    public List<Enchantment> acceptedEnchantments() {
        ArrayList<Enchantment> list = new ArrayList<Enchantment>();
        list.add((Enchantment)ModEnchantments.POTENCY.get());
        list.add((Enchantment)ModEnchantments.DURATION.get());
        return list;
    }

    public Predicate<LivingEntity> summonPredicate() {
        return livingEntity -> livingEntity instanceof RoyalDraugrServant;
    }

    public SoundEvent loopSound(LivingEntity caster) {
        return (SoundEvent)GoetySounds.VANGUARD_SPELL.get();
    }

    public int summonLimit() {
        return (Integer)GCSpellConfig.RoyalDraugrLimit.get();
    }

    public void commonResult(ServerLevel worldIn, LivingEntity caster) {
        if (this.isShifting(caster)) {
            for (Entity entity : worldIn.m_8583_()) {
                if (!(entity instanceof RoyalDraugrServant)) continue;
                this.teleportServants(caster, entity);
            }
            for (int i = 0; i < caster.m_9236_().f_46441_.m_188503_(35) + 10; ++i) {
                worldIn.m_8767_((ParticleOptions)ParticleTypes.f_123759_, caster.m_20185_(), caster.m_20188_(), caster.m_20189_(), 1, 0.0, 0.0, 0.0, 0.0);
            }
            worldIn.m_6263_(null, caster.m_20185_(), caster.m_20186_(), caster.m_20189_(), (SoundEvent)GoetySounds.VANGUARD_SUMMON.get(), this.getSoundSource(), 1.0f, 1.0f);
        }
    }

    public void SpellResult(ServerLevel worldIn, LivingEntity caster, ItemStack staff, SpellStat spellStat) {
        this.commonResult(worldIn, caster);
        int potency = spellStat.getPotency();
        int duration = spellStat.getDuration();
        if (WandUtil.enchantedFocus((LivingEntity)caster)) {
            potency += WandUtil.getLevels((Enchantment)((Enchantment)ModEnchantments.POTENCY.get()), (LivingEntity)caster);
            duration += WandUtil.getLevels((Enchantment)((Enchantment)ModEnchantments.DURATION.get()), (LivingEntity)caster) + 1;
        }
        if (!this.isShifting(caster)) {
            if (staff.m_150930_((Item)GoetyItems.NAMELESS_STAFF.get())) {
                Vec3 vec3 = caster.m_20182_();
                Direction direction = caster.m_6350_();
                double stepX = direction.m_122429_();
                double stepZ = direction.m_122431_();
                for (int i1 = -3; i1 <= 3; ++i1) {
                    RoyalDraugrServant summonedentity = new RoyalDraugrServant((EntityType<? extends Summoned>)((EntityType)GCEntityType.ROYAL_DRAUGR_SERVANT.get()), (Level)worldIn);
                    summonedentity.setTrueOwner(caster);
                    Vec3 vec32 = new Vec3(2.0 * stepX + (double)i1 * stepZ + vec3.m_7096_(), vec3.m_7098_(), 2.0 * stepZ + (double)i1 * stepX + vec3.m_7094_());
                    if (!worldIn.m_45756_((Entity)summonedentity, summonedentity.m_20191_().m_82383_(vec32))) {
                        vec32 = Vec3.m_82512_((Vec3i)BlockFinder.SummonRadius((BlockPos)caster.m_20183_(), (Entity)summonedentity, (Level)worldIn));
                    }
                    summonedentity.m_146884_(vec32);
                    MobUtil.moveDownToGround((Entity)summonedentity);
                    summonedentity.m_21530_();
                    summonedentity.setLimitedLife(MobUtil.getSummonLifespan((Level)worldIn) * duration);
                    if (potency > 0) {
                        int boost = Mth.m_14045_((int)(potency - 1), (int)0, (int)10);
                        summonedentity.m_7292_(new MobEffectInstance((MobEffect)GoetyEffects.BUFF.get(), EffectsUtil.infiniteEffect(), boost, false, false));
                    }
                    summonedentity.m_6518_((ServerLevelAccessor)worldIn, worldIn.m_6436_(caster.m_20183_()), MobSpawnType.MOB_SUMMONED, null, null);
                    summonedentity.m_5616_(caster.m_6080_());
                    summonedentity.m_146922_(caster.m_146908_());
                    this.SummonSap(caster, (LivingEntity)summonedentity);
                    this.setTarget(caster, (Mob)summonedentity);
                    if (worldIn.m_7967_((Entity)summonedentity)) {
                        ColorUtil colorUtil = new ColorUtil(11009086);
                        ServerParticleUtil.windShockwaveParticle((ServerLevel)worldIn, (ColorUtil)colorUtil, (float)0.1f, (float)0.1f, (float)0.05f, (int)-1, (Vec3)summonedentity.m_20182_());
                        worldIn.m_8767_((ParticleOptions)((SimpleParticleType)ModParticleTypes.LICH.get()), summonedentity.m_20185_(), summonedentity.m_20186_(), summonedentity.m_20189_(), 1, 0.0, 0.0, 0.0, 0.0);
                        worldIn.m_6263_(null, caster.m_20185_(), caster.m_20186_(), caster.m_20189_(), (SoundEvent)GoetySounds.SOUL_EXPLODE.get(), this.getSoundSource(), 0.25f + worldIn.f_46441_.m_188501_() / 2.0f, 1.0f);
                        worldIn.m_6263_(null, caster.m_20185_(), caster.m_20186_(), caster.m_20189_(), SoundEvents.f_11852_, this.getSoundSource(), 0.25f + worldIn.f_46441_.m_188501_() / 2.0f, 1.0f);
                    }
                    this.summonAdvancement(caster, (LivingEntity)summonedentity);
                }
            } else {
                int i = 1;
                if (this.rightStaff(staff)) {
                    i = 2 + caster.m_9236_().f_46441_.m_188503_(4);
                } else if (this.typeStaff(staff, SpellType.FROST)) {
                    i = 2;
                }
                for (int i1 = 0; i1 < i; ++i1) {
                    RoyalDraugrServant summonedentity = new RoyalDraugrServant((EntityType<? extends Summoned>)((EntityType)GCEntityType.ROYAL_DRAUGR_SERVANT.get()), (Level)worldIn);
                    BlockPos blockPos = BlockFinder.SummonRadius((BlockPos)caster.m_20183_(), (Entity)summonedentity, (Level)worldIn);
                    summonedentity.setTrueOwner(caster);
                    summonedentity.m_20035_(blockPos, 0.0f, 0.0f);
                    MobUtil.moveDownToGround((Entity)summonedentity);
                    summonedentity.setLimitedLife(MobUtil.getSummonLifespan((Level)worldIn) * duration);
                    summonedentity.m_21530_();
                    summonedentity.m_6518_((ServerLevelAccessor)worldIn, caster.m_9236_().m_6436_(caster.m_20183_()), MobSpawnType.MOB_SUMMONED, null, null);
                    if (potency > 0) {
                        int boost = Mth.m_14045_((int)(potency - 1), (int)0, (int)10);
                        summonedentity.m_7292_(new MobEffectInstance((MobEffect)GoetyEffects.BUFF.get(), EffectsUtil.infiniteEffect(), boost, false, false));
                    }
                    this.SummonSap(caster, (LivingEntity)summonedentity);
                    this.setTarget(caster, (Mob)summonedentity);
                    if (worldIn.m_7967_((Entity)summonedentity)) {
                        ColorUtil colorUtil = new ColorUtil(2804175);
                        ServerParticleUtil.windShockwaveParticle((ServerLevel)worldIn, (ColorUtil)colorUtil, (float)0.1f, (float)0.1f, (float)0.05f, (int)-1, (Vec3)summonedentity.m_20182_());
                    }
                    this.summonAdvancement(caster, (LivingEntity)summonedentity);
                }
            }
            this.SummonDown(caster);
            worldIn.m_6263_(null, caster.m_20185_(), caster.m_20186_(), caster.m_20189_(), (SoundEvent)GoetySounds.VANGUARD_SUMMON.get(), this.getSoundSource(), 1.0f, 1.0f);
        }
    }
}

