/*
 * Decompiled with CFR 0.152.
 */
package com.Polarice3.goety_cataclysm.common.magic.spells.abyss;

import com.Polarice3.Goety.api.magic.SpellType;
import com.Polarice3.Goety.common.enchantments.ModEnchantments;
import com.Polarice3.Goety.common.magic.Spell;
import com.Polarice3.Goety.common.magic.SpellStat;
import com.Polarice3.Goety.config.SpellConfig;
import com.Polarice3.Goety.utils.WandUtil;
import com.Polarice3.goety_cataclysm.config.GCSpellConfig;
import com.Polarice3.goety_cataclysm.init.GoetySounds;
import com.github.L_Ender.cataclysm.entity.projectile.Water_Spear_Entity;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.Nullable;

public class WaterSpearSpell
extends Spell {
    public int defaultSoulCost() {
        return (Integer)GCSpellConfig.WaterSpearCost.get();
    }

    public int defaultCastDuration() {
        return (Integer)GCSpellConfig.WaterSpearDuration.get();
    }

    public int defaultSpellCooldown() {
        return (Integer)GCSpellConfig.WaterSpearCoolDown.get();
    }

    public SpellType getSpellType() {
        return SpellType.ABYSS;
    }

    @Nullable
    public SoundEvent CastingSound(LivingEntity caster) {
        return (SoundEvent)GoetySounds.ABYSS_PREPARE_SPELL.get();
    }

    public List<Enchantment> acceptedEnchantments() {
        ArrayList<Enchantment> list = new ArrayList<Enchantment>();
        list.add((Enchantment)ModEnchantments.POTENCY.get());
        list.add((Enchantment)ModEnchantments.VELOCITY.get());
        return list;
    }

    public void SpellResult(ServerLevel worldIn, LivingEntity caster, ItemStack staff, SpellStat spellStat) {
        int potency = spellStat.getPotency();
        float velocity = spellStat.getVelocity();
        if (WandUtil.enchantedFocus((LivingEntity)caster)) {
            potency += WandUtil.getLevels((Enchantment)((Enchantment)ModEnchantments.POTENCY.get()), (LivingEntity)caster);
            velocity += (float)WandUtil.getLevels((Enchantment)((Enchantment)ModEnchantments.VELOCITY.get()), (LivingEntity)caster) / 10.0f;
        }
        Vec3 vector3d = caster.m_20154_();
        float damage = (float)((Double)GCSpellConfig.WaterSpearDamage.get() * (double)((Integer)SpellConfig.SpellDamageMultiplier.get()).intValue());
        float yRot = (float)(Mth.m_14136_((double)vector3d.f_82481_, (double)vector3d.f_82479_) * 57.29577951308232) + 90.0f;
        float xRot = (float)(-(Mth.m_14136_((double)vector3d.f_82480_, (double)Math.sqrt(vector3d.f_82479_ * vector3d.f_82479_ + vector3d.f_82481_ * vector3d.f_82481_)) * 57.29577951308232));
        if (this.rightStaff(staff)) {
            float f = Mth.m_14089_((float)(caster.f_20883_ * ((float)Math.PI / 180)));
            float f1 = Mth.m_14031_((float)(caster.f_20883_ * ((float)Math.PI / 180)));
            float math = -0.5f;
            int spearAmount = 5;
            double offsetangle = Math.toRadians(15.0);
            double d0 = caster.m_20185_() + (double)(f * math);
            double d1 = caster.m_20186_() + (double)(caster.m_20206_() * 0.7f);
            double d2 = caster.m_20189_() + (double)(f1 * math);
            for (int i = 0; i <= spearAmount - 1; ++i) {
                double angle = ((double)i - (double)(spearAmount - 1) / 2.0) * offsetangle;
                double x = vector3d.f_82479_ * Math.cos(angle) + vector3d.f_82481_ * Math.sin(angle);
                double z = -vector3d.f_82479_ * Math.sin(angle) + vector3d.f_82481_ * Math.cos(angle);
                Vec3 vec3 = new Vec3(x, vector3d.f_82480_, z).m_82541_();
                Water_Spear_Entity water = new Water_Spear_Entity(caster, vec3, (Level)worldIn, damage + (float)potency);
                water.accelerationPower = 0.2;
                water.m_146922_(yRot);
                water.m_146926_(xRot);
                water.m_20343_(caster.m_20185_() + vector3d.f_82479_ / 2.0 * (double)math, caster.m_20188_() - 0.2, caster.m_20189_() + vector3d.f_82481_ / 2.0 * (double)math);
                water.accelerationPower += (double)velocity;
                water.setTotalBounces(8 + potency);
                worldIn.m_7967_((Entity)water);
            }
        } else {
            Water_Spear_Entity waterSpear = new Water_Spear_Entity(caster, vector3d, (Level)worldIn, damage + (float)potency);
            waterSpear.m_146922_(yRot);
            waterSpear.m_146926_(xRot);
            waterSpear.m_20343_(caster.m_20185_() + vector3d.f_82479_ / 2.0, caster.m_20188_() - 0.2, caster.m_20189_() + vector3d.f_82481_ / 2.0);
            waterSpear.accelerationPower += (double)velocity;
            waterSpear.setTotalBounces(10 + potency);
            worldIn.m_7967_((Entity)waterSpear);
        }
        this.playSound(worldIn, (Entity)caster, SoundEvents.f_11917_, 1.0f, 1.0f);
    }
}

