/*
 * Decompiled with CFR 0.152.
 */
package com.Polarice3.goety_cataclysm.common.magic.spells.abyss;

import com.Polarice3.Goety.api.magic.SpellType;
import com.Polarice3.Goety.common.enchantments.ModEnchantments;
import com.Polarice3.Goety.common.magic.Spell;
import com.Polarice3.Goety.common.magic.SpellStat;
import com.Polarice3.Goety.utils.BlockFinder;
import com.Polarice3.Goety.utils.WandUtil;
import com.Polarice3.goety_cataclysm.common.entities.projectiles.AbyssMine;
import com.Polarice3.goety_cataclysm.config.GCSpellConfig;
import com.Polarice3.goety_cataclysm.init.CataclysmSounds;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.tags.FluidTags;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.Nullable;

public class AbyssalMinesSpell
extends Spell {
    public SpellStat defaultStats() {
        return super.defaultStats().setRadius(((Double)GCSpellConfig.AbyssalMinesRadius.get()).doubleValue());
    }

    public int defaultSoulCost() {
        return (Integer)GCSpellConfig.AbyssalMinesCost.get();
    }

    public int defaultCastDuration() {
        return (Integer)GCSpellConfig.AbyssalMinesDuration.get();
    }

    @Nullable
    public SoundEvent CastingSound() {
        return (SoundEvent)CataclysmSounds.LEVIATHAN_IDLE.get();
    }

    public int defaultSpellCooldown() {
        return (Integer)GCSpellConfig.AbyssalMinesCoolDown.get();
    }

    public SpellType getSpellType() {
        return SpellType.ABYSS;
    }

    public List<Enchantment> acceptedEnchantments() {
        ArrayList<Enchantment> list = new ArrayList<Enchantment>();
        list.add((Enchantment)ModEnchantments.RANGE.get());
        list.add((Enchantment)ModEnchantments.RADIUS.get());
        return list;
    }

    public void SpellResult(ServerLevel worldIn, LivingEntity caster, ItemStack staff, SpellStat spellStat) {
        int range = spellStat.getRange();
        double radius = spellStat.getRadius();
        if (WandUtil.enchantedFocus((LivingEntity)caster)) {
            range += WandUtil.getLevels((Enchantment)((Enchantment)ModEnchantments.RANGE.get()), (LivingEntity)caster);
            radius += (double)((float)WandUtil.getLevels((Enchantment)((Enchantment)ModEnchantments.RADIUS.get()), (LivingEntity)caster) / 2.0f);
        }
        HitResult hitResult = this.rayTrace((Level)worldIn, caster, range, 3.0);
        Vec3 vec3 = hitResult.m_82450_();
        LivingEntity target = this.getTarget(caster);
        if (target != null) {
            vec3 = target.m_20182_();
        }
        float f = (float)Mth.m_14136_((double)(vec3.f_82481_ - caster.m_20189_()), (double)(vec3.f_82479_ - caster.m_20185_()));
        int amount = this.rightStaff(staff) ? 35 : 17;
        for (int l = 0; l < amount; ++l) {
            double randomNearbyZ;
            double randomNearbyY;
            int j = (int)(2.0f * (float)l);
            double randomNearbyX = vec3.f_82479_ + caster.m_217043_().m_188583_() * 12.0;
            if (!worldIn.m_142433_(BlockPos.m_274561_((double)randomNearbyX, (double)(randomNearbyY = vec3.f_82480_ + caster.m_217043_().m_188583_() * 8.0), (double)(randomNearbyZ = vec3.f_82481_ + caster.m_217043_().m_188583_() * 12.0)), fluidState -> fluidState.m_205070_(FluidTags.f_13131_))) {
                randomNearbyY = BlockFinder.moveDownToGround((Entity)caster) + 1.0;
            }
            this.spawnMines(caster, randomNearbyX, randomNearbyY, randomNearbyZ, f, j, radius);
        }
        worldIn.m_6269_(null, (Entity)caster, (SoundEvent)CataclysmSounds.LEVIATHAN_STUN_ROAR.get(), this.getSoundSource(), 2.0f, 0.8f);
    }

    private void spawnMines(LivingEntity caster, double x, double y, double z, float rotation, int delay, double radius) {
        AbyssMine mine = new AbyssMine(caster.m_9236_(), x, y, z, rotation, delay, caster);
        mine.setRadius((float)radius);
        if (mine.m_9236_().m_45786_((Entity)mine)) {
            caster.m_9236_().m_7967_((Entity)mine);
        }
    }
}

