/*
 * Decompiled with CFR 0.152.
 */
package com.Polarice3.goety_cataclysm.common.magic.spells.abyss;

import com.Polarice3.Goety.api.magic.SpellType;
import com.Polarice3.Goety.common.enchantments.ModEnchantments;
import com.Polarice3.Goety.common.magic.Spell;
import com.Polarice3.Goety.common.magic.SpellStat;
import com.Polarice3.Goety.config.SpellConfig;
import com.Polarice3.Goety.utils.WandUtil;
import com.Polarice3.goety_cataclysm.common.entities.util.AbyssMark;
import com.Polarice3.goety_cataclysm.config.GCSpellConfig;
import com.Polarice3.goety_cataclysm.init.GoetySounds;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;

public class AbyssalBeamSpell
extends Spell {
    public int defaultSoulCost() {
        return (Integer)GCSpellConfig.AbyssalBeamCost.get();
    }

    public int defaultCastDuration() {
        return (Integer)GCSpellConfig.AbyssalBeamDuration.get() + 10;
    }

    public int castDuration(LivingEntity caster, ItemStack staff) {
        return this.defaultCastDuration();
    }

    public SoundEvent CastingSound() {
        return (SoundEvent)GoetySounds.TRIDENT_STORM_PRE.get();
    }

    public int defaultSpellCooldown() {
        return (Integer)GCSpellConfig.AbyssalBeamCoolDown.get();
    }

    public SpellType getSpellType() {
        return SpellType.ABYSS;
    }

    public List<Enchantment> acceptedEnchantments() {
        ArrayList<Enchantment> list = new ArrayList<Enchantment>();
        list.add((Enchantment)ModEnchantments.POTENCY.get());
        list.add((Enchantment)ModEnchantments.RANGE.get());
        return list;
    }

    public void startSpell(ServerLevel worldIn, LivingEntity caster, ItemStack staff, SpellStat spellStat) {
        int potency = spellStat.getPotency();
        int range = spellStat.getRange();
        if (WandUtil.enchantedFocus((LivingEntity)caster)) {
            potency += WandUtil.getLevels((Enchantment)((Enchantment)ModEnchantments.POTENCY.get()), (LivingEntity)caster);
            range += WandUtil.getLevels((Enchantment)((Enchantment)ModEnchantments.RANGE.get()), (LivingEntity)caster);
        }
        HitResult rayTrace = this.rayTrace((Level)worldIn, caster, range, 3.0);
        Vec3 location = rayTrace.m_82450_();
        LivingEntity target = this.getTarget(caster, range);
        if (target != null) {
            location = caster.m_20182_();
        }
        AbyssMark abyssMark = new AbyssMark((Level)worldIn, location, (Integer)GCSpellConfig.AbyssalBeamDuration.get(), ((Double)GCSpellConfig.AbyssalBeamDamage.get()).floatValue() * (float)((Integer)SpellConfig.SpellDamageMultiplier.get()).intValue() + (float)potency, ((Double)GCSpellConfig.AbyssalBeamHPDamage.get()).floatValue(), caster.m_20148_(), target, this.rightStaff(staff), potency);
        worldIn.m_7967_((Entity)abyssMark);
    }
}

