/*
 * Decompiled with CFR 0.152.
 */
package com.Polarice3.goety_cataclysm.common.magic.construct;

import com.Polarice3.Goety.api.magic.IMold;
import com.Polarice3.Goety.common.research.Research;
import com.Polarice3.Goety.common.research.ResearchList;
import com.Polarice3.Goety.utils.SEHelper;
import com.Polarice3.goety_cataclysm.common.entities.GCEntityType;
import com.Polarice3.goety_cataclysm.common.entities.ally.golem.CoralssusServant;
import com.Polarice3.goety_cataclysm.config.GCSpellConfig;
import com.Polarice3.goety_cataclysm.init.GCTags;
import com.google.common.collect.ImmutableList;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.stream.Stream;
import net.minecraft.advancements.CriteriaTriggers;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.tags.BlockTags;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.SeaPickleBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraftforge.common.Tags;

public class CoralssusMold
implements IMold {
    private static final List<BlockPos> BOTTOM_STONE_LOCATIONS = ImmutableList.of((Object)new BlockPos(0, -1, 0), (Object)new BlockPos(0, -1, 1), (Object)new BlockPos(0, -1, -1), (Object)new BlockPos(1, -1, 0), (Object)new BlockPos(-1, -1, 0), (Object)new BlockPos(1, -1, 1), (Object)new BlockPos(1, -1, -1), (Object)new BlockPos(-1, -1, 1), (Object)new BlockPos(-1, -1, -1), (Object)new BlockPos(2, -1, 1), (Object)new BlockPos(2, -1, -1), (Object)new BlockPos(-2, -1, 1), (Object[])new BlockPos[]{new BlockPos(-2, -1, -1), new BlockPos(1, -1, 2), new BlockPos(-1, -1, 2), new BlockPos(1, -1, -2), new BlockPos(-1, -1, -2)});
    private static final List<BlockPos> ABOVE_STONE_LOCATIONS = ImmutableList.of((Object)new BlockPos(1, 0, 3), (Object)new BlockPos(-1, 0, 3), (Object)new BlockPos(1, 0, -3), (Object)new BlockPos(-1, 0, -3), (Object)new BlockPos(3, 0, 1), (Object)new BlockPos(3, 0, -1), (Object)new BlockPos(-3, 0, 1), (Object)new BlockPos(-3, 0, -1));
    private static final List<BlockPos> STONE_LOCATIONS = Stream.of(BOTTOM_STONE_LOCATIONS, ABOVE_STONE_LOCATIONS).flatMap(Collection::stream).toList();
    private static final List<BlockPos> BOTTOM_AMETHYST_LOCATIONS = ImmutableList.of((Object)new BlockPos(2, -1, 0), (Object)new BlockPos(-2, -1, 0), (Object)new BlockPos(0, -1, 2), (Object)new BlockPos(0, -1, -2));
    private static final List<BlockPos> ABOVE_AMETHYST_LOCATIONS = ImmutableList.of((Object)new BlockPos(0, 0, 3), (Object)new BlockPos(0, 0, -3), (Object)new BlockPos(3, 0, 0), (Object)new BlockPos(-3, 0, 0), (Object)new BlockPos(-2, 0, 2), (Object)new BlockPos(2, 0, 2), (Object)new BlockPos(2, 0, -2), (Object)new BlockPos(-2, 0, -2));
    private static final List<BlockPos> AMETHYST_LOCATIONS = Stream.of(BOTTOM_AMETHYST_LOCATIONS, ABOVE_AMETHYST_LOCATIONS).flatMap(Collection::stream).toList();
    private static final List<BlockPos> WATER_LOCATIONS = ImmutableList.of((Object)new BlockPos(3, -1, 1), (Object)new BlockPos(3, -1, 0), (Object)new BlockPos(3, -1, -1), (Object)new BlockPos(-3, -1, 1), (Object)new BlockPos(-3, -1, 0), (Object)new BlockPos(-3, -1, -1), (Object)new BlockPos(1, -1, 3), (Object)new BlockPos(0, -1, 3), (Object)new BlockPos(-1, -1, 3), (Object)new BlockPos(1, -1, -3), (Object)new BlockPos(0, -1, -3), (Object)new BlockPos(-1, -1, -3), (Object[])new BlockPos[]{new BlockPos(-2, -1, 2), new BlockPos(2, -1, 2), new BlockPos(2, -1, -2), new BlockPos(-2, -1, -2), new BlockPos(4, 0, 1), new BlockPos(4, 0, 0), new BlockPos(4, 0, -1), new BlockPos(1, 0, 4), new BlockPos(0, 0, 4), new BlockPos(-1, 0, 4), new BlockPos(-4, 0, 1), new BlockPos(-4, 0, 0), new BlockPos(-4, 0, -1), new BlockPos(1, 0, -4), new BlockPos(0, 0, -4), new BlockPos(-1, 0, -4), new BlockPos(3, 0, 2), new BlockPos(3, 0, -2), new BlockPos(-3, 0, 2), new BlockPos(-3, 0, -2), new BlockPos(2, 0, 3), new BlockPos(2, 0, -3), new BlockPos(-2, 0, 3), new BlockPos(-2, 0, -3)});
    private static final List<BlockPos> CORAL_LOCATIONS = ImmutableList.of((Object)new BlockPos(0, 0, 0), (Object)new BlockPos(1, 0, 0), (Object)new BlockPos(0, 0, 1), (Object)new BlockPos(-1, 0, 0), (Object)new BlockPos(0, 0, -1), (Object)new BlockPos(1, 0, 1), (Object)new BlockPos(-1, 0, 1), (Object)new BlockPos(1, 0, -1), (Object)new BlockPos(-1, 0, -1), (Object)new BlockPos(0, 0, 2), (Object)new BlockPos(1, 0, 2), (Object)new BlockPos(-1, 0, 2), (Object[])new BlockPos[]{new BlockPos(0, 0, -2), new BlockPos(1, 0, -2), new BlockPos(-1, 0, -2), new BlockPos(2, 0, 0), new BlockPos(2, 0, 1), new BlockPos(2, 0, -1), new BlockPos(-2, 0, 0), new BlockPos(-2, 0, 1), new BlockPos(-2, 0, -1)});
    private static final BlockPos PICKLE = new BlockPos(0, 1, 0);

    private static List<BlockPos> checkStones(Level level, BlockPos blockPos) {
        ArrayList<BlockPos> invalid = new ArrayList<BlockPos>();
        for (BlockPos blockPos1 : STONE_LOCATIONS) {
            BlockPos blockPos2 = blockPos.m_121955_((Vec3i)blockPos1);
            BlockState blockState = level.m_8055_(blockPos2);
            if (!blockState.m_204336_(GCTags.Blocks.CORALSSUS_BRICK_MOLD)) {
                invalid.add(blockPos1);
            }
            if (blockState.m_60838_((BlockGetter)level, blockPos2)) continue;
            invalid.add(blockPos1);
        }
        return invalid;
    }

    private static List<BlockPos> checkAmethyst(Level level, BlockPos blockPos) {
        ArrayList<BlockPos> invalid = new ArrayList<BlockPos>();
        for (BlockPos blockPos1 : AMETHYST_LOCATIONS) {
            BlockPos blockPos2 = blockPos.m_121955_((Vec3i)blockPos1);
            if (level.m_8055_(blockPos2).m_204336_(Tags.Blocks.STORAGE_BLOCKS_AMETHYST)) continue;
            invalid.add(blockPos1);
        }
        return invalid;
    }

    private static List<BlockPos> checkWater(Level level, BlockPos blockPos) {
        ArrayList<BlockPos> invalid = new ArrayList<BlockPos>();
        for (BlockPos blockPos1 : WATER_LOCATIONS) {
            BlockPos blockPos2 = blockPos.m_121955_((Vec3i)blockPos1);
            if (level.m_8055_(blockPos2).m_60713_(Blocks.f_49990_)) continue;
            invalid.add(blockPos1);
        }
        return invalid;
    }

    private static boolean hasPickle(Level level, BlockPos blockPos) {
        BlockState blockState = level.m_8055_(blockPos.m_121955_((Vec3i)PICKLE));
        return blockState.m_60713_(Blocks.f_50567_) && blockState.m_61138_((Property)SeaPickleBlock.f_56074_) && (Integer)blockState.m_61143_((Property)SeaPickleBlock.f_56074_) > 1;
    }

    private static List<BlockPos> checkFireCorals(Level level, BlockPos blockPos) {
        ArrayList<BlockPos> invalid = new ArrayList<BlockPos>();
        for (BlockPos blockPos1 : CORAL_LOCATIONS) {
            BlockPos blockPos2 = blockPos.m_121955_((Vec3i)blockPos1);
            BlockState blockState = level.m_8055_(blockPos2);
            if (blockState.m_60713_(Blocks.f_50587_)) continue;
            invalid.add(blockPos1);
        }
        return invalid;
    }

    private static List<BlockPos> checkHornCorals(Level level, BlockPos blockPos) {
        ArrayList<BlockPos> invalid = new ArrayList<BlockPos>();
        for (BlockPos blockPos1 : CORAL_LOCATIONS) {
            BlockPos blockPos2 = blockPos.m_121955_((Vec3i)blockPos1);
            BlockState blockState = level.m_8055_(blockPos2);
            if (blockState.m_60713_(Blocks.f_50588_)) continue;
            invalid.add(blockPos1);
        }
        return invalid;
    }

    private static List<BlockPos> checkTubeCorals(Level level, BlockPos blockPos) {
        ArrayList<BlockPos> invalid = new ArrayList<BlockPos>();
        for (BlockPos blockPos1 : CORAL_LOCATIONS) {
            BlockPos blockPos2 = blockPos.m_121955_((Vec3i)blockPos1);
            BlockState blockState = level.m_8055_(blockPos2);
            if (blockState.m_60713_(Blocks.f_50584_)) continue;
            invalid.add(blockPos1);
        }
        return invalid;
    }

    public static boolean checkCoralBlock(Level level, BlockPos blockPos, Block coral) {
        if (coral == Blocks.f_50587_) {
            return CoralssusMold.checkFireCorals(level, blockPos).isEmpty();
        }
        if (coral == Blocks.f_50588_) {
            return CoralssusMold.checkHornCorals(level, blockPos).isEmpty();
        }
        if (coral == Blocks.f_50584_) {
            return CoralssusMold.checkTubeCorals(level, blockPos).isEmpty();
        }
        return false;
    }

    public static boolean checkBlocks(Level level, BlockPos blockPos, Block coral) {
        return CoralssusMold.checkStones(level, blockPos).isEmpty() && CoralssusMold.checkAmethyst(level, blockPos).isEmpty() && CoralssusMold.checkCoralBlock(level, blockPos, coral) && CoralssusMold.hasPickle(level, blockPos) && CoralssusMold.checkWater(level, blockPos).isEmpty();
    }

    public static boolean conditionsMet(Level worldIn, LivingEntity entityLiving) {
        int count = 0;
        if (worldIn instanceof ServerLevel) {
            ServerLevel serverLevel = (ServerLevel)worldIn;
            for (Entity entity : serverLevel.m_8583_()) {
                CoralssusServant servant;
                if (!(entity instanceof CoralssusServant) || (servant = (CoralssusServant)entity).getTrueOwner() != entityLiving || !servant.m_6084_()) continue;
                ++count;
            }
        }
        return count < (Integer)GCSpellConfig.CoralssusLimit.get();
    }

    public boolean spawnServant(Player player, ItemStack stack, Level level, BlockPos blockPos) {
        if (!level.f_46443_ && level.m_8055_(blockPos).m_204336_(BlockTags.f_13051_)) {
            Block block = level.m_8055_(blockPos).m_60734_();
            if (CoralssusMold.checkBlocks(level, blockPos, level.m_8055_(blockPos).m_60734_())) {
                if (SEHelper.hasResearch((Player)player, (Research)ResearchList.FLORAL)) {
                    if (CoralssusMold.conditionsMet(level, (LivingEntity)player)) {
                        CoralssusServant coralssusServant = (CoralssusServant)((EntityType)GCEntityType.CORALSSUS.get()).m_20615_(level);
                        if (coralssusServant != null) {
                            coralssusServant.setTrueOwner((LivingEntity)player);
                            coralssusServant.m_6518_((ServerLevelAccessor)level, level.m_6436_(coralssusServant.m_20183_()), MobSpawnType.MOB_SUMMONED, null, null);
                            coralssusServant.m_7678_((double)blockPos.m_123341_() + 0.5, (double)blockPos.m_123342_() + 0.05, (double)blockPos.m_123343_() + 0.5, 0.0f, 0.0f);
                            if (block == Blocks.f_50587_) {
                                coralssusServant.setVariant(CoralssusServant.Variant.FIRE);
                            } else if (block == Blocks.f_50588_) {
                                coralssusServant.setVariant(CoralssusServant.Variant.HORN);
                            } else if (block == Blocks.f_50584_) {
                                coralssusServant.setVariant(CoralssusServant.Variant.TUBE);
                            }
                            if (level.m_7967_((Entity)coralssusServant)) {
                                CoralssusMold.removeBlocks(level, blockPos);
                                stack.m_41774_(1);
                                if (player instanceof ServerPlayer) {
                                    ServerPlayer serverPlayer = (ServerPlayer)player;
                                    CriteriaTriggers.f_10580_.m_68256_(serverPlayer, (Entity)coralssusServant);
                                }
                                return true;
                            }
                        }
                    } else {
                        player.m_5661_((Component)Component.m_237115_((String)"info.goety.summon.limit"), true);
                    }
                } else {
                    player.m_5661_((Component)Component.m_237115_((String)"info.goety.research.fail"), true);
                }
            } else {
                player.m_5661_((Component)Component.m_237115_((String)"info.goety.block.fail"), true);
            }
        }
        return false;
    }

    public static void removeBlocks(Level level, BlockPos blockPos) {
        if (!level.f_46443_) {
            for (int i = -4; i < 4; ++i) {
                for (int j = -4; j < 4; ++j) {
                    for (int k = -4; k < 4; ++k) {
                        BlockPos blockPos2 = blockPos.m_7918_(i, j, k);
                        if (!level.m_8055_(blockPos2).m_60713_(Blocks.f_49990_)) continue;
                        level.m_46796_(2001, blockPos2, Block.m_49956_((BlockState)level.m_8055_(blockPos2)));
                        level.m_46597_(blockPos2, Blocks.f_50016_.m_49966_());
                    }
                }
            }
            for (BlockPos blockPos1 : CORAL_LOCATIONS) {
                BlockPos blockPos2 = blockPos.m_121955_((Vec3i)blockPos1);
                BlockState blockState = level.m_8055_(blockPos2);
                if (!blockState.m_60713_(Blocks.f_50587_) && !blockState.m_60713_(Blocks.f_50588_) && !blockState.m_60713_(Blocks.f_50584_)) continue;
                level.m_46796_(2001, blockPos2, Block.m_49956_((BlockState)level.m_8055_(blockPos2)));
                level.m_46597_(blockPos2, Blocks.f_50016_.m_49966_());
            }
            if (level.m_8055_(blockPos.m_121955_((Vec3i)PICKLE)).m_60713_(Blocks.f_50567_)) {
                level.m_46796_(2001, blockPos.m_121955_((Vec3i)PICKLE), Block.m_49956_((BlockState)level.m_8055_(blockPos.m_121955_((Vec3i)PICKLE))));
                level.m_46597_(blockPos.m_121955_((Vec3i)PICKLE), Blocks.f_50016_.m_49966_());
            }
        }
    }
}

