/*
 * Decompiled with CFR 0.152.
 */
package com.Polarice3.goety_cataclysm.common.entities.util;

import com.Polarice3.Goety.config.SpellConfig;
import com.Polarice3.Goety.utils.MobUtil;
import com.Polarice3.goety_cataclysm.common.entities.GCEntityType;
import com.Polarice3.goety_cataclysm.common.entities.util.AbyssBlastPortal;
import com.Polarice3.goety_cataclysm.config.GCSpellConfig;
import com.github.L_Ender.cataclysm.init.ModEntities;
import java.util.Optional;
import java.util.UUID;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientGamePacketListener;
import net.minecraft.network.protocol.game.ClientboundAddEntityPacket;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.Vec3;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.minecraftforge.entity.PartEntity;

public class AbyssMark
extends Entity {
    private static final EntityDataAccessor<Optional<UUID>> CREATOR_ID = SynchedEntityData.m_135353_(AbyssMark.class, (EntityDataSerializer)EntityDataSerializers.f_135041_);
    protected static final EntityDataAccessor<Integer> LIFESPAN = SynchedEntityData.m_135353_(AbyssMark.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    private static final EntityDataAccessor<Float> DAMAGE = SynchedEntityData.m_135353_(AbyssMark.class, (EntityDataSerializer)EntityDataSerializers.f_135029_);
    private static final EntityDataAccessor<Float> HP_DAMAGE = SynchedEntityData.m_135353_(AbyssMark.class, (EntityDataSerializer)EntityDataSerializers.f_135029_);
    private static final EntityDataAccessor<Boolean> STAFF = SynchedEntityData.m_135353_(AbyssMark.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    private int potency;
    @Nullable
    private Entity finalTarget;
    @Nullable
    private UUID targetId;

    public AbyssMark(EntityType<?> entityTypeIn, Level worldIn) {
        super(entityTypeIn, worldIn);
    }

    public AbyssMark(Level worldIn, double x, double y, double z, int lifespan, float damage, float hpdamage, UUID casterIn, @Nullable LivingEntity finalTarget) {
        this((EntityType)GCEntityType.ABYSS_MARK.get(), worldIn);
        this.setCreatorEntityUUID(casterIn);
        this.setLifespan(lifespan);
        this.setDamage(damage);
        this.setHpDamage(hpdamage);
        this.finalTarget = finalTarget;
        this.m_6034_(x, y, z);
    }

    public AbyssMark(Level worldIn, Vec3 vec3, int lifespan, float damage, float hpdamage, UUID casterIn, @Nullable LivingEntity finalTarget, boolean staff, int potency) {
        this((EntityType)GCEntityType.ABYSS_MARK.get(), worldIn);
        this.setCreatorEntityUUID(casterIn);
        this.setLifespan(lifespan);
        this.setDamage(damage);
        this.setHpDamage(hpdamage);
        this.finalTarget = finalTarget;
        this.m_6034_(vec3.f_82479_, vec3.f_82480_, vec3.f_82481_);
        this.setStaff(staff);
        this.potency = potency;
    }

    protected Component m_5677_() {
        return ((EntityType)ModEntities.ABYSS_MARK.get()).m_20676_();
    }

    protected void m_7378_(CompoundTag compound) {
        this.setLifespan(compound.m_128451_("Lifespan"));
        if (compound.m_128403_("Owner")) {
            this.setCreatorEntityUUID(compound.m_128342_("Owner"));
        }
        if (compound.m_128403_("Target")) {
            this.targetId = compound.m_128342_("Target");
        }
        if (compound.m_128441_("Potency")) {
            this.potency = compound.m_128451_("Potency");
        }
        if (compound.m_128441_("Damage")) {
            this.setDamage(compound.m_128457_("Damage"));
        }
        if (compound.m_128441_("HpDamage")) {
            this.setHpDamage(compound.m_128457_("HpDamage"));
        }
        if (compound.m_128441_("Staff")) {
            this.setStaff(compound.m_128471_("Staff"));
        }
    }

    protected void m_7380_(CompoundTag compound) {
        compound.m_128405_("Lifespan", this.getLifespan());
        if (this.getCreatorEntityUUID() != null) {
            compound.m_128362_("Owner", this.getCreatorEntityUUID());
        }
        if (this.finalTarget != null) {
            compound.m_128362_("Target", this.finalTarget.m_20148_());
        }
        compound.m_128405_("Potency", this.potency);
        compound.m_128350_("Damage", this.getDamage());
        compound.m_128350_("HpDamage", this.getHpDamage());
        compound.m_128379_("Staff", this.isStaff());
    }

    protected void m_8097_() {
        this.f_19804_.m_135372_(CREATOR_ID, Optional.empty());
        this.f_19804_.m_135372_(LIFESPAN, (Object)300);
        this.f_19804_.m_135372_(DAMAGE, (Object)Float.valueOf(0.0f));
        this.f_19804_.m_135372_(HP_DAMAGE, (Object)Float.valueOf(0.0f));
        this.f_19804_.m_135372_(STAFF, (Object)false);
    }

    public float getDamage() {
        return ((Float)this.f_19804_.m_135370_(DAMAGE)).floatValue();
    }

    public void setDamage(float damage) {
        this.f_19804_.m_135381_(DAMAGE, (Object)Float.valueOf(damage));
    }

    public float getHpDamage() {
        return ((Float)this.f_19804_.m_135370_(HP_DAMAGE)).floatValue();
    }

    public void setHpDamage(float damage) {
        this.f_19804_.m_135381_(HP_DAMAGE, (Object)Float.valueOf(damage));
    }

    public boolean isStaff() {
        return (Boolean)this.f_19804_.m_135370_(STAFF);
    }

    public void setStaff(boolean staff) {
        this.f_19804_.m_135381_(STAFF, (Object)staff);
    }

    public void m_8119_() {
        Object player;
        super.m_8119_();
        this.updateMotion();
        Entity owner = this.getCreatorEntity();
        if (owner != null && !owner.m_6084_()) {
            this.m_146870_();
        }
        if (owner instanceof Player && !MobUtil.isSpellCasting((LivingEntity)(player = (Player)owner))) {
            this.m_146870_();
        }
        this.setLifespan(this.getLifespan() - 1);
        if (!(this.m_9236_().f_46443_ || this.finalTarget != null && this.finalTarget.m_6084_())) {
            if (this.targetId != null) {
                this.finalTarget = ((ServerLevel)this.m_9236_()).m_8791_(this.targetId);
                if (this.finalTarget == null) {
                    this.targetId = null;
                }
            } else {
                for (Entity entity1 : this.m_9236_().m_45976_(Entity.class, this.m_20191_().m_82400_(16.0))) {
                    PartEntity partEntity;
                    Entity entity;
                    LivingEntity livingEntity = null;
                    if (entity1 instanceof PartEntity && (entity = (partEntity = (PartEntity)entity1).getParent()) instanceof LivingEntity) {
                        LivingEntity living;
                        livingEntity = living = (LivingEntity)entity;
                    } else if (entity1 instanceof LivingEntity) {
                        LivingEntity living;
                        livingEntity = living = (LivingEntity)entity1;
                    }
                    if (livingEntity == null || !MobUtil.ownedPredicate((Entity)this).test(livingEntity)) continue;
                    this.finalTarget = livingEntity;
                    this.targetId = livingEntity.m_20148_();
                }
            }
        }
        if (this.getLifespan() <= 0) {
            if (owner instanceof LivingEntity) {
                LivingEntity livingEntity = (LivingEntity)owner;
                this.m_9236_().m_7967_((Entity)new AbyssBlastPortal(this.m_9236_(), this.m_20185_(), this.m_20186_(), this.m_20189_(), this.m_146908_(), 0, this.getDamage(), this.getHpDamage(), livingEntity));
                if (this.isStaff()) {
                    Vec3 rayTrace = this.m_20252_(1.0f);
                    double d0 = Math.min(rayTrace.f_82480_, this.m_20186_()) - 50.0;
                    double d1 = Math.max(rayTrace.f_82480_, this.m_20186_()) + 3.0;
                    float f = (float)Mth.m_14136_((double)(rayTrace.f_82481_ - this.m_20189_()), (double)(rayTrace.f_82479_ - this.m_20185_()));
                    if (this.finalTarget != null) {
                        d0 = Math.min(this.finalTarget.m_20186_(), this.m_20186_()) - 50.0;
                        d1 = Math.max(this.finalTarget.m_20186_(), this.m_20186_()) + 3.0;
                        f = (float)Mth.m_14136_((double)(this.finalTarget.m_20189_() - this.m_20189_()), (double)(this.finalTarget.m_20185_() - this.m_20185_()));
                    }
                    for (int l = 0; l < 9; ++l) {
                        int j = (int)(5.0f * (float)l);
                        double randomNearbyX = rayTrace.f_82479_ + this.f_19796_.m_188583_() * 12.0;
                        double randomNearbyZ = rayTrace.f_82481_ + this.f_19796_.m_188583_() * 12.0;
                        if (this.finalTarget != null) {
                            randomNearbyX = this.finalTarget.m_20185_() + this.f_19796_.m_188583_() * 12.0;
                            randomNearbyZ = this.finalTarget.m_20189_() + this.f_19796_.m_188583_() * 12.0;
                        }
                        this.spawnUnderPortal(livingEntity, randomNearbyX, randomNearbyZ, d0, d1, f, j, this.potency);
                    }
                }
            }
            this.m_146870_();
        }
    }

    private void spawnUnderPortal(LivingEntity caster, double x, double z, double minY, double maxY, float rotation, int delay, int potency) {
        BlockPos blockpos = BlockPos.m_274561_((double)x, (double)maxY, (double)z);
        boolean flag = false;
        double d0 = 0.0;
        do {
            BlockState blockstate1;
            VoxelShape voxelshape;
            BlockPos blockpos1 = blockpos.m_7495_();
            BlockState blockstate = caster.m_9236_().m_8055_(blockpos1);
            if (!blockstate.m_60783_((BlockGetter)caster.m_9236_(), blockpos1, Direction.UP)) continue;
            if (!caster.m_9236_().m_46859_(blockpos) && !(voxelshape = (blockstate1 = caster.m_9236_().m_8055_(blockpos)).m_60812_((BlockGetter)caster.m_9236_(), blockpos)).m_83281_()) {
                d0 = voxelshape.m_83297_(Direction.Axis.Y);
            }
            flag = true;
            break;
        } while ((blockpos = blockpos.m_7495_()).m_123342_() >= Mth.m_14107_((double)minY) - 1);
        if (flag) {
            caster.m_9236_().m_7967_((Entity)new AbyssBlastPortal(caster.m_9236_(), x, (double)blockpos.m_123342_() + d0, z, rotation, delay, ((Double)GCSpellConfig.AbyssalBeamDamage.get()).floatValue() * (float)((Integer)SpellConfig.SpellDamageMultiplier.get()).intValue() + (float)potency, ((Double)GCSpellConfig.AbyssalBeamHPDamage.get()).floatValue(), caster));
        }
    }

    public int getLifespan() {
        return (Integer)this.f_19804_.m_135370_(LIFESPAN);
    }

    public void setLifespan(int i) {
        this.f_19804_.m_135381_(LIFESPAN, (Object)i);
    }

    public UUID getCreatorEntityUUID() {
        return ((Optional)this.f_19804_.m_135370_(CREATOR_ID)).orElse(null);
    }

    public void setCreatorEntityUUID(UUID id) {
        this.f_19804_.m_135381_(CREATOR_ID, Optional.ofNullable(id));
    }

    public Entity getCreatorEntity() {
        UUID uuid = this.getCreatorEntityUUID();
        return uuid != null && !this.m_9236_().f_46443_ ? ((ServerLevel)this.m_9236_()).m_8791_(uuid) : null;
    }

    private void updateMotion() {
        Vec3 vec3 = this.m_20184_();
        double h0 = this.m_20185_() + vec3.f_82479_;
        double h1 = this.m_20186_() + vec3.f_82480_;
        double h2 = this.m_20189_() + vec3.f_82481_;
        if (this.finalTarget != null && this.finalTarget.m_6084_() || this.finalTarget instanceof Player && !this.finalTarget.m_5833_()) {
            double dx = this.finalTarget.m_20185_() - this.m_20185_();
            double dz = this.finalTarget.m_20189_() - this.m_20189_();
            double p0 = Math.min(this.finalTarget.m_20186_(), this.m_20186_() - 50.0);
            double p1 = Math.max(this.finalTarget.m_20186_(), this.m_20186_());
            BlockPos blockpos = BlockPos.m_274561_((double)this.finalTarget.m_20185_(), (double)p1, (double)this.finalTarget.m_20189_());
            double d0 = 0.0;
            do {
                BlockState blockstate1;
                VoxelShape voxelshape;
                BlockPos blockpos1 = blockpos.m_7495_();
                BlockState blockstate = this.m_9236_().m_8055_(blockpos1);
                if (!blockstate.m_60783_((BlockGetter)this.m_9236_(), blockpos1, Direction.UP)) continue;
                if (this.m_9236_().m_46859_(blockpos) || (voxelshape = (blockstate1 = this.m_9236_().m_8055_(blockpos)).m_60812_((BlockGetter)this.m_9236_(), blockpos)).m_83281_()) break;
                d0 = voxelshape.m_83297_(Direction.Axis.Y);
                break;
            } while ((blockpos = blockpos.m_7495_()).m_123342_() >= Mth.m_14107_((double)p0) - 1);
            this.m_6034_(h0, (double)blockpos.m_123342_() + d0, h2);
            this.m_20256_(vec3.m_82520_(dx, 0.0, dz).m_82490_(0.05));
        }
    }

    public Packet<ClientGamePacketListener> m_5654_() {
        return new ClientboundAddEntityPacket((Entity)this);
    }
}

