/*
 * Decompiled with CFR 0.152.
 */
package com.Polarice3.goety_cataclysm.common.entities.projectiles;

import com.Polarice3.Goety.utils.CuriosFinder;
import com.Polarice3.Goety.utils.ExplosionUtil;
import com.Polarice3.Goety.utils.LootingExplosion;
import com.Polarice3.Goety.utils.MobUtil;
import com.Polarice3.goety_cataclysm.common.entities.GCEntityType;
import com.github.L_Ender.cataclysm.client.particle.StormParticle;
import com.github.L_Ender.cataclysm.init.ModEntities;
import javax.annotation.Nullable;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientGamePacketListener;
import net.minecraft.network.protocol.game.ClientboundAddEntityPacket;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntitySelector;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.level.Explosion;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;

public class VoidVortex
extends Entity {
    protected static final EntityDataAccessor<Integer> LIFESPAN = SynchedEntityData.m_135353_(VoidVortex.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    private static final EntityDataAccessor<Integer> CASTER = SynchedEntityData.m_135353_(VoidVortex.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    private static final EntityDataAccessor<Float> RADIUS = SynchedEntityData.m_135353_(VoidVortex.class, (EntityDataSerializer)EntityDataSerializers.f_135029_);
    private boolean madeOpenNoise = false;
    private boolean madeCloseNoise = false;
    @Nullable
    private LivingEntity owner;

    public VoidVortex(EntityType<?> entityTypeIn, Level worldIn) {
        super(entityTypeIn, worldIn);
    }

    public VoidVortex(Level worldIn, double x, double y, double z, float p_i47276_8_, LivingEntity casterIn, int span) {
        this((EntityType)GCEntityType.VOID_VORTEX.get(), worldIn);
        this.setLifespan(span);
        this.setOwner(casterIn);
        this.m_146922_(p_i47276_8_ * 57.295776f);
        this.m_6034_(x, y, z);
        if (!worldIn.f_46443_) {
            this.setCasterID(casterIn.m_19879_());
        }
    }

    protected Component m_5677_() {
        return ((EntityType)ModEntities.VOID_VORTEX.get()).m_20676_();
    }

    public Packet<ClientGamePacketListener> m_5654_() {
        return new ClientboundAddEntityPacket((Entity)this);
    }

    public void m_8119_() {
        super.m_8119_();
        if (this.f_19797_ == 1) {
            Entity entity;
            if (this.getLifespan() == 0) {
                this.setLifespan(60);
            }
            if (this.m_9236_().f_46443_ && (entity = this.m_9236_().m_6815_(this.getCasterID())) instanceof LivingEntity) {
                LivingEntity livingEntity;
                this.owner = livingEntity = (LivingEntity)entity;
            }
        }
        if (!this.madeOpenNoise) {
            this.m_146850_(GameEvent.f_157810_);
            this.m_5496_(SoundEvents.f_11860_, 1.0f, 1.0f + this.f_19796_.m_188501_() * 0.2f);
            this.madeOpenNoise = true;
        }
        if (Math.min(this.f_19797_, this.getLifespan()) >= 16) {
            if (this.m_9236_().f_46443_) {
                float r = 0.4f;
                float g = 0.1f;
                float b = 0.8f;
                this.m_9236_().m_7106_((ParticleOptions)new StormParticle.OrbData(r, g, b, 2.5f + this.f_19796_.m_188501_() * 0.9f, 5.0f + this.f_19796_.m_188501_() * 0.9f, this.m_19879_()), this.m_20185_(), this.m_20186_(), this.m_20189_(), 0.0, 0.0, 0.0);
                this.m_9236_().m_7106_((ParticleOptions)new StormParticle.OrbData(r, g, b, 2.25f + this.f_19796_.m_188501_() * 0.6f, 4.25f + this.f_19796_.m_188501_() * 0.6f, this.m_19879_()), this.m_20185_(), this.m_20186_(), this.m_20189_(), 0.0, 0.0, 0.0);
                this.m_9236_().m_7106_((ParticleOptions)new StormParticle.OrbData(r, g, b, 2.0f + this.f_19796_.m_188501_() * 0.45f, 3.5f + this.f_19796_.m_188501_() * 0.45f, this.m_19879_()), this.m_20185_(), this.m_20186_(), this.m_20189_(), 0.0, 0.0, 0.0);
                this.m_9236_().m_7106_((ParticleOptions)new StormParticle.OrbData(r, g, b, 1.5f + this.f_19796_.m_188501_() * 0.25f, 2.75f + this.f_19796_.m_188501_() * 0.45f, this.m_19879_()), this.m_20185_(), this.m_20186_(), this.m_20189_(), 0.0, 0.0, 0.0);
                this.m_9236_().m_7106_((ParticleOptions)new StormParticle.OrbData(r, g, b, 1.25f + this.f_19796_.m_188501_() * 0.25f, 2.0f + this.f_19796_.m_188501_() * 0.45f, this.m_19879_()), this.m_20185_(), this.m_20186_(), this.m_20189_(), 0.0, 0.0, 0.0);
                this.m_9236_().m_7106_((ParticleOptions)new StormParticle.OrbData(r, g, b, 1.0f + this.f_19796_.m_188501_() * 0.25f, 1.25f + this.f_19796_.m_188501_() * 0.45f, this.m_19879_()), this.m_20185_(), this.m_20186_(), this.m_20189_(), 0.0, 0.0, 0.0);
                this.m_9236_().m_7106_((ParticleOptions)new StormParticle.OrbData(r, g, b, 0.75f + this.f_19796_.m_188501_() * 0.25f, 0.5f + this.f_19796_.m_188501_() * 0.45f, this.m_19879_()), this.m_20185_(), this.m_20186_(), this.m_20189_(), 0.0, 0.0, 0.0);
            }
            float radius = 3.0f;
            AABB screamBox = new AABB(this.m_20185_() - (double)radius, this.m_20186_(), this.m_20189_() - (double)radius, this.m_20185_() + (double)radius, this.m_20186_() + (double)(radius * 5.0f), this.m_20189_() + (double)radius);
            for (LivingEntity entity : this.m_9236_().m_45976_(LivingEntity.class, screamBox)) {
                if (this.getOwner() == null || entity == this.getOwner() || MobUtil.areAllies((Entity)this.owner, (Entity)entity) || !EntitySelector.f_20406_.test(entity)) continue;
                Vec3 diff = entity.m_20182_().m_82546_(this.m_20182_().m_82520_(0.0, 0.0, 0.0));
                diff = diff.m_82541_().m_82490_(0.075);
                entity.m_20256_(entity.m_20184_().m_82520_(0.0, -2.0, 0.0).m_82546_(diff));
            }
        }
        this.setLifespan(this.getLifespan() - 1);
        if (this.getLifespan() <= 16 && !this.madeCloseNoise) {
            this.m_146850_(GameEvent.f_157810_);
            this.madeCloseNoise = true;
        }
        if (this.getLifespan() <= 0) {
            LootingExplosion.Mode lootMode = CuriosFinder.hasWanting((Entity)this.getOwner()) ? LootingExplosion.Mode.LOOT : LootingExplosion.Mode.REGULAR;
            ExplosionUtil.lootExplode((Level)this.m_9236_(), (Entity)this.getOwner(), (double)this.m_20185_(), (double)this.m_20186_(), (double)this.m_20189_(), (float)this.getRadius(), (boolean)false, (Explosion.BlockInteraction)Explosion.BlockInteraction.KEEP, (LootingExplosion.Mode)lootMode);
            this.m_146870_();
        }
    }

    public int getLifespan() {
        return (Integer)this.f_19804_.m_135370_(LIFESPAN);
    }

    public void setLifespan(int i) {
        this.f_19804_.m_135381_(LIFESPAN, (Object)i);
    }

    public int getCasterID() {
        return (Integer)this.f_19804_.m_135370_(CASTER);
    }

    public void setCasterID(int id) {
        this.f_19804_.m_135381_(CASTER, (Object)id);
    }

    public float getRadius() {
        return ((Float)this.f_19804_.m_135370_(RADIUS)).floatValue();
    }

    public void setRadius(float damage) {
        this.f_19804_.m_135381_(RADIUS, (Object)Float.valueOf(damage));
    }

    public void setOwner(@Nullable LivingEntity p_19719_) {
        this.owner = p_19719_;
        this.setCasterID(p_19719_ == null ? 0 : p_19719_.m_19879_());
    }

    @Nullable
    public LivingEntity getOwner() {
        ServerLevel serverLevel;
        Entity entity;
        Level level;
        if (this.owner == null && this.getCasterID() != 0 && (level = this.m_9236_()) instanceof ServerLevel && (entity = (serverLevel = (ServerLevel)level).m_6815_(this.getCasterID())) instanceof LivingEntity) {
            this.owner = (LivingEntity)entity;
        }
        return this.owner;
    }

    protected void m_8097_() {
        this.f_19804_.m_135372_(LIFESPAN, (Object)300);
        this.f_19804_.m_135372_(CASTER, (Object)-1);
        this.f_19804_.m_135372_(RADIUS, (Object)Float.valueOf(2.0f));
    }

    protected void m_7378_(CompoundTag compound) {
        this.setLifespan(compound.m_128451_("Lifespan"));
        this.setCasterID(compound.m_128451_("CasterId"));
        this.setRadius(compound.m_128457_("Radius"));
    }

    protected void m_7380_(CompoundTag compound) {
        compound.m_128405_("Lifespan", this.getLifespan());
        compound.m_128405_("CasterId", this.getCasterID());
        compound.m_128350_("Radius", this.getRadius());
    }
}

