/*
 * Decompiled with CFR 0.152.
 */
package com.Polarice3.goety_cataclysm.common.entities.projectiles;

import com.Polarice3.Goety.utils.MobUtil;
import com.Polarice3.goety_cataclysm.common.entities.GCEntityType;
import com.github.L_Ender.cataclysm.client.particle.CircleLightningParticle;
import com.github.L_Ender.cataclysm.client.particle.Not_Spin_TrailParticle;
import com.github.L_Ender.cataclysm.entity.effect.ScreenShake_Entity;
import com.github.L_Ender.cataclysm.init.ModEffect;
import com.github.L_Ender.cataclysm.init.ModEntities;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.Objects;
import java.util.UUID;
import javax.annotation.Nullable;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientGamePacketListener;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.Mth;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.AnimationState;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.entity.PartEntity;
import net.minecraftforge.network.NetworkHooks;

public class StormSerpent
extends Entity {
    public int warmupDelayTicks;
    private boolean sentSpikeEvent;
    public int lifeTicks;
    private boolean clientSideAttackStarted;
    private LivingEntity caster;
    private UUID casterUuid;
    @Nullable
    public Entity finalTarget;
    @Nullable
    public UUID targetId;
    private static final EntityDataAccessor<Integer> STATE = SynchedEntityData.m_135353_(StormSerpent.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    private static final EntityDataAccessor<Float> DAMAGE = SynchedEntityData.m_135353_(StormSerpent.class, (EntityDataSerializer)EntityDataSerializers.f_135029_);
    private static final EntityDataAccessor<Boolean> RIGHT = SynchedEntityData.m_135353_(StormSerpent.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    public AnimationState SpawnAnimationState = new AnimationState();
    public AnimationState Spawn2AnimationState = new AnimationState();

    public StormSerpent(EntityType<? extends StormSerpent> p_i50170_1_, Level p_i50170_2_) {
        super(p_i50170_1_, p_i50170_2_);
    }

    public StormSerpent(Level worldIn, double x, double y, double z, float p_i47276_8_, int p_i47276_9_, LivingEntity casterIn, float damage, @Nullable LivingEntity finalTarget, boolean right) {
        this((EntityType<? extends StormSerpent>)((EntityType)GCEntityType.STORM_SERPENT.get()), worldIn);
        this.warmupDelayTicks = p_i47276_9_;
        this.setCaster(casterIn);
        this.finalTarget = finalTarget;
        this.m_146922_(p_i47276_8_ * 57.295776f);
        this.setDamage(damage);
        this.m_6034_(x, y, z);
        this.setRight(right);
    }

    protected Component m_5677_() {
        return ((EntityType)ModEntities.STORM_SERPENT.get()).m_20676_();
    }

    protected void m_8097_() {
        this.f_19804_.m_135372_(STATE, (Object)0);
        this.f_19804_.m_135372_(DAMAGE, (Object)Float.valueOf(0.0f));
        this.f_19804_.m_135372_(RIGHT, (Object)false);
    }

    public AnimationState getAnimationState(String input) {
        if (Objects.equals(input, "spawn")) {
            return this.SpawnAnimationState;
        }
        if (Objects.equals(input, "spawn2")) {
            return this.Spawn2AnimationState;
        }
        return new AnimationState();
    }

    public void m_7350_(EntityDataAccessor<?> p_21104_) {
        if (STATE.equals(p_21104_) && this.m_9236_().f_46443_) {
            switch (this.getState()) {
                case 0: {
                    this.stopAllAnimationStates();
                    break;
                }
                case 1: {
                    this.stopAllAnimationStates();
                    this.SpawnAnimationState.m_216982_(this.f_19797_);
                    break;
                }
                case 2: {
                    this.stopAllAnimationStates();
                    this.Spawn2AnimationState.m_216982_(this.f_19797_);
                }
            }
        }
        super.m_7350_(p_21104_);
    }

    public void stopAllAnimationStates() {
        this.SpawnAnimationState.m_216973_();
        this.Spawn2AnimationState.m_216973_();
    }

    public int getState() {
        return (Integer)this.f_19804_.m_135370_(STATE);
    }

    public void setState(int state) {
        this.f_19804_.m_135381_(STATE, (Object)state);
    }

    public boolean getRight() {
        return (Boolean)this.f_19804_.m_135370_(RIGHT);
    }

    public void setRight(boolean right) {
        this.f_19804_.m_135381_(RIGHT, (Object)right);
    }

    public float getDamage() {
        return ((Float)this.f_19804_.m_135370_(DAMAGE)).floatValue();
    }

    public void setDamage(float damage) {
        this.f_19804_.m_135381_(DAMAGE, (Object)Float.valueOf(damage));
    }

    public void setCaster(@Nullable LivingEntity p_190549_1_) {
        this.caster = p_190549_1_;
        this.casterUuid = p_190549_1_ == null ? null : p_190549_1_.m_20148_();
    }

    @Nullable
    public LivingEntity getCaster() {
        Entity entity;
        if (this.caster == null && this.casterUuid != null && this.m_9236_() instanceof ServerLevel && (entity = ((ServerLevel)this.m_9236_()).m_8791_(this.casterUuid)) instanceof LivingEntity) {
            this.caster = (LivingEntity)entity;
        }
        return this.caster;
    }

    protected void m_7378_(CompoundTag compound) {
        this.warmupDelayTicks = compound.m_128451_("Warmup");
        if (compound.m_128403_("Owner")) {
            this.casterUuid = compound.m_128342_("Owner");
        }
        if (compound.m_128403_("Target")) {
            this.targetId = compound.m_128342_("Target");
        }
        this.setDamage(compound.m_128457_("Damage"));
    }

    protected void m_7380_(CompoundTag compound) {
        if (this.finalTarget != null) {
            compound.m_128362_("Target", this.finalTarget.m_20148_());
        }
        compound.m_128405_("Warmup", this.warmupDelayTicks);
        if (this.casterUuid != null) {
            compound.m_128362_("Owner", this.casterUuid);
        }
        compound.m_128350_("Damage", this.getDamage());
    }

    public void m_8119_() {
        super.m_8119_();
        if (this.m_9236_().f_46443_) {
            if (this.clientSideAttackStarted) {
                int i;
                ++this.lifeTicks;
                if (this.lifeTicks == 10) {
                    for (i = 0; i < 12; ++i) {
                        float angle = (float)Math.PI / 180 * this.m_146908_() + (float)i;
                        float r = 0.5f + this.f_19796_.m_188501_() * 0.9f;
                        float velocity = r + this.f_19796_.m_188501_() * 4.0f;
                        float x = r * Mth.m_14031_((float)((float)(Math.PI + (double)angle)));
                        float z = r * Mth.m_14089_((float)angle);
                        double d0 = this.m_20185_() + (double)x;
                        double d1 = this.m_20186_() + 0.1;
                        double d2 = this.m_20189_() + (double)z;
                        double extraX = d0 + (double)(velocity * 0.4f * Mth.m_14031_((float)((float)(Math.PI + (double)angle))));
                        double extraY = d1 + (double)0.3f + (double)(this.f_19796_.m_188501_() * 2.0f);
                        double extraZ = d2 + (double)(velocity * 0.4f * Mth.m_14089_((float)angle));
                        this.m_9236_().m_7106_((ParticleOptions)new Not_Spin_TrailParticle.NSTData(0.44313726f, 0.7607843f, 0.9411765f, 0.05f, 0.75f, 0.5f, 0.0, 60 + this.f_19796_.m_188503_(40)), d0, d1, d2, extraX, extraY, extraZ);
                    }
                }
                if (this.lifeTicks > 12 && this.lifeTicks < 18) {
                    for (i = 0; i < 5; ++i) {
                        this.m_9236_().m_7106_((ParticleOptions)new CircleLightningParticle.CircleData(113, 194, 240), this.m_20185_(), this.m_20186_() + 0.1, this.m_20189_(), this.m_20185_() + (double)((this.f_19796_.m_188501_() - 0.5f) * 7.0f), this.m_20186_() + 0.1, this.m_20189_() + (double)((this.f_19796_.m_188501_() - 0.5f) * 7.0f));
                    }
                }
                if (this.lifeTicks == 52) {
                    for (i = 0; i < 12; ++i) {
                        double theta = Math.toRadians(this.m_146908_());
                        double vecX = Math.cos(theta) * 8.0;
                        double vecZ = Math.sin(theta) * 8.0;
                        float angle = (float)Math.PI / 180 * this.m_146908_() + (float)i;
                        float r = 0.5f + this.f_19796_.m_188501_() * 0.9f;
                        float velocity = r + this.f_19796_.m_188501_() * 4.0f;
                        float x = (float)(vecX + (double)(r * Mth.m_14031_((float)((float)(Math.PI + (double)angle)))));
                        float z = (float)(vecZ + (double)(r * Mth.m_14089_((float)angle)));
                        double d0 = this.m_20185_() + (double)x;
                        double d1 = this.m_20186_() + 0.1;
                        double d2 = this.m_20189_() + (double)z;
                        double extraX = d0 + (double)(velocity * 0.6f * Mth.m_14031_((float)((float)(Math.PI + (double)angle))));
                        double extraY = d1 + (double)0.3f + (double)(this.f_19796_.m_188501_() * 1.2f);
                        double extraZ = d2 + (double)(velocity * 0.6f * Mth.m_14089_((float)angle));
                        this.m_9236_().m_7106_((ParticleOptions)new Not_Spin_TrailParticle.NSTData(0.44313726f, 0.7607843f, 0.9411765f, 0.05f, 0.75f, 0.5f, 0.0, 80 + this.f_19796_.m_188503_(40)), d0, d1, d2, extraX, extraY, extraZ);
                    }
                }
                if (this.lifeTicks > 52 && this.lifeTicks < 56) {
                    for (i = 0; i < 5; ++i) {
                        double theta = Math.toRadians(this.m_146908_());
                        double vecX = Math.cos(theta) * 8.0;
                        double vecZ = Math.sin(theta) * 8.0;
                        this.m_9236_().m_7106_((ParticleOptions)new CircleLightningParticle.CircleData(113, 194, 240), this.m_20185_() + vecX, this.m_20186_() + 0.1, this.m_20189_() + vecZ, this.m_20185_() + vecX + (double)((this.f_19796_.m_188501_() - 0.5f) * 7.0f), this.m_20186_() + 0.1, this.m_20189_() + vecZ + (double)((this.f_19796_.m_188501_() - 0.5f) * 7.0f));
                    }
                }
            }
        } else if (--this.warmupDelayTicks < 0) {
            if (this.warmupDelayTicks == -10 && this.getState() == 0) {
                this.setState(!this.getRight() ? 1 : 2);
            }
            if (this.finalTarget == null || !this.finalTarget.m_6084_()) {
                if (this.targetId != null) {
                    this.finalTarget = ((ServerLevel)this.m_9236_()).m_8791_(this.targetId);
                    if (this.finalTarget == null) {
                        this.targetId = null;
                    }
                } else {
                    ArrayList<LivingEntity> list = new ArrayList<LivingEntity>();
                    for (Entity entity1 : this.m_9236_().m_45976_(Entity.class, this.m_20191_().m_82400_(16.0))) {
                        PartEntity partEntity;
                        Object angle;
                        LivingEntity livingEntity = null;
                        if (entity1 instanceof PartEntity && (angle = (partEntity = (PartEntity)entity1).getParent()) instanceof LivingEntity) {
                            LivingEntity living;
                            livingEntity = living = (LivingEntity)angle;
                        } else if (entity1 instanceof LivingEntity) {
                            LivingEntity living;
                            livingEntity = living = (LivingEntity)entity1;
                        }
                        if (livingEntity == null || !MobUtil.ownedPredicate((Entity)this).test(livingEntity)) continue;
                        list.add(livingEntity);
                    }
                    list.sort(Comparator.comparingDouble(arg_0 -> ((StormSerpent)this).m_20270_(arg_0)));
                    if (list.stream().findFirst().isPresent()) {
                        LivingEntity livingEntity = (LivingEntity)list.stream().findFirst().get();
                        this.finalTarget = livingEntity;
                        this.targetId = livingEntity.m_20148_();
                    }
                }
            }
            if (this.finalTarget != null && this.finalTarget.m_6084_() && this.warmupDelayTicks > -48) {
                this.lookAt(this.finalTarget, 30.0f, 0.0f);
            }
            if (this.warmupDelayTicks == -52 || this.warmupDelayTicks == -53 || this.warmupDelayTicks == -54 || this.warmupDelayTicks == -55) {
                double theta = Math.toRadians(this.m_146908_());
                double vecX = this.m_20185_() + Math.cos(theta) * 8.0;
                double vecZ = this.m_20189_() + Math.sin(theta) * 8.0;
                AABB selection = new AABB(vecX - 1.5, this.m_20186_() - 2.0, vecZ - 1.5, vecX + 1.5, this.m_20186_() + (double)this.m_20206_(), vecZ + 1.5);
                for (LivingEntity livingentity : this.m_9236_().m_45976_(LivingEntity.class, selection)) {
                    this.damage(livingentity);
                }
                Vec3 vec3 = new Vec3(vecX, this.m_20186_(), vecZ);
                ScreenShake_Entity.ScreenShake((Level)this.m_9236_(), (Vec3)vec3, (float)10.0f, (float)0.07f, (int)0, (int)20);
            }
            if (!this.sentSpikeEvent) {
                this.m_9236_().m_7605_((Entity)this, (byte)4);
                this.sentSpikeEvent = true;
            }
            if (++this.lifeTicks > 70) {
                this.m_146870_();
            }
        }
    }

    protected void lookAt(Entity entity, float maxYRotIncrease, float maxXRotIncrease) {
        double d1;
        double d0 = entity.m_20185_() - this.m_20185_();
        double d2 = entity.m_20189_() - this.m_20189_();
        if (entity instanceof LivingEntity) {
            LivingEntity livingentity = (LivingEntity)entity;
            d1 = livingentity.m_20188_() - this.m_20188_();
        } else {
            d1 = (entity.m_20191_().f_82289_ + entity.m_20191_().f_82292_) / 2.0 - this.m_20188_();
        }
        double d3 = Math.sqrt(d0 * d0 + d2 * d2);
        float f = (float)(Mth.m_14136_((double)d2, (double)d0) * 180.0 / 3.1415927410125732);
        float f1 = (float)(-(Mth.m_14136_((double)d1, (double)d3) * 180.0 / 3.1415927410125732));
        this.m_146926_(this.rotlerp(this.m_146909_(), f1, maxXRotIncrease));
        this.m_146922_(this.rotlerp(this.m_146908_(), f, maxYRotIncrease));
    }

    private float rotlerp(float angle, float targetAngle, float maxIncrease) {
        float f = Mth.m_14177_((float)(targetAngle - angle));
        if (f > maxIncrease) {
            f = maxIncrease;
        }
        if (f < -maxIncrease) {
            f = -maxIncrease;
        }
        return angle + f;
    }

    protected void damage(LivingEntity Hitentity) {
        LivingEntity livingentity = this.getCaster();
        if (Hitentity.m_6084_() && !Hitentity.m_20147_() && Hitentity != livingentity) {
            if (livingentity == null) {
                Hitentity.m_6469_(this.m_269291_().m_269425_(), this.getDamage());
            } else {
                if (livingentity.m_7307_((Entity)Hitentity)) {
                    return;
                }
                boolean flag = Hitentity.m_6469_(this.m_269291_().m_269104_((Entity)this, (Entity)livingentity), this.getDamage());
                if (flag) {
                    MobEffectInstance effectinstance = new MobEffectInstance((MobEffect)ModEffect.EFFECTWETNESS.get(), 150, 4, false, true, true);
                    Hitentity.m_7292_(effectinstance);
                }
            }
        }
    }

    public void m_7822_(byte id) {
        super.m_7822_(id);
        if (id == 4) {
            this.clientSideAttackStarted = true;
        }
    }

    public Packet<ClientGamePacketListener> m_5654_() {
        return NetworkHooks.getEntitySpawningPacket((Entity)this);
    }
}

