/*
 * Decompiled with CFR 0.152.
 */
package com.Polarice3.goety_cataclysm.common.entities.ally.undead.draugr;

import com.Polarice3.Goety.client.particles.ModParticleTypes;
import com.Polarice3.Goety.common.entities.ally.Summoned;
import com.Polarice3.Goety.utils.MobUtil;
import com.Polarice3.goety_cataclysm.common.entities.ally.InternalAnimationSummon;
import com.Polarice3.goety_cataclysm.common.items.CataclysmItems;
import com.Polarice3.goety_cataclysm.config.GCAttributesConfig;
import com.Polarice3.goety_cataclysm.config.GCSpellConfig;
import com.Polarice3.goety_cataclysm.init.CataclysmSounds;
import java.util.EnumSet;
import java.util.Objects;
import java.util.function.Predicate;
import javax.annotation.Nullable;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.SimpleParticleType;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.util.TimeUtil;
import net.minecraft.util.valueproviders.UniformInt;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.AnimationState;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntitySelector;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.HumanoidArm;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.MobType;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.SpawnGroupData;
import net.minecraft.world.entity.ai.attributes.AttributeInstance;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.LookAtPlayerGoal;
import net.minecraft.world.entity.ai.goal.RandomLookAroundGoal;
import net.minecraft.world.entity.monster.CrossbowAttackMob;
import net.minecraft.world.entity.monster.Monster;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.AbstractArrow;
import net.minecraft.world.entity.projectile.Projectile;
import net.minecraft.world.entity.projectile.ProjectileUtil;
import net.minecraft.world.item.CrossbowItem;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.level.pathfinder.Node;
import net.minecraft.world.level.pathfinder.Path;
import net.minecraftforge.common.Tags;

public class EliteDraugrServant
extends InternalAnimationSummon
implements CrossbowAttackMob {
    private static final EntityDataAccessor<Boolean> IS_CHARGING_CROSSBOW = SynchedEntityData.m_135353_(EliteDraugrServant.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    public static final int RELOAD = 1;
    public static final int SHOOT = 2;
    public static final int SWING = 3;
    public static final int SHOOT_2 = 4;
    public AnimationState idleAnimationState = new AnimationState();
    public AnimationState ReloadAnimationState = new AnimationState();
    public AnimationState attackAnimationState = new AnimationState();
    public AnimationState attack2AnimationState = new AnimationState();
    public AnimationState swingAnimationState = new AnimationState();
    public AnimationState Shoot1AnimationState = new AnimationState();
    public AnimationState Shoot2AnimationState = new AnimationState();

    public EliteDraugrServant(EntityType<? extends InternalAnimationSummon> entity, Level world) {
        super(entity, world);
    }

    protected void m_8099_() {
        super.m_8099_();
        this.f_21345_.m_25352_(0, (Goal)new ReloadedGoal(this, 1, 0, 20, 20.0f));
        this.f_21345_.m_25352_(0, (Goal)new CrossBowShootGoal(this, 0, 4, 0, 23, 15, 12.0f));
        this.f_21345_.m_25352_(1, (Goal)new CrossBowReloadGoal(this, 0, 1, 1, 30, 15, 12.0f));
        this.f_21345_.m_25352_(2, (Goal)new Summoned.WanderGoal((PathfinderMob)this, 1.0, 80.0f));
        this.f_21345_.m_25352_(4, (Goal)new Elite_DraugrAttackGoal(this, 1.0, 12.0f, true));
        this.f_21345_.m_25352_(7, (Goal)new LookAtPlayerGoal((Mob)this, Player.class, 8.0f));
        this.f_21345_.m_25352_(8, (Goal)new RandomLookAroundGoal((Mob)this));
    }

    public void followGoal() {
        this.f_21345_.m_25352_(3, (Goal)new Summoned.FollowOwnerGoal((Mob)this, 1.0, 10.0f, 2.0f));
    }

    public static AttributeSupplier.Builder setCustomAttributes() {
        return Monster.m_33035_().m_22268_(Attributes.f_22277_, 30.0).m_22268_(Attributes.f_22279_, (double)0.27f).m_22268_(Attributes.f_22281_, ((Double)GCAttributesConfig.EliteDraugrMeleeDamage.get()).doubleValue()).m_22268_(Attributes.f_22276_, ((Double)GCAttributesConfig.EliteDraugrHealth.get()).doubleValue()).m_22268_(Attributes.f_22284_, ((Double)GCAttributesConfig.EliteDraugrArmor.get()).doubleValue()).m_22268_(Attributes.f_22278_, (double)0.1f);
    }

    public void setConfigurableAttributes() {
        MobUtil.setBaseAttributes((AttributeInstance)this.m_21051_(Attributes.f_22276_), (double)((Double)GCAttributesConfig.EliteDraugrHealth.get()));
        MobUtil.setBaseAttributes((AttributeInstance)this.m_21051_(Attributes.f_22284_), (double)((Double)GCAttributesConfig.EliteDraugrArmor.get()));
        MobUtil.setBaseAttributes((AttributeInstance)this.m_21051_(Attributes.f_22281_), (double)((Double)GCAttributesConfig.EliteDraugrMeleeDamage.get()));
    }

    public MobType m_6336_() {
        return MobType.f_21641_;
    }

    public Predicate<Entity> summonPredicate() {
        return entity -> entity instanceof EliteDraugrServant;
    }

    public int getSummonLimit(LivingEntity owner) {
        return (Integer)GCSpellConfig.EliteDraugrLimit.get();
    }

    public AnimationState getAnimationState(String input) {
        if (Objects.equals(input, "attack")) {
            return this.attackAnimationState;
        }
        if (Objects.equals(input, "attack2")) {
            return this.attack2AnimationState;
        }
        if (Objects.equals(input, "re_load")) {
            return this.ReloadAnimationState;
        }
        if (Objects.equals(input, "idle")) {
            return this.idleAnimationState;
        }
        if (Objects.equals(input, "swing")) {
            return this.swingAnimationState;
        }
        if (Objects.equals(input, "shoot")) {
            return this.Shoot1AnimationState;
        }
        return Objects.equals(input, "shoot2") ? this.Shoot2AnimationState : new AnimationState();
    }

    public void m_7350_(EntityDataAccessor<?> p_21104_) {
        if (ATTACK_STATE.equals(p_21104_)) {
            switch (this.getAttackState()) {
                case 0: {
                    this.stopAllAnimationStates();
                    break;
                }
                case 1: {
                    this.stopAllAnimationStates();
                    this.ReloadAnimationState.m_216982_(this.f_19797_);
                    break;
                }
                case 2: {
                    this.stopAllAnimationStates();
                    this.Shoot1AnimationState.m_216982_(this.f_19797_);
                    break;
                }
                case 3: {
                    this.stopAllAnimationStates();
                    this.swingAnimationState.m_216982_(this.f_19797_);
                    break;
                }
                case 4: {
                    this.stopAllAnimationStates();
                    this.Shoot2AnimationState.m_216982_(this.f_19797_);
                }
            }
        }
        super.m_7350_(p_21104_);
    }

    @Override
    protected void m_8097_() {
        super.m_8097_();
        this.f_19804_.m_135372_(IS_CHARGING_CROSSBOW, (Object)false);
    }

    public void stopAllAnimationStates() {
        this.attackAnimationState.m_216973_();
        this.attack2AnimationState.m_216973_();
        this.ReloadAnimationState.m_216973_();
        this.swingAnimationState.m_216973_();
        this.Shoot1AnimationState.m_216973_();
        this.Shoot2AnimationState.m_216973_();
    }

    public HumanoidArm m_5737_() {
        return HumanoidArm.LEFT;
    }

    @Override
    public void m_7822_(byte p_219360_) {
        if (p_219360_ == 4) {
            if (this.f_19796_.m_188499_()) {
                this.attackAnimationState.m_216977_(this.f_19797_);
            } else {
                this.attack2AnimationState.m_216977_(this.f_19797_);
            }
        } else {
            super.m_7822_(p_219360_);
        }
    }

    public boolean m_7327_(Entity p_219472_) {
        this.m_9236_().m_7605_((Entity)this, (byte)4);
        return super.m_7327_(p_219472_);
    }

    @Nullable
    public SpawnGroupData m_6518_(ServerLevelAccessor p_34088_, DifficultyInstance p_34089_, MobSpawnType p_34090_, @Nullable SpawnGroupData p_34091_, @Nullable CompoundTag p_34092_) {
        SpawnGroupData spawngroupdata = super.m_6518_(p_34088_, p_34089_, p_34090_, p_34091_, p_34092_);
        this.m_8061_(EquipmentSlot.MAINHAND, this.createSpawnWeapon());
        this.m_21409_(EquipmentSlot.MAINHAND, 0.0f);
        return spawngroupdata;
    }

    private ItemStack createSpawnWeapon() {
        return new ItemStack((ItemLike)Items.f_42717_);
    }

    @Override
    public void m_8119_() {
        super.m_8119_();
        if (this.m_9236_().m_5776_()) {
            this.idleAnimationState.m_246184_(true, this.f_19797_);
        }
    }

    protected SoundEvent m_7975_(DamageSource damageSourceIn) {
        return (SoundEvent)CataclysmSounds.DRAUGR_HURT.get();
    }

    protected SoundEvent m_5592_() {
        return (SoundEvent)CataclysmSounds.DRAUGR_DEATH.get();
    }

    protected SoundEvent m_7515_() {
        return (SoundEvent)CataclysmSounds.DRAUGR_IDLE.get();
    }

    public boolean isChargingCrossbow() {
        return (Boolean)this.f_19804_.m_135370_(IS_CHARGING_CROSSBOW);
    }

    public void m_6136_(boolean p_33302_) {
        this.f_19804_.m_135381_(IS_CHARGING_CROSSBOW, (Object)p_33302_);
    }

    public void m_5811_(LivingEntity p_32328_, ItemStack p_32329_, Projectile p_32330_, float p_32331_) {
        if (p_32330_ instanceof AbstractArrow) {
            AbstractArrow arrow = (AbstractArrow)p_32330_;
            arrow.m_36781_(arrow.m_36789_() + (Double)GCAttributesConfig.EliteDraugrRangeDamage.get());
        }
        this.m_32322_((LivingEntity)this, p_32328_, p_32330_, p_32331_, 1.6f);
    }

    public void m_5847_() {
        this.f_20891_ = 0;
    }

    public void m_6504_(LivingEntity p_33317_, float p_33318_) {
        this.m_32336_((LivingEntity)this, 1.6f);
    }

    public InteractionResult m_6071_(Player pPlayer, InteractionHand p_230254_2_) {
        ItemStack itemstack = pPlayer.m_21120_(p_230254_2_);
        if (this.getTrueOwner() != null && pPlayer == this.getTrueOwner() && (itemstack.m_150930_(Items.f_42583_) || itemstack.m_204117_(Tags.Items.BONES)) && this.m_21223_() < this.m_21233_()) {
            if (!pPlayer.m_150110_().f_35937_) {
                itemstack.m_41774_(1);
            }
            this.m_5496_(SoundEvents.f_11912_, 1.0f, 1.0f);
            this.m_5634_(2.0f);
            Level level = this.m_9236_();
            if (level instanceof ServerLevel) {
                ServerLevel serverLevel = (ServerLevel)level;
                for (int i = 0; i < 7; ++i) {
                    double d0 = this.f_19796_.m_188583_() * 0.02;
                    double d1 = this.f_19796_.m_188583_() * 0.02;
                    double d2 = this.f_19796_.m_188583_() * 0.02;
                    serverLevel.m_8767_((ParticleOptions)((SimpleParticleType)ModParticleTypes.HEAL_EFFECT.get()), this.m_20208_(1.0), this.m_20187_() + 0.5, this.m_20262_(1.0), 0, d0, d1, d2, 0.5);
                }
            }
            return InteractionResult.SUCCESS;
        }
        return InteractionResult.PASS;
    }

    static class ReloadedGoal
    extends Goal {
        protected final EliteDraugrServant entity;
        private final int getattackstate;
        private final int attackendstate;
        private final int attackseetick;
        private final float attackrange;

        public ReloadedGoal(EliteDraugrServant entity, int getattackstate, int attackendstate, int attackseetick, float attackrange) {
            this.entity = entity;
            this.m_7021_(EnumSet.of(Goal.Flag.MOVE, Goal.Flag.LOOK, Goal.Flag.JUMP));
            this.getattackstate = getattackstate;
            this.attackendstate = attackendstate;
            this.attackseetick = attackseetick;
            this.attackrange = attackrange;
        }

        public boolean m_8036_() {
            LivingEntity target = this.entity.m_5448_();
            return target != null && target.m_6084_() && this.entity.m_20270_((Entity)target) < this.attackrange && this.entity.getAttackState() == this.getattackstate && this.isHoldingCrossbow() && this.entity.isChargingCrossbow();
        }

        public void m_8056_() {
            LivingEntity livingentity = this.entity.m_5448_();
            boolean flag = true;
            if (livingentity != null) {
                float f = livingentity.m_20205_();
                float dis = f * 2.5f * f * 2.5f + livingentity.m_20205_();
                double d0 = this.entity.m_262793_(livingentity);
                if (d0 <= (double)dis) {
                    flag = false;
                }
            }
            if (flag) {
                this.entity.setAttackState(2);
            } else {
                this.entity.setAttackState(3);
            }
        }

        public void m_8041_() {
            this.entity.setAttackState(this.attackendstate);
        }

        public boolean m_8045_() {
            return (this.entity.getAttackState() == 2 || this.entity.getAttackState() == 3) && this.entity.attackTicks <= 30;
        }

        private boolean isHoldingCrossbow() {
            return this.entity.m_21093_(is -> is.m_41720_() instanceof CrossbowItem);
        }

        public void m_8037_() {
            LivingEntity target = this.entity.m_5448_();
            if (this.entity.attackTicks < this.attackseetick && target != null) {
                this.entity.m_21563_().m_24960_((Entity)target, 30.0f, 30.0f);
                this.entity.m_21391_((Entity)target, 30.0f, 30.0f);
            } else {
                this.entity.m_146922_(this.entity.f_19859_);
            }
            if (this.entity.getAttackState() == 2 && target != null && this.entity.attackTicks == 10) {
                this.entity.m_6504_(target, 1.0f);
                ItemStack itemstack1 = this.entity.m_21120_(ProjectileUtil.getWeaponHoldingHand((LivingEntity)this.entity, item -> item instanceof CrossbowItem));
                CrossbowItem.m_40884_((ItemStack)itemstack1, (boolean)false);
                this.entity.m_6136_(false);
            }
            if (this.entity.getAttackState() == 3 && target != null && this.entity.attackTicks == 11) {
                target.m_6469_(this.entity.getServantAttack(), (float)this.entity.m_21133_(Attributes.f_22281_));
            }
        }

        public boolean m_183429_() {
            return true;
        }

        protected double getAttackReachSqr(LivingEntity p_25556_) {
            float f = p_25556_.m_20205_();
            return f * 2.5f * f * 2.5f + p_25556_.m_20205_();
        }
    }

    static class CrossBowShootGoal
    extends Goal {
        protected final EliteDraugrServant entity;
        private final int getattackstate;
        private final int attackstate;
        private final int attackendstate;
        private final int attackMaxtick;
        private final int attackseetick;
        private final float attackrange;

        public CrossBowShootGoal(EliteDraugrServant entity, int getattackstate, int attackstate, int attackendstate, int attackMaxtick, int attackseetick, float attackrange) {
            this.entity = entity;
            this.m_7021_(EnumSet.of(Goal.Flag.MOVE, Goal.Flag.LOOK, Goal.Flag.JUMP));
            this.getattackstate = getattackstate;
            this.attackstate = attackstate;
            this.attackendstate = attackendstate;
            this.attackMaxtick = attackMaxtick;
            this.attackseetick = attackseetick;
            this.attackrange = attackrange;
        }

        public boolean m_8036_() {
            LivingEntity target = this.entity.m_5448_();
            return target != null && this.entity.m_217043_().m_188501_() * 100.0f < 22.0f && target.m_6084_() && this.entity.m_20270_((Entity)target) < this.attackrange && this.entity.getAttackState() == this.getattackstate && this.isHoldingCrossbow() && this.entity.isChargingCrossbow();
        }

        public void m_8056_() {
            this.entity.setAttackState(this.attackstate);
        }

        public void m_8041_() {
            this.entity.setAttackState(this.attackendstate);
        }

        public boolean m_8045_() {
            return this.entity.getAttackState() == this.attackstate && this.entity.attackTicks <= this.attackMaxtick;
        }

        private boolean isHoldingCrossbow() {
            return this.entity.m_21093_(is -> is.m_41720_() instanceof CrossbowItem);
        }

        public void m_8037_() {
            LivingEntity target = this.entity.m_5448_();
            if (this.entity.attackTicks < this.attackseetick && target != null) {
                this.entity.m_21563_().m_24960_((Entity)target, 30.0f, 30.0f);
                this.entity.m_21391_((Entity)target, 30.0f, 30.0f);
            } else {
                this.entity.m_146922_(this.entity.f_19859_);
            }
            if (target != null && this.entity.attackTicks == 11) {
                this.entity.m_6504_(target, 1.0f);
                ItemStack itemstack1 = this.entity.m_21120_(ProjectileUtil.getWeaponHoldingHand((LivingEntity)this.entity, item -> item instanceof CrossbowItem));
                CrossbowItem.m_40884_((ItemStack)itemstack1, (boolean)false);
                this.entity.m_6136_(false);
            }
        }

        public boolean m_183429_() {
            return true;
        }
    }

    static class CrossBowReloadGoal
    extends Goal {
        protected final EliteDraugrServant entity;
        private final int getattackstate;
        private final int attackstate;
        private final int attackendstate;
        private final int attackMaxtick;
        private final int attackseetick;
        private final float attackrange;
        private CrossbowState crossbowState = CrossbowState.UNCHARGED;

        public CrossBowReloadGoal(EliteDraugrServant entity, int getattackstate, int attackstate, int attackendstate, int attackMaxtick, int attackseetick, float attackrange) {
            this.entity = entity;
            this.m_7021_(EnumSet.of(Goal.Flag.MOVE, Goal.Flag.LOOK, Goal.Flag.JUMP));
            this.getattackstate = getattackstate;
            this.attackstate = attackstate;
            this.attackendstate = attackendstate;
            this.attackMaxtick = attackMaxtick;
            this.attackseetick = attackseetick;
            this.attackrange = attackrange;
        }

        public boolean m_8036_() {
            LivingEntity target = this.entity.m_5448_();
            return target != null && this.entity.m_217043_().m_188501_() * 100.0f < 22.0f && target.m_6084_() && this.entity.m_20270_((Entity)target) < this.attackrange && this.entity.getAttackState() == this.getattackstate && this.isHoldingCrossbow() && !this.entity.isChargingCrossbow();
        }

        public void m_8056_() {
            this.entity.setAttackState(this.attackstate);
        }

        public void m_8041_() {
            this.entity.setAttackState(this.attackendstate);
        }

        public boolean m_8045_() {
            return this.entity.getAttackState() == this.attackstate && this.entity.attackTicks <= this.attackMaxtick;
        }

        private boolean isHoldingCrossbow() {
            return this.entity.m_21093_(is -> is.m_41720_() instanceof CrossbowItem);
        }

        public void m_8037_() {
            ItemStack itemstack;
            int i;
            LivingEntity target = this.entity.m_5448_();
            if (this.entity.attackTicks < this.attackseetick && target != null) {
                this.entity.m_21563_().m_24960_((Entity)target, 30.0f, 30.0f);
                this.entity.m_21391_((Entity)target, 30.0f, 30.0f);
            } else {
                this.entity.m_146922_(this.entity.f_19859_);
            }
            if (this.entity.attackTicks == 5) {
                this.entity.m_6672_(ProjectileUtil.getWeaponHoldingHand((LivingEntity)this.entity, item -> item instanceof CrossbowItem));
            }
            if ((i = this.entity.m_21252_()) >= CrossbowItem.m_40939_((ItemStack)(itemstack = this.entity.m_21211_()))) {
                this.entity.m_21253_();
                this.entity.m_6136_(true);
            }
        }

        public boolean m_183429_() {
            return true;
        }
    }

    static class Elite_DraugrAttackGoal
    extends Goal {
        public static final UniformInt PATHFINDING_DELAY_RANGE = TimeUtil.m_145020_((int)1, (int)2);
        private final EliteDraugrServant mob;
        private final double speedModifier;
        private final float attackRadiusSqr;
        private int seeTime;
        private int updatePathDelay;
        private final boolean followingTargetEvenIfNotSeen;
        private Path path;
        private double pathedTargetX;
        private double pathedTargetY;
        private double pathedTargetZ;
        private int ticksUntilNextPathRecalculation;
        private int ticksUntilNextAttack;
        private final int attackInterval = 20;
        private long lastCanUseCheck;
        private static final long COOLDOWN_BETWEEN_CAN_USE_CHECKS = 20L;
        private int failedPathFindingPenalty = 0;
        private boolean canPenalize = false;

        public Elite_DraugrAttackGoal(EliteDraugrServant p_25814_, double p_25815_, float p_25816_, boolean p_25554_) {
            this.mob = p_25814_;
            this.speedModifier = p_25815_;
            this.attackRadiusSqr = p_25816_ * p_25816_;
            this.followingTargetEvenIfNotSeen = p_25554_;
            this.m_7021_(EnumSet.of(Goal.Flag.MOVE, Goal.Flag.LOOK));
        }

        public boolean m_8036_() {
            if (this.isHoldingCrossbow()) {
                return true;
            }
            long i = this.mob.m_9236_().m_46467_();
            if (i - this.lastCanUseCheck < 20L) {
                return false;
            }
            this.lastCanUseCheck = i;
            LivingEntity livingentity = this.mob.m_5448_();
            if (livingentity == null) {
                return false;
            }
            if (!livingentity.m_6084_()) {
                return false;
            }
            if (this.canPenalize) {
                if (--this.ticksUntilNextPathRecalculation <= 0) {
                    this.path = this.mob.m_21573_().m_6570_((Entity)livingentity, 0);
                    this.ticksUntilNextPathRecalculation = 4 + this.mob.m_217043_().m_188503_(7);
                    return this.path != null;
                }
                return true;
            }
            this.path = this.mob.m_21573_().m_6570_((Entity)livingentity, 0);
            if (this.path != null) {
                return true;
            }
            return this.getAttackReachSqr(livingentity) >= this.mob.m_20275_(livingentity.m_20185_(), livingentity.m_20186_(), livingentity.m_20189_());
        }

        private boolean isHoldingCrossbow() {
            return this.mob.m_21093_(is -> is.m_41720_() instanceof CrossbowItem);
        }

        public boolean m_8045_() {
            LivingEntity livingentity = this.mob.m_5448_();
            if (this.isHoldingCrossbow()) {
                return this.isValidTarget() && (this.m_8036_() || !this.mob.m_21573_().m_26571_());
            }
            if (livingentity == null) {
                return false;
            }
            if (!livingentity.m_6084_()) {
                return false;
            }
            if (this.isHoldingCrossbow()) {
                return false;
            }
            if (!this.followingTargetEvenIfNotSeen) {
                return !this.mob.m_21573_().m_26571_();
            }
            if (!this.mob.m_21444_(livingentity.m_20183_())) {
                return false;
            }
            return !(livingentity instanceof Player) || !livingentity.m_5833_() && !((Player)livingentity).m_7500_();
        }

        private boolean isValidTarget() {
            return this.mob.m_5448_() != null && this.mob.m_5448_().m_6084_();
        }

        public void m_8041_() {
            super.m_8041_();
            LivingEntity livingentity = this.mob.m_5448_();
            if (!EntitySelector.f_20406_.test(livingentity)) {
                this.mob.m_6710_(null);
            }
            this.mob.m_21561_(false);
            this.seeTime = 0;
            if (this.isHoldingCrossbow() && this.mob.m_6117_()) {
                this.mob.m_5810_();
                this.mob.m_6136_(false);
                CrossbowItem.m_40884_((ItemStack)this.mob.m_21211_(), (boolean)false);
            }
        }

        public boolean m_183429_() {
            return true;
        }

        public void m_8037_() {
            LivingEntity target = this.mob.m_5448_();
            if (target != null) {
                double t0 = this.mob.m_20280_((Entity)target);
                if (this.isHoldingCrossbow()) {
                    boolean flag2;
                    boolean flag1;
                    boolean flag = this.mob.m_21574_().m_148306_((Entity)target);
                    boolean bl = flag1 = this.seeTime > 0;
                    if (flag != flag1) {
                        this.seeTime = 0;
                    }
                    this.seeTime = flag ? ++this.seeTime : --this.seeTime;
                    boolean bl2 = flag2 = t0 > (double)this.attackRadiusSqr || this.seeTime < 5;
                    if (flag2) {
                        --this.updatePathDelay;
                        if (this.updatePathDelay <= 0) {
                            this.mob.m_21573_().m_5624_((Entity)target, this.speedModifier * 0.5);
                            this.updatePathDelay = PATHFINDING_DELAY_RANGE.m_214085_(this.mob.m_217043_());
                        }
                    } else {
                        this.updatePathDelay = 0;
                        this.mob.m_21573_().m_26573_();
                    }
                    if (t0 < 10.0) {
                        this.mob.m_8061_(EquipmentSlot.MAINHAND, new ItemStack((ItemLike)CataclysmItems.BLACK_STEEL_SWORD.get()));
                    }
                    this.mob.m_21563_().m_24960_((Entity)target, 30.0f, 30.0f);
                } else {
                    this.mob.m_21563_().m_24960_((Entity)target, 30.0f, 30.0f);
                    double d0 = this.mob.m_262793_(target);
                    this.ticksUntilNextPathRecalculation = Math.max(this.ticksUntilNextPathRecalculation - 1, 0);
                    if ((this.followingTargetEvenIfNotSeen || this.mob.m_21574_().m_148306_((Entity)target)) && this.ticksUntilNextPathRecalculation <= 0 && (this.pathedTargetX == 0.0 && this.pathedTargetY == 0.0 && this.pathedTargetZ == 0.0 || target.m_20275_(this.pathedTargetX, this.pathedTargetY, this.pathedTargetZ) >= 1.0 || this.mob.m_217043_().m_188501_() < 0.05f)) {
                        this.pathedTargetX = target.m_20185_();
                        this.pathedTargetY = target.m_20186_();
                        this.pathedTargetZ = target.m_20189_();
                        this.ticksUntilNextPathRecalculation = 4 + this.mob.m_217043_().m_188503_(7);
                        if (this.canPenalize) {
                            Node finalPathPoint;
                            this.ticksUntilNextPathRecalculation += this.failedPathFindingPenalty;
                            this.failedPathFindingPenalty = this.mob.m_21573_().m_26570_() != null ? ((finalPathPoint = this.mob.m_21573_().m_26570_().m_77395_()) != null && target.m_20275_((double)finalPathPoint.f_77271_, (double)finalPathPoint.f_77272_, (double)finalPathPoint.f_77273_) < 1.0 ? 0 : (this.failedPathFindingPenalty += 10)) : (this.failedPathFindingPenalty += 10);
                        }
                        if (d0 > 1024.0) {
                            this.ticksUntilNextPathRecalculation += 10;
                        } else if (d0 > 256.0) {
                            this.ticksUntilNextPathRecalculation += 5;
                        }
                        if (!this.mob.m_21573_().m_5624_((Entity)target, this.speedModifier)) {
                            this.ticksUntilNextPathRecalculation += 15;
                        }
                        this.ticksUntilNextPathRecalculation = this.m_183277_(this.ticksUntilNextPathRecalculation);
                    }
                    if (t0 > 10.0) {
                        this.mob.m_8061_(EquipmentSlot.MAINHAND, new ItemStack((ItemLike)Items.f_42717_));
                    }
                    this.ticksUntilNextAttack = Math.max(this.ticksUntilNextAttack - 1, 0);
                    this.checkAndPerformAttack(target, d0);
                }
            }
        }

        protected void checkAndPerformAttack(LivingEntity p_25557_, double p_25558_) {
            double d0 = this.getAttackReachSqr(p_25557_);
            if (p_25558_ <= d0 && this.ticksUntilNextAttack <= 0) {
                this.resetAttackCooldown();
                this.mob.m_6674_(InteractionHand.MAIN_HAND);
                this.mob.m_7327_((Entity)p_25557_);
            }
        }

        protected void resetAttackCooldown() {
            this.ticksUntilNextAttack = this.m_183277_(20);
        }

        protected double getAttackReachSqr(LivingEntity p_25556_) {
            float f = p_25556_.m_20205_();
            return f * 2.25f * f * 2.25f + p_25556_.m_20205_();
        }
    }

    private static enum CrossbowState {
        UNCHARGED,
        CHARGING,
        CHARGED,
        READY_TO_ATTACK;

    }
}

