/*
 * Decompiled with CFR 0.152.
 */
package com.Polarice3.goety_cataclysm.common.entities.ally.golem;

import com.Polarice3.Goety.utils.MobUtil;
import com.Polarice3.goety_cataclysm.common.blocks.GCBlocks;
import com.Polarice3.goety_cataclysm.common.entities.ally.AnimationSummon;
import com.Polarice3.goety_cataclysm.common.entities.ally.LLibraryBossSummon;
import com.Polarice3.goety_cataclysm.common.items.CataclysmItems;
import com.Polarice3.goety_cataclysm.common.items.block.EnderGolemSkullItem;
import com.Polarice3.goety_cataclysm.config.GCAttributesConfig;
import com.Polarice3.goety_cataclysm.config.GCSpellConfig;
import com.Polarice3.goety_cataclysm.init.CataclysmSounds;
import com.github.L_Ender.cataclysm.config.CMConfig;
import com.github.L_Ender.cataclysm.entity.AI.CmAttackGoal;
import com.github.L_Ender.cataclysm.entity.etc.SmartBodyHelper2;
import com.github.L_Ender.cataclysm.entity.etc.path.CMPathNavigateGround;
import com.github.L_Ender.cataclysm.entity.projectile.Void_Rune_Entity;
import com.github.L_Ender.lionfishapi.server.animation.Animation;
import java.util.EnumSet;
import java.util.function.Predicate;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.particles.BlockParticleOption;
import net.minecraft.core.particles.DustParticleOptions;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.tags.DamageTypeTags;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.damagesource.DamageTypes;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.SpawnGroupData;
import net.minecraft.world.entity.ai.attributes.AttributeInstance;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.control.BodyRotationControl;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.LookAtPlayerGoal;
import net.minecraft.world.entity.ai.goal.RandomLookAroundGoal;
import net.minecraft.world.entity.ai.navigation.PathNavigation;
import net.minecraft.world.entity.animal.AbstractGolem;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.monster.Monster;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.level.block.RenderShape;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.pathfinder.BlockPathTypes;
import net.minecraft.world.phys.Vec3;
import net.minecraft.world.phys.shapes.VoxelShape;

public class EnderGolemServant
extends LLibraryBossSummon {
    private static final EntityDataAccessor<Boolean> IS_AWAKEN = SynchedEntityData.m_135353_(EnderGolemServant.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    public static final Animation ANIMATION_ATTACK1 = Animation.create((int)25);
    public static final Animation ANIMATION_ATTACK2 = Animation.create((int)25);
    public static final Animation ANIMATION_EARTHQUAKE = Animation.create((int)35);
    public static final Animation VOID_RUNE_ATTACK = Animation.create((int)83);
    public static final Animation ENDER_GOLEM_DEATH = Animation.create((int)95);
    private int void_rune_attack_cooldown = 0;
    public float deactivateProgress;
    public float prevDeactivateProgress;
    public int wakeUp = 0;

    public EnderGolemServant(EntityType<? extends AnimationSummon> type, Level worldIn) {
        super(type, worldIn);
        this.m_274367_(1.5f);
        this.m_21441_(BlockPathTypes.UNPASSABLE_RAIL, 0.0f);
        this.m_21441_(BlockPathTypes.WATER, -1.0f);
    }

    @Override
    public Animation[] getAnimations() {
        return new Animation[]{NO_ANIMATION, ANIMATION_ATTACK1, ANIMATION_ATTACK2, ANIMATION_EARTHQUAKE, VOID_RUNE_ATTACK, ENDER_GOLEM_DEATH};
    }

    protected void m_8099_() {
        super.m_8099_();
        this.f_21345_.m_25352_(0, (Goal)new AwakenGoal());
        this.f_21345_.m_25352_(1, (Goal)new AttackGoal());
        this.f_21345_.m_25352_(2, (Goal)new CmAttackGoal((PathfinderMob)this, 1.0));
        this.f_21345_.m_25352_(7, (Goal)new LookAtPlayerGoal((Mob)this, Player.class, 8.0f));
        this.f_21345_.m_25352_(8, (Goal)new RandomLookAroundGoal((Mob)this));
    }

    public static AttributeSupplier.Builder setCustomAttributes() {
        return Monster.m_33035_().m_22268_(Attributes.f_22277_, 20.0).m_22268_(Attributes.f_22279_, (double)0.28f).m_22268_(Attributes.f_22281_, ((Double)GCAttributesConfig.EnderGolemDamage.get()).doubleValue()).m_22268_(Attributes.f_22276_, ((Double)GCAttributesConfig.EnderGolemHealth.get()).doubleValue()).m_22268_(Attributes.f_22284_, ((Double)GCAttributesConfig.EnderGolemArmor.get()).doubleValue()).m_22268_(Attributes.f_22278_, 1.0);
    }

    public void setConfigurableAttributes() {
        MobUtil.setBaseAttributes((AttributeInstance)this.m_21051_(Attributes.f_22276_), (double)((Double)GCAttributesConfig.EnderGolemHealth.get()));
        MobUtil.setBaseAttributes((AttributeInstance)this.m_21051_(Attributes.f_22284_), (double)((Double)GCAttributesConfig.EnderGolemArmor.get()));
        MobUtil.setBaseAttributes((AttributeInstance)this.m_21051_(Attributes.f_22281_), (double)((Double)GCAttributesConfig.EnderGolemDamage.get()));
    }

    protected int m_7302_(int air) {
        return air;
    }

    public boolean m_142535_(float p_148711_, float p_148712_, DamageSource p_148713_) {
        return false;
    }

    private static Animation getRandomAttack(RandomSource rand) {
        return switch (rand.m_188503_(3)) {
            case 0 -> ANIMATION_ATTACK1;
            case 1 -> ANIMATION_ATTACK2;
            default -> ANIMATION_EARTHQUAKE;
        };
    }

    public int xpReward() {
        return 15;
    }

    @Override
    public boolean m_6469_(DamageSource source, float damage) {
        double range;
        if (!(this.getAnimation() != VOID_RUNE_ATTACK && this.getIsAwaken() || !source.m_269533_(DamageTypeTags.f_268738_) && source.m_276093_(DamageTypes.f_268515_))) {
            damage = (float)((double)damage * 0.5);
        }
        if ((range = this.calculateRange(source)) > CMConfig.EndergolemLongRangelimit * CMConfig.EndergolemLongRangelimit && !source.m_269533_(DamageTypeTags.f_268738_)) {
            return false;
        }
        Entity entity = source.m_7640_();
        if (entity instanceof AbstractGolem) {
            damage = (float)((double)damage * 0.5);
        }
        return super.m_6469_(source, damage);
    }

    protected void m_8097_() {
        super.m_8097_();
        this.f_19804_.m_135372_(IS_AWAKEN, (Object)false);
    }

    public void m_7380_(CompoundTag compound) {
        super.m_7380_(compound);
        compound.m_128379_("is_Awaken", this.getIsAwaken());
    }

    public void m_7378_(CompoundTag compound) {
        super.m_7378_(compound);
        this.setIsAwaken(compound.m_128471_("is_Awaken"));
    }

    public void setIsAwaken(boolean isAwaken) {
        this.f_19804_.m_135381_(IS_AWAKEN, (Object)isAwaken);
    }

    public boolean getIsAwaken() {
        return (Boolean)this.f_19804_.m_135370_(IS_AWAKEN);
    }

    public Predicate<Entity> summonPredicate() {
        return entity -> entity instanceof EnderGolemServant;
    }

    public int getSummonLimit(LivingEntity owner) {
        return (Integer)GCSpellConfig.EnderGolemLimit.get();
    }

    @Nullable
    public SpawnGroupData m_6518_(ServerLevelAccessor pLevel, DifficultyInstance pDifficulty, MobSpawnType pReason, @Nullable SpawnGroupData pSpawnData, @Nullable CompoundTag pDataTag) {
        if (pReason == MobSpawnType.MOB_SUMMONED) {
            this.setIsAwaken(false);
            this.wakeUp = 20;
        }
        return super.m_6518_(pLevel, pDifficulty, pReason, pSpawnData, pDataTag);
    }

    @Override
    public void m_8119_() {
        super.m_8119_();
        this.repelEntities(1.7f, 3.7f, 1.7f, 1.7f);
        LivingEntity target = this.m_5448_();
        this.prevDeactivateProgress = this.deactivateProgress;
        if (!this.getIsAwaken() && this.deactivateProgress < 30.0f) {
            this.deactivateProgress += 1.0f;
        }
        if (this.getIsAwaken() && this.deactivateProgress > 0.0f) {
            this.deactivateProgress -= 1.0f;
        }
        if (this.deactivateProgress == 0.0f && this.m_6084_()) {
            if (target != null && target.m_6084_()) {
                if (!(this.void_rune_attack_cooldown <= 0 && !this.m_21525_() && this.getAnimation() == NO_ANIMATION && target.m_20096_() && (this.f_19796_.m_188503_(45) == 0 && this.m_20270_((Entity)target) < 4.0f || this.f_19796_.m_188503_(24) == 0 && this.m_20270_((Entity)target) < 10.0f))) {
                    if (this.m_20270_((Entity)target) < 4.0f && !this.m_21525_() && this.getAnimation() == NO_ANIMATION) {
                        Animation animation = EnderGolemServant.getRandomAttack(this.f_19796_);
                        this.setAnimation(animation);
                    }
                } else {
                    this.void_rune_attack_cooldown = 250;
                    this.setAnimation(VOID_RUNE_ATTACK);
                }
            }
            if (this.getAnimation() == ANIMATION_EARTHQUAKE && this.getAnimationTick() == 19) {
                this.EarthQuake(5.0f, 6);
                this.EarthQuakeParticle();
            }
            if ((this.getAnimation() == ANIMATION_ATTACK1 || this.getAnimation() == ANIMATION_ATTACK2) && this.getAnimationTick() == 13) {
                this.m_5496_((SoundEvent)CataclysmSounds.GOLEMATTACK.get(), 1.0f, 1.0f);
                if (target != null && target.m_6084_() && this.m_20270_((Entity)target) < 4.75f) {
                    target.m_6469_(this.getServantAttack(), (float)this.m_21133_(Attributes.f_22281_) + (float)this.f_19796_.m_188503_(4));
                    target.m_147240_(1.25, this.m_20185_() - target.m_20185_(), this.m_20189_() - target.m_20189_());
                }
            }
            if (this.getAnimation() == VOID_RUNE_ATTACK) {
                if (this.getAnimationTick() == 22) {
                    this.EarthQuake(4.25f, 4);
                    this.EarthQuakeParticle();
                }
                if (this.getAnimationTick() == 28) {
                    this.VoidRuneAttack();
                }
            }
        }
        if (this.void_rune_attack_cooldown > 0) {
            --this.void_rune_attack_cooldown;
        }
        if (this.wakeUp > 0) {
            --this.wakeUp;
        }
        if (!this.m_9236_().f_46443_) {
            this.setIsAwaken((!this.isStaying() || this.m_5448_() != null) && this.wakeUp <= 0);
        }
    }

    private void EarthQuakeParticle() {
        if (this.m_9236_().f_46443_) {
            BlockState block = this.m_9236_().m_8055_(this.m_20183_().m_7495_());
            for (int i1 = 0; i1 < 20 + this.f_19796_.m_188503_(12); ++i1) {
                double DeltaMovementX = this.m_217043_().m_188583_() * 0.07;
                double DeltaMovementY = this.m_217043_().m_188583_() * 0.07;
                double DeltaMovementZ = this.m_217043_().m_188583_() * 0.07;
                float angle = (float)Math.PI / 180 * this.f_20883_ + (float)i1;
                double extraX = 4.0f * Mth.m_14031_((float)((float)(Math.PI + (double)angle)));
                double extraY = 0.3f;
                double extraZ = 4.0f * Mth.m_14089_((float)angle);
                if (block.m_60799_() == RenderShape.INVISIBLE) continue;
                this.m_9236_().m_7106_((ParticleOptions)new BlockParticleOption(ParticleTypes.f_123794_, block), this.m_20185_() + extraX, this.m_20186_() + extraY, this.m_20189_() + extraZ, DeltaMovementX, DeltaMovementY, DeltaMovementZ);
            }
        }
    }

    private void EarthQuake(float grow, int damage) {
        this.m_5496_(SoundEvents.f_11913_, 1.5f, 1.0f + this.m_217043_().m_188501_() * 0.1f);
        for (LivingEntity entity : this.m_9236_().m_45976_(LivingEntity.class, this.m_20191_().m_82400_((double)grow))) {
            if (MobUtil.areAllies((Entity)this, (Entity)entity)) continue;
            entity.m_6469_(this.getServantAttack(), (float)this.m_21133_(Attributes.f_22281_) + (float)this.f_19796_.m_188503_(damage));
            this.launch(entity, true);
        }
    }

    private void VoidRuneAttack() {
        LivingEntity target = this.m_5448_();
        if (target != null) {
            int k;
            double d0 = Math.min(target.m_20186_(), this.m_20186_());
            double d1 = Math.max(target.m_20186_(), this.m_20186_()) + 1.0;
            float f = (float)Mth.m_14136_((double)(target.m_20189_() - this.m_20189_()), (double)(target.m_20185_() - this.m_20185_()));
            float f2 = Mth.m_14089_((float)(this.m_146908_() * ((float)Math.PI / 180))) * 2.0f;
            float f3 = Mth.m_14031_((float)(this.m_146908_() * ((float)Math.PI / 180))) * 2.0f;
            for (k = 0; k < 10; ++k) {
                double d2 = 1.5 * (double)(k + 1);
                int j = (int)(1.25f * (float)k);
                this.spawnFangs(this.m_20185_() + (double)f2 + (double)Mth.m_14089_((float)f) * d2, this.m_20189_() + (double)f3 + (double)Mth.m_14031_((float)f) * d2, d0, d1, f, j);
                this.spawnFangs(this.m_20185_() - (double)f2 + (double)Mth.m_14089_((float)f) * d2, this.m_20189_() - (double)f3 + (double)Mth.m_14031_((float)f) * d2, d0, d1, f, j);
            }
            for (k = 0; k < 6; ++k) {
                float f4 = f + (float)k * (float)Math.PI * 2.0f / 6.0f + 0.83775806f;
                this.spawnFangs(this.m_20185_() + (double)Mth.m_14089_((float)f4) * 2.5, this.m_20189_() + (double)Mth.m_14031_((float)f4) * 2.5, d0, d1, f2, 5);
            }
            for (k = 0; k < 8; ++k) {
                this.spawnFangs(this.m_20185_() + this.f_19796_.m_188583_() * 4.5, this.m_20189_() + this.f_19796_.m_188583_() * 4.5, d0, d1, f3, 15);
            }
        }
    }

    private void spawnFangs(double x, double z, double minY, double maxY, float rotation, int delay) {
        BlockPos blockpos = BlockPos.m_274561_((double)x, (double)maxY, (double)z);
        boolean flag = false;
        double d0 = 0.0;
        do {
            BlockState blockstate1;
            VoxelShape voxelshape;
            BlockPos blockpos1 = blockpos.m_7495_();
            BlockState blockstate = this.m_9236_().m_8055_(blockpos1);
            if (!blockstate.m_60783_((BlockGetter)this.m_9236_(), blockpos1, Direction.UP)) continue;
            if (!this.m_9236_().m_46859_(blockpos) && !(voxelshape = (blockstate1 = this.m_9236_().m_8055_(blockpos)).m_60812_((BlockGetter)this.m_9236_(), blockpos)).m_83281_()) {
                d0 = voxelshape.m_83297_(Direction.Axis.Y);
            }
            flag = true;
            break;
        } while ((blockpos = blockpos.m_7495_()).m_123342_() >= Mth.m_14107_((double)minY) - 1);
        if (flag) {
            this.m_9236_().m_7967_((Entity)new Void_Rune_Entity(this.m_9236_(), x, (double)blockpos.m_123342_() + d0, z, rotation, delay, (float)CMConfig.Voidrunedamage, (LivingEntity)this));
        }
    }

    private void launch(LivingEntity e, boolean huge) {
        double d0 = e.m_20185_() - this.m_20185_();
        double d1 = e.m_20189_() - this.m_20189_();
        double d2 = Math.max(d0 * d0 + d1 * d1, 0.001);
        float f = huge ? 2.0f : 0.5f;
        e.m_5997_(d0 / d2 * (double)f, huge ? 0.5 : (double)0.2f, d1 / d2 * (double)f);
    }

    @Override
    protected void onDeathAIUpdate() {
        super.onDeathAIUpdate();
        this.m_20334_(0.0, this.m_20184_().f_82480_, 0.0);
        if (this.f_20919_ == 40) {
            this.m_5496_((SoundEvent)CataclysmSounds.MONSTROSITYLAND.get(), 1.0f, 1.0f);
        }
    }

    @Override
    public void onDeathUpdate(int deathDuration) {
        super.onDeathUpdate(deathDuration);
        if (this.f_20919_ == deathDuration) {
            ItemStack itemStack = new ItemStack((ItemLike)GCBlocks.ENDER_GOLEM_SKULL_BLOCK.get());
            if (this.getTrueOwner() != null) {
                ItemEntity itemEntity;
                EnderGolemSkullItem.setOwner(this.getTrueOwner(), itemStack);
                if (this.m_7770_() != null) {
                    EnderGolemSkullItem.setCustomName(this.m_7770_().getString(), itemStack);
                }
                if ((itemEntity = this.m_19983_(itemStack)) != null) {
                    itemEntity.m_32064_();
                }
            } else if (this.m_9236_().m_213780_().m_188501_() <= 0.11f) {
                this.m_19983_(itemStack);
            }
        }
    }

    @Override
    public boolean canBePushedByEntity(Entity entity) {
        return false;
    }

    @Override
    @Nullable
    public Animation getDeathAnimation() {
        return ENDER_GOLEM_DEATH;
    }

    protected void m_7355_(BlockPos pos, BlockState blockIn) {
        this.m_5496_(SoundEvents.f_12010_, 1.0f, 1.0f);
    }

    protected SoundEvent m_7975_(DamageSource damageSourceIn) {
        return (SoundEvent)CataclysmSounds.GOLEMHURT.get();
    }

    protected SoundEvent m_5592_() {
        return (SoundEvent)CataclysmSounds.GOLEMDEATH.get();
    }

    protected BodyRotationControl m_7560_() {
        return new SmartBodyHelper2((Mob)this);
    }

    protected PathNavigation m_6037_(Level worldIn) {
        return new CMPathNavigateGround((Mob)this, worldIn);
    }

    public InteractionResult m_6071_(Player pPlayer, InteractionHand p_230254_2_) {
        if (!this.m_9236_().f_46443_) {
            ItemStack itemstack = pPlayer.m_21120_(p_230254_2_);
            if (this.getTrueOwner() != null && pPlayer == this.getTrueOwner() && (itemstack.m_150930_((Item)CataclysmItems.VOID_STONE.get()) || itemstack.m_150930_((Item)CataclysmItems.VOID_CORE.get())) && this.m_21223_() < this.m_21233_()) {
                Level level;
                if (!pPlayer.m_150110_().f_35937_) {
                    itemstack.m_41774_(1);
                }
                if (itemstack.m_150930_((Item)CataclysmItems.VOID_CORE.get())) {
                    this.m_5634_(this.m_21233_() / 2.0f);
                    this.m_5496_(SoundEvents.f_12009_, 1.0f, 1.5f);
                }
                if (itemstack.m_150930_((Item)CataclysmItems.VOID_STONE.get())) {
                    this.m_5634_(this.m_21233_() / 4.0f);
                    this.m_5496_(SoundEvents.f_12009_, 1.0f, 1.5f);
                }
                if ((level = this.m_9236_()) instanceof ServerLevel) {
                    ServerLevel serverLevel = (ServerLevel)level;
                    for (int i = 0; i < 7; ++i) {
                        double d0 = serverLevel.f_46441_.m_188583_() * 0.02;
                        double d1 = serverLevel.f_46441_.m_188583_() * 0.02;
                        double d2 = serverLevel.f_46441_.m_188583_() * 0.02;
                        serverLevel.m_8767_((ParticleOptions)new DustParticleOptions(Vec3.m_82501_((int)4461914).m_252839_(), 1.0f), this.m_20208_(1.0), this.m_20187_(), this.m_20262_(1.0), 0, d0, d1, d2, 0.5);
                    }
                }
                return InteractionResult.SUCCESS;
            }
        }
        return InteractionResult.PASS;
    }

    public void tryKill(Player player) {
        if (this.killChance <= 0) {
            this.warnKill(player);
        } else {
            super.tryKill(player);
        }
    }

    class AwakenGoal
    extends Goal {
        public AwakenGoal() {
            this.m_7021_(EnumSet.of(Goal.Flag.JUMP, Goal.Flag.LOOK, Goal.Flag.MOVE));
        }

        public boolean m_8036_() {
            return EnderGolemServant.this.deactivateProgress > 0.0f;
        }

        public boolean m_183429_() {
            return true;
        }

        public void m_8037_() {
            EnderGolemServant.this.m_20334_(0.0, EnderGolemServant.this.m_20184_().f_82480_, 0.0);
        }
    }

    class AttackGoal
    extends Goal {
        public AttackGoal() {
            this.m_7021_(EnumSet.of(Goal.Flag.JUMP, Goal.Flag.LOOK, Goal.Flag.MOVE));
        }

        public boolean m_8036_() {
            return EnderGolemServant.this.getAnimation() == ANIMATION_EARTHQUAKE || EnderGolemServant.this.getAnimation() == VOID_RUNE_ATTACK;
        }

        public boolean m_183429_() {
            return true;
        }

        public void m_8041_() {
            super.m_8041_();
        }

        public void m_8037_() {
            EnderGolemServant.this.m_20334_(0.0, EnderGolemServant.this.m_20184_().f_82480_, 0.0);
            LivingEntity target = EnderGolemServant.this.m_5448_();
            if (EnderGolemServant.this.getAnimation() == ANIMATION_EARTHQUAKE) {
                if (EnderGolemServant.this.getAnimationTick() < 19 && target != null) {
                    EnderGolemServant.this.m_21563_().m_24960_((Entity)target, 30.0f, 30.0f);
                    EnderGolemServant.this.m_21391_((Entity)target, 30.0f, 30.0f);
                } else {
                    EnderGolemServant.this.m_146922_(EnderGolemServant.this.f_19859_);
                }
            }
            if (EnderGolemServant.this.getAnimation() == VOID_RUNE_ATTACK) {
                if (EnderGolemServant.this.getAnimationTick() < 22 && target != null) {
                    EnderGolemServant.this.m_21563_().m_24960_((Entity)target, 30.0f, 30.0f);
                    EnderGolemServant.this.m_21391_((Entity)target, 30.0f, 30.0f);
                } else {
                    EnderGolemServant.this.m_146922_(EnderGolemServant.this.f_19859_);
                }
            }
        }
    }
}

