/*
 * Decompiled with CFR 0.152.
 */
package com.Polarice3.goety_cataclysm.common.entities.ally.deepling;

import com.Polarice3.Goety.client.particles.ModParticleTypes;
import com.Polarice3.Goety.common.entities.ally.Summoned;
import com.Polarice3.goety_cataclysm.common.entities.ally.AnimationSummon;
import com.Polarice3.goety_cataclysm.common.entities.ally.LLibrarySummon;
import com.Polarice3.goety_cataclysm.common.entities.ally.golem.CoralGolemServant;
import com.Polarice3.goety_cataclysm.common.entities.ally.golem.CoralssusServant;
import com.Polarice3.goety_cataclysm.config.GCMobsConfig;
import com.Polarice3.goety_cataclysm.init.CataclysmSounds;
import com.github.L_Ender.cataclysm.entity.AI.MobAIFindWater;
import com.github.L_Ender.cataclysm.entity.AI.MobAILeaveWater;
import com.github.L_Ender.cataclysm.entity.etc.ISemiAquatic;
import com.github.L_Ender.cataclysm.entity.etc.path.GroundPathNavigatorWide;
import com.github.L_Ender.cataclysm.entity.etc.path.SemiAquaticPathNavigator;
import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.SimpleParticleType;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.tags.ItemTags;
import net.minecraft.util.Mth;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityDimensions;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobType;
import net.minecraft.world.entity.MoverType;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.Pose;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.control.MoveControl;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.LookAtPlayerGoal;
import net.minecraft.world.entity.ai.goal.MoveToBlockGoal;
import net.minecraft.world.entity.ai.goal.RandomLookAroundGoal;
import net.minecraft.world.entity.ai.util.DefaultRandomPos;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.pathfinder.Path;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.common.ForgeMod;
import net.minecraftforge.fluids.FluidType;

public class AbstractDeeplingServant
extends LLibrarySummon
implements ISemiAquatic {
    public boolean searchingForLand;
    private int moistureAttackTime = 0;
    public float LayerBrightness;
    public float oLayerBrightness;
    public int LayerTicks;
    private boolean isLandNavigator;
    private static final EntityDataAccessor<Integer> MOISTNESS = SynchedEntityData.m_135353_(AbstractDeeplingServant.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    private static final EntityDataAccessor<Boolean> DEEPLING_SWIM = SynchedEntityData.m_135353_(AbstractDeeplingServant.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);

    public AbstractDeeplingServant(EntityType<? extends AbstractDeeplingServant> entity, Level world) {
        super((EntityType<? extends AnimationSummon>)entity, world);
    }

    protected void m_8099_() {
        super.m_8099_();
        this.f_21345_.m_25352_(4, (Goal)new MobAIFindWater((PathfinderMob)this, 1.0));
        this.f_21345_.m_25352_(4, (Goal)new MobAILeaveWater((PathfinderMob)this));
        this.f_21345_.m_25352_(6, (Goal)new LookAtPlayerGoal((Mob)this, Player.class, 8.0f));
        this.f_21345_.m_25352_(6, (Goal)new RandomLookAroundGoal((Mob)this));
        this.f_21345_.m_25352_(7, (Goal)new Summoned.WaterWanderGoal((Summoned)this, (PathfinderMob)this));
    }

    public void followGoal() {
        this.f_21345_.m_25352_(5, (Goal)new Summoned.FollowOwnerWaterGoal((Summoned)this, 1.0, 10.0f, 2.0f));
    }

    protected void m_8097_() {
        super.m_8097_();
        this.f_19804_.m_135372_(MOISTNESS, (Object)40000);
        this.f_19804_.m_135372_(DEEPLING_SWIM, (Object)false);
    }

    protected SoundEvent m_7515_() {
        return (SoundEvent)CataclysmSounds.DEEPLING_IDLE.get();
    }

    protected SoundEvent m_7975_(DamageSource damageSourceIn) {
        return (SoundEvent)CataclysmSounds.DEEPLING_HURT.get();
    }

    protected SoundEvent m_5592_() {
        return (SoundEvent)CataclysmSounds.DEEPLING_DEATH.get();
    }

    protected void m_7355_(BlockPos pos, BlockState blockIn) {
        this.m_5496_((SoundEvent)CataclysmSounds.DEEPLING_IDLE.get(), 0.15f, 0.6f);
    }

    public boolean canRide(LivingEntity livingEntity) {
        if (livingEntity.m_146895_() == null) {
            AnimationSummon servant;
            if (livingEntity instanceof CoralssusServant) {
                servant = (CoralssusServant)livingEntity;
                if (this.getTrueOwner() != null) {
                    return servant.getTrueOwner() == this.getTrueOwner();
                }
            }
            if (livingEntity instanceof CoralGolemServant) {
                servant = (CoralGolemServant)livingEntity;
                if (this.getTrueOwner() != null) {
                    return servant.getTrueOwner() == this.getTrueOwner();
                }
            }
        }
        return super.canRide(livingEntity);
    }

    @Override
    public void m_8119_() {
        super.m_8119_();
        if (this.m_20069_() && this.isLandNavigator) {
            this.switchNavigator(false);
        }
        if (!this.m_20069_() && !this.isLandNavigator) {
            this.switchNavigator(true);
        }
        if (this.m_21525_()) {
            this.m_20301_(this.m_6062_());
        } else if (this.m_20071_() || !((Boolean)GCMobsConfig.DeeplingMoistness.get()).booleanValue()) {
            this.setMoistness(6000);
        } else {
            int dry = this.m_9236_().m_46461_() ? 2 : 1;
            this.setMoistness(this.getMoistness() - dry);
            if (this.getMoistness() <= 0 && this.moistureAttackTime-- <= 0) {
                this.m_6469_(this.m_269291_().m_269483_(), this.f_19796_.m_188503_(2) == 0 ? 1.0f : 0.0f);
                this.moistureAttackTime = 20;
            }
        }
        boolean flag1 = this.canInFluidType(this.getEyeInFluidType());
        if (flag1) {
            if (this.m_9236_().m_45756_((Entity)this, this.getSwimmingBox())) {
                if (!this.getDeeplingSwim()) {
                    this.setDeeplingSwim(true);
                }
                this.m_6210_();
            }
        } else if (this.m_9236_().m_45756_((Entity)this, this.getNormalBox())) {
            if (this.getDeeplingSwim()) {
                this.setDeeplingSwim(false);
            }
            this.m_6210_();
        }
        if (this.m_9236_().f_46443_) {
            this.oLayerBrightness = this.LayerBrightness;
            ++this.LayerTicks;
            this.LayerBrightness += (0.0f - this.LayerBrightness) * 0.8f;
        }
    }

    private boolean canInFluidType(FluidType type) {
        ForgeMod.WATER_TYPE.get();
        return type.canSwim((Entity)this.self());
    }

    public boolean m_6067_() {
        return this.getDeeplingSwim();
    }

    public void switchNavigator(boolean onLand) {
        if (onLand) {
            this.f_21344_ = new GroundPathNavigatorWide((Mob)this, this.m_9236_());
            this.isLandNavigator = true;
        } else {
            this.f_21344_ = new SemiAquaticPathNavigator((Mob)this, this.m_9236_());
            this.isLandNavigator = false;
        }
    }

    public AABB getSwimmingBox() {
        return new AABB(this.m_20185_() - (double)1.15f, this.m_20186_(), this.m_20189_() - (double)1.15f, this.m_20185_() + (double)1.15f, this.m_20186_() + (double)0.6f, this.m_20189_() + (double)1.15f);
    }

    public AABB getNormalBox() {
        return new AABB(this.m_20185_() - (double)0.6f, this.m_20186_(), this.m_20189_() - (double)0.6f, this.m_20185_() + (double)0.6f, this.m_20186_() + (double)2.3f, this.m_20189_() + (double)0.6f);
    }

    public EntityDimensions getSwimmingSize() {
        return this.m_6095_().m_20680_().m_20388_(this.m_6134_());
    }

    public EntityDimensions m_6972_(Pose poseIn) {
        return this.getDeeplingSwim() ? this.getSwimmingSize() : super.m_6972_(poseIn);
    }

    public void m_7380_(CompoundTag compound) {
        super.m_7380_(compound);
        compound.m_128405_("Moisture", this.getMoistness());
    }

    public void m_7378_(CompoundTag compound) {
        super.m_7378_(compound);
        this.setMoistness(compound.m_128451_("Moisture"));
    }

    public int getMoistness() {
        return (Integer)this.f_19804_.m_135370_(MOISTNESS);
    }

    public void setMoistness(int p_211137_1_) {
        this.f_19804_.m_135381_(MOISTNESS, (Object)p_211137_1_);
    }

    public boolean getDeeplingSwim() {
        return (Boolean)this.f_19804_.m_135370_(DEEPLING_SWIM);
    }

    public void setDeeplingSwim(boolean swim) {
        this.f_19804_.m_135381_(DEEPLING_SWIM, (Object)swim);
    }

    public MobType m_6336_() {
        return MobType.f_21644_;
    }

    public boolean m_6063_() {
        return !this.m_6069_();
    }

    public boolean m_6040_() {
        return true;
    }

    public boolean shouldEnterWater() {
        return this.getMoistness() < 300;
    }

    public boolean shouldLeaveWater() {
        return this.m_5448_() != null && !this.m_5448_().m_20069_() || this.getTrueOwner() != null && !this.getTrueOwner().m_20069_();
    }

    public boolean shouldStopMoving() {
        return false;
    }

    public int getWaterSearchRange() {
        return 32;
    }

    public boolean wantsToSwim() {
        if (this.searchingForLand) {
            return true;
        }
        if (this.m_5448_() != null && this.m_5448_().m_20069_()) {
            return true;
        }
        return this.getTrueOwner() != null && this.isFollowing() && (this.getTrueOwner().m_20069_() || this.m_20069_() && this.getTrueOwner().m_20186_() > this.m_20186_());
    }

    public void m_7023_(Vec3 p_32394_) {
        if (this.m_21515_() && this.m_20069_() && this.wantsToSwim()) {
            this.m_19920_(0.01f, p_32394_);
            this.m_6478_(MoverType.SELF, this.m_20184_());
            this.m_20256_(this.m_20184_().m_82490_(0.9));
        } else {
            super.m_7023_(p_32394_);
        }
    }

    protected boolean closeToNextPos() {
        double d0;
        BlockPos blockpos;
        Path path = this.m_21573_().m_26570_();
        return path != null && (blockpos = path.m_77406_()) != null && (d0 = this.m_20275_(blockpos.m_123341_(), blockpos.m_123342_(), blockpos.m_123343_())) < 4.0;
    }

    public void setSearchingForLand(boolean p_32399_) {
        this.searchingForLand = p_32399_;
    }

    public InteractionResult m_6071_(Player pPlayer, InteractionHand pHand) {
        ItemStack itemstack = pPlayer.m_21120_(pHand);
        if (this.getTrueOwner() != null && pPlayer == this.getTrueOwner() && itemstack.m_204117_(ItemTags.f_13156_) && this.m_21223_() < this.m_21233_()) {
            if (!pPlayer.m_150110_().f_35937_) {
                itemstack.m_41774_(1);
            }
            this.m_5496_(SoundEvents.f_11912_, 1.0f, 1.0f);
            this.m_5634_(2.0f);
            Level level = this.m_9236_();
            if (level instanceof ServerLevel) {
                ServerLevel serverLevel = (ServerLevel)level;
                for (int i = 0; i < 7; ++i) {
                    double d0 = this.f_19796_.m_188583_() * 0.02;
                    double d1 = this.f_19796_.m_188583_() * 0.02;
                    double d2 = this.f_19796_.m_188583_() * 0.02;
                    serverLevel.m_8767_((ParticleOptions)((SimpleParticleType)ModParticleTypes.HEAL_EFFECT.get()), this.m_20208_(1.0), this.m_20187_() + 0.5, this.m_20262_(1.0), 0, d0, d1, d2, 0.5);
                }
            }
            return InteractionResult.SUCCESS;
        }
        return InteractionResult.PASS;
    }

    static class DeeplingSwimUpGoal
    extends Goal {
        private final AbstractDeeplingServant drowned;
        private final double speedModifier;
        private final int seaLevel;
        private boolean stuck;

        public DeeplingSwimUpGoal(AbstractDeeplingServant p_32440_, double p_32441_, int p_32442_) {
            this.drowned = p_32440_;
            this.speedModifier = p_32441_;
            this.seaLevel = p_32442_;
        }

        public boolean m_8036_() {
            if (this.drowned.getTrueOwner() != null && this.drowned.getTrueOwner().m_5842_()) {
                return false;
            }
            return (this.drowned.m_9236_().m_46471_() || this.drowned.m_20069_()) && this.drowned.m_20186_() < (double)(this.seaLevel - 2);
        }

        public boolean m_8045_() {
            return this.m_8036_() && !this.stuck;
        }

        public void m_8037_() {
            if (this.drowned.m_20186_() < (double)(this.seaLevel - 1) && (this.drowned.m_21573_().m_26571_() || this.drowned.closeToNextPos())) {
                Vec3 vec3 = DefaultRandomPos.m_148412_((PathfinderMob)this.drowned, (int)4, (int)8, (Vec3)new Vec3(this.drowned.m_20185_(), (double)(this.seaLevel - 1), this.drowned.m_20189_()), (double)1.5707963705062866);
                if (vec3 == null) {
                    this.stuck = true;
                    return;
                }
                this.drowned.m_21573_().m_26519_(vec3.f_82479_, vec3.f_82480_, vec3.f_82481_, this.speedModifier);
            }
        }

        public void m_8056_() {
            this.drowned.setSearchingForLand(true);
            this.stuck = false;
        }

        public void m_8041_() {
            this.drowned.setSearchingForLand(false);
        }
    }

    static class DeeplingGoToBeachGoal
    extends MoveToBlockGoal {
        private final AbstractDeeplingServant drowned;

        public DeeplingGoToBeachGoal(AbstractDeeplingServant p_32409_, double p_32410_) {
            super((PathfinderMob)p_32409_, p_32410_, 8, 2);
            this.drowned = p_32409_;
        }

        public boolean m_8036_() {
            if (this.drowned.getTrueOwner() != null && this.drowned.getTrueOwner().m_5842_()) {
                return false;
            }
            return super.m_8036_() && this.drowned.m_9236_().m_46471_() && this.drowned.m_20069_() && this.drowned.m_20186_() >= (double)(this.drowned.m_9236_().m_5736_() - 3);
        }

        public boolean m_8045_() {
            return super.m_8045_();
        }

        protected boolean m_6465_(LevelReader p_32413_, BlockPos p_32414_) {
            BlockPos blockpos = p_32414_.m_7494_();
            return p_32413_.m_46859_(blockpos) && p_32413_.m_46859_(blockpos.m_7494_()) ? p_32413_.m_8055_(p_32414_).m_60634_((BlockGetter)p_32413_, p_32414_, (Entity)this.drowned) : false;
        }

        public void m_8056_() {
            this.drowned.setSearchingForLand(false);
            super.m_8056_();
        }

        public void m_8041_() {
            super.m_8041_();
        }
    }

    static class DeeplingMoveControl
    extends MoveControl {
        private final AbstractDeeplingServant drowned;
        private final float speedMulti;

        public DeeplingMoveControl(AbstractDeeplingServant p_32433_, float speedMulti) {
            super((Mob)p_32433_);
            this.drowned = p_32433_;
            this.speedMulti = speedMulti;
        }

        public void m_8126_() {
            LivingEntity livingentity = this.drowned.m_5448_();
            LivingEntity owner = this.drowned.getTrueOwner();
            if (this.drowned.wantsToSwim() && this.drowned.m_20069_()) {
                if (livingentity != null && livingentity.m_20186_() > this.drowned.m_20186_() || this.drowned.searchingForLand || owner != null && owner.m_20186_() > this.drowned.m_20186_() && this.drowned.isFollowing()) {
                    this.drowned.m_20256_(this.drowned.m_20184_().m_82520_(0.0, 0.002, 0.0));
                }
                if (this.f_24981_ != MoveControl.Operation.MOVE_TO || this.drowned.m_21573_().m_26571_()) {
                    this.drowned.m_7910_(0.0f);
                    return;
                }
                double d0 = this.f_24975_ - this.drowned.m_20185_();
                double d1 = this.f_24976_ - this.drowned.m_20186_();
                double d2 = this.f_24977_ - this.drowned.m_20189_();
                double d3 = Math.sqrt(d0 * d0 + d1 * d1 + d2 * d2);
                d1 /= d3;
                float f = (float)(Mth.m_14136_((double)d2, (double)d0) * 57.2957763671875) - 90.0f;
                this.drowned.m_146922_(this.m_24991_(this.drowned.m_146908_(), f, 90.0f));
                this.drowned.f_20883_ = this.drowned.m_146908_();
                float f1 = (float)(this.f_24978_ * (double)this.speedMulti * this.drowned.m_21133_(Attributes.f_22279_));
                float f2 = Mth.m_14179_((float)0.125f, (float)this.drowned.m_6113_(), (float)f1);
                this.drowned.m_7910_(f2);
                this.drowned.m_20256_(this.drowned.m_20184_().m_82520_((double)f2 * d0 * 0.005, (double)f2 * d1 * 0.1, (double)f2 * d2 * 0.005));
            } else {
                if (!this.drowned.m_20096_()) {
                    this.drowned.m_20256_(this.drowned.m_20184_().m_82520_(0.0, -0.008, 0.0));
                }
                super.m_8126_();
            }
        }
    }
}

