/*
 * Decompiled with CFR 0.152.
 */
package com.Polarice3.goety_cataclysm.common.entities.ally.acropolis;

import com.Polarice3.Goety.client.particles.ModParticleTypes;
import com.Polarice3.Goety.common.entities.ally.Summoned;
import com.Polarice3.Goety.common.entities.ally.undead.zombie.DrownedServant;
import com.Polarice3.Goety.common.entities.neutral.Owned;
import com.Polarice3.Goety.utils.MobUtil;
import com.Polarice3.goety_cataclysm.common.entities.GCEntityType;
import com.Polarice3.goety_cataclysm.common.entities.ally.acropolis.DrownedHostServant;
import com.Polarice3.goety_cataclysm.common.entities.projectiles.OctoInk;
import com.Polarice3.goety_cataclysm.config.GCAttributesConfig;
import com.Polarice3.goety_cataclysm.config.GCMobsConfig;
import com.Polarice3.goety_cataclysm.config.GCSpellConfig;
import com.github.L_Ender.cataclysm.entity.etc.path.SemiAquaticPathNavigator;
import java.util.EnumSet;
import java.util.Objects;
import java.util.function.Predicate;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.core.particles.SimpleParticleType;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.tags.ItemTags;
import net.minecraft.util.Mth;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.damagesource.DamageTypes;
import net.minecraft.world.entity.AnimationState;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntitySelector;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobType;
import net.minecraft.world.entity.MoverType;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.ai.attributes.AttributeInstance;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.control.MoveControl;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.LookAtPlayerGoal;
import net.minecraft.world.entity.ai.goal.MeleeAttackGoal;
import net.minecraft.world.entity.ai.goal.RandomLookAroundGoal;
import net.minecraft.world.entity.ai.navigation.GroundPathNavigation;
import net.minecraft.world.entity.monster.Monster;
import net.minecraft.world.entity.monster.RangedAttackMob;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.pathfinder.BlockPathTypes;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.common.ForgeMod;
import net.minecraftforge.fluids.FluidType;

public class SymbioctoServant
extends Summoned
implements RangedAttackMob {
    boolean searchingForLand;
    public AnimationState idleAnimationState = new AnimationState();
    public AnimationState spitAnimationState = new AnimationState();
    public AnimationState attackAnimationState = new AnimationState();
    public static final EntityDataAccessor<Integer> ATTACK_STATE = SynchedEntityData.m_135353_(SymbioctoServant.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    public int attackTicks;
    public float interestTime;
    protected final SemiAquaticPathNavigator waterNavigation;
    protected final GroundPathNavigation groundNavigation;

    public SymbioctoServant(EntityType<? extends Owned> type, Level worldIn) {
        super(type, worldIn);
        this.m_21441_(BlockPathTypes.WATER, 0.0f);
        this.waterNavigation = new SemiAquaticPathNavigator((Mob)this, worldIn);
        this.groundNavigation = new GroundPathNavigation((Mob)this, worldIn);
    }

    protected void m_8099_() {
        super.m_8099_();
        this.f_21345_.m_25352_(2, (Goal)new CrossBowShootGoal(this, 0, 1, 0, 34, 19, 16.0f));
        this.f_21345_.m_25352_(3, (Goal)new MeleeAttackGoal((PathfinderMob)this, 1.0, true));
        this.f_21345_.m_25352_(5, (Goal)new Summoned.WaterWanderGoal((Summoned)this, (PathfinderMob)this, 1.0, 80));
        this.f_21345_.m_25352_(7, (Goal)new LookAtPlayerGoal((Mob)this, Player.class, 8.0f));
        this.f_21345_.m_25352_(8, (Goal)new RandomLookAroundGoal((Mob)this));
    }

    public void followGoal() {
        this.f_21345_.m_25352_(5, (Goal)new Summoned.FollowOwnerWaterGoal((Summoned)this, 1.0, 10.0f, 2.0f));
    }

    public static AttributeSupplier.Builder setCustomAttributes() {
        return Monster.m_33035_().m_22268_(Attributes.f_22277_, 16.0).m_22268_(Attributes.f_22279_, 0.3).m_22268_(Attributes.f_22284_, ((Double)GCAttributesConfig.SymbioctoArmor.get()).doubleValue()).m_22268_(Attributes.f_22281_, ((Double)GCAttributesConfig.SymbioctoMeleeDamage.get()).doubleValue()).m_22268_(Attributes.f_22276_, ((Double)GCAttributesConfig.SymbioctoHealth.get()).doubleValue());
    }

    public void setConfigurableAttributes() {
        MobUtil.setBaseAttributes((AttributeInstance)this.m_21051_(Attributes.f_22276_), (double)((Double)GCAttributesConfig.SymbioctoHealth.get()));
        MobUtil.setBaseAttributes((AttributeInstance)this.m_21051_(Attributes.f_22284_), (double)((Double)GCAttributesConfig.SymbioctoArmor.get()));
        MobUtil.setBaseAttributes((AttributeInstance)this.m_21051_(Attributes.f_22281_), (double)((Double)GCAttributesConfig.SymbioctoMeleeDamage.get()));
    }

    public MobType m_6336_() {
        return MobType.f_21644_;
    }

    public int xpReward() {
        return 5;
    }

    public Predicate<Entity> summonPredicate() {
        return entity -> entity instanceof SymbioctoServant;
    }

    public int getSummonLimit(LivingEntity owner) {
        return (Integer)GCSpellConfig.OctoHostLimit.get();
    }

    public boolean canUpdateMove() {
        return true;
    }

    boolean wantsToSwim() {
        if (this.searchingForLand) {
            return true;
        }
        if (this.m_5448_() != null && this.m_5448_().m_20069_()) {
            return true;
        }
        return this.getTrueOwner() != null && this.isFollowing() && (this.getTrueOwner().m_20069_() || this.m_20069_() && this.getTrueOwner().m_20186_() > this.m_20186_());
    }

    public void m_7023_(Vec3 travelVector) {
        if (this.m_6109_() && this.m_20069_() && this.wantsToSwim()) {
            this.m_19920_(0.01f, travelVector);
            this.m_6478_(MoverType.SELF, this.m_20184_());
            this.m_20256_(this.m_20184_().m_82490_(0.9));
        } else {
            super.m_7023_(travelVector);
        }
    }

    public void m_5844_() {
        if (!this.m_9236_().f_46443_) {
            if (this.m_21515_() && this.m_20069_() && this.wantsToSwim()) {
                this.f_21344_ = this.waterNavigation;
                this.f_21342_ = new SymbioctoSwimControl(this, 4.0f);
                this.m_20282_(true);
            } else {
                this.f_21344_ = this.groundNavigation;
                this.f_21342_ = new MoveControl((Mob)this);
                this.m_20282_(false);
            }
        }
    }

    protected int m_7302_(int air) {
        return air;
    }

    public AnimationState getAnimationState(String input) {
        if (Objects.equals(input, "spit")) {
            return this.spitAnimationState;
        }
        if (Objects.equals(input, "idle")) {
            return this.idleAnimationState;
        }
        return Objects.equals(input, "attack") ? this.attackAnimationState : new AnimationState();
    }

    public boolean isCloseEye() {
        return this.m_20202_() instanceof DrownedServant || this.m_20202_() instanceof Player;
    }

    protected void m_8097_() {
        super.m_8097_();
        this.f_19804_.m_135372_(ATTACK_STATE, (Object)0);
    }

    public double m_6049_() {
        return 0.2;
    }

    public void m_7350_(EntityDataAccessor<?> p_21104_) {
        if (ATTACK_STATE.equals(p_21104_)) {
            switch (this.getAttackState()) {
                case 0: {
                    this.stopAllAnimationStates();
                    break;
                }
                case 1: {
                    this.stopAllAnimationStates();
                    this.spitAnimationState.m_216982_(this.f_19797_);
                }
            }
        }
        super.m_7350_(p_21104_);
    }

    public int getAttackState() {
        return (Integer)this.f_19804_.m_135370_(ATTACK_STATE);
    }

    public void setAttackState(int input) {
        this.attackTicks = 0;
        this.f_19804_.m_135381_(ATTACK_STATE, (Object)input);
        this.m_9236_().m_7605_((Entity)this, (byte)(-input));
    }

    public boolean m_6673_(DamageSource source) {
        return source.m_276093_(DamageTypes.f_268612_) || super.m_6673_(source);
    }

    public void stopAllAnimationStates() {
        this.spitAnimationState.m_216973_();
    }

    public boolean m_7327_(Entity p_219472_) {
        this.m_9236_().m_7605_((Entity)this, (byte)4);
        return super.m_7327_(p_219472_);
    }

    public void m_7822_(byte id) {
        if (id <= 0) {
            this.attackTicks = 0;
        } else if (id == 4) {
            this.attackAnimationState.m_216977_(this.f_19797_);
        } else if (id == 5) {
            this.interestTime = 40.0f;
            this.m_5496_(SoundEvents.f_12438_, 1.0f, 2.0f);
            this.addParticlesAroundSelf((ParticleOptions)ParticleTypes.f_123750_);
        } else {
            super.m_7822_(id);
        }
    }

    protected void addParticlesAroundSelf(ParticleOptions pParticleData) {
        for (int i = 0; i < 5; ++i) {
            double d0 = this.f_19796_.m_188583_() * 0.02;
            double d1 = this.f_19796_.m_188583_() * 0.02;
            double d2 = this.f_19796_.m_188583_() * 0.02;
            this.m_9236_().m_7106_(pParticleData, this.m_20208_(1.0), this.m_20187_() + 1.0, this.m_20262_(1.0), d0, d1, d2);
        }
    }

    public boolean canRide(LivingEntity livingEntity) {
        DrownedServant drownedServant;
        if (livingEntity instanceof DrownedServant && !(drownedServant = (DrownedServant)livingEntity).m_6162_() && drownedServant.getTrueOwner() == this.getTrueOwner()) {
            return true;
        }
        return super.canRide(livingEntity);
    }

    public boolean m_20329_(Entity entity) {
        DrownedHostServant drownedHostServant;
        DrownedServant drownedServant;
        if (entity instanceof DrownedServant && (drownedServant = (DrownedServant)entity).getTrueOwner() == this.getTrueOwner() && drownedServant.m_6095_() != GCEntityType.DROWNED_HOST_SERVANT.get() && (drownedHostServant = (DrownedHostServant)drownedServant.m_21406_((EntityType)GCEntityType.DROWNED_HOST_SERVANT.get(), true)) != null) {
            drownedHostServant.m_5618_(drownedServant.f_20883_);
            drownedHostServant.m_5616_(drownedServant.m_6080_());
            drownedHostServant.m_146922_(drownedServant.m_146908_());
            float health = drownedServant.m_21223_();
            if (drownedHostServant.m_21233_() > drownedServant.m_21233_()) {
                health += drownedHostServant.m_21233_() - drownedServant.m_21233_();
            }
            drownedHostServant.m_21153_(health);
            if (this.getTrueOwner() != null) {
                drownedHostServant.setTrueOwner(this.getTrueOwner());
            }
            this.m_5618_(drownedHostServant.f_20883_);
            this.m_5616_(drownedHostServant.m_6080_());
            this.m_146922_(drownedHostServant.m_146908_());
            return super.m_20329_((Entity)drownedHostServant);
        }
        return super.m_20329_(entity);
    }

    protected boolean m_7341_(Entity p_20339_) {
        if (this.getTrueOwner() != null && p_20339_ instanceof Player) {
            Player player = (Player)p_20339_;
            if (this.getTrueOwner() == player) {
                return !this.m_6144_();
            }
        }
        return super.m_7341_(p_20339_);
    }

    public void m_8119_() {
        LivingEntity livingEntity;
        Entity entity;
        super.m_8119_();
        if (this.getAttackState() > 0) {
            ++this.attackTicks;
        }
        if (this.interestTime > 0.0f) {
            this.interestTime -= 1.0f;
        }
        if (this.m_9236_().m_5776_()) {
            this.idleAnimationState.m_246184_(true, this.f_19797_);
        } else if (((Boolean)GCMobsConfig.SymbioctoBreath.get()).booleanValue() && (entity = this.m_20202_()) instanceof LivingEntity && (livingEntity = (LivingEntity)entity).m_6084_() && this.m_5448_() != livingEntity && livingEntity.getEyeInFluidType() == ForgeMod.WATER_TYPE.get() && livingEntity.canDrownInFluidType(livingEntity.getEyeInFluidType()) && livingEntity.m_20146_() < livingEntity.m_6062_()) {
            livingEntity.m_20301_(Math.min(livingEntity.m_20146_() + 4, livingEntity.m_6062_()));
        }
    }

    public void m_6083_() {
        super.m_6083_();
        Entity entity = this.m_20202_();
        if (entity instanceof Player) {
            Player player = (Player)entity;
            this.m_5618_(player.f_20883_);
            this.m_5616_(player.m_6080_());
            this.m_146922_(player.m_146908_());
        }
    }

    public boolean canBeRiddenUnderFluidType(FluidType type, Entity rider) {
        return true;
    }

    protected SoundEvent m_7975_(DamageSource damageSourceIn) {
        return SoundEvents.f_12440_;
    }

    protected SoundEvent m_5592_() {
        return SoundEvents.f_12439_;
    }

    protected SoundEvent m_7515_() {
        return SoundEvents.f_12438_;
    }

    public void m_6504_(LivingEntity target, float p_33318_) {
        OctoInk octoInk = new OctoInk(this.m_9236_(), (LivingEntity)this);
        octoInk.setDamage(((Double)GCAttributesConfig.SymbioctoRangeDamage.get()).floatValue());
        double d0 = target.m_20185_() - this.m_20185_();
        double d1 = target.m_20227_(0.3333333333333333) - octoInk.m_20186_();
        double d2 = target.m_20189_() - this.m_20189_();
        double d3 = Math.sqrt(d0 * d0 + d2 * d2) * 0.2;
        octoInk.m_6686_(d0, d1 + d3, d2, 1.5f, 10.0f);
        if (!this.m_20067_()) {
            this.m_9236_().m_6263_(null, this.m_20185_(), this.m_20186_(), this.m_20189_(), SoundEvents.f_12441_, this.m_5720_(), 0.5f, 1.0f);
        }
        this.m_9236_().m_7967_((Entity)octoInk);
    }

    public boolean canRiderInteract() {
        return true;
    }

    public InteractionResult m_6071_(Player pPlayer, InteractionHand pHand) {
        ItemStack itemstack = pPlayer.m_21120_(pHand);
        if (this.getTrueOwner() != null && pPlayer == this.getTrueOwner()) {
            if (itemstack.m_204117_(ItemTags.f_13156_) && this.m_21223_() < this.m_21233_()) {
                if (!pPlayer.m_150110_().f_35937_) {
                    itemstack.m_41774_(1);
                }
                this.m_5496_(SoundEvents.f_11912_, 1.0f, 1.0f);
                this.m_5634_(2.0f);
                Level level = this.m_9236_();
                if (level instanceof ServerLevel) {
                    ServerLevel serverLevel = (ServerLevel)level;
                    for (int i = 0; i < 7; ++i) {
                        double d0 = this.f_19796_.m_188583_() * 0.02;
                        double d1 = this.f_19796_.m_188583_() * 0.02;
                        double d2 = this.f_19796_.m_188583_() * 0.02;
                        serverLevel.m_8767_((ParticleOptions)((SimpleParticleType)ModParticleTypes.HEAL_EFFECT.get()), this.m_20208_(1.0), this.m_20187_() + 0.5, this.m_20262_(1.0), 0, d0, d1, d2, 0.5);
                    }
                }
                return InteractionResult.SUCCESS;
            }
            if (pPlayer.m_21205_().m_41619_()) {
                if (!this.m_20159_() && pPlayer.m_6144_()) {
                    this.m_20329_((Entity)pPlayer);
                } else if (this.m_20202_() == pPlayer) {
                    this.m_8127_();
                } else if (this.interestTime <= 0.0f) {
                    this.interestTime = 40.0f;
                    this.m_5496_(SoundEvents.f_12438_, 1.0f, 2.0f);
                    this.m_9236_().m_7605_((Entity)this, (byte)5);
                }
                return InteractionResult.SUCCESS;
            }
        }
        return InteractionResult.PASS;
    }

    static class CrossBowShootGoal
    extends Goal {
        protected final SymbioctoServant entity;
        private final int getattackstate;
        private final int attackstate;
        private final int attackendstate;
        private final int attackMaxtick;
        private final int attackseetick;
        private final float attackrange;

        public CrossBowShootGoal(SymbioctoServant entity, int getattackstate, int attackstate, int attackendstate, int attackMaxtick, int attackseetick, float attackrange) {
            this.entity = entity;
            this.m_7021_(EnumSet.of(Goal.Flag.MOVE, Goal.Flag.LOOK, Goal.Flag.JUMP));
            this.getattackstate = getattackstate;
            this.attackstate = attackstate;
            this.attackendstate = attackendstate;
            this.attackMaxtick = attackMaxtick;
            this.attackseetick = attackseetick;
            this.attackrange = attackrange;
        }

        public boolean m_8036_() {
            LivingEntity target = this.entity.m_5448_();
            return target != null && target.m_6084_() && this.entity.m_20270_((Entity)target) < this.attackrange && !this.entity.m_217066_(target) && this.entity.getAttackState() == this.getattackstate;
        }

        public void m_8056_() {
            this.entity.setAttackState(this.attackstate);
        }

        public void m_8041_() {
            this.entity.setAttackState(this.attackendstate);
            LivingEntity target = this.entity.m_5448_();
            if (!EntitySelector.f_20406_.test(target)) {
                this.entity.m_6710_(null);
            }
        }

        public boolean m_8045_() {
            return this.entity.getAttackState() == this.attackstate && this.entity.attackTicks <= this.attackMaxtick;
        }

        public void m_8037_() {
            LivingEntity target = this.entity.m_5448_();
            if (this.entity.attackTicks < this.attackseetick && target != null) {
                this.entity.m_21563_().m_24960_((Entity)target, 30.0f, 30.0f);
                this.entity.m_21391_((Entity)target, 30.0f, 30.0f);
            } else {
                this.entity.m_146922_(this.entity.f_19859_);
            }
            if (target != null && this.entity.attackTicks == 19) {
                this.entity.m_6504_(target, 1.0f);
            }
        }

        public boolean m_183429_() {
            return true;
        }
    }

    static class SymbioctoSwimControl
    extends MoveControl {
        private final SymbioctoServant drowned;
        private final float speedMulti;

        public SymbioctoSwimControl(SymbioctoServant p_32433_, float speedMulti) {
            super((Mob)p_32433_);
            this.drowned = p_32433_;
            this.speedMulti = speedMulti;
        }

        public void m_8126_() {
            LivingEntity livingentity = this.drowned.m_5448_();
            LivingEntity owner = this.drowned.getTrueOwner();
            if (this.drowned.wantsToSwim() && this.drowned.m_20069_()) {
                if (livingentity != null && livingentity.m_20186_() > this.drowned.m_20186_() || this.drowned.searchingForLand || owner != null && owner.m_20186_() > this.drowned.m_20186_() && this.drowned.isFollowing()) {
                    this.drowned.m_20256_(this.drowned.m_20184_().m_82520_(0.0, 0.002, 0.0));
                }
                if (this.f_24981_ != MoveControl.Operation.MOVE_TO || this.drowned.m_21573_().m_26571_()) {
                    this.drowned.m_7910_(0.0f);
                    return;
                }
                double d0 = this.f_24975_ - this.drowned.m_20185_();
                double d1 = this.f_24976_ - this.drowned.m_20186_();
                double d2 = this.f_24977_ - this.drowned.m_20189_();
                double d3 = Math.sqrt(d0 * d0 + d1 * d1 + d2 * d2);
                d1 /= d3;
                float f = (float)(Mth.m_14136_((double)d2, (double)d0) * 57.2957763671875) - 90.0f;
                this.drowned.m_146922_(this.m_24991_(this.drowned.m_146908_(), f, 90.0f));
                this.drowned.f_20883_ = this.drowned.m_146908_();
                float f1 = (float)(this.f_24978_ * (double)this.speedMulti * this.drowned.m_21133_(Attributes.f_22279_));
                float f2 = Mth.m_14179_((float)0.125f, (float)this.drowned.m_6113_(), (float)f1);
                this.drowned.m_7910_(f2);
                this.drowned.m_20256_(this.drowned.m_20184_().m_82520_((double)f2 * d0 * 0.005, (double)f2 * d1 * 0.1, (double)f2 * d2 * 0.005));
            } else {
                if (!this.drowned.m_20096_()) {
                    this.drowned.m_20256_(this.drowned.m_20184_().m_82520_(0.0, -0.008, 0.0));
                }
                super.m_8126_();
            }
        }
    }
}

