/*
 * Decompiled with CFR 0.152.
 */
package com.Polarice3.goety_cataclysm.client.render.model;

import com.Polarice3.goety_cataclysm.common.entities.ally.acropolis.ClawdianServant;
import com.github.L_Ender.cataclysm.client.animation.Clawdian_Animation;
import com.github.L_Ender.cataclysm.client.animation.Clawdian_Skill_Animation;
import com.github.L_Ender.lionfishapi.server.animation.LegSolverQuadruped;
import com.mojang.blaze3d.vertex.PoseStack;
import net.minecraft.client.Minecraft;
import net.minecraft.client.model.HierarchicalModel;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.world.entity.Entity;

public class ClawdianServantModel<T extends Entity>
extends HierarchicalModel<T> {
    private final ModelPart root;
    private final ModelPart everything;
    private final ModelPart mid_root;
    private final ModelPart lower_body;
    private final ModelPart pelvis;
    private final ModelPart body;
    private final ModelPart neck;
    private final ModelPart head;
    private final ModelPart right_down_antenna;
    private final ModelPart left_down_antenna;
    private final ModelPart head_tail;
    private final ModelPart left_arm;
    private final ModelPart left_front_arm_rotator;
    private final ModelPart left_front_arm;
    private final ModelPart left_claw;
    private final ModelPart block;
    private final ModelPart right_arm;
    private final ModelPart right_front_arm_rotator;
    private final ModelPart right_front_arm;
    private final ModelPart right_claw;
    private final ModelPart right_hammer;
    private final ModelPart tail1;
    private final ModelPart tail2;
    private final ModelPart legs;
    private final ModelPart left_f_leg_joint;
    private final ModelPart left_f_leg;
    private final ModelPart left_f_leg_solver;
    private final ModelPart left_f_fore_leg;
    private final ModelPart left_f_fore_leg_solver;
    private final ModelPart right_f_leg_joint;
    private final ModelPart right_f_leg;
    private final ModelPart right_f_leg_solver;
    private final ModelPart right_f_fore_leg;
    private final ModelPart right_f_fore_leg_solver;
    private final ModelPart right_b_leg_joint;
    private final ModelPart right_b_leg;
    private final ModelPart right_b_leg_solver;
    private final ModelPart right_b_fore_leg;
    private final ModelPart right_b_fore_leg_solver;
    private final ModelPart left_b_leg_joint;
    private final ModelPart left_b_leg;
    private final ModelPart left_b_leg_solver;
    private final ModelPart left_b_fore_leg;
    private final ModelPart left_b_fore_leg_solver;

    public ClawdianServantModel(ModelPart root) {
        this.root = root;
        this.everything = this.root.m_171324_("everything");
        this.mid_root = this.everything.m_171324_("mid_root");
        this.lower_body = this.mid_root.m_171324_("lower_body");
        this.pelvis = this.lower_body.m_171324_("pelvis");
        this.body = this.pelvis.m_171324_("body");
        this.neck = this.body.m_171324_("neck");
        this.head = this.neck.m_171324_("head");
        this.right_down_antenna = this.head.m_171324_("right_down_antenna");
        this.left_down_antenna = this.head.m_171324_("left_down_antenna");
        this.head_tail = this.head.m_171324_("head_tail");
        this.left_arm = this.body.m_171324_("left_arm");
        this.left_front_arm_rotator = this.left_arm.m_171324_("left_front_arm_rotator");
        this.left_front_arm = this.left_front_arm_rotator.m_171324_("left_front_arm");
        this.left_claw = this.left_front_arm.m_171324_("left_claw");
        this.block = this.left_front_arm.m_171324_("block");
        this.right_arm = this.body.m_171324_("right_arm");
        this.right_front_arm_rotator = this.right_arm.m_171324_("right_front_arm_rotator");
        this.right_front_arm = this.right_front_arm_rotator.m_171324_("right_front_arm");
        this.right_claw = this.right_front_arm.m_171324_("right_claw");
        this.right_hammer = this.right_front_arm.m_171324_("right_hammer");
        this.tail1 = this.lower_body.m_171324_("tail1");
        this.tail2 = this.tail1.m_171324_("tail2");
        this.legs = this.lower_body.m_171324_("legs");
        this.left_f_leg_joint = this.legs.m_171324_("left_f_leg_joint");
        this.left_f_leg = this.left_f_leg_joint.m_171324_("left_f_leg");
        this.left_f_leg_solver = this.left_f_leg.m_171324_("left_f_leg_solver");
        this.left_f_fore_leg = this.left_f_leg_solver.m_171324_("left_f_fore_leg");
        this.left_f_fore_leg_solver = this.left_f_fore_leg.m_171324_("left_f_fore_leg_solver");
        this.right_f_leg_joint = this.legs.m_171324_("right_f_leg_joint");
        this.right_f_leg = this.right_f_leg_joint.m_171324_("right_f_leg");
        this.right_f_leg_solver = this.right_f_leg.m_171324_("right_f_leg_solver");
        this.right_f_fore_leg = this.right_f_leg_solver.m_171324_("right_f_fore_leg");
        this.right_f_fore_leg_solver = this.right_f_fore_leg.m_171324_("right_f_fore_leg_solver");
        this.right_b_leg_joint = this.legs.m_171324_("right_b_leg_joint");
        this.right_b_leg = this.right_b_leg_joint.m_171324_("right_b_leg");
        this.right_b_leg_solver = this.right_b_leg.m_171324_("right_b_leg_solver");
        this.right_b_fore_leg = this.right_b_leg_solver.m_171324_("right_b_fore_leg");
        this.right_b_fore_leg_solver = this.right_b_fore_leg.m_171324_("right_b_fore_leg_solver");
        this.left_b_leg_joint = this.legs.m_171324_("left_b_leg_joint");
        this.left_b_leg = this.left_b_leg_joint.m_171324_("left_b_leg");
        this.left_b_leg_solver = this.left_b_leg.m_171324_("left_b_leg_solver");
        this.left_b_fore_leg = this.left_b_leg_solver.m_171324_("left_b_fore_leg");
        this.left_b_fore_leg_solver = this.left_b_fore_leg.m_171324_("left_b_fore_leg_solver");
    }

    public void m_6973_(T entity, float limbSwing, float limbSwingAmount, float ageInTicks, float netHeadYaw, float headPitch) {
        this.m_142109_().m_171331_().forEach(ModelPart::m_233569_);
        this.animateHeadLookTarget(netHeadYaw, headPitch);
        if (entity instanceof ClawdianServant) {
            ClawdianServant servant = (ClawdianServant)((Object)entity);
            if (servant.getAttackState() != 5 && servant.getAttackState() != 2 && servant.getAttackState() != 10) {
                this.m_267799_(Clawdian_Animation.WALK, limbSwing, limbSwingAmount, 2.0f, 1.5f);
            }
            this.m_233385_(servant.getAnimationState("idle"), Clawdian_Animation.IDLE, ageInTicks, 1.0f);
            this.m_233385_(servant.getAnimationState("vertical_swing"), Clawdian_Animation.VERTICAL_SWING, ageInTicks, 1.0f);
            this.m_233385_(servant.getAnimationState("horizontal_swing"), Clawdian_Animation.HORIZONTAL_SWING, ageInTicks, 1.0f);
            this.m_233385_(servant.getAnimationState("death"), Clawdian_Animation.DEATH, ageInTicks, 1.0f);
            this.m_233385_(servant.getAnimationState("charge_ready"), Clawdian_Skill_Animation.CHARGE_READY, ageInTicks, 1.0f);
            this.m_233385_(servant.getAnimationState("charge_loop"), Clawdian_Skill_Animation.CHARGE_LOOP, ageInTicks, 1.5f);
            this.m_233385_(servant.getAnimationState("charge_end"), Clawdian_Skill_Animation.CHARGE_END, ageInTicks, 1.0f);
            this.m_233385_(servant.getAnimationState("wave_stomp"), Clawdian_Skill_Animation.WAVE_STOMP, ageInTicks, 1.0f);
            this.m_233385_(servant.getAnimationState("claw_punch"), Clawdian_Animation.CLAW_PUNCH, ageInTicks, 1.0f);
            this.m_233385_(servant.getAnimationState("grab_and_throw"), Clawdian_Animation.GRAB_AND_THROW, ageInTicks, 1.0f);
            this.m_233385_(servant.getAnimationState("backstep"), Clawdian_Animation.BACKSTEP, ageInTicks, 1.0f);
            float partialTick = Minecraft.m_91087_().m_91296_();
            this.articulateLegs(servant.legSolver, partialTick);
        }
    }

    public void translateToHand(PoseStack matrixStack) {
        this.root.m_104299_(matrixStack);
        this.everything.m_104299_(matrixStack);
        this.mid_root.m_104299_(matrixStack);
        this.lower_body.m_104299_(matrixStack);
        this.pelvis.m_104299_(matrixStack);
        this.body.m_104299_(matrixStack);
        this.left_arm.m_104299_(matrixStack);
        this.left_front_arm_rotator.m_104299_(matrixStack);
        this.left_front_arm.m_104299_(matrixStack);
        this.block.m_104299_(matrixStack);
    }

    private void articulateLegs(LegSolverQuadruped legs, float partialTick) {
        float heightBackLeft = legs.backLeft.getHeight(partialTick);
        float heightBackRight = legs.backRight.getHeight(partialTick);
        float heightFrontLeft = legs.frontLeft.getHeight(partialTick);
        float heightFrontRight = legs.frontRight.getHeight(partialTick);
        float max = Math.max(Math.max(heightBackLeft, heightBackRight), Math.max(heightFrontLeft, heightFrontRight)) * 0.8f;
        this.everything.f_104201_ += max * 16.0f;
        this.right_f_leg_joint.f_104201_ += (heightFrontRight - max) * 3.0f;
        this.right_f_leg_solver.f_104205_ = (float)((double)this.right_f_leg_solver.f_104205_ + (double)(heightFrontRight - max) * Math.toRadians(-45.0));
        this.right_b_leg_joint.f_104201_ += (heightBackRight - max) * 3.0f;
        this.right_b_leg_solver.f_104205_ = (float)((double)this.right_b_leg_solver.f_104205_ + (double)(heightBackRight - max) * Math.toRadians(-45.0));
        this.right_f_fore_leg_solver.f_104205_ = (float)((double)this.right_f_fore_leg_solver.f_104205_ + (double)(heightFrontRight - max) * Math.toRadians(45.0));
        this.right_b_fore_leg_solver.f_104205_ = (float)((double)this.right_b_fore_leg_solver.f_104205_ + (double)(heightBackRight - max) * Math.toRadians(45.0));
        this.left_f_leg_joint.f_104201_ += (heightFrontLeft - max) * 3.0f;
        this.left_f_leg_solver.f_104205_ = (float)((double)this.left_f_leg_solver.f_104205_ + (double)(heightFrontLeft - max) * Math.toRadians(45.0));
        this.left_b_leg_joint.f_104201_ += (heightBackLeft - max) * 3.0f;
        this.left_b_leg_solver.f_104205_ = (float)((double)this.left_b_leg_solver.f_104205_ + (double)(heightBackLeft - max) * Math.toRadians(45.0));
        this.left_f_fore_leg_solver.f_104205_ = (float)((double)this.left_f_fore_leg_solver.f_104205_ + (double)(heightFrontLeft - max) * Math.toRadians(-45.0));
        this.left_b_fore_leg_solver.f_104205_ = (float)((double)this.left_b_fore_leg_solver.f_104205_ + (double)(heightBackLeft - max) * Math.toRadians(-45.0));
    }

    private void animateHeadLookTarget(float yRot, float xRot) {
        this.neck.f_104203_ += xRot * ((float)Math.PI / 180) * 1.0f / 2.0f;
        this.neck.f_104204_ += yRot * ((float)Math.PI / 180) * 1.0f / 2.0f;
        this.head.f_104203_ += xRot * ((float)Math.PI / 180) * 1.0f / 2.0f;
        this.head.f_104204_ += yRot * ((float)Math.PI / 180) * 1.0f / 2.0f;
    }

    public ModelPart m_142109_() {
        return this.root;
    }
}

