/*
 * Decompiled with CFR 0.152.
 */
package net.mehvahdjukaar.dummmmmmy.configs;

import com.mojang.serialization.Codec;
import com.mojang.serialization.DataResult;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import java.util.function.Predicate;
import java.util.function.Supplier;
import net.mehvahdjukaar.dummmmmmy.Dummmmmmy;
import net.mehvahdjukaar.dummmmmmy.configs.CritMode;
import net.mehvahdjukaar.moonlight.api.client.util.ColorUtil;
import net.mehvahdjukaar.moonlight.api.platform.PlatHelper;
import net.mehvahdjukaar.moonlight.api.platform.configs.ConfigBuilder;
import net.mehvahdjukaar.moonlight.api.platform.configs.ConfigSpec;
import net.mehvahdjukaar.moonlight.api.platform.configs.ConfigType;
import net.mehvahdjukaar.moonlight.api.util.Utils;
import net.minecraft.core.Holder;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.DamageTypeTags;
import net.minecraft.tags.TagKey;
import net.minecraft.world.damagesource.DamageType;

public class ClientConfigs {
    public static final ConfigSpec SPEC;
    public static final Supplier<Double> ANIMATION_INTENSITY;
    public static final Supplier<Boolean> SHOW_HEARTHS;
    public static final Supplier<SkinType> SKIN;
    public static final Supplier<Boolean> DAMAGE_NUMBERS;
    public static final Supplier<Boolean> LIT_UP_PARTICLES;
    public static final Supplier<CritMode> CRIT_MODE;
    public static final Supplier<Map<IdOrTagPredicate, Integer>> DAMAGE_TO_COLORS;
    private static final int COLOR_GENERIC = 0xFFFFFF;
    private static final int COLOR_CRIT = 0xFF0000;
    private static final int COLOR_DRAGON = 15073535;
    private static final int COLOR_WITHER = 0x666666;
    private static final int COLOR_EXPLOSION = 16759593;
    private static final int COLOR_IND_MAGIC = 8670439;
    private static final int COLOR_WATER = 1612003;
    private static final int COLOR_FREEZING = 643839;
    private static final int COLOR_TRIDENT = 65437;
    private static final int COLOR_FIRE = 0xFF7700;
    private static final int COLOR_LIGHTNING = 0xFFF200;
    private static final int COLOR_CACTUS = 1024521;
    private static final int COLOR_TRUE = 9502776;
    private static final int COLOR_WARDEN = 476496;
    private static final int COLOR_BLEED = 8456714;

    public static void init() {
    }

    public static int getDamageColor(ResourceLocation damageTypeId) {
        Map<IdOrTagPredicate, Integer> values = DAMAGE_TO_COLORS.get();
        Optional opt = Utils.hackyGetRegistry((ResourceKey)Registries.f_268580_).m_203636_(ResourceKey.m_135785_((ResourceKey)Registries.f_268580_, (ResourceLocation)damageTypeId));
        if (opt.isEmpty()) {
            Dummmmmmy.LOGGER.error("Received invalid damage type: " + damageTypeId);
        } else {
            Holder.Reference holder = (Holder.Reference)opt.get();
            for (Map.Entry<IdOrTagPredicate, Integer> e : values.entrySet()) {
                if (!e.getKey().test(holder)) continue;
                return e.getValue();
            }
        }
        return -1;
    }

    static {
        ConfigBuilder builder = ConfigBuilder.create((ResourceLocation)Dummmmmmy.res("client"), (ConfigType)ConfigType.CLIENT);
        builder.comment("lots of cosmetic stuff in here");
        builder.push("visuals").comment("To edit the damage numbers color you'll have to edit the config file manually");
        ANIMATION_INTENSITY = builder.comment("How much the dummy swings in degrees with respect to the damage dealt. default=0.75").define("animation_intensity", 0.75, 0.0, 2.0);
        SHOW_HEARTHS = builder.comment("Show hearths instead of damage dealt? (1 hearth = two damage)").define("show_hearths", false);
        DAMAGE_NUMBERS = builder.comment("Show damage numbers on entity").define("damage_numbers", true);
        LIT_UP_PARTICLES = builder.comment("Display particles fullbright").define("full_bright_damage_numbers", true);
        CRIT_MODE = PlatHelper.getPlatform().isForge() ? builder.comment("How crits should be shown").define("crit_mode", (Enum)CritMode.COLOR_AND_MULTIPLIER) : () -> CritMode.OFF;
        SKIN = builder.comment("Skin used by the dummy").define("texture", (Enum)SkinType.DEFAULT);
        HashMap<Record, Integer> map = new HashMap<Record, Integer>();
        map.put(new IdPredicate(Dummmmmmy.TRUE_DAMAGE), 9502776);
        map.put(new IdPredicate(Dummmmmmy.CRITICAL_DAMAGE), 0xFF0000);
        map.put(new IdPredicate("generic"), 0xFFFFFF);
        map.put(new IdPredicate("trident"), 65437);
        map.put(new IdPredicate("dragon_breath"), 15073535);
        map.put(new IdPredicate("sonic_boom"), 476496);
        map.put(new IdPredicate("attributeslib:bleeding"), 8456714);
        map.put(new TagPredicate(Dummmmmmy.IS_EXPLOSION), 16759593);
        map.put(new TagPredicate(Dummmmmmy.IS_COLD), 643839);
        map.put(new TagPredicate(Dummmmmmy.IS_THORN), 1024521);
        map.put(new TagPredicate(Dummmmmmy.IS_FIRE), 0xFF7700);
        map.put(new TagPredicate(Dummmmmmy.IS_WITHER), 0x666666);
        map.put(new TagPredicate((TagKey<DamageType>)DamageTypeTags.f_268725_), 0xFFF200);
        map.put(new TagPredicate((TagKey<DamageType>)DamageTypeTags.f_268581_), 1612003);
        map.put(new TagPredicate((TagKey<DamageType>)DamageTypeTags.f_268731_), 8670439);
        DAMAGE_TO_COLORS = builder.comment("Add here custom colors (in hex format) to associate with your damage types. This is a map from damage source ID to a color where you can add new entries for each").defineObject("damage_type_colors", () -> map, (Codec)Codec.unboundedMap(IdOrTagPredicate.CODEC, (Codec)ColorUtil.CODEC));
        builder.pop();
        SPEC = builder.buildAndRegister();
    }

    public static interface IdOrTagPredicate
    extends Predicate<Holder<DamageType>> {
        public static final Codec<IdOrTagPredicate> CODEC = Codec.STRING.comapFlatMap(IdOrTagPredicate::read, IdOrTagPredicate::toString).stable();

        public String toString();

        public static DataResult<IdOrTagPredicate> read(String location) {
            if (location.startsWith("#")) {
                return ResourceLocation.m_135837_((String)location.substring(1)).map(TagPredicate::new);
            }
            return ResourceLocation.m_135837_((String)location).map(IdPredicate::new);
        }
    }

    public static enum SkinType {
        DEFAULT("dummy", "dummy_h"),
        ORIGINAL("dummy_1", "dummy_1"),
        DUNGEONS("dummy_3", "dummy_3_h"),
        ALTERNATIVE("dummy_2", "dummy_2_h");

        private final ResourceLocation texture;
        private final ResourceLocation shearedTexture;

        private SkinType(String name, String shearedName) {
            this.texture = new ResourceLocation("dummmmmmy:textures/entity/" + name + ".png");
            this.shearedTexture = new ResourceLocation("dummmmmmy:textures/entity/" + shearedName + ".png");
        }

        public ResourceLocation getSkin(Boolean sheared) {
            return sheared != false ? this.shearedTexture : this.texture;
        }
    }

    record IdPredicate(ResourceLocation resourceLocation) implements IdOrTagPredicate
    {
        public IdPredicate(String name) {
            this(new ResourceLocation(name));
        }

        @Override
        public String toString() {
            return this.resourceLocation.toString();
        }

        @Override
        public boolean test(Holder<DamageType> id) {
            return ((ResourceKey)id.m_203543_().get()).m_135782_().equals((Object)this.resourceLocation);
        }
    }

    record TagPredicate(TagKey<DamageType> tag) implements IdOrTagPredicate
    {
        public TagPredicate(ResourceLocation resourceLocation) {
            this((TagKey<DamageType>)new TagKey(Registries.f_268580_, resourceLocation));
        }

        @Override
        public String toString() {
            return "#" + this.tag.f_203868_();
        }

        @Override
        public boolean test(Holder<DamageType> holder) {
            return holder.m_203656_(this.tag);
        }
    }
}

