/*
 * Decompiled with CFR 0.152.
 */
package juuxel.adorn.util;

import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import juuxel.adorn.lib.registry.Registered;
import juuxel.adorn.util.LoggingKt;
import kotlin.Function;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.FunctionAdapter;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.PropertyReference0Impl;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.ranges.RangesKt;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.inventory.ContainerLevelAccess;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;

@Metadata(mv={1, 8, 0}, k=2, xi=48, d1={"\u0000z\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010$\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0006\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\u001a.\u0010\u0007\u001a\u00020\u00052\u0006\u0010\u0001\u001a\u00020\u00002\u0006\u0010\u0003\u001a\u00020\u00022\f\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004H\u0082\b\u00a2\u0006\u0004\b\u0007\u0010\b\u001a\u0015\u0010\f\u001a\u00020\u000b2\u0006\u0010\n\u001a\u00020\t\u00a2\u0006\u0004\b\f\u0010\r\u001aO\u0010\u0015\u001a\u0014\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00028\u00010\u00140\u0012\"\u0004\b\u0000\u0010\u000e\"\u0004\b\u0001\u0010\u000f*\b\u0012\u0004\u0012\u00028\u00000\u00102\u0018\u0010\u0013\u001a\u0014\u0012\u0004\u0012\u00028\u0000\u0012\n\u0012\b\u0012\u0004\u0012\u00028\u00010\u00120\u0011\u00a2\u0006\u0004\b\u0015\u0010\u0016\u001a\u0011\u0010\u0018\u001a\u00020\u0017*\u00020\u0000\u00a2\u0006\u0004\b\u0018\u0010\u0019\u001a\u0019\u0010\u001b\u001a\n \u001a*\u0004\u0018\u00010\u00000\u0000*\u00020\u000b\u00a2\u0006\u0004\b\u001b\u0010\u001c\u001a\u0013\u0010\u001d\u001a\u0004\u0018\u00010\t*\u00020\u000b\u00a2\u0006\u0004\b\u001d\u0010\u001e\u001a\u0019\u0010#\u001a\u00020\"*\u00020\u001f2\u0006\u0010!\u001a\u00020 \u00a2\u0006\u0004\b#\u0010$\u001a)\u0010)\u001a\u00020%*\u00020\t2\u0006\u0010&\u001a\u00020%2\u0006\u0010'\u001a\u00020%2\u0006\u0010(\u001a\u00020%\u00a2\u0006\u0004\b)\u0010*\u001a\u0011\u0010+\u001a\u00020\u0005*\u00020\t\u00a2\u0006\u0004\b+\u0010,\u001a\u0011\u0010/\u001a\u00020.*\u00020-\u00a2\u0006\u0004\b/\u00100\u001a\u0011\u00101\u001a\u00020\u001f*\u00020\u001f\u00a2\u0006\u0004\b1\u00102\u001a\u0019\u00104\u001a\u000203*\u0002032\u0006\u0010\u0001\u001a\u00020\u0000\u00a2\u0006\u0004\b4\u00105\"\u0014\u00107\u001a\u0002068\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b7\u00108\u00a8\u00069"}, d2={"Lnet/minecraft/world/level/block/Block;", "block", "", "name", "Lkotlin/Function0;", "", "fn", "caughtProperty", "(Lnet/minecraft/world/level/block/Block;Ljava/lang/String;Lkotlin/jvm/functions/Function0;)V", "Lnet/minecraft/world/level/block/entity/BlockEntity;", "blockEntity", "Lnet/minecraft/world/inventory/ContainerLevelAccess;", "menuContextOf", "(Lnet/minecraft/world/level/block/entity/BlockEntity;)Lnet/minecraft/world/inventory/ContainerLevelAccess;", "K", "V", "", "Lkotlin/Function1;", "Ljuuxel/adorn/lib/registry/Registered;", "mapper", "", "associateLazily", "([Ljava/lang/Object;Lkotlin/jvm/functions/Function1;)Ljuuxel/adorn/lib/registry/Registered;", "Lnet/minecraft/world/level/block/state/BlockBehaviour$Properties;", "copySettingsSafely", "(Lnet/minecraft/world/level/block/Block;)Lnet/minecraft/world/level/block/state/BlockBehaviour$Properties;", "kotlin.jvm.PlatformType", "getBlock", "(Lnet/minecraft/world/inventory/ContainerLevelAccess;)Lnet/minecraft/world/level/block/Block;", "getBlockEntity", "(Lnet/minecraft/world/inventory/ContainerLevelAccess;)Lnet/minecraft/world/level/block/entity/BlockEntity;", "Lnet/minecraft/core/Direction$Axis;", "Lnet/minecraft/core/Direction$AxisDirection;", "axisDirection", "Lnet/minecraft/core/Direction;", "getDirection", "(Lnet/minecraft/core/Direction$Axis;Lnet/minecraft/core/Direction$AxisDirection;)Lnet/minecraft/core/Direction;", "", "x", "y", "z", "getSquaredDistance", "(Lnet/minecraft/world/level/block/entity/BlockEntity;DDD)D", "syncToClient", "(Lnet/minecraft/world/level/block/entity/BlockEntity;)V", "Lnet/minecraft/world/item/ItemStack;", "Lnet/minecraft/network/chat/MutableComponent;", "toTextWithCount", "(Lnet/minecraft/world/item/ItemStack;)Lnet/minecraft/network/chat/MutableComponent;", "turnHorizontally", "(Lnet/minecraft/core/Direction$Axis;)Lnet/minecraft/core/Direction$Axis;", "Lnet/minecraft/world/level/block/state/BlockState;", "withBlock", "(Lnet/minecraft/world/level/block/state/BlockState;Lnet/minecraft/world/level/block/Block;)Lnet/minecraft/world/level/block/state/BlockState;", "Lorg/slf4j/Logger;", "LOGGER", "Lorg/slf4j/Logger;", "Adorn"})
@SourceDebugExtension(value={"SMAP\nExtensions.kt\nKotlin\n*S Kotlin\n*F\n+ 1 Extensions.kt\njuuxel/adorn/util/ExtensionsKt\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 _Arrays.kt\nkotlin/collections/ArraysKt___ArraysKt\n*L\n1#1,131:1\n63#1,6:135\n63#1,6:141\n63#1,6:147\n63#1,6:153\n63#1,6:159\n63#1,6:165\n63#1,6:171\n63#1,6:177\n1789#2,3:132\n1179#2,2:187\n1253#2,4:189\n11335#3:183\n11670#3,3:184\n*S KotlinDebug\n*F\n+ 1 Extensions.kt\njuuxel/adorn/util/ExtensionsKt\n*L\n51#1:135,6\n52#1:141,6\n53#1:147,6\n54#1:153,6\n55#1:159,6\n56#1:165,6\n57#1:171,6\n58#1:177,6\n26#1:132,3\n94#1:187,2\n94#1:189,4\n93#1:183\n93#1:184,3\n*E\n"})
public final class ExtensionsKt {
    @NotNull
    private static final Logger LOGGER = LoggingKt.logger();

    @NotNull
    public static final MutableComponent toTextWithCount(@NotNull ItemStack $this$toTextWithCount) {
        Intrinsics.checkNotNullParameter((Object)$this$toTextWithCount, (String)"<this>");
        Object[] objectArray = new Object[]{$this$toTextWithCount.m_41613_(), $this$toTextWithCount.m_41611_()};
        MutableComponent mutableComponent = Component.m_237110_((String)"text.adorn.item_stack_with_count", (Object[])objectArray);
        Intrinsics.checkNotNullExpressionValue((Object)mutableComponent, (String)"translatable(\"text.adorn\u2026count, toHoverableText())");
        return mutableComponent;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public static final BlockState withBlock(@NotNull BlockState $this$withBlock, @NotNull Block block) {
        void $this$fold$iv;
        Intrinsics.checkNotNullParameter((Object)$this$withBlock, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)block, (String)"block");
        Set set = $this$withBlock.m_61148_().entrySet();
        Intrinsics.checkNotNullExpressionValue((Object)set, (String)"entries.entries");
        Iterable iterable = set;
        BlockState initial$iv = block.m_49966_();
        boolean $i$f$fold = false;
        BlockState accumulator$iv = initial$iv;
        for (Object element$iv : $this$fold$iv) {
            Map.Entry entry = (Map.Entry)element$iv;
            BlockState acc = accumulator$iv;
            boolean bl = false;
            Intrinsics.checkNotNullExpressionValue((Object)entry, (String)"(key, value)");
            Property key = (Property)entry.getKey();
            Comparable value2 = (Comparable)entry.getValue();
            Intrinsics.checkNotNull((Object)key, (String)"null cannot be cast to non-null type net.minecraft.state.property.Property<kotlin.Comparable<kotlin.Any>>");
            Intrinsics.checkNotNull((Object)value2, (String)"null cannot be cast to non-null type kotlin.Comparable<kotlin.Any>");
            accumulator$iv = (BlockState)acc.m_61124_(key, value2);
        }
        BlockState blockState = accumulator$iv;
        Intrinsics.checkNotNullExpressionValue((Object)blockState, (String)"entries.entries.fold(blo\u2026as Comparable<Any>)\n    }");
        return blockState;
    }

    public static final double getSquaredDistance(@NotNull BlockEntity $this$getSquaredDistance, double x, double y, double z) {
        Intrinsics.checkNotNullParameter((Object)$this$getSquaredDistance, (String)"<this>");
        double xd = (double)$this$getSquaredDistance.m_58899_().m_123341_() + 0.5 - x;
        double yd = (double)$this$getSquaredDistance.m_58899_().m_123342_() + 0.5 - y;
        double zd = (double)$this$getSquaredDistance.m_58899_().m_123343_() + 0.5 - z;
        return xd * xd + yd * yd + zd * zd;
    }

    @NotNull
    public static final BlockBehaviour.Properties copySettingsSafely(@NotNull Block $this$copySettingsSafely) {
        Object[] objectArray;
        Intrinsics.checkNotNullParameter((Object)$this$copySettingsSafely, (String)"<this>");
        BlockBehaviour.Properties settings = BlockBehaviour.Properties.m_284310_();
        String name$iv = "mapColor";
        boolean $i$f$caughtProperty = false;
        try {
            boolean bl = false;
            settings.m_284180_($this$copySettingsSafely.m_284356_());
        }
        catch (Exception e$iv) {
            objectArray = new Object[]{name$iv, BuiltInRegistries.f_256975_.m_7981_((Object)$this$copySettingsSafely), e$iv};
            LOGGER.warn("[Adorn] Could not get block property {} from {}", objectArray);
        }
        name$iv = "luminance";
        $i$f$caughtProperty = false;
        try {
            boolean bl = false;
            settings.m_60953_(arg_0 -> ExtensionsKt.copySettingsSafely$lambda$3$lambda$2($this$copySettingsSafely, arg_0));
        }
        catch (Exception e$iv) {
            objectArray = new Object[]{name$iv, BuiltInRegistries.f_256975_.m_7981_((Object)$this$copySettingsSafely), e$iv};
            LOGGER.warn("[Adorn] Could not get block property {} from {}", objectArray);
        }
        name$iv = "hardness";
        $i$f$caughtProperty = false;
        try {
            boolean bl = false;
            settings.m_155954_($this$copySettingsSafely.m_49966_().m_60800_(null, null));
        }
        catch (Exception e$iv) {
            objectArray = new Object[]{name$iv, BuiltInRegistries.f_256975_.m_7981_((Object)$this$copySettingsSafely), e$iv};
            LOGGER.warn("[Adorn] Could not get block property {} from {}", objectArray);
        }
        name$iv = "resistance";
        $i$f$caughtProperty = false;
        try {
            boolean bl = false;
            settings.m_155956_($this$copySettingsSafely.m_7325_());
        }
        catch (Exception e$iv) {
            objectArray = new Object[]{name$iv, BuiltInRegistries.f_256975_.m_7981_((Object)$this$copySettingsSafely), e$iv};
            LOGGER.warn("[Adorn] Could not get block property {} from {}", objectArray);
        }
        name$iv = "velocityMultiplier";
        $i$f$caughtProperty = false;
        try {
            boolean bl = false;
            settings.m_60956_($this$copySettingsSafely.m_49961_());
        }
        catch (Exception e$iv) {
            objectArray = new Object[]{name$iv, BuiltInRegistries.f_256975_.m_7981_((Object)$this$copySettingsSafely), e$iv};
            LOGGER.warn("[Adorn] Could not get block property {} from {}", objectArray);
        }
        name$iv = "jumpVelocityMultiplier";
        $i$f$caughtProperty = false;
        try {
            boolean bl = false;
            settings.m_60967_($this$copySettingsSafely.m_49964_());
        }
        catch (Exception e$iv) {
            objectArray = new Object[]{name$iv, BuiltInRegistries.f_256975_.m_7981_((Object)$this$copySettingsSafely), e$iv};
            LOGGER.warn("[Adorn] Could not get block property {} from {}", objectArray);
        }
        name$iv = "slipperiness";
        $i$f$caughtProperty = false;
        try {
            boolean bl = false;
            settings.m_60911_($this$copySettingsSafely.m_49958_());
        }
        catch (Exception e$iv) {
            objectArray = new Object[]{name$iv, BuiltInRegistries.f_256975_.m_7981_((Object)$this$copySettingsSafely), e$iv};
            LOGGER.warn("[Adorn] Could not get block property {} from {}", objectArray);
        }
        name$iv = "soundGroup";
        $i$f$caughtProperty = false;
        try {
            boolean bl = false;
            settings.m_60918_($this$copySettingsSafely.m_49966_().m_60827_());
        }
        catch (Exception e$iv) {
            objectArray = new Object[]{name$iv, BuiltInRegistries.f_256975_.m_7981_((Object)$this$copySettingsSafely), e$iv};
            LOGGER.warn("[Adorn] Could not get block property {} from {}", objectArray);
        }
        Intrinsics.checkNotNullExpressionValue((Object)settings, (String)"settings");
        return settings;
    }

    private static final void caughtProperty(Block block, String name, Function0<Unit> fn) {
        boolean $i$f$caughtProperty = false;
        try {
            fn.invoke();
        }
        catch (Exception e) {
            Object[] objectArray = new Object[]{name, BuiltInRegistries.f_256975_.m_7981_((Object)block), e};
            LOGGER.warn("[Adorn] Could not get block property {} from {}", objectArray);
        }
    }

    @NotNull
    public static final Direction.Axis turnHorizontally(@NotNull Direction.Axis $this$turnHorizontally) {
        Intrinsics.checkNotNullParameter((Object)$this$turnHorizontally, (String)"<this>");
        return switch (WhenMappings.$EnumSwitchMapping$0[$this$turnHorizontally.ordinal()]) {
            case 1 -> Direction.Axis.Z;
            case 2 -> Direction.Axis.X;
            case 3 -> Direction.Axis.Y;
            default -> throw new NoWhenBranchMatchedException();
        };
    }

    @NotNull
    public static final Direction getDirection(@NotNull Direction.Axis $this$getDirection, @NotNull Direction.AxisDirection axisDirection) {
        Intrinsics.checkNotNullParameter((Object)$this$getDirection, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)axisDirection, (String)"axisDirection");
        return switch (WhenMappings.$EnumSwitchMapping$1[axisDirection.ordinal()]) {
            case 1 -> {
                switch (WhenMappings.$EnumSwitchMapping$0[$this$getDirection.ordinal()]) {
                    case 1: {
                        yield Direction.EAST;
                    }
                    case 3: {
                        yield Direction.UP;
                    }
                    case 2: {
                        yield Direction.SOUTH;
                    }
                }
                throw new NoWhenBranchMatchedException();
            }
            case 2 -> {
                switch (WhenMappings.$EnumSwitchMapping$0[$this$getDirection.ordinal()]) {
                    case 1: {
                        yield Direction.WEST;
                    }
                    case 3: {
                        yield Direction.DOWN;
                    }
                    case 2: {
                        yield Direction.NORTH;
                    }
                }
                throw new NoWhenBranchMatchedException();
            }
            default -> throw new NoWhenBranchMatchedException();
        };
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public static final <K, V> Registered<Map<K, V>> associateLazily(@NotNull K[] $this$associateLazily, @NotNull Function1<? super K, ? extends Registered<? extends V>> mapper) {
        void $this$mapTo$iv$iv;
        Intrinsics.checkNotNullParameter($this$associateLazily, (String)"<this>");
        Intrinsics.checkNotNullParameter(mapper, (String)"mapper");
        K[] $this$map$iv = $this$associateLazily;
        boolean $i$f$map = false;
        K[] KArray = $this$map$iv;
        Collection destination$iv$iv = new ArrayList($this$map$iv.length);
        boolean $i$f$mapTo = false;
        int n = ((void)$this$mapTo$iv$iv).length;
        for (int i = 0; i < n; ++i) {
            void it;
            void item$iv$iv;
            void var11_11 = item$iv$iv = $this$mapTo$iv$iv[i];
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add(TuplesKt.to((Object)it, (Object)mapper.invoke((Object)it)));
        }
        List pairs = (List)destination$iv$iv;
        Lazy map = LazyKt.lazy(() -> ExtensionsKt.associateLazily$lambda$12(pairs));
        PropertyReference0Impl propertyReference0Impl = new PropertyReference0Impl(map){

            @Nullable
            public Object get() {
                return ((Lazy)this.receiver).getValue();
            }
        };
        return new Registered((Function0)propertyReference0Impl){
            private final /* synthetic */ Function0 function;
            {
                Intrinsics.checkNotNullParameter((Object)function, (String)"function");
                this.function = function;
            }

            public final /* synthetic */ Object get() {
                return this.function.invoke();
            }

            @NotNull
            public final Function<?> getFunctionDelegate() {
                return (Function)this.function;
            }

            public final boolean equals(@Nullable Object other) {
                return other instanceof Registered ? (other instanceof FunctionAdapter ? Intrinsics.areEqual(this.getFunctionDelegate(), (Object)((FunctionAdapter)other).getFunctionDelegate()) : false) : false;
            }

            public final int hashCode() {
                return this.getFunctionDelegate().hashCode();
            }
        };
    }

    @Nullable
    public static final BlockEntity getBlockEntity(@NotNull ContainerLevelAccess $this$getBlockEntity) {
        Intrinsics.checkNotNullParameter((Object)$this$getBlockEntity, (String)"<this>");
        return $this$getBlockEntity.m_6721_(ExtensionsKt::getBlockEntity$lambda$13).orElse(null);
    }

    public static final Block getBlock(@NotNull ContainerLevelAccess $this$getBlock) {
        Intrinsics.checkNotNullParameter((Object)$this$getBlock, (String)"<this>");
        return $this$getBlock.m_6721_(ExtensionsKt::getBlock$lambda$14).orElse(Blocks.f_50016_);
    }

    @NotNull
    public static final ContainerLevelAccess menuContextOf(@NotNull BlockEntity blockEntity) {
        Intrinsics.checkNotNullParameter((Object)blockEntity, (String)"blockEntity");
        ContainerLevelAccess containerLevelAccess = ContainerLevelAccess.m_39289_((Level)blockEntity.m_58904_(), (BlockPos)blockEntity.m_58899_());
        Intrinsics.checkNotNullExpressionValue((Object)containerLevelAccess, (String)"create(blockEntity.world, blockEntity.pos)");
        return containerLevelAccess;
    }

    public static final void syncToClient(@NotNull BlockEntity $this$syncToClient) {
        Intrinsics.checkNotNullParameter((Object)$this$syncToClient, (String)"<this>");
        Level world = $this$syncToClient.m_58904_();
        if (!(world instanceof ServerLevel)) {
            throw new IllegalStateException("[Adorn] Can't sync server->client from the server. What on earth am I doing?");
        }
        ((ServerLevel)world).m_7726_().m_8450_($this$syncToClient.m_58899_());
    }

    private static final int copySettingsSafely$lambda$3$lambda$2(Block $this_copySettingsSafely, BlockState it) {
        Intrinsics.checkNotNullParameter((Object)$this_copySettingsSafely, (String)"$this_copySettingsSafely");
        return $this_copySettingsSafely.m_49966_().m_60791_();
    }

    /*
     * WARNING - void declaration
     */
    private static final Map associateLazily$lambda$12(List $pairs) {
        void $this$associateTo$iv$iv;
        Intrinsics.checkNotNullParameter((Object)$pairs, (String)"$pairs");
        Iterable $this$associate$iv = $pairs;
        boolean $i$f$associate = false;
        int capacity$iv = RangesKt.coerceAtLeast((int)MapsKt.mapCapacity((int)CollectionsKt.collectionSizeOrDefault((Iterable)$this$associate$iv, (int)10)), (int)16);
        Iterable iterable = $this$associate$iv;
        Map destination$iv$iv = new LinkedHashMap(capacity$iv);
        boolean $i$f$associateTo = false;
        for (Object element$iv$iv : $this$associateTo$iv$iv) {
            Map map = destination$iv$iv;
            Pair pair = (Pair)element$iv$iv;
            boolean bl = false;
            Object key = pair.component1();
            Registered value2 = (Registered)pair.component2();
            pair = TuplesKt.to((Object)key, value2.get());
            map.put(pair.getFirst(), pair.getSecond());
        }
        return destination$iv$iv;
    }

    private static final BlockEntity getBlockEntity$lambda$13(Level world, BlockPos pos) {
        Intrinsics.checkNotNullParameter((Object)world, (String)"world");
        Intrinsics.checkNotNullParameter((Object)pos, (String)"pos");
        return world.m_7702_(pos);
    }

    private static final Block getBlock$lambda$14(Level world, BlockPos pos) {
        return world.m_8055_(pos).m_60734_();
    }

    @Metadata(mv={1, 8, 0}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;
        public static final /* synthetic */ int[] $EnumSwitchMapping$1;

        static {
            int[] nArray = new int[Direction.Axis.values().length];
            try {
                nArray[Direction.Axis.X.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[Direction.Axis.Z.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[Direction.Axis.Y.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
            nArray = new int[Direction.AxisDirection.values().length];
            try {
                nArray[Direction.AxisDirection.POSITIVE.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[Direction.AxisDirection.NEGATIVE.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$1 = nArray;
        }
    }
}

