/*
 * Decompiled with CFR 0.152.
 */
package juuxel.adorn.platform.forge;

import juuxel.adorn.fluid.FluidReference;
import juuxel.adorn.platform.NetworkBridge;
import juuxel.adorn.platform.forge.networking.AdornNetworking;
import juuxel.adorn.platform.forge.networking.BrewerFluidSyncS2CMessage;
import juuxel.adorn.platform.forge.networking.OpenBookS2CMessage;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientGamePacketListener;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraftforge.network.NetworkHooks;
import net.minecraftforge.network.PacketDistributor;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000<\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\t\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0018\u0010\u0019J\u001d\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\u00050\u00042\u0006\u0010\u0003\u001a\u00020\u0002H\u0016\u00a2\u0006\u0004\b\u0006\u0010\u0007J'\u0010\u000f\u001a\u00020\u000e2\u0006\u0010\t\u001a\u00020\b2\u0006\u0010\u000b\u001a\u00020\n2\u0006\u0010\r\u001a\u00020\fH\u0016\u00a2\u0006\u0004\b\u000f\u0010\u0010J\u001f\u0010\u0013\u001a\u00020\u000e2\u0006\u0010\t\u001a\u00020\b2\u0006\u0010\u0012\u001a\u00020\u0011H\u0016\u00a2\u0006\u0004\b\u0013\u0010\u0014J#\u0010\u0016\u001a\u00020\u000e2\u0006\u0010\u0003\u001a\u00020\u00022\n\u0010\u0015\u001a\u0006\u0012\u0002\b\u00030\u0004H\u0016\u00a2\u0006\u0004\b\u0016\u0010\u0017\u00a8\u0006\u001a"}, d2={"Ljuuxel/adorn/platform/forge/NetworkBridgeImpl;", "Ljuuxel/adorn/platform/NetworkBridge;", "Lnet/minecraft/world/entity/Entity;", "entity", "Lnet/minecraft/network/protocol/Packet;", "Lnet/minecraft/network/protocol/game/ClientGamePacketListener;", "createEntitySpawnPacket", "(Lnet/minecraft/world/entity/Entity;)Lnet/minecraft/network/protocol/Packet;", "Lnet/minecraft/world/entity/player/Player;", "player", "", "syncId", "Ljuuxel/adorn/fluid/FluidReference;", "fluid", "", "sendBrewerFluidSync", "(Lnet/minecraft/world/entity/player/Player;ILjuuxel/adorn/fluid/FluidReference;)V", "Lnet/minecraft/resources/ResourceLocation;", "bookId", "sendOpenBookPacket", "(Lnet/minecraft/world/entity/player/Player;Lnet/minecraft/resources/ResourceLocation;)V", "packet", "sendToTracking", "(Lnet/minecraft/world/entity/Entity;Lnet/minecraft/network/protocol/Packet;)V", "<init>", "()V", "Adorn"})
public final class NetworkBridgeImpl
implements NetworkBridge {
    @NotNull
    public static final NetworkBridgeImpl INSTANCE = new NetworkBridgeImpl();

    private NetworkBridgeImpl() {
    }

    @Override
    public void sendToTracking(@NotNull Entity entity, @NotNull Packet<?> packet) {
        Intrinsics.checkNotNullParameter((Object)entity, (String)"entity");
        Intrinsics.checkNotNullParameter(packet, (String)"packet");
        PacketDistributor.TRACKING_ENTITY.with(() -> NetworkBridgeImpl.sendToTracking$lambda$0(entity)).send(packet);
    }

    @Override
    @NotNull
    public Packet<ClientGamePacketListener> createEntitySpawnPacket(@NotNull Entity entity) {
        Intrinsics.checkNotNullParameter((Object)entity, (String)"entity");
        Packet packet = NetworkHooks.getEntitySpawningPacket((Entity)entity);
        Intrinsics.checkNotNullExpressionValue((Object)packet, (String)"getEntitySpawningPacket(entity)");
        return packet;
    }

    @Override
    public void sendOpenBookPacket(@NotNull Player player, @NotNull ResourceLocation bookId) {
        Intrinsics.checkNotNullParameter((Object)player, (String)"player");
        Intrinsics.checkNotNullParameter((Object)bookId, (String)"bookId");
        if (player instanceof ServerPlayer) {
            AdornNetworking.INSTANCE.getCHANNEL().send(PacketDistributor.PLAYER.with(() -> NetworkBridgeImpl.sendOpenBookPacket$lambda$1(player)), (Object)new OpenBookS2CMessage(bookId));
        }
    }

    @Override
    public void sendBrewerFluidSync(@NotNull Player player, int syncId, @NotNull FluidReference fluid) {
        Intrinsics.checkNotNullParameter((Object)player, (String)"player");
        Intrinsics.checkNotNullParameter((Object)fluid, (String)"fluid");
        if (player instanceof ServerPlayer) {
            AdornNetworking.INSTANCE.getCHANNEL().send(PacketDistributor.PLAYER.with(() -> NetworkBridgeImpl.sendBrewerFluidSync$lambda$2(player)), (Object)new BrewerFluidSyncS2CMessage(syncId, fluid.createSnapshot()));
        }
    }

    private static final Entity sendToTracking$lambda$0(Entity $entity) {
        Intrinsics.checkNotNullParameter((Object)$entity, (String)"$entity");
        return $entity;
    }

    private static final ServerPlayer sendOpenBookPacket$lambda$1(Player $player) {
        Intrinsics.checkNotNullParameter((Object)$player, (String)"$player");
        return (ServerPlayer)$player;
    }

    private static final ServerPlayer sendBrewerFluidSync$lambda$2(Player $player) {
        Intrinsics.checkNotNullParameter((Object)$player, (String)"$player");
        return (ServerPlayer)$player;
    }
}

