/*
 * Decompiled with CFR 0.152.
 */
package juuxel.adorn.lib.registry;

import juuxel.adorn.item.BaseBlockItem;
import juuxel.adorn.lib.registry.Registered;
import juuxel.adorn.lib.registry.Registrar;
import juuxel.adorn.lib.registry.RegistrarFactory;
import kotlin.Metadata;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.block.Block;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000>\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\t\b&\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u001e\u0010\u001fJ\u001f\u0010\u0007\u001a\u00020\u00062\u0006\u0010\u0003\u001a\u00020\u00022\u0006\u0010\u0005\u001a\u00020\u0004H\u0004\u00a2\u0006\u0004\b\u0007\u0010\bJ5\u0010\u000e\u001a\b\u0012\u0004\u0012\u00028\u00000\r\"\b\b\u0000\u0010\t*\u00020\u00022\u0006\u0010\u000b\u001a\u00020\n2\f\u0010\u0003\u001a\b\u0012\u0004\u0012\u00028\u00000\fH\u0004\u00a2\u0006\u0004\b\u000e\u0010\u000fJC\u0010\u000e\u001a\b\u0012\u0004\u0012\u00028\u00000\r\"\b\b\u0000\u0010\t*\u00020\u00022\u0006\u0010\u000b\u001a\u00020\n2\f\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00040\f2\f\u0010\u0003\u001a\b\u0012\u0004\u0012\u00028\u00000\fH\u0004\u00a2\u0006\u0004\b\u000e\u0010\u0010JI\u0010\u000e\u001a\b\u0012\u0004\u0012\u00028\u00000\r\"\b\b\u0000\u0010\t*\u00020\u00022\u0006\u0010\u000b\u001a\u00020\n2\u0012\u0010\u0012\u001a\u000e\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00020\u00060\u00112\f\u0010\u0003\u001a\b\u0012\u0004\u0012\u00028\u00000\fH\u0004\u00a2\u0006\u0004\b\u000e\u0010\u0013J5\u0010\u0014\u001a\b\u0012\u0004\u0012\u00028\u00000\r\"\b\b\u0000\u0010\t*\u00020\u00022\u0006\u0010\u000b\u001a\u00020\n2\f\u0010\u0003\u001a\b\u0012\u0004\u0012\u00028\u00000\fH\u0004\u00a2\u0006\u0004\b\u0014\u0010\u000fJ5\u0010\u0016\u001a\b\u0012\u0004\u0012\u00028\u00000\r\"\b\b\u0000\u0010\t*\u00020\u00062\u0006\u0010\u000b\u001a\u00020\n2\f\u0010\u0015\u001a\b\u0012\u0004\u0012\u00028\u00000\fH\u0004\u00a2\u0006\u0004\b\u0016\u0010\u000fR\u001d\u0010\u0018\u001a\b\u0012\u0004\u0012\u00020\u00020\u00178\u0006\u00a2\u0006\f\n\u0004\b\u0018\u0010\u0019\u001a\u0004\b\u001a\u0010\u001bR\u001d\u0010\u001c\u001a\b\u0012\u0004\u0012\u00020\u00060\u00178\u0006\u00a2\u0006\f\n\u0004\b\u001c\u0010\u0019\u001a\u0004\b\u001d\u0010\u001b\u00a8\u0006 "}, d2={"Ljuuxel/adorn/lib/registry/RegistryHelper;", "", "Lnet/minecraft/world/level/block/Block;", "block", "Lnet/minecraft/world/item/Item$Properties;", "itemSettings", "Lnet/minecraft/world/item/Item;", "makeItemForBlock", "(Lnet/minecraft/world/level/block/Block;Lnet/minecraft/world/item/Item$Properties;)Lnet/minecraft/world/item/Item;", "T", "", "name", "Lkotlin/Function0;", "Ljuuxel/adorn/lib/registry/Registered;", "registerBlock", "(Ljava/lang/String;Lkotlin/jvm/functions/Function0;)Ljuuxel/adorn/lib/registry/Registered;", "(Ljava/lang/String;Lkotlin/jvm/functions/Function0;Lkotlin/jvm/functions/Function0;)Ljuuxel/adorn/lib/registry/Registered;", "Lkotlin/Function1;", "itemProvider", "(Ljava/lang/String;Lkotlin/jvm/functions/Function1;Lkotlin/jvm/functions/Function0;)Ljuuxel/adorn/lib/registry/Registered;", "registerBlockWithoutItem", "content", "registerItem", "Ljuuxel/adorn/lib/registry/Registrar;", "blocks", "Ljuuxel/adorn/lib/registry/Registrar;", "getBlocks", "()Ljuuxel/adorn/lib/registry/Registrar;", "items", "getItems", "<init>", "()V", "Adorn"})
public abstract class RegistryHelper {
    @NotNull
    private final Registrar<Block> blocks;
    @NotNull
    private final Registrar<Item> items;

    public RegistryHelper() {
        RegistrarFactory registrarFactory = RegistrarFactory.Companion.get();
        ResourceKey resourceKey = Registries.f_256747_;
        Intrinsics.checkNotNullExpressionValue((Object)resourceKey, (String)"BLOCK");
        this.blocks = registrarFactory.create(resourceKey);
        RegistrarFactory registrarFactory2 = RegistrarFactory.Companion.get();
        ResourceKey resourceKey2 = Registries.f_256913_;
        Intrinsics.checkNotNullExpressionValue((Object)resourceKey2, (String)"ITEM");
        this.items = registrarFactory2.create(resourceKey2);
    }

    @NotNull
    public final Registrar<Block> getBlocks() {
        return this.blocks;
    }

    @NotNull
    public final Registrar<Item> getItems() {
        return this.items;
    }

    @NotNull
    protected final <T extends Block> Registered<T> registerBlock(@NotNull String name, @NotNull Function0<? extends T> block) {
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        Intrinsics.checkNotNullParameter(block, (String)"block");
        return this.registerBlock(name, (Function0<? extends Item.Properties>)((Function0)RegistryHelper::registerBlock$lambda$0), block);
    }

    @NotNull
    protected final <T extends Block> Registered<T> registerBlock(@NotNull String name, @NotNull Function0<? extends Item.Properties> itemSettings, @NotNull Function0<? extends T> block) {
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        Intrinsics.checkNotNullParameter(itemSettings, (String)"itemSettings");
        Intrinsics.checkNotNullParameter(block, (String)"block");
        return this.registerBlock(name, arg_0 -> RegistryHelper.registerBlock$lambda$1(this, itemSettings, arg_0), block);
    }

    @NotNull
    protected final <T extends Block> Registered<T> registerBlock(@NotNull String name, @NotNull Function1<? super T, ? extends Item> itemProvider, @NotNull Function0<? extends T> block) {
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        Intrinsics.checkNotNullParameter(itemProvider, (String)"itemProvider");
        Intrinsics.checkNotNullParameter(block, (String)"block");
        Registered<? extends T> registered = this.registerBlockWithoutItem(name, block);
        this.registerItem(name, () -> RegistryHelper.registerBlock$lambda$2(itemProvider, registered));
        return registered;
    }

    @NotNull
    protected final <T extends Block> Registered<T> registerBlockWithoutItem(@NotNull String name, @NotNull Function0<? extends T> block) {
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        Intrinsics.checkNotNullParameter(block, (String)"block");
        return this.blocks.register(name, block);
    }

    @NotNull
    protected final Item makeItemForBlock(@NotNull Block block, @NotNull Item.Properties itemSettings) {
        Intrinsics.checkNotNullParameter((Object)block, (String)"block");
        Intrinsics.checkNotNullParameter((Object)itemSettings, (String)"itemSettings");
        return (Item)new BaseBlockItem(block, itemSettings);
    }

    @NotNull
    protected final <T extends Item> Registered<T> registerItem(@NotNull String name, @NotNull Function0<? extends T> content) {
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        Intrinsics.checkNotNullParameter(content, (String)"content");
        return this.items.register(name, content);
    }

    private static final Item.Properties registerBlock$lambda$0() {
        return new Item.Properties();
    }

    private static final Item registerBlock$lambda$1(RegistryHelper this$0, Function0 $itemSettings, Block it) {
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        Intrinsics.checkNotNullParameter((Object)$itemSettings, (String)"$itemSettings");
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return this$0.makeItemForBlock(it, (Item.Properties)$itemSettings.invoke());
    }

    private static final Item registerBlock$lambda$2(Function1 $itemProvider, Registered $registered) {
        Intrinsics.checkNotNullParameter((Object)$itemProvider, (String)"$itemProvider");
        Intrinsics.checkNotNullParameter((Object)$registered, (String)"$registered");
        return (Item)$itemProvider.invoke($registered.get());
    }
}

