/*
 * Decompiled with CFR 0.152.
 */
package juuxel.adorn.compat.jei;

import juuxel.adorn.AdornCommon;
import juuxel.adorn.block.AdornBlocks;
import juuxel.adorn.compat.jei.JeiRecipeTypes;
import juuxel.adorn.fluid.FluidIngredient;
import juuxel.adorn.fluid.FluidUnit;
import juuxel.adorn.item.AdornItems;
import juuxel.adorn.platform.FluidBridge;
import juuxel.adorn.recipe.BrewingRecipe;
import juuxel.adorn.recipe.FluidBrewingRecipe;
import juuxel.adorn.recipe.ItemBrewingRecipe;
import mezz.jei.api.gui.builder.IRecipeLayoutBuilder;
import mezz.jei.api.gui.builder.IRecipeSlotBuilder;
import mezz.jei.api.gui.drawable.IDrawable;
import mezz.jei.api.helpers.IGuiHelper;
import mezz.jei.api.helpers.IJeiHelpers;
import mezz.jei.api.recipe.IFocusGroup;
import mezz.jei.api.recipe.RecipeIngredientRole;
import mezz.jei.api.recipe.RecipeType;
import mezz.jei.api.recipe.category.IRecipeCategory;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.material.Fluid;

public final class BrewerCategory
implements IRecipeCategory<BrewingRecipe> {
    private static final ResourceLocation TEXTURE = AdornCommon.id("textures/gui/recipe_viewer/brewer_light.png");
    private final IDrawable background = new Background();
    private final IDrawable icon;
    private final IGuiHelper guiHelper;

    public BrewerCategory(IJeiHelpers helpers) {
        this.guiHelper = helpers.getGuiHelper();
        this.icon = this.guiHelper.createDrawableItemStack(AdornBlocks.INSTANCE.getBREWER().m_5456_().m_7968_());
    }

    public RecipeType<BrewingRecipe> getRecipeType() {
        return JeiRecipeTypes.BREWER;
    }

    public Component getTitle() {
        return Component.m_237115_((String)"category.adorn.brewer");
    }

    public IDrawable getBackground() {
        return this.background;
    }

    public IDrawable getIcon() {
        return this.icon;
    }

    public void setRecipe(IRecipeLayoutBuilder layoutBuilder, BrewingRecipe recipe, IFocusGroup focusGroup) {
        int leftX = 0;
        int topY = 0;
        IRecipeSlotBuilder firstSlot = layoutBuilder.addSlot(RecipeIngredientRole.INPUT, leftX + 1, topY + 1);
        IRecipeSlotBuilder secondSlot = layoutBuilder.addSlot(RecipeIngredientRole.INPUT, leftX + 61, topY + 1);
        IRecipeSlotBuilder resultSlot = layoutBuilder.addSlot(RecipeIngredientRole.OUTPUT, leftX + 31, topY + 40);
        layoutBuilder.addSlot(RecipeIngredientRole.INPUT, leftX + 4, topY + 39).addIngredients(Ingredient.m_43929_((ItemLike[])new ItemLike[]{AdornItems.INSTANCE.getMUG()}));
        long capacity = FluidBridge.get().getFluidUnit().getBucketVolume() * 2L;
        IRecipeSlotBuilder tank2 = layoutBuilder.addSlot(RecipeIngredientRole.INPUT, leftX + 88, topY + 1).setFluidRenderer(capacity, false, 16, 59).setOverlay((IDrawable)this.guiHelper.createDrawable(TEXTURE, 154, 17, 16, 59), 0, 0);
        if (recipe instanceof ItemBrewingRecipe) {
            ItemBrewingRecipe r = (ItemBrewingRecipe)recipe;
            firstSlot.addIngredients(r.getFirstIngredient());
            secondSlot.addIngredients(r.getSecondIngredient());
            resultSlot.addItemStack(r.getResult());
        } else if (recipe instanceof FluidBrewingRecipe) {
            FluidBrewingRecipe r = (FluidBrewingRecipe)recipe;
            firstSlot.addIngredients(r.getFirstIngredient());
            secondSlot.addIngredients(r.getSecondIngredient());
            resultSlot.addItemStack(r.getResult());
            FluidIngredient ingredient = r.getFluid();
            long amount = FluidUnit.convert(ingredient.getAmount(), ingredient.getUnit(), FluidBridge.get().getFluidUnit());
            for (Fluid fluid : ingredient.getFluid().getFluids()) {
                tank2.addFluidStack(fluid, amount, ingredient.getNbt());
            }
        }
    }

    private static final class Background
    implements IDrawable {
        private Background() {
        }

        public int getWidth() {
            return 105;
        }

        public int getHeight() {
            return 61;
        }

        public void draw(GuiGraphics context2, int offsetX, int offsetY) {
            context2.m_280218_(TEXTURE, offsetX, offsetY, 49, 16, this.getWidth(), this.getHeight());
            float progressFraction = (float)(System.currentTimeMillis() % 4000L) / 4000.0f;
            int height = Math.round(progressFraction * 25.0f);
            context2.m_280218_(TEXTURE, offsetX + 35, offsetY + 8, 176, 0, 8, height);
        }
    }
}

