/*
 * Decompiled with CFR 0.152.
 */
package juuxel.adorn.client.gui.screen;

import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.math.Axis;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import juuxel.adorn.AdornCommon;
import juuxel.adorn.client.gui.widget.ConfigScreenHeading;
import juuxel.adorn.config.ConfigManager;
import juuxel.adorn.util.Colors;
import juuxel.adorn.util.ColorsKt;
import juuxel.adorn.util.Displayable;
import juuxel.adorn.util.PropertyRef;
import juuxel.adorn.util.animation.AnimationEngine;
import juuxel.adorn.util.animation.AnimationTask;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.random.Random;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.CycleButton;
import net.minecraft.client.gui.components.Tooltip;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.AlertScreen;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000z\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0007\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0002\b\n\n\u0002\u0018\u0002\n\u0002\b\n\b&\u0018\u0000 G2\u00020\u0001:\u0003GHIB\u0017\u0012\u0006\u0010D\u001a\u00020\u0011\u0012\u0006\u0010>\u001a\u00020\u0001\u00a2\u0006\u0004\bE\u0010FJG\u0010\r\u001a\u00020\f\"\b\b\u0000\u0010\u0003*\u00020\u00022\u0006\u0010\u0005\u001a\u00020\u00042\f\u0010\u0007\u001a\b\u0012\u0004\u0012\u00028\u00000\u00062\f\u0010\t\u001a\b\u0012\u0004\u0012\u00028\u00000\b2\b\b\u0002\u0010\u000b\u001a\u00020\nH\u0004\u00a2\u0006\u0004\b\r\u0010\u000eJ/\u0010\u000f\u001a\u00020\f2\u0006\u0010\u0005\u001a\u00020\u00042\f\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\n0\u00062\b\b\u0002\u0010\u000b\u001a\u00020\nH\u0004\u00a2\u0006\u0004\b\u000f\u0010\u0010J\u001f\u0010\u0013\u001a\u00020\f2\u0006\u0010\u0012\u001a\u00020\u00112\u0006\u0010\u0005\u001a\u00020\u0004H\u0004\u00a2\u0006\u0004\b\u0013\u0010\u0014J\u000f\u0010\u0015\u001a\u00020\fH\u0016\u00a2\u0006\u0004\b\u0015\u0010\u0016Ju\u0010\u001d\u001a&\u0012\f\u0012\n \u001c*\u0004\u0018\u00018\u00008\u0000 \u001c*\u0012\u0012\f\u0012\n \u001c*\u0004\u0018\u00018\u00008\u0000\u0018\u00010\u001b0\u001b\"\u0004\b\u0000\u0010\u00032\f\u0010\u0018\u001a\b\u0012\u0004\u0012\u00028\u00000\u00172\u0006\u0010\u0019\u001a\u00020\u00042\u0006\u0010\u001a\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00042\f\u0010\u0007\u001a\b\u0012\u0004\u0012\u00028\u00000\u00062\u0006\u0010\u000b\u001a\u00020\nH\u0002\u00a2\u0006\u0004\b\u001d\u0010\u001eJ\u0017\u0010!\u001a\u00020\u001f2\u0006\u0010 \u001a\u00020\u001fH\u0014\u00a2\u0006\u0004\b!\u0010\"J\u0017\u0010#\u001a\u00020\u001f2\u0006\u0010 \u001a\u00020\u001fH\u0002\u00a2\u0006\u0004\b#\u0010\"J\u000f\u0010$\u001a\u00020\fH\u0014\u00a2\u0006\u0004\b$\u0010\u0016J\u000f\u0010%\u001a\u00020\fH\u0016\u00a2\u0006\u0004\b%\u0010\u0016J/\u0010,\u001a\u00020\f2\u0006\u0010'\u001a\u00020&2\u0006\u0010(\u001a\u00020\u00042\u0006\u0010)\u001a\u00020\u00042\u0006\u0010+\u001a\u00020*H\u0016\u00a2\u0006\u0004\b,\u0010-J\u001f\u0010.\u001a\u00020\f2\u0006\u0010'\u001a\u00020&2\u0006\u0010+\u001a\u00020*H\u0002\u00a2\u0006\u0004\b.\u0010/J\u000f\u00100\u001a\u00020\fH\u0002\u00a2\u0006\u0004\b0\u0010\u0016R\u0014\u00102\u001a\u0002018\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b2\u00103R\u001a\u00106\u001a\b\u0012\u0004\u0012\u000205048\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b6\u00107R\"\u00108\u001a\u00020\u00048\u0004@\u0004X\u0084\u000e\u00a2\u0006\u0012\n\u0004\b8\u00109\u001a\u0004\b:\u0010;\"\u0004\b<\u0010=R\u0014\u0010>\u001a\u00020\u00018\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b>\u0010?R\u0014\u0010A\u001a\u00020@8\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\bA\u0010BR\u0016\u0010\u000b\u001a\u00020\n8\u0002@\u0002X\u0082\u000e\u00a2\u0006\u0006\n\u0004\b\u000b\u0010C\u00a8\u0006J"}, d2={"Ljuuxel/adorn/client/gui/screen/AbstractConfigScreen;", "Lnet/minecraft/client/gui/screens/Screen;", "Ljuuxel/adorn/util/Displayable;", "T", "", "width", "Ljuuxel/adorn/util/PropertyRef;", "property", "", "values", "", "restartRequired", "", "addConfigButton", "(ILjuuxel/adorn/util/PropertyRef;Ljava/util/List;Z)V", "addConfigToggle", "(ILjuuxel/adorn/util/PropertyRef;Z)V", "Lnet/minecraft/network/chat/Component;", "text", "addHeading", "(Lnet/minecraft/network/chat/Component;I)V", "close", "()V", "Lnet/minecraft/client/gui/components/CycleButton$Builder;", "builder", "x", "y", "Lnet/minecraft/client/gui/components/CycleButton;", "kotlin.jvm.PlatformType", "createConfigButton", "(Lnet/minecraft/client/gui/components/CycleButton$Builder;IIILjuuxel/adorn/util/PropertyRef;Z)Lnet/minecraft/client/gui/components/CycleButton;", "", "name", "getOptionTranslationKey", "(Ljava/lang/String;)Ljava/lang/String;", "getTooltipTranslationKey", "init", "removed", "Lnet/minecraft/client/gui/GuiGraphics;", "context", "mouseX", "mouseY", "", "delta", "render", "(Lnet/minecraft/client/gui/GuiGraphics;IIF)V", "renderHearts", "(Lnet/minecraft/client/gui/GuiGraphics;F)V", "tickHearts", "Ljuuxel/adorn/util/animation/AnimationEngine;", "animationEngine", "Ljuuxel/adorn/util/animation/AnimationEngine;", "", "Ljuuxel/adorn/client/gui/screen/AbstractConfigScreen$Heart;", "hearts", "Ljava/util/List;", "nextChildY", "I", "getNextChildY", "()I", "setNextChildY", "(I)V", "parent", "Lnet/minecraft/client/gui/screens/Screen;", "Lkotlin/random/Random;", "random", "Lkotlin/random/Random;", "Z", "title", "<init>", "(Lnet/minecraft/network/chat/Component;Lnet/minecraft/client/gui/screens/Screen;)V", "Companion", "Heart", "HeartAnimationTask", "Adorn"})
public abstract class AbstractConfigScreen
extends Screen {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Screen parent;
    @NotNull
    private final Random random;
    @NotNull
    private final List<Heart> hearts;
    private boolean restartRequired;
    @NotNull
    private final AnimationEngine animationEngine;
    private int nextChildY;
    private static final int CONFIG_BUTTON_START_Y = 40;
    public static final int BUTTON_HEIGHT = 20;
    public static final int BUTTON_GAP = 4;
    public static final int BUTTON_SPACING = 24;
    private static final int HEART_SIZE = 12;
    @NotNull
    private static final List<Integer> HEART_COLORS;
    @NotNull
    private static final ResourceLocation HEART_TEXTURE;
    private static final double MIN_HEART_SPEED = 0.05;
    private static final double MAX_HEART_SPEED = 1.5;
    private static final double MAX_HEART_ANGULAR_SPEED = 0.07;
    private static final int HEART_CHANCE = 65;

    public AbstractConfigScreen(@NotNull Component title, @NotNull Screen parent) {
        Intrinsics.checkNotNullParameter((Object)title, (String)"title");
        Intrinsics.checkNotNullParameter((Object)parent, (String)"parent");
        super(title);
        this.parent = parent;
        this.random = (Random)Random.Default;
        this.hearts = new ArrayList();
        this.animationEngine = new AnimationEngine();
        this.nextChildY = 40;
        this.animationEngine.add(new HeartAnimationTask());
    }

    protected final int getNextChildY() {
        return this.nextChildY;
    }

    protected final void setNextChildY(int n) {
        this.nextChildY = n;
    }

    protected void m_7856_() {
        this.nextChildY = 40;
        this.animationEngine.start();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void m_88315_(@NotNull GuiGraphics context2, int mouseX, int mouseY, float delta) {
        Intrinsics.checkNotNullParameter((Object)context2, (String)"context");
        this.m_280273_(context2);
        List<Heart> list = this.hearts;
        synchronized (list) {
            boolean bl = false;
            this.renderHearts(context2, delta);
            Unit unit = Unit.INSTANCE;
        }
        context2.m_280653_(this.f_96547_, this.f_96539_, this.f_96543_ / 2, 20, Colors.INSTANCE.getWHITE());
        super.m_88315_(context2, mouseX, mouseY, delta);
    }

    private final void renderHearts(GuiGraphics context2, float delta) {
        for (Heart heart : this.hearts) {
            RenderSystem.setShaderColor((float)Colors.INSTANCE.redOf(heart.getColor()), (float)Colors.INSTANCE.greenOf(heart.getColor()), (float)Colors.INSTANCE.blueOf(heart.getColor()), (float)1.0f);
            PoseStack matrices = context2.m_280168_();
            matrices.m_85836_();
            matrices.m_85837_((double)heart.getX(), Mth.m_14139_((double)delta, (double)heart.getPreviousY(), (double)heart.getY()), 0.0);
            matrices.m_85837_(6.0, 6.0, 0.0);
            matrices.m_252781_(Axis.f_252403_.m_252961_((float)heart.getAngle()));
            matrices.m_85837_(-6.0, -6.0, 0.0);
            context2.m_280411_(HEART_TEXTURE, 0, 0, 12, 12, 0.0f, 0.0f, 8, 8, 8, 8);
            matrices.m_85849_();
        }
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
    }

    public void m_7379_() {
        Minecraft minecraft = this.f_96541_;
        Intrinsics.checkNotNull((Object)minecraft);
        minecraft.m_91152_(this.restartRequired ? (Screen)new AlertScreen(() -> AbstractConfigScreen.close$lambda$1(this), (Component)Component.m_237115_((String)"gui.adorn.config.restart_required.title"), (Component)Component.m_237115_((String)"gui.adorn.config.restart_required.message"), (Component)Component.m_237115_((String)"gui.ok"), true) : this.parent);
    }

    public void m_7861_() {
        this.animationEngine.stop();
    }

    private final void tickHearts() {
        Iterator<Heart> iter = this.hearts.iterator();
        while (iter.hasNext()) {
            Heart heart = iter.next();
            if (heart.getY() - (double)12 > (double)this.f_96544_) {
                iter.remove();
                continue;
            }
            heart.move();
        }
        if (this.random.nextInt(65) == 0) {
            int x = this.random.nextInt(this.f_96543_);
            int color = ((Number)CollectionsKt.random((Collection)HEART_COLORS, (Random)this.random)).intValue();
            double speed = this.random.nextDouble(0.05, 1.5);
            double angularSpeed = this.random.nextDouble(-0.07, 0.07);
            ((Collection)this.hearts).add(new Heart(x, -12.0, color, speed, angularSpeed));
        }
    }

    private final <T> CycleButton<T> createConfigButton(CycleButton.Builder<T> builder, int x, int y, int width, PropertyRef<T> property, boolean restartRequired) {
        return builder.m_232498_(arg_0 -> AbstractConfigScreen.createConfigButton$lambda$2(this, property, restartRequired, arg_0)).m_168936_(x, y, width, 20, (Component)Component.m_237115_((String)this.getOptionTranslationKey(property.getName())), (arg_0, arg_1) -> AbstractConfigScreen.createConfigButton$lambda$3(property, restartRequired, this, arg_0, arg_1));
    }

    protected final void addConfigToggle(int width, @NotNull PropertyRef<Boolean> property, boolean restartRequired) {
        Intrinsics.checkNotNullParameter(property, (String)"property");
        CycleButton.Builder builder = CycleButton.m_168916_((boolean)property.get());
        Intrinsics.checkNotNullExpressionValue((Object)builder, (String)"onOffBuilder(property.get())");
        CycleButton<Boolean> button = this.createConfigButton(builder, (this.f_96543_ - width) / 2, this.nextChildY, width, property, restartRequired);
        this.m_142416_((GuiEventListener)button);
        this.nextChildY += 24;
    }

    public static /* synthetic */ void addConfigToggle$default(AbstractConfigScreen abstractConfigScreen, int n, PropertyRef propertyRef, boolean bl, int n2, Object object) {
        if (object != null) {
            throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: addConfigToggle");
        }
        if ((n2 & 4) != 0) {
            bl = false;
        }
        abstractConfigScreen.addConfigToggle(n, propertyRef, bl);
    }

    protected final <T extends Displayable> void addConfigButton(int width, @NotNull PropertyRef<T> property, @NotNull List<? extends T> values2, boolean restartRequired) {
        Intrinsics.checkNotNullParameter(property, (String)"property");
        Intrinsics.checkNotNullParameter(values2, (String)"values");
        CycleButton.Builder builder = CycleButton.m_168894_(AbstractConfigScreen::addConfigButton$lambda$4).m_232502_((Collection)values2).m_168948_(property.get());
        Intrinsics.checkNotNullExpressionValue((Object)builder, (String)"builder<T> { it.displayN\u2026initially(property.get())");
        CycleButton<T> button = this.createConfigButton(builder, (this.f_96543_ - width) / 2, this.nextChildY, width, property, restartRequired);
        this.m_142416_((GuiEventListener)button);
        this.nextChildY += 24;
    }

    public static /* synthetic */ void addConfigButton$default(AbstractConfigScreen abstractConfigScreen, int n, PropertyRef propertyRef, List list, boolean bl, int n2, Object object) {
        if (object != null) {
            throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: addConfigButton");
        }
        if ((n2 & 8) != 0) {
            bl = false;
        }
        abstractConfigScreen.addConfigButton(n, propertyRef, list, bl);
    }

    protected final void addHeading(@NotNull Component text, int width) {
        Intrinsics.checkNotNullParameter((Object)text, (String)"text");
        this.m_169394_(new ConfigScreenHeading(text, (this.f_96543_ - width) / 2, this.nextChildY, width));
        this.nextChildY += 18;
    }

    @NotNull
    protected String getOptionTranslationKey(@NotNull String name) {
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        return "gui.adorn.config.option." + name;
    }

    private final String getTooltipTranslationKey(String name) {
        return this.getOptionTranslationKey(name) + ".description";
    }

    private static final void close$lambda$1(AbstractConfigScreen this$0) {
        Intrinsics.checkNotNullParameter((Object)((Object)this$0), (String)"this$0");
        Minecraft minecraft = this$0.f_96541_;
        Intrinsics.checkNotNull((Object)minecraft);
        minecraft.m_91152_(this$0.parent);
    }

    private static final Tooltip createConfigButton$lambda$2(AbstractConfigScreen this$0, PropertyRef $property, boolean $restartRequired, Object it) {
        Intrinsics.checkNotNullParameter((Object)((Object)this$0), (String)"this$0");
        Intrinsics.checkNotNullParameter((Object)$property, (String)"$property");
        MutableComponent text = Component.m_237115_((String)this$0.getTooltipTranslationKey($property.getName()));
        if ($restartRequired) {
            ChatFormatting[] chatFormattingArray = new ChatFormatting[]{ChatFormatting.ITALIC, ChatFormatting.GOLD};
            text.m_7220_((Component)Component.m_237113_((String)"\n")).m_7220_((Component)Component.m_237115_((String)"gui.adorn.config.requires_restart").m_130944_(chatFormattingArray));
        }
        return Tooltip.m_257550_((Component)((Component)text));
    }

    private static final void createConfigButton$lambda$3(PropertyRef $property, boolean $restartRequired, AbstractConfigScreen this$0, CycleButton cycleButton, Object value2) {
        Intrinsics.checkNotNullParameter((Object)$property, (String)"$property");
        Intrinsics.checkNotNullParameter((Object)((Object)this$0), (String)"this$0");
        $property.set(value2);
        ConfigManager.Companion.getINSTANCE().save();
        if ($restartRequired) {
            this$0.restartRequired = true;
        }
    }

    private static final Component addConfigButton$lambda$4(Displayable it) {
        return it.getDisplayName();
    }

    static {
        Object[] objectArray = new Integer[]{ColorsKt.color$default(0xFF0000, 0, 2, null), ColorsKt.color$default(16549634, 0, 2, null), ColorsKt.color$default(0xFFFF00, 0, 2, null), ColorsKt.color$default(11009112, 0, 2, null), ColorsKt.color$default(2974204, 0, 2, null), ColorsKt.color$default(10486524, 0, 2, null), ColorsKt.color$default(5827068, 0, 2, null), ColorsKt.color$default(16556511, 0, 2, null)};
        HEART_COLORS = CollectionsKt.listOf((Object[])objectArray);
        HEART_TEXTURE = AdornCommon.id("textures/gui/heart.png");
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\u0010\b\n\u0002\b\u0006\n\u0002\u0010 \n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0006\n\u0002\b\u0007\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0015\u0010\u0016R\u0014\u0010\u0003\u001a\u00020\u00028\u0006X\u0086T\u00a2\u0006\u0006\n\u0004\b\u0003\u0010\u0004R\u0014\u0010\u0005\u001a\u00020\u00028\u0006X\u0086T\u00a2\u0006\u0006\n\u0004\b\u0005\u0010\u0004R\u0014\u0010\u0006\u001a\u00020\u00028\u0006X\u0086T\u00a2\u0006\u0006\n\u0004\b\u0006\u0010\u0004R\u0014\u0010\u0007\u001a\u00020\u00028\u0002X\u0082T\u00a2\u0006\u0006\n\u0004\b\u0007\u0010\u0004R\u0014\u0010\b\u001a\u00020\u00028\u0002X\u0082T\u00a2\u0006\u0006\n\u0004\b\b\u0010\u0004R\u001a\u0010\n\u001a\b\u0012\u0004\u0012\u00020\u00020\t8\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\n\u0010\u000bR\u0014\u0010\f\u001a\u00020\u00028\u0002X\u0082T\u00a2\u0006\u0006\n\u0004\b\f\u0010\u0004R\u0014\u0010\u000e\u001a\u00020\r8\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\u000e\u0010\u000fR\u0014\u0010\u0011\u001a\u00020\u00108\u0002X\u0082T\u00a2\u0006\u0006\n\u0004\b\u0011\u0010\u0012R\u0014\u0010\u0013\u001a\u00020\u00108\u0002X\u0082T\u00a2\u0006\u0006\n\u0004\b\u0013\u0010\u0012R\u0014\u0010\u0014\u001a\u00020\u00108\u0002X\u0082T\u00a2\u0006\u0006\n\u0004\b\u0014\u0010\u0012\u00a8\u0006\u0017"}, d2={"Ljuuxel/adorn/client/gui/screen/AbstractConfigScreen$Companion;", "", "", "BUTTON_GAP", "I", "BUTTON_HEIGHT", "BUTTON_SPACING", "CONFIG_BUTTON_START_Y", "HEART_CHANCE", "", "HEART_COLORS", "Ljava/util/List;", "HEART_SIZE", "Lnet/minecraft/resources/ResourceLocation;", "HEART_TEXTURE", "Lnet/minecraft/resources/ResourceLocation;", "", "MAX_HEART_ANGULAR_SPEED", "D", "MAX_HEART_SPEED", "MIN_HEART_SPEED", "<init>", "()V", "Adorn"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010\u0006\n\u0002\b\b\n\u0002\u0010\b\n\u0002\b\u0014\b\u0002\u0018\u00002\u00020\u0001B/\u0012\u0006\u0010\u001b\u001a\u00020\u000e\u0012\u0006\u0010\u001d\u001a\u00020\u0005\u0012\u0006\u0010\u000f\u001a\u00020\u000e\u0012\u0006\u0010\u0019\u001a\u00020\u0005\u0012\u0006\u0010\f\u001a\u00020\u0005\u00a2\u0006\u0004\b \u0010!J\r\u0010\u0003\u001a\u00020\u0002\u00a2\u0006\u0004\b\u0003\u0010\u0004R\"\u0010\u0006\u001a\u00020\u00058\u0006@\u0006X\u0086\u000e\u00a2\u0006\u0012\n\u0004\b\u0006\u0010\u0007\u001a\u0004\b\b\u0010\t\"\u0004\b\n\u0010\u000bR\u0017\u0010\f\u001a\u00020\u00058\u0006\u00a2\u0006\f\n\u0004\b\f\u0010\u0007\u001a\u0004\b\r\u0010\tR\u0017\u0010\u000f\u001a\u00020\u000e8\u0006\u00a2\u0006\f\n\u0004\b\u000f\u0010\u0010\u001a\u0004\b\u0011\u0010\u0012R\"\u0010\u0013\u001a\u00020\u00058\u0006@\u0006X\u0086\u000e\u00a2\u0006\u0012\n\u0004\b\u0013\u0010\u0007\u001a\u0004\b\u0014\u0010\t\"\u0004\b\u0015\u0010\u000bR\"\u0010\u0016\u001a\u00020\u00058\u0006@\u0006X\u0086\u000e\u00a2\u0006\u0012\n\u0004\b\u0016\u0010\u0007\u001a\u0004\b\u0017\u0010\t\"\u0004\b\u0018\u0010\u000bR\u0017\u0010\u0019\u001a\u00020\u00058\u0006\u00a2\u0006\f\n\u0004\b\u0019\u0010\u0007\u001a\u0004\b\u001a\u0010\tR\u0017\u0010\u001b\u001a\u00020\u000e8\u0006\u00a2\u0006\f\n\u0004\b\u001b\u0010\u0010\u001a\u0004\b\u001c\u0010\u0012R\"\u0010\u001d\u001a\u00020\u00058\u0006@\u0006X\u0086\u000e\u00a2\u0006\u0012\n\u0004\b\u001d\u0010\u0007\u001a\u0004\b\u001e\u0010\t\"\u0004\b\u001f\u0010\u000b\u00a8\u0006\""}, d2={"Ljuuxel/adorn/client/gui/screen/AbstractConfigScreen$Heart;", "", "", "move", "()V", "", "angle", "D", "getAngle", "()D", "setAngle", "(D)V", "angularSpeed", "getAngularSpeed", "", "color", "I", "getColor", "()I", "previousAngle", "getPreviousAngle", "setPreviousAngle", "previousY", "getPreviousY", "setPreviousY", "speed", "getSpeed", "x", "getX", "y", "getY", "setY", "<init>", "(IDIDD)V", "Adorn"})
    private static final class Heart {
        private final int x;
        private double y;
        private final int color;
        private final double speed;
        private final double angularSpeed;
        private double previousY;
        private double previousAngle;
        private double angle;

        public Heart(int x, double y, int color, double speed, double angularSpeed) {
            this.x = x;
            this.y = y;
            this.color = color;
            this.speed = speed;
            this.angularSpeed = angularSpeed;
            this.previousY = this.y;
        }

        public final int getX() {
            return this.x;
        }

        public final double getY() {
            return this.y;
        }

        public final void setY(double d) {
            this.y = d;
        }

        public final int getColor() {
            return this.color;
        }

        public final double getSpeed() {
            return this.speed;
        }

        public final double getAngularSpeed() {
            return this.angularSpeed;
        }

        public final double getPreviousY() {
            return this.previousY;
        }

        public final void setPreviousY(double d) {
            this.previousY = d;
        }

        public final double getPreviousAngle() {
            return this.previousAngle;
        }

        public final void setPreviousAngle(double d) {
            this.previousAngle = d;
        }

        public final double getAngle() {
            return this.angle;
        }

        public final void setAngle(double d) {
            this.angle = d;
        }

        public final void move() {
            this.previousY = this.y;
            this.y += this.speed;
            this.previousAngle = this.angle;
            this.angle = (this.angle + this.angularSpeed) % (double)((float)Math.PI * 2);
        }
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0005\b\u0082\u0004\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\b\u0010\tJ\u000f\u0010\u0003\u001a\u00020\u0002H\u0016\u00a2\u0006\u0004\b\u0003\u0010\u0004J\u000f\u0010\u0006\u001a\u00020\u0005H\u0016\u00a2\u0006\u0004\b\u0006\u0010\u0007\u00a8\u0006\n"}, d2={"Ljuuxel/adorn/client/gui/screen/AbstractConfigScreen$HeartAnimationTask;", "Ljuuxel/adorn/util/animation/AnimationTask;", "", "isAlive", "()Z", "", "tick", "()V", "<init>", "(Ljuuxel/adorn/client/gui/screen/AbstractConfigScreen;)V", "Adorn"})
    private final class HeartAnimationTask
    implements AnimationTask {
        @Override
        public boolean isAlive() {
            return true;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void tick() {
            List list = AbstractConfigScreen.this.hearts;
            AbstractConfigScreen abstractConfigScreen = AbstractConfigScreen.this;
            List list2 = list;
            synchronized (list2) {
                boolean bl = false;
                abstractConfigScreen.tickHearts();
                Unit unit = Unit.INSTANCE;
            }
        }
    }
}

