/*
 * Decompiled with CFR 0.152.
 */
package juuxel.adorn.client.gui;

import com.mojang.blaze3d.platform.Window;
import com.mojang.blaze3d.systems.RenderSystem;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.ArrayDeque;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import net.minecraft.client.Minecraft;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\b\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\b\u00c6\u0002\u0018\u00002\u00020\u0001:\u0001\u0019B\t\b\u0002\u00a2\u0006\u0004\b\u0018\u0010\u0004J\u000f\u0010\u0003\u001a\u00020\u0002H\u0002\u00a2\u0006\u0004\b\u0003\u0010\u0004J\r\u0010\u0006\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\u0015\u0010\t\u001a\u00020\u00022\u0006\u0010\b\u001a\u00020\u0005\u00a2\u0006\u0004\b\t\u0010\nJ-\u0010\t\u001a\u00020\u00022\u0006\u0010\f\u001a\u00020\u000b2\u0006\u0010\r\u001a\u00020\u000b2\u0006\u0010\u000e\u001a\u00020\u000b2\u0006\u0010\u000f\u001a\u00020\u000b\u00a2\u0006\u0004\b\t\u0010\u0010J.\u0010\u0013\u001a\u00020\u00022\f\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\u00020\u0011H\u0086\b\u00f8\u0001\u0000\u0082\u0002\n\n\b\b\u0001\u0012\u0002\u0010\u0001 \u0001\u00a2\u0006\u0004\b\u0013\u0010\u0014R\u001a\u0010\u0016\u001a\b\u0012\u0004\u0012\u00020\u00050\u00158\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\u0016\u0010\u0017\u0082\u0002\u0007\n\u0005\b\u009920\u0001\u00a8\u0006\u001a"}, d2={"Ljuuxel/adorn/client/gui/Scissors;", "", "", "apply", "()V", "Ljuuxel/adorn/client/gui/Scissors$Frame;", "pop", "()Ljuuxel/adorn/client/gui/Scissors$Frame;", "frame", "push", "(Ljuuxel/adorn/client/gui/Scissors$Frame;)V", "", "x", "y", "width", "height", "(IIII)V", "Lkotlin/Function0;", "fn", "suspendScissors", "(Lkotlin/jvm/functions/Function0;)V", "Lkotlin/collections/ArrayDeque;", "stack", "Lkotlin/collections/ArrayDeque;", "<init>", "Frame", "Adorn"})
public final class Scissors {
    @NotNull
    public static final Scissors INSTANCE = new Scissors();
    @NotNull
    private static final ArrayDeque<Frame> stack = new ArrayDeque();

    private Scissors() {
    }

    public final void push(int x, int y, int width, int height) {
        this.push(new Frame(x, y, x + width, y + height));
    }

    public final void push(@NotNull Frame frame) {
        Intrinsics.checkNotNullParameter((Object)frame, (String)"frame");
        stack.addLast((Object)frame);
        this.apply();
    }

    @NotNull
    public final Frame pop() {
        Frame frame = (Frame)stack.removeLast();
        this.apply();
        return frame;
    }

    public final void suspendScissors(@NotNull Function0<Unit> fn) {
        Intrinsics.checkNotNullParameter(fn, (String)"fn");
        boolean $i$f$suspendScissors = false;
        Frame frame = this.pop();
        fn.invoke();
        this.push(frame);
    }

    private final void apply() {
        Window window = Minecraft.m_91087_().m_91268_();
        if (stack.isEmpty()) {
            RenderSystem.disableScissor();
            return;
        }
        int x1 = 0;
        int y1 = 0;
        int x2 = window.m_85445_();
        int y2 = window.m_85446_();
        for (Frame frame : stack) {
            x1 = Math.max(x1, frame.getX1());
            y1 = Math.max(y1, frame.getY1());
            x2 = Math.min(x2, frame.getX2());
            y2 = Math.min(y2, frame.getY2());
        }
        double scale = window.m_85449_();
        RenderSystem.enableScissor((int)((int)((double)x1 * scale)), (int)((int)((double)window.m_85442_() - scale * (double)y2)), (int)((int)((double)(x2 - x1) * scale)), (int)((int)((double)(y2 - y1) * scale)));
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\u0010\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\u0010\b\n\u0002\b\r\u0018\u00002\u00020\u0001B'\u0012\u0006\u0010\u0003\u001a\u00020\u0002\u0012\u0006\u0010\t\u001a\u00020\u0002\u0012\u0006\u0010\u0007\u001a\u00020\u0002\u0012\u0006\u0010\u000b\u001a\u00020\u0002\u00a2\u0006\u0004\b\r\u0010\u000eR\u0017\u0010\u0003\u001a\u00020\u00028\u0006\u00a2\u0006\f\n\u0004\b\u0003\u0010\u0004\u001a\u0004\b\u0005\u0010\u0006R\u0017\u0010\u0007\u001a\u00020\u00028\u0006\u00a2\u0006\f\n\u0004\b\u0007\u0010\u0004\u001a\u0004\b\b\u0010\u0006R\u0017\u0010\t\u001a\u00020\u00028\u0006\u00a2\u0006\f\n\u0004\b\t\u0010\u0004\u001a\u0004\b\n\u0010\u0006R\u0017\u0010\u000b\u001a\u00020\u00028\u0006\u00a2\u0006\f\n\u0004\b\u000b\u0010\u0004\u001a\u0004\b\f\u0010\u0006\u00a8\u0006\u000f"}, d2={"Ljuuxel/adorn/client/gui/Scissors$Frame;", "", "", "x1", "I", "getX1", "()I", "x2", "getX2", "y1", "getY1", "y2", "getY2", "<init>", "(IIII)V", "Adorn"})
    public static final class Frame {
        private final int x1;
        private final int y1;
        private final int x2;
        private final int y2;

        public Frame(int x1, int y1, int x2, int y2) {
            this.x1 = x1;
            this.y1 = y1;
            this.x2 = x2;
            this.y2 = y2;
        }

        public final int getX1() {
            return this.x1;
        }

        public final int getY1() {
            return this.y1;
        }

        public final int getX2() {
            return this.x2;
        }

        public final int getY2() {
            return this.y2;
        }
    }
}

