/*
 * Decompiled with CFR 0.152.
 */
package juuxel.adorn.block.variant;

import com.google.common.collect.ListMultimap;
import com.google.common.collect.MultimapBuilder;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import juuxel.adorn.block.BenchBlock;
import juuxel.adorn.block.ChairBlock;
import juuxel.adorn.block.CoffeeTableBlock;
import juuxel.adorn.block.DrawerBlock;
import juuxel.adorn.block.KitchenCounterBlock;
import juuxel.adorn.block.KitchenCupboardBlock;
import juuxel.adorn.block.KitchenSinkBlock;
import juuxel.adorn.block.PlatformBlock;
import juuxel.adorn.block.PostBlock;
import juuxel.adorn.block.ShelfBlock;
import juuxel.adorn.block.StepBlock;
import juuxel.adorn.block.TableBlock;
import juuxel.adorn.block.variant.BlockKind;
import juuxel.adorn.block.variant.BlockVariant;
import juuxel.adorn.block.variant.BlockVariantSet;
import juuxel.adorn.block.variant.MinecraftBlockVariants;
import juuxel.adorn.item.ChairBlockItem;
import juuxel.adorn.item.TableBlockItem;
import juuxel.adorn.lib.registry.Registered;
import juuxel.adorn.lib.registry.RegistryHelper;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import net.minecraft.world.level.block.Block;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000T\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010\"\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0016\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010%\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010!\n\u0002\b\u0004\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b1\u0010\u0015J\u0015\u0010\u0005\u001a\u00020\u00042\u0006\u0010\u0003\u001a\u00020\u0002\u00a2\u0006\u0004\b\u0005\u0010\u0006J\u0013\u0010\t\u001a\b\u0012\u0004\u0012\u00020\b0\u0007\u00a2\u0006\u0004\b\t\u0010\nJ!\u0010\u0010\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u000f0\u000e0\r2\u0006\u0010\f\u001a\u00020\u000b\u00a2\u0006\u0004\b\u0010\u0010\u0011J%\u0010\u0010\u001a\n\u0012\u0004\u0012\u00020\u000f\u0018\u00010\u000e2\u0006\u0010\f\u001a\u00020\u000b2\u0006\u0010\u0012\u001a\u00020\b\u00a2\u0006\u0004\b\u0010\u0010\u0013J\r\u0010\u0014\u001a\u00020\u0004\u00a2\u0006\u0004\b\u0014\u0010\u0015J\u001f\u0010\u0014\u001a\u00020\u00042\u0006\u0010\f\u001a\u00020\u000b2\u0006\u0010\u0012\u001a\u00020\bH\u0002\u00a2\u0006\u0004\b\u0014\u0010\u0016J%\u0010\u0014\u001a\u00020\u00042\u0006\u0010\f\u001a\u00020\u000b2\f\u0010\u0017\u001a\b\u0012\u0004\u0012\u00020\b0\rH\u0002\u00a2\u0006\u0004\b\u0014\u0010\u0018J\u001d\u0010\u0019\u001a\b\u0012\u0004\u0012\u00020\u000f0\u000e2\u0006\u0010\u0012\u001a\u00020\bH\u0002\u00a2\u0006\u0004\b\u0019\u0010\u001aJ\u001d\u0010\u001b\u001a\b\u0012\u0004\u0012\u00020\u000f0\u000e2\u0006\u0010\u0012\u001a\u00020\bH\u0002\u00a2\u0006\u0004\b\u001b\u0010\u001aJ\u001d\u0010\u001c\u001a\b\u0012\u0004\u0012\u00020\u000f0\u000e2\u0006\u0010\u0012\u001a\u00020\bH\u0002\u00a2\u0006\u0004\b\u001c\u0010\u001aJ\u001d\u0010\u001d\u001a\b\u0012\u0004\u0012\u00020\u000f0\u000e2\u0006\u0010\u0012\u001a\u00020\bH\u0002\u00a2\u0006\u0004\b\u001d\u0010\u001aJ\u001d\u0010\u001e\u001a\b\u0012\u0004\u0012\u00020\u000f0\u000e2\u0006\u0010\u0012\u001a\u00020\bH\u0002\u00a2\u0006\u0004\b\u001e\u0010\u001aJ\u001d\u0010\u001f\u001a\b\u0012\u0004\u0012\u00020\u000f0\u000e2\u0006\u0010\u0012\u001a\u00020\bH\u0002\u00a2\u0006\u0004\b\u001f\u0010\u001aJ\u001d\u0010 \u001a\b\u0012\u0004\u0012\u00020\u000f0\u000e2\u0006\u0010\u0012\u001a\u00020\bH\u0002\u00a2\u0006\u0004\b \u0010\u001aJ\u001d\u0010!\u001a\b\u0012\u0004\u0012\u00020\u000f0\u000e2\u0006\u0010\u0012\u001a\u00020\bH\u0002\u00a2\u0006\u0004\b!\u0010\u001aJ\u001d\u0010\"\u001a\b\u0012\u0004\u0012\u00020\u000f0\u000e2\u0006\u0010\u0012\u001a\u00020\bH\u0002\u00a2\u0006\u0004\b\"\u0010\u001aJ\u001d\u0010#\u001a\b\u0012\u0004\u0012\u00020\u000f0\u000e2\u0006\u0010\u0012\u001a\u00020\bH\u0002\u00a2\u0006\u0004\b#\u0010\u001aJ\u001d\u0010$\u001a\b\u0012\u0004\u0012\u00020\u000f0\u000e2\u0006\u0010\u0012\u001a\u00020\bH\u0002\u00a2\u0006\u0004\b$\u0010\u001aJ\u001d\u0010%\u001a\b\u0012\u0004\u0012\u00020\u000f0\u000e2\u0006\u0010\u0012\u001a\u00020\bH\u0002\u00a2\u0006\u0004\b%\u0010\u001aR&\u0010'\u001a\u0014\u0012\u0004\u0012\u00020\u000b\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u000f0\u000e0&8\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b'\u0010(R2\u0010+\u001a \u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\u000b\u0012\u0004\u0012\u00020\b0*\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u000f0\u000e0)8\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b+\u0010,R&\u0010-\u001a\u0014\u0012\u0004\u0012\u00020\b\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u000f0\u000e0&8\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b-\u0010(R\u001a\u0010/\u001a\b\u0012\u0004\u0012\u00020\u00020.8\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b/\u00100\u00a8\u00062"}, d2={"Ljuuxel/adorn/block/variant/BlockVariantSets;", "Ljuuxel/adorn/lib/registry/RegistryHelper;", "Ljuuxel/adorn/block/variant/BlockVariantSet;", "variantSet", "", "add", "(Ljuuxel/adorn/block/variant/BlockVariantSet;)V", "", "Ljuuxel/adorn/block/variant/BlockVariant;", "allVariants", "()Ljava/util/Set;", "Ljuuxel/adorn/block/variant/BlockKind;", "kind", "", "Ljuuxel/adorn/lib/registry/Registered;", "Lnet/minecraft/world/level/block/Block;", "get", "(Ljuuxel/adorn/block/variant/BlockKind;)Ljava/util/List;", "variant", "(Ljuuxel/adorn/block/variant/BlockKind;Ljuuxel/adorn/block/variant/BlockVariant;)Ljuuxel/adorn/lib/registry/Registered;", "register", "()V", "(Ljuuxel/adorn/block/variant/BlockKind;Ljuuxel/adorn/block/variant/BlockVariant;)V", "variants", "(Ljuuxel/adorn/block/variant/BlockKind;Ljava/util/List;)V", "registerBench", "(Ljuuxel/adorn/block/variant/BlockVariant;)Ljuuxel/adorn/lib/registry/Registered;", "registerChair", "registerCoffeeTable", "registerDrawer", "registerKitchenCounter", "registerKitchenCupboard", "registerKitchenSink", "registerPlatform", "registerPost", "registerShelf", "registerStep", "registerTable", "Lcom/google/common/collect/ListMultimap;", "blocksByKind", "Lcom/google/common/collect/ListMultimap;", "", "Lkotlin/Pair;", "blocksByKindVariant", "Ljava/util/Map;", "blocksByVariant", "", "variantSets", "Ljava/util/List;", "<init>", "Adorn"})
@SourceDebugExtension(value={"SMAP\nBlockVariantSets.kt\nKotlin\n*S Kotlin\n*F\n+ 1 BlockVariantSets.kt\njuuxel/adorn/block/variant/BlockVariantSets\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,152:1\n1360#2:153\n1446#2,5:154\n1360#2:159\n1446#2,5:160\n*S KotlinDebug\n*F\n+ 1 BlockVariantSets.kt\njuuxel/adorn/block/variant/BlockVariantSets\n*L\n59#1:153\n59#1:154,5\n60#1:159\n60#1:160,5\n*E\n"})
public final class BlockVariantSets
extends RegistryHelper {
    @NotNull
    public static final BlockVariantSets INSTANCE = new BlockVariantSets();
    @NotNull
    private static final List<BlockVariantSet> variantSets;
    @NotNull
    private static final ListMultimap<BlockKind, Registered<Block>> blocksByKind;
    @NotNull
    private static final ListMultimap<BlockVariant, Registered<Block>> blocksByVariant;
    @NotNull
    private static final Map<Pair<BlockKind, BlockVariant>, Registered<Block>> blocksByKindVariant;

    private BlockVariantSets() {
    }

    @NotNull
    public final Set<BlockVariant> allVariants() {
        Set set = blocksByVariant.keySet();
        Intrinsics.checkNotNullExpressionValue((Object)set, (String)"blocksByVariant.keySet()");
        List variants = CollectionsKt.toMutableList((Collection)set);
        BlockVariantSet.Sorter sorter = (arg_0, arg_1) -> BlockVariantSets.allVariants$lambda$0(variants, arg_0, arg_1);
        for (BlockVariantSet variantSet : variantSets) {
            variantSet.sortVariants(sorter);
        }
        return CollectionsKt.toSet((Iterable)variants);
    }

    public final void add(@NotNull BlockVariantSet variantSet) {
        Intrinsics.checkNotNullParameter((Object)variantSet, (String)"variantSet");
        ((Collection)variantSets).add(variantSet);
    }

    @NotNull
    public final List<Registered<Block>> get(@NotNull BlockKind kind) {
        Intrinsics.checkNotNullParameter((Object)((Object)kind), (String)"kind");
        List list = blocksByKind.get((Object)kind);
        Intrinsics.checkNotNullExpressionValue((Object)list, (String)"blocksByKind[kind]");
        return list;
    }

    @Nullable
    public final Registered<Block> get(@NotNull BlockKind kind, @NotNull BlockVariant variant2) {
        Intrinsics.checkNotNullParameter((Object)((Object)kind), (String)"kind");
        Intrinsics.checkNotNullParameter((Object)variant2, (String)"variant");
        return blocksByKindVariant.get(TuplesKt.to((Object)((Object)kind), (Object)variant2));
    }

    /*
     * WARNING - void declaration
     */
    public final void register() {
        void $this$flatMapTo$iv$iv;
        void $this$flatMapTo$iv$iv2;
        Iterable $this$flatMap$iv = variantSets;
        boolean $i$f$flatMap = false;
        Iterable iterable = $this$flatMap$iv;
        Iterable destination$iv$iv = new ArrayList();
        boolean $i$f$flatMapTo = false;
        for (Object element$iv$iv : $this$flatMapTo$iv$iv2) {
            BlockVariantSet p0 = (BlockVariantSet)element$iv$iv;
            boolean bl = false;
            Iterable list$iv$iv = p0.getWoodVariants();
            CollectionsKt.addAll((Collection)destination$iv$iv, (Iterable)list$iv$iv);
        }
        List woodVariants = (List)destination$iv$iv;
        Iterable $this$flatMap$iv2 = variantSets;
        boolean $i$f$flatMap2 = false;
        destination$iv$iv = $this$flatMap$iv2;
        Collection destination$iv$iv2 = new ArrayList();
        boolean $i$f$flatMapTo2 = false;
        for (Object element$iv$iv : $this$flatMapTo$iv$iv) {
            BlockVariantSet p0 = (BlockVariantSet)element$iv$iv;
            boolean bl = false;
            Iterable list$iv$iv = p0.getStoneVariants();
            CollectionsKt.addAll((Collection)destination$iv$iv2, (Iterable)list$iv$iv);
        }
        List stoneVariants = (List)destination$iv$iv2;
        List allVariants = CollectionsKt.plus((Collection)woodVariants, (Iterable)stoneVariants);
        this.register(BlockKind.CHAIR, woodVariants);
        this.register(BlockKind.TABLE, woodVariants);
        this.register(BlockKind.DRAWER, woodVariants);
        this.register(BlockKind.KITCHEN_COUNTER, woodVariants);
        this.register(BlockKind.KITCHEN_CUPBOARD, woodVariants);
        this.register(BlockKind.KITCHEN_SINK, woodVariants);
        this.register(BlockKind.POST, allVariants);
        this.register(BlockKind.PLATFORM, allVariants);
        this.register(BlockKind.STEP, allVariants);
        this.register(BlockKind.SHELF, woodVariants);
        this.register(BlockKind.COFFEE_TABLE, woodVariants);
        this.register(BlockKind.BENCH, woodVariants);
        for (BlockVariantSet set : variantSets) {
            set.addVariants(BlockVariantSets::register$lambda$2);
        }
    }

    private final void register(BlockKind kind, List<? extends BlockVariant> variants) {
        for (BlockVariant blockVariant : variants) {
            this.register(kind, blockVariant);
        }
    }

    private final void register(BlockKind kind, BlockVariant variant2) {
        Registered<Block> registered = switch (WhenMappings.$EnumSwitchMapping$0[kind.ordinal()]) {
            case 1 -> this.registerChair(variant2);
            case 2 -> this.registerTable(variant2);
            case 3 -> this.registerDrawer(variant2);
            case 4 -> this.registerKitchenCounter(variant2);
            case 5 -> this.registerKitchenCupboard(variant2);
            case 6 -> this.registerKitchenSink(variant2);
            case 7 -> this.registerPost(variant2);
            case 8 -> this.registerPlatform(variant2);
            case 9 -> this.registerStep(variant2);
            case 10 -> this.registerShelf(variant2);
            case 11 -> this.registerCoffeeTable(variant2);
            case 12 -> this.registerBench(variant2);
            default -> throw new NoWhenBranchMatchedException();
        };
        blocksByKind.put((Object)kind, registered);
        blocksByVariant.put((Object)variant2, registered);
        blocksByKindVariant.put((Pair<BlockKind, BlockVariant>)TuplesKt.to((Object)((Object)kind), (Object)variant2), registered);
    }

    private final Registered<Block> registerPost(BlockVariant variant2) {
        return this.registerBlock(variant2.getName() + "_post", () -> BlockVariantSets.registerPost$lambda$3(variant2));
    }

    private final Registered<Block> registerPlatform(BlockVariant variant2) {
        return this.registerBlock(variant2.getName() + "_platform", () -> BlockVariantSets.registerPlatform$lambda$4(variant2));
    }

    private final Registered<Block> registerStep(BlockVariant variant2) {
        return this.registerBlock(variant2.getName() + "_step", () -> BlockVariantSets.registerStep$lambda$5(variant2));
    }

    private final Registered<Block> registerDrawer(BlockVariant variant2) {
        return this.registerBlock(variant2.getName() + "_drawer", () -> BlockVariantSets.registerDrawer$lambda$6(variant2));
    }

    private final Registered<Block> registerChair(BlockVariant variant2) {
        Registered<Block> block = this.registerBlockWithoutItem(variant2.getName() + "_chair", () -> BlockVariantSets.registerChair$lambda$7(variant2));
        this.registerItem(variant2.getName() + "_chair", () -> BlockVariantSets.registerChair$lambda$8(block));
        return block;
    }

    private final Registered<Block> registerTable(BlockVariant variant2) {
        Registered<Block> block = this.registerBlockWithoutItem(variant2.getName() + "_table", () -> BlockVariantSets.registerTable$lambda$9(variant2));
        this.registerItem(variant2.getName() + "_table", () -> BlockVariantSets.registerTable$lambda$10(block));
        return block;
    }

    private final Registered<Block> registerKitchenCounter(BlockVariant variant2) {
        return this.registerBlock(variant2.getName() + "_kitchen_counter", () -> BlockVariantSets.registerKitchenCounter$lambda$11(variant2));
    }

    private final Registered<Block> registerKitchenCupboard(BlockVariant variant2) {
        return this.registerBlock(variant2.getName() + "_kitchen_cupboard", () -> BlockVariantSets.registerKitchenCupboard$lambda$12(variant2));
    }

    private final Registered<Block> registerKitchenSink(BlockVariant variant2) {
        return this.registerBlock(variant2.getName() + "_kitchen_sink", () -> BlockVariantSets.registerKitchenSink$lambda$13(variant2));
    }

    private final Registered<Block> registerShelf(BlockVariant variant2) {
        return this.registerBlock(variant2.getName() + "_shelf", () -> BlockVariantSets.registerShelf$lambda$14(variant2));
    }

    private final Registered<Block> registerCoffeeTable(BlockVariant variant2) {
        return this.registerBlock(variant2.getName() + "_coffee_table", () -> BlockVariantSets.registerCoffeeTable$lambda$15(variant2));
    }

    private final Registered<Block> registerBench(BlockVariant variant2) {
        return this.registerBlock(variant2.getName() + "_bench", () -> BlockVariantSets.registerBench$lambda$16(variant2));
    }

    private static final void allVariants$lambda$0(List $variants, BlockVariant variant2, BlockVariant after) {
        Intrinsics.checkNotNullParameter((Object)$variants, (String)"$variants");
        Intrinsics.checkNotNullParameter((Object)variant2, (String)"variant");
        Intrinsics.checkNotNullParameter((Object)after, (String)"after");
        $variants.remove(variant2);
        $variants.add($variants.indexOf(after) + 1, variant2);
    }

    private static final void register$lambda$2(BlockVariant variant2, List kinds) {
        Intrinsics.checkNotNullParameter((Object)variant2, (String)"variant");
        Intrinsics.checkNotNullParameter((Object)kinds, (String)"kinds");
        for (BlockKind kind : kinds) {
            INSTANCE.register(kind, variant2);
        }
    }

    private static final PostBlock registerPost$lambda$3(BlockVariant $variant) {
        Intrinsics.checkNotNullParameter((Object)$variant, (String)"$variant");
        return new PostBlock($variant);
    }

    private static final PlatformBlock registerPlatform$lambda$4(BlockVariant $variant) {
        Intrinsics.checkNotNullParameter((Object)$variant, (String)"$variant");
        return new PlatformBlock($variant);
    }

    private static final StepBlock registerStep$lambda$5(BlockVariant $variant) {
        Intrinsics.checkNotNullParameter((Object)$variant, (String)"$variant");
        return new StepBlock($variant);
    }

    private static final DrawerBlock registerDrawer$lambda$6(BlockVariant $variant) {
        Intrinsics.checkNotNullParameter((Object)$variant, (String)"$variant");
        return new DrawerBlock($variant);
    }

    private static final ChairBlock registerChair$lambda$7(BlockVariant $variant) {
        Intrinsics.checkNotNullParameter((Object)$variant, (String)"$variant");
        return new ChairBlock($variant);
    }

    private static final ChairBlockItem registerChair$lambda$8(Registered $block) {
        Intrinsics.checkNotNullParameter((Object)$block, (String)"$block");
        return new ChairBlockItem((Block)$block.get());
    }

    private static final TableBlock registerTable$lambda$9(BlockVariant $variant) {
        Intrinsics.checkNotNullParameter((Object)$variant, (String)"$variant");
        return new TableBlock($variant);
    }

    private static final TableBlockItem registerTable$lambda$10(Registered $block) {
        Intrinsics.checkNotNullParameter((Object)$block, (String)"$block");
        return new TableBlockItem((Block)$block.get());
    }

    private static final KitchenCounterBlock registerKitchenCounter$lambda$11(BlockVariant $variant) {
        Intrinsics.checkNotNullParameter((Object)$variant, (String)"$variant");
        return new KitchenCounterBlock($variant);
    }

    private static final KitchenCupboardBlock registerKitchenCupboard$lambda$12(BlockVariant $variant) {
        Intrinsics.checkNotNullParameter((Object)$variant, (String)"$variant");
        return new KitchenCupboardBlock($variant);
    }

    private static final KitchenSinkBlock registerKitchenSink$lambda$13(BlockVariant $variant) {
        Intrinsics.checkNotNullParameter((Object)$variant, (String)"$variant");
        return new KitchenSinkBlock($variant);
    }

    private static final ShelfBlock registerShelf$lambda$14(BlockVariant $variant) {
        Intrinsics.checkNotNullParameter((Object)$variant, (String)"$variant");
        return new ShelfBlock($variant);
    }

    private static final CoffeeTableBlock registerCoffeeTable$lambda$15(BlockVariant $variant) {
        Intrinsics.checkNotNullParameter((Object)$variant, (String)"$variant");
        return new CoffeeTableBlock($variant);
    }

    private static final BenchBlock registerBench$lambda$16(BlockVariant $variant) {
        Intrinsics.checkNotNullParameter((Object)$variant, (String)"$variant");
        return new BenchBlock($variant);
    }

    static {
        Object[] objectArray = new BlockVariantSet[]{MinecraftBlockVariants.INSTANCE};
        variantSets = CollectionsKt.mutableListOf((Object[])objectArray);
        ListMultimap listMultimap = MultimapBuilder.enumKeys(BlockKind.class).arrayListValues().build();
        Intrinsics.checkNotNullExpressionValue((Object)listMultimap, (String)"enumKeys(BlockKind::clas\u2026es()\n            .build()");
        blocksByKind = listMultimap;
        ListMultimap listMultimap2 = MultimapBuilder.linkedHashKeys().arrayListValues().build();
        Intrinsics.checkNotNullExpressionValue((Object)listMultimap2, (String)"linkedHashKeys()\n       \u2026es()\n            .build()");
        blocksByVariant = listMultimap2;
        blocksByKindVariant = new LinkedHashMap();
    }

    @Metadata(mv={1, 8, 0}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[BlockKind.values().length];
            try {
                nArray[BlockKind.CHAIR.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[BlockKind.TABLE.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[BlockKind.DRAWER.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[BlockKind.KITCHEN_COUNTER.ordinal()] = 4;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[BlockKind.KITCHEN_CUPBOARD.ordinal()] = 5;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[BlockKind.KITCHEN_SINK.ordinal()] = 6;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[BlockKind.POST.ordinal()] = 7;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[BlockKind.PLATFORM.ordinal()] = 8;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[BlockKind.STEP.ordinal()] = 9;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[BlockKind.SHELF.ordinal()] = 10;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[BlockKind.COFFEE_TABLE.ordinal()] = 11;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[BlockKind.BENCH.ordinal()] = 12;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

